/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.wither.feature;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.LoadFeature;
import insane96mcp.progressivebosses.module.wither.dispenser.WitherSkullDispenseBehavior;
import insane96mcp.progressivebosses.utils.DifficultyHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Label(name="Misc", description="Handles various small features, such as the explosion")
@LoadFeature(module="progressivebosses:wither")
public class MiscFeature
extends Feature {
    @Config(min=0.0, max=8.0)
    @Label(name="Explosion Power Bonus", description="How much explosion power (after the invulnerability) will the Wither have at max difficulty. Explosion Radius is capped to 13. Base Wither Explosion Power is 7.0. Setting this to 0 will not increase the Wither Explosion Power")
    public static Double explosionPowerBonus = 8.0;
    @Config(min=-1.0)
    @Label(name="Explosion Causes Fire at Difficulty", description="At this difficulty the Wither Explosion will cause fire. Set to -1 to disable.")
    public static Integer explosionCausesFireAtDifficulty = -1;
    @Config
    @Label(name="Faster Breaking Blocks", description="The Wither will no longer wait 1.0 seconds before breaking blocks when he's hit, instead just 0.5s")
    public static Boolean fasterBlockBreaking = true;
    @Config
    @Label(name="Bigger Breaking Blocks", description="The Wither will break even blocks below him when hit.")
    public static Boolean biggerBlockBreaking = true;
    @Config
    @Label(name="Ignore Wither-proof Blocks", description="If true the Wither will break even blocks that are wither-proof. Unbreakable blocks will still be unbreakable, so it's really useful with other mods as in vanilla Wither Proof Blocks are all the unbreakable blocks.")
    public static Boolean ignoreWitherProofBlocks = false;
    @Config
    @Label(name="Wither Nether Only", description="The wither can only be spawned in the Nether.\nNote that this feature completely disables Wither Skulls from begin placed nearby Soul Sand when not in the Nether or when on the Nether Roof.\nRequires Minecraft restart.")
    public static Boolean witherNetherOnly = false;
    private boolean behaviourRegistered = false;

    public MiscFeature(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    public void readConfig(ModConfigEvent event) {
        super.readConfig(event);
        if (witherNetherOnly.booleanValue() && !this.behaviourRegistered) {
            DispenserBlock.m_52672_((ItemLike)Items.f_42679_, (DispenseItemBehavior)new WitherSkullDispenseBehavior());
            this.behaviourRegistered = true;
        }
    }

    @SubscribeEvent
    public void onUpdate(LivingEvent.LivingTickEvent event) {
        if (event.getEntity().f_19853_.f_46443_) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (!biggerBlockBreaking.booleanValue()) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof WitherBoss)) {
            return;
        }
        WitherBoss wither = (WitherBoss)livingEntity;
        if (!wither.m_6084_()) {
            return;
        }
        if (wither.f_31429_ == 1) {
            --wither.f_31429_;
            if (ForgeEventFactory.getMobGriefingEvent((Level)wither.f_19853_, (Entity)wither)) {
                int i1 = Mth.m_14107_((double)wither.m_20186_());
                int l1 = Mth.m_14107_((double)wither.m_20185_());
                int i2 = Mth.m_14107_((double)wither.m_20189_());
                boolean flag = false;
                int yOffsetLow = -1;
                if (wither.m_7090_()) {
                    yOffsetLow = 0;
                }
                for (int k2 = -1; k2 <= 1; ++k2) {
                    for (int l2 = -1; l2 <= 1; ++l2) {
                        for (int j = yOffsetLow; j <= 4; ++j) {
                            int i3 = l1 + k2;
                            int k = i1 + j;
                            int l = i2 + l2;
                            BlockPos blockpos = new BlockPos(i3, k, l);
                            BlockState blockstate = wither.f_19853_.m_8055_(blockpos);
                            if (!this.canWitherDestroy(wither, blockpos, blockstate) || !ForgeEventFactory.onEntityDestroyBlock((LivingEntity)wither, (BlockPos)blockpos, (BlockState)blockstate)) continue;
                            flag = wither.f_19853_.m_46953_(blockpos, true, (Entity)wither) || flag;
                        }
                    }
                }
                if (flag) {
                    wither.f_19853_.m_5898_(null, 1022, wither.m_20183_(), 0);
                }
            }
        }
    }

    private boolean canWitherDestroy(WitherBoss wither, BlockPos pos, BlockState state) {
        if (ignoreWitherProofBlocks.booleanValue()) {
            return !state.m_60795_() && state.m_60800_((BlockGetter)wither.f_19853_, pos) >= 0.0f;
        }
        return state.canEntityDestroy((BlockGetter)wither.f_19853_, pos, (Entity)wither);
    }

    @SubscribeEvent
    public void onExplosion(ExplosionEvent.Start event) {
        WitherBoss wither;
        block7: {
            block6: {
                Entity entity;
                if (!this.isEnabled() || explosionCausesFireAtDifficulty == -1 && explosionPowerBonus == 0.0 || !((entity = event.getExplosion().getExploder()) instanceof WitherBoss)) break block6;
                wither = (WitherBoss)entity;
                if (event.getExplosion().f_46017_ == 7.0f) break block7;
            }
            return;
        }
        CompoundTag tags = wither.getPersistentData();
        float difficulty = tags.m_128457_("progressivebosses:difficulty");
        if (difficulty <= 0.0f) {
            return;
        }
        float explosionPower = (float)((double)event.getExplosion().f_46017_ + explosionPowerBonus * (double)DifficultyHelper.getScalingDifficulty((LivingEntity)wither));
        if (explosionPower > 13.0f) {
            explosionPower = 13.0f;
        }
        event.getExplosion().f_46017_ = explosionPower;
        if (explosionCausesFireAtDifficulty > -1) {
            event.getExplosion().f_46009_ = difficulty >= (float)explosionCausesFireAtDifficulty.intValue();
        }
    }

    @SubscribeEvent
    public void onWitherDamage(LivingHurtEvent event) {
        LivingEntity livingEntity;
        if (!(!event.getEntity().f_19853_.f_46443_ && this.isEnabled() && fasterBlockBreaking.booleanValue() && event.getEntity().m_6084_() && (livingEntity = event.getEntity()) instanceof WitherBoss)) {
            return;
        }
        WitherBoss wither = (WitherBoss)livingEntity;
        wither.f_31429_ = 10;
    }

    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (!this.isEnabled()) {
            return;
        }
        if (event.getItemStack().m_41720_() == Items.f_42679_) {
            if (!MiscFeature.canPlaceSkull(event.getLevel(), event.getPos().m_121955_(event.getFace().m_122436_()))) {
                event.setCanceled(true);
            }
        }
    }

    public static boolean canPlaceSkull(Level world, BlockPos pos) {
        if (!witherNetherOnly.booleanValue()) {
            return true;
        }
        boolean isNether = world.m_46472_().equals((Object)Level.f_46429_);
        boolean hasSoulSandNearby = false;
        for (Direction dir : Direction.values()) {
            if (!world.m_8055_(pos.m_121955_(dir.m_122436_())).m_60734_().equals(Blocks.f_50135_) && !world.m_8055_(pos.m_121955_(dir.m_122436_())).m_60734_().equals(Blocks.f_50136_)) continue;
            hasSoulSandNearby = true;
            break;
        }
        return isNether && pos.m_123342_() <= 127 || !hasSoulSandNearby;
    }
}

