/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.elderguardian.feature;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.LoadFeature;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.ElderGuardian;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Resistances", description="Handles the Damage Resistances")
@LoadFeature(module="progressivebosses:elder_guardian")
public class ResistancesFeature
extends Feature {
    @Config(min=0.0, max=1.0)
    @Label(name="Damage Reduction per Elder Guardian Defeated", description="Percentage Damage Reduction for each Elder Guardian Defeated.")
    public static Double resistancePerElderGuardianDefeated = 0.3;

    public ResistancesFeature(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    @SubscribeEvent
    public void onElderGuardianDamage(LivingDamageEvent event) {
        LivingEntity livingEntity;
        if (!this.isEnabled() || resistancePerElderGuardianDefeated == 0.0 || !((livingEntity = event.getEntity()) instanceof ElderGuardian)) {
            return;
        }
        ElderGuardian elderGuardian = (ElderGuardian)livingEntity;
        float damageReduction = (float)(resistancePerElderGuardianDefeated * (double)elderGuardian.getPersistentData().m_128451_("progressivebosses:difficulty"));
        if (damageReduction > 0.95f) {
            damageReduction = 0.95f;
        }
        event.setAmount(event.getAmount() * (1.0f - damageReduction));
    }
}

