/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.elderguardian.feature;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.LoadFeature;
import insane96mcp.insanelib.util.MCUtils;
import insane96mcp.progressivebosses.setup.Strings;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.ElderGuardian;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Health", description="Bonus Health and Health regeneration.")
@LoadFeature(module="progressivebosses:elder_guardian")
public class HealthFeature
extends Feature {
    public static final String APPLIED_HEALTH_FEATURE = "progressivebosses:applied_health_feature";
    @Config(min=0.0)
    @Label(name="Health Bonus", description="Increase Elder Guardians' Health by this percentage (1 = +100% health)")
    public static Double bonusHealth = 0.5;
    @Config(min=0.0)
    @Label(name="Absorption Health", description="Adds absorption health to Elder Guardians (health that doesn't regen)")
    public static Double absorptionHealth = 40.0;
    @Config(min=0.0)
    @Label(name="Health Regen", description="Health Regen per second")
    public static Double healthRegen = 0.5;

    public HealthFeature(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    @SubscribeEvent
    public void onSpawn(EntityJoinLevelEvent event) {
        Entity entity;
        if (event.getLevel().f_46443_ || !this.isEnabled() || bonusHealth == 0.0 && absorptionHealth == 0.0 || !((entity = event.getEntity()) instanceof ElderGuardian)) {
            return;
        }
        ElderGuardian elderGuardian = (ElderGuardian)entity;
        CompoundTag nbt = elderGuardian.getPersistentData();
        if (!nbt.m_128441_("progressivebosses:difficulty") || nbt.m_128441_(APPLIED_HEALTH_FEATURE)) {
            return;
        }
        nbt.m_128379_(APPLIED_HEALTH_FEATURE, true);
        if (bonusHealth > 0.0) {
            MCUtils.applyModifier((LivingEntity)elderGuardian, (Attribute)Attributes.f_22276_, (UUID)Strings.AttributeModifiers.BONUS_HEALTH_UUID, (String)"progressivebosses:bonus_health", (double)bonusHealth, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_BASE);
        }
        if (absorptionHealth > 0.0) {
            elderGuardian.m_7911_(absorptionHealth.floatValue());
        }
    }

    @SubscribeEvent
    public void onUpdate(LivingEvent.LivingTickEvent event) {
        ElderGuardian elderGuardian;
        block3: {
            block2: {
                LivingEntity livingEntity;
                if (event.getEntity().f_19853_.f_46443_ || !this.isEnabled() || !((livingEntity = event.getEntity()) instanceof ElderGuardian)) break block2;
                elderGuardian = (ElderGuardian)livingEntity;
                if (healthRegen != 0.0 && elderGuardian.m_6084_()) break block3;
            }
            return;
        }
        float heal = healthRegen.floatValue() / 20.0f;
        elderGuardian.m_5634_(heal);
    }
}

