/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.dragon.phase;

import insane96mcp.progressivebosses.module.dragon.feature.CrystalFeature;
import insane96mcp.progressivebosses.utils.LogHelper;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.AbstractDragonPhaseInstance;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhase;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.levelgen.feature.SpikeFeature;
import net.minecraft.world.phys.Vec3;

public class CrystalRespawnPhase
extends AbstractDragonPhaseInstance {
    private static EnderDragonPhase<CrystalRespawnPhase> CRYSTAL_RESPAWN;
    public Vec3 targetLocation;
    private int tick = 0;
    private boolean respawning = false;
    private final ArrayList<SpikeFeature.EndSpike> spikesToRespawn = new ArrayList();
    private final int TICK_RESPAWN_CRYSTAL = 100;

    public CrystalRespawnPhase(EnderDragon dragonIn) {
        super(dragonIn);
    }

    public void m_6989_() {
        if (this.targetLocation == null) {
            if (this.spikesToRespawn.isEmpty()) {
                this.f_31176_.m_31157_().m_31416_(EnderDragonPhase.f_31381_);
                return;
            }
            this.targetLocation = new Vec3((double)this.spikesToRespawn.get(0).m_66886_() + 0.5, (double)this.spikesToRespawn.get(0).m_66899_() + 5.5, (double)this.spikesToRespawn.get(0).m_66893_() + 0.5);
        }
        if (!this.respawning) {
            double d0 = this.targetLocation.m_82531_(this.f_31176_.m_20185_(), this.f_31176_.m_20186_(), this.f_31176_.m_20189_());
            if (d0 < 9.0) {
                this.f_31176_.m_20256_(Vec3.f_82478_);
                this.respawning = true;
            }
        } else {
            ++this.tick;
            this.f_31176_.m_20256_(Vec3.f_82478_);
            if (this.tick <= 75 && this.tick % 5 == 0) {
                this.f_31176_.m_5496_(SoundEvents.f_11894_, 4.0f, 1.0f);
            }
            if (this.tick >= 100) {
                double x = this.spikesToRespawn.get(0).m_66886_();
                double y = this.spikesToRespawn.get(0).m_66899_();
                double z = this.spikesToRespawn.get(0).m_66893_();
                EndCrystal crystal = new EndCrystal(this.f_31176_.f_19853_, x + 0.5, y + 1.0, z + 0.5);
                crystal.m_31056_(true);
                crystal.f_19853_.m_46511_((Entity)this.f_31176_, x + 0.5, y + 1.5, z + 0.5, 5.0f, Explosion.BlockInteraction.NONE);
                this.f_31176_.f_19853_.m_7967_((Entity)crystal);
                CrystalFeature.generateCage(crystal.f_19853_, crystal.m_20183_());
                this.spikesToRespawn.remove(0);
                if (this.spikesToRespawn.isEmpty()) {
                    LogHelper.info("No more crystals to respawn left", new Object[0]);
                }
                this.tick = 0;
                this.respawning = false;
                this.targetLocation = null;
            }
        }
    }

    public boolean m_7080_() {
        return this.respawning;
    }

    public void m_7083_() {
        this.targetLocation = null;
        this.spikesToRespawn.clear();
    }

    public float m_7072_() {
        return 12.0f;
    }

    public float m_7089_() {
        float f = (float)this.f_31176_.m_20184_().m_165924_() + 1.0f;
        float f1 = Math.min(f, 40.0f);
        return 0.875f / f1 / f;
    }

    @Nullable
    public Vec3 m_5535_() {
        return this.targetLocation;
    }

    public void addCrystalRespawn(SpikeFeature.EndSpike spike) {
        if (!this.spikesToRespawn.contains(spike)) {
            this.spikesToRespawn.add(spike);
        }
    }

    public float m_7584_(DamageSource source, float amount) {
        if (source.m_19372_() && !source.m_19385_().equals("fireworks")) {
            return amount;
        }
        return amount * 1.5f;
    }

    public EnderDragonPhase<CrystalRespawnPhase> m_7309_() {
        return CRYSTAL_RESPAWN;
    }

    public static EnderDragonPhase<CrystalRespawnPhase> getPhaseType() {
        return CRYSTAL_RESPAWN;
    }

    public static void init() {
        CRYSTAL_RESPAWN = EnderDragonPhase.m_31402_(CrystalRespawnPhase.class, (String)"CrystalRespawn");
    }
}

