/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.dragon.feature;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.LoadFeature;
import insane96mcp.progressivebosses.utils.DifficultyHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Rewards", description="Bonus Experience and Dragon Egg per player")
@LoadFeature(module="progressivebosses:ender_dragon")
public class RewardFeature
extends Feature {
    @Config(min=0.0)
    @Label(name="Bonus Experience", description="How much more experience (percentage, 36 means +3600%) will Dragon drop at max Difficulty.")
    public static Double bonusExperience = 36.0;
    @Config
    @Label(name="Dragon Egg per Player", description="If true whenever a player, that has never killed the dragon, kills the dragon a Dragon Egg will drop. E.g. If 2 players kill the Dragon for the first time, she will drop 2 Dragon Eggs")
    public static Boolean dragonEggPerPlayer = true;
    @Config
    @Label(name="Inject Default Loot", description="If true default mod drops are added to the Ender Dragon.\nNote that replacing the Ender Dragon loot table (e.g. via DataPack) will automatically remove the Injected loot.")
    public static Boolean injectDefaultRewards = true;

    public RewardFeature(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    @SubscribeEvent
    public void onUpdate(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity;
        if (!this.isEnabled() || !((livingEntity = event.getEntity()) instanceof EnderDragon)) {
            return;
        }
        EnderDragon dragon = (EnderDragon)livingEntity;
        RewardFeature.dropEgg(dragon);
    }

    @SubscribeEvent
    public void onExpDrop(LivingExperienceDropEvent event) {
        EnderDragon dragon;
        block5: {
            block4: {
                LivingEntity livingEntity;
                if (!this.isEnabled() || !((livingEntity = event.getEntity()) instanceof EnderDragon)) break block4;
                dragon = (EnderDragon)livingEntity;
                if (bonusExperience != 0.0) break block5;
            }
            return;
        }
        float scalingDifficulty = DifficultyHelper.getScalingDifficulty((LivingEntity)dragon);
        if (scalingDifficulty == 0.0f) {
            return;
        }
        event.setDroppedExperience((int)((double)event.getDroppedExperience() * bonusExperience * (double)scalingDifficulty));
    }

    private static void dropEgg(EnderDragon dragon) {
        if (!dragonEggPerPlayer.booleanValue() || dragon.f_31084_ != 100) {
            return;
        }
        CompoundTag tags = dragon.getPersistentData();
        int eggsToDrop = tags.m_128451_("progressivebosses:eggs_to_drop");
        if (dragon.m_31158_() != null && !dragon.m_31158_().m_64099_()) {
            --eggsToDrop;
        }
        for (int i = 0; i < eggsToDrop; ++i) {
            dragon.f_19853_.m_46597_(new BlockPos(0, 255 - i, 0), Blocks.f_50260_.m_49966_());
        }
    }

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent event) {
        if (!this.isEnabled() || !injectDefaultRewards.booleanValue()) {
            return;
        }
        ResourceLocation name = event.getName();
        if (!"minecraft".equals(name.m_135827_()) || !"entities/ender_dragon".equals(name.m_135815_())) {
            return;
        }
        LootPool pool = new LootPool.Builder().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)new ResourceLocation("progressivebosses", "entities/ender_dragon"))).m_79082_();
        event.getTable().addPool(pool);
    }
}

