/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.dragon.feature;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.LoadFeature;
import insane96mcp.insanelib.util.MCUtils;
import insane96mcp.progressivebosses.setup.Strings;
import insane96mcp.progressivebosses.utils.DifficultyHelper;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhase;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Health", description="Bonus Health and Bonus regeneration.")
@LoadFeature(module="progressivebosses:ender_dragon")
public class HealthFeature
extends Feature {
    @Config(min=0.0)
    @Label(name="Health Bonus at Max Difficulty", description="Ender Dragon health will be increased by this value at max difficulty (scaling accordingly at lower difficulties)")
    public static Double bonusHealth = 200.0;
    @Config(min=0.0)
    @Label(name="Bonus Regeneration", description="How much health will the Ender Dragon regen at max difficulty (scaling accordingly at lower difficulties). This doesn't affect the health regen given by crystals.")
    public static Double bonusRegen = 1.0;
    @Config(min=0.0)
    @Label(name="Maximum Bonus Regeneration", description="Maximum bonus regeneration per second given by \"Bonus Regeneration\". Set to 0 to disable bonus health regeneration. Can be lower than \"Bonus Regeneration\". This doesn't affect the health regen given by crystals.")
    public static Double maxBonusRegen = 1.0;
    @Config(min=0.0)
    @Label(name="Bonus Crystal Regeneration", description="How much health (when missing 100% health) will the Ender Dragon regen at max difficulty each second whenever she's attached to a Crystal. So if she's missing 30% health, this will be 30% effective. This is added to the normal Crystal regen.")
    public static Double bonusCrystalRegen = 0.0;
    @Config(min=0.0, max=4.0)
    @Label(name="Bonus Regeneration Ratio When Hit", description="Bonus regeneration (also bonus crystal regen) will be multiplied by this ratio when the Dragon has been hit in the last 'Bonus Regeneration When Hit Duration' ticks.")
    public static Double bonusRegenRatioWhenHit = 0.4;
    @Config(min=0.0)
    @Label(name="Bonus Regeneration When Hit Duration")
    public static Integer bonusRegenerationWhenHitDuration = 85;

    public HealthFeature(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    @SubscribeEvent
    public void onSpawn(EntityJoinLevelEvent event) {
        EnderDragon dragon;
        Entity entity;
        if (event.getLevel().f_46443_ || !this.isEnabled() || bonusHealth == 0.0 || !((entity = event.getEntity()) instanceof EnderDragon) || (dragon = (EnderDragon)entity).m_21051_(Attributes.f_22276_).m_22111_(Strings.AttributeModifiers.BONUS_HEALTH_UUID) != null) {
            return;
        }
        MCUtils.applyModifier((LivingEntity)dragon, (Attribute)Attributes.f_22276_, (UUID)Strings.AttributeModifiers.BONUS_HEALTH_UUID, (String)"progressivebosses:bonus_health", (double)(bonusHealth * (double)DifficultyHelper.getScalingDifficulty((LivingEntity)dragon)), (AttributeModifier.Operation)AttributeModifier.Operation.ADDITION);
    }

    @SubscribeEvent
    public void onUpdate(LivingEvent.LivingTickEvent event) {
        float crystalBonusHeal;
        EnderDragon dragon;
        LivingEntity livingEntity;
        if (event.getEntity().f_19853_.f_46443_ || !this.isEnabled() || !((livingEntity = event.getEntity()) instanceof EnderDragon) || !(dragon = (EnderDragon)livingEntity).m_6084_() || dragon.m_31157_().m_31415_().m_7309_() == EnderDragonPhase.f_31386_) {
            return;
        }
        CompoundTag tags = dragon.getPersistentData();
        float difficulty = tags.m_128457_("progressivebosses:difficulty");
        if (difficulty <= 0.0f) {
            return;
        }
        float flatBonusHeal = (float)Math.min(bonusRegen * (double)DifficultyHelper.getScalingDifficulty((LivingEntity)dragon), maxBonusRegen);
        float heal = flatBonusHeal + (crystalBonusHeal = HealthFeature.getCrystalBonusHeal(dragon));
        if (heal == 0.0f) {
            return;
        }
        heal /= 20.0f;
        if (dragon.f_19797_ - dragon.m_21213_() <= bonusRegenerationWhenHitDuration) {
            heal = (float)((double)heal * bonusRegenRatioWhenHit);
        }
        dragon.m_5634_(heal);
    }

    private static float getCrystalBonusHeal(EnderDragon dragon) {
        if (bonusCrystalRegen == 0.0 || dragon.f_31086_ == null || !dragon.f_31086_.m_6084_()) {
            return 0.0f;
        }
        double currHealthPerc = 1.0f - dragon.m_21223_() / dragon.m_21233_();
        return (float)(bonusCrystalRegen * (double)DifficultyHelper.getScalingDifficulty((LivingEntity)dragon) * currHealthPerc);
    }
}

