/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.mixin;

import com.brutalbosses.entity.IOnProjectileHit;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Projectile.class})
public abstract class ProjectileHitActionMixin
extends Entity
implements IOnProjectileHit {
    private long maxLifeTime = 0L;
    private Consumer<HitResult> onHitAction = null;
    private float damageModifier = 0.0f;

    public ProjectileHitActionMixin(EntityType<?> p_i48580_1_, Level p_i48580_2_) {
        super(p_i48580_1_, p_i48580_2_);
    }

    @Inject(method={"onHit"}, at={@At(value="HEAD")}, cancellable=true)
    public void onHitCallback(HitResult rayTraceResult, CallbackInfo ci) {
        if (this.onHitAction != null) {
            this.onHitAction.accept(rayTraceResult);
            this.onHitAction = null;
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void onTick(CallbackInfo ci) {
        if (this.maxLifeTime != 0L && this.m_9236_().m_46467_() > this.maxLifeTime) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public boolean m_20223_(CompoundTag nbt) {
        if (this.maxLifeTime != 0L) {
            return false;
        }
        return super.m_20223_(nbt);
    }

    @Override
    public void setOnHitAction(Consumer<HitResult> action) {
        this.onHitAction = action;
    }

    @Override
    public void setAddDamage(float modifier) {
        this.damageModifier = modifier;
    }

    @Override
    public float getAddDamage() {
        return this.damageModifier;
    }

    @Override
    public void setMaxLifeTime(long maxLifeTime) {
        this.maxLifeTime = maxLifeTime;
    }
}

