/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.entity.ai;

import com.brutalbosses.entity.IOnProjectileHit;
import com.brutalbosses.entity.ai.IAIParams;
import com.brutalbosses.entity.ai.SimpleRangedAttackGoal;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.phys.EntityHitResult;

public class SnowballAttackGoal
extends SimpleRangedAttackGoal {
    public static final ResourceLocation ID = new ResourceLocation("brutalbosses:shootsnowballs");
    private static final double AIM_HEIGHT = 2.0;
    private static final double ARROW_SPEED = 1.0;
    private static final double AIM_SLIGHTLY_HIGHER_MULTIPLIER = 0.18;
    private static final double SPEED_FOR_DIST = 35.0;

    public SnowballAttackGoal(Mob mob, IAIParams params) {
        super(mob, params);
    }

    @Override
    protected ResourceLocation getID() {
        return ID;
    }

    @Override
    protected Projectile createProjectile() {
        Snowball snowballentity = new Snowball(this.mob.m_9236_(), (LivingEntity)this.mob);
        ((IOnProjectileHit)snowballentity).setMaxLifeTime(this.mob.m_9236_().m_46467_() + 800L);
        return snowballentity;
    }

    @Override
    protected void doRangedAttack(@Nullable Projectile snowballentity, LivingEntity target) {
        snowballentity.f_19794_ = false;
        snowballentity.m_20242_(false);
        this.positionProjectile(snowballentity, 1);
        double xVector = target.m_20185_() - snowballentity.m_20185_();
        double yVector = target.m_20191_().f_82289_ + (double)target.m_20206_() / 2.0 - snowballentity.m_20186_();
        double zVector = target.m_20189_() - snowballentity.m_20189_();
        double distance = Math.sqrt(xVector * xVector + zVector * zVector);
        double dist3d = Math.sqrt(yVector * yVector + xVector * xVector + zVector * zVector);
        snowballentity.m_6686_(xVector, yVector + distance * 0.18, zVector, (float)(1.0 + dist3d / 35.0) * this.params.speed, 3.0f);
        this.mob.m_5496_(SoundEvents.f_12479_, 1.0f, 0.4f / (this.mob.m_217043_().m_188501_() * 0.4f + 0.8f));
        if (snowballentity instanceof IOnProjectileHit) {
            ((IOnProjectileHit)snowballentity).setMaxLifeTime(this.mob.m_9236_().m_46467_() + 400L);
            ((IOnProjectileHit)snowballentity).setOnHitAction(rayTraceResult -> {
                Entity hitEntity;
                if (rayTraceResult instanceof EntityHitResult && (hitEntity = ((EntityHitResult)rayTraceResult).m_82443_()) instanceof LivingEntity) {
                    hitEntity.m_6469_(this.mob.m_269291_().m_269390_((Entity)snowballentity, (Entity)this.mob), 1.0f);
                    ((LivingEntity)hitEntity).m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, 4));
                }
            });
        }
    }
}

