/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.command;

import com.brutalbosses.BrutalBosses;
import com.brutalbosses.command.ICommand;
import com.brutalbosses.command.Opcommand;
import com.brutalbosses.entity.BossSpawnHandler;
import com.brutalbosses.entity.BossType;
import com.brutalbosses.entity.BossTypeManager;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ServerLevelAccessor;

public class CommandSpawnBoss
implements Opcommand {
    @Override
    public int onExecute(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        source.m_81352_((Component)Component.m_237113_((String)"Enter a valid boss id(name of the json file)"));
        return 0;
    }

    @Override
    public String getName() {
        return "spawnboss";
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)ICommand.newLiteral(this.getName()).then(ICommand.newArgument("bossID", StringArgumentType.word()).executes(this::executeSpawnBoss))).executes(this::checkPreConditionAndExecute);
    }

    private int executeSpawnBoss(CommandContext<CommandSourceStack> context) {
        try {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            if (!this.checkPreCondition(context)) {
                return 0;
            }
            String bossName = StringArgumentType.getString(context, (String)"bossID");
            if (bossName.equals("random")) {
                BossSpawnHandler.spawnRandomBoss(source.m_81372_(), BlockPos.m_274446_((Position)source.m_81371_()));
                return 0;
            }
            if (bossName.equals("all")) {
                for (BossType type : BossTypeManager.instance.bosses.values()) {
                    BossSpawnHandler.spawnBoss((ServerLevelAccessor)source.m_81372_(), BlockPos.m_274446_((Position)source.m_81371_()), type, null);
                }
                return 0;
            }
            ResourceLocation bossID = new ResourceLocation("brutalbosses", bossName);
            BossType bossType = BossTypeManager.instance.bosses.get(bossID);
            if (bossType == null) {
                source.m_81352_((Component)Component.m_237113_((String)("Enter a valid boss id(name of the json file), no boss found for:" + bossID)));
                return 0;
            }
            BossSpawnHandler.spawnBoss((ServerLevelAccessor)source.m_81372_(), BlockPos.m_274446_((Position)source.m_81371_()), bossType, null);
        }
        catch (Error e) {
            BrutalBosses.LOGGER.error((Object)e);
        }
        return 0;
    }
}

