/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.shieldexp.init;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.ForgeRegistries;

public class Config {
    public static ForgeConfigSpec CONFIG;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> SHIELD_LIST;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> SHIELD_BLACKLIST;
    public static ForgeConfigSpec.BooleanValue STASHING_COOLDOWN;
    public static ForgeConfigSpec.BooleanValue GENERAL_COOLDOWN;
    public static ForgeConfigSpec.BooleanValue SPEED_MODIFICATION;
    public static ForgeConfigSpec.BooleanValue ADVANCED_EXPLOSIONS;
    public static ForgeConfigSpec.BooleanValue LENIENT_PARRY;
    public static ForgeConfigSpec.BooleanValue LENIENT_STAMINA;

    public static Boolean isShield(Item item) {
        String itemID = ForgeRegistries.ITEMS.getKey((Object)item).toString();
        for (String s : (List)SHIELD_BLACKLIST.get()) {
            if (!s.equals(itemID)) continue;
            return false;
        }
        for (String s : (List)SHIELD_LIST.get()) {
            if (!s.equals(itemID)) continue;
            return true;
        }
        return false;
    }

    public static void extendList(String id) {
        ArrayList<String> newList = new ArrayList<String>(List.of());
        newList.addAll((Collection)SHIELD_LIST.get());
        if (!newList.contains(id)) {
            newList.add(id);
        }
        SHIELD_LIST.set(newList);
    }

    public static Boolean stashingCooldownDisabled() {
        return (Boolean)STASHING_COOLDOWN.get();
    }

    public static Boolean cooldownDisabled() {
        return (Boolean)GENERAL_COOLDOWN.get();
    }

    public static Boolean speedModifierDisabled() {
        return (Boolean)SPEED_MODIFICATION.get();
    }

    public static Boolean advancedExplosionsEnabled() {
        return (Boolean)ADVANCED_EXPLOSIONS.get();
    }

    public static Boolean lenientParryEnabled() {
        return (Boolean)LENIENT_PARRY.get();
    }

    public static Boolean lenientStaminaEnabled() {
        return (Boolean)LENIENT_STAMINA.get();
    }

    static {
        ForgeConfigSpec.Builder SHIELD_BUILDER = new ForgeConfigSpec.Builder();
        SHIELD_BUILDER.push("ShieldList");
        SHIELD_BUILDER.comment(new String[]{"", "List of items to considered as shields, any item with right-click functionality will theoretically work", "Automatically populated with items that have parrying stats set by active datapacks"});
        SHIELD_LIST = SHIELD_BUILDER.defineList("shieldList", List.of(), entry -> true);
        SHIELD_BUILDER.comment(new String[]{"", "List of items to not consider as shields, even if they have stats set by a datapack"});
        SHIELD_BLACKLIST = SHIELD_BUILDER.defineList("shieldBlacklist", List.of(), entry -> true);
        SHIELD_BUILDER.pop();
        SHIELD_BUILDER.push("Modifiers");
        SHIELD_BUILDER.comment(new String[]{"", "Disable the cooldown when the player lowers their shield"});
        STASHING_COOLDOWN = SHIELD_BUILDER.define("noLoweringCooldown", false);
        SHIELD_BUILDER.comment(new String[]{"", "Disable putting shields on cooldown at all"});
        GENERAL_COOLDOWN = SHIELD_BUILDER.define("noCooldown", false);
        SHIELD_BUILDER.comment(new String[]{"", "Make all shields have vanilla movement speed"});
        SPEED_MODIFICATION = SHIELD_BUILDER.define("noSpeedModifier", false);
        SHIELD_BUILDER.comment(new String[]{"", "Make shields only block partial damage from explosions when not parrying"});
        ADVANCED_EXPLOSIONS = SHIELD_BUILDER.define("harderExplosions", false);
        SHIELD_BUILDER.comment(new String[]{"", "Double the parry window for a more relaxed experience"});
        LENIENT_PARRY = SHIELD_BUILDER.define("lenientParryMode", false);
        SHIELD_BUILDER.comment(new String[]{"", "Double the shield stamina for a more relaxed experience"});
        LENIENT_STAMINA = SHIELD_BUILDER.define("lenientStaminaMode", false);
        SHIELD_BUILDER.pop();
        CONFIG = SHIELD_BUILDER.build();
    }
}

