/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity;

import com.sargerasarm.noseenotick.Config;
import com.sargerasarm.noseenotick.Utils;
import java.util.function.Consumer;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.server.timings.TimeTracker;

public class TickOptimizer {
    public static void entityTicking(Consumer<Entity> consumer, Entity entity, Level level, RandomSource random) {
        int maxDistanceSquare;
        if (!Utils.enoughPlayers(level)) {
            TickOptimizer.handleGuardEntityTick(consumer, entity);
            return;
        }
        if (Utils.isIgnoredEntity(entity)) {
            TickOptimizer.handleGuardEntityTick(consumer, entity);
            return;
        }
        BlockPos entityPos = entity.m_20183_();
        boolean isInClaimedChunk = Utils.isInClaimedChunk(level, entityPos);
        if (!(entity instanceof LivingEntity) || entity instanceof Player) {
            if (!isInClaimedChunk && entity instanceof ItemEntity && random.m_188503_(4) == 0) {
                return;
            }
            TickOptimizer.handleGuardEntityTick(consumer, entity);
            return;
        }
        int maxHeight = (Integer)Config.maxEntityTickDistanceVertical.get();
        if (Utils.isNearPlayer(level, entityPos, maxHeight, maxDistanceSquare = ((Integer)Config.maxEntityTickDistanceHorizontal.get()).intValue())) {
            TickOptimizer.handleGuardEntityTick(consumer, entity);
            return;
        }
        if (isInClaimedChunk || ((LivingEntity)entity).m_21224_()) {
            TickOptimizer.handleGuardEntityTick(consumer, entity);
        }
    }

    public static void handleGuardEntityTick(Consumer<Entity> consumer, Entity entity) {
        try {
            TimeTracker.ENTITY_UPDATE.trackStart((Object)entity);
            consumer.accept(entity);
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.m_127521_((Throwable)throwable, (String)"Ticking entity");
            CrashReportCategory crashreportcategory = crashreport.m_127514_("Entity being ticked");
            entity.m_7976_(crashreportcategory);
            throw new ReportedException(crashreport);
        }
        finally {
            TimeTracker.ENTITY_UPDATE.trackEnd((Object)entity);
        }
    }
}

