/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.trashslot.network;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.trashslot.TrashHelper;
import net.blay09.mods.trashslot.config.TrashSlotConfig;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class MessageTrashSlotClick {
    private final ItemStack itemStack;
    private final boolean isRightClick;

    public MessageTrashSlotClick(ItemStack itemStack, boolean isRightClick) {
        this.itemStack = itemStack;
        this.isRightClick = isRightClick;
    }

    public static void encode(MessageTrashSlotClick message, FriendlyByteBuf buf) {
        buf.m_130055_(message.itemStack);
        buf.writeBoolean(message.isRightClick);
    }

    public static MessageTrashSlotClick decode(FriendlyByteBuf buf) {
        ItemStack itemStack = buf.m_130267_();
        boolean isRightClick = buf.readBoolean();
        return new MessageTrashSlotClick(itemStack, isRightClick);
    }

    public static void handle(ServerPlayer player, MessageTrashSlotClick message) {
        if (player.m_5833_()) {
            return;
        }
        ItemStack actualMouseItem = player.f_36096_.m_142621_();
        ResourceLocation registryName = Balm.getRegistries().getKey(actualMouseItem.m_41720_());
        if (registryName != null && TrashSlotConfig.getActive().deletionDenyList.contains(registryName.toString())) {
            return;
        }
        if (ItemStack.m_41728_((ItemStack)actualMouseItem, (ItemStack)message.itemStack)) {
            if (actualMouseItem.m_41619_()) {
                ItemStack trashStack = TrashHelper.getTrashItem((Player)player);
                ItemStack mouseStack = message.isRightClick ? trashStack.m_41620_(1) : trashStack;
                player.f_36096_.m_142503_(mouseStack);
                TrashHelper.setTrashItem((Player)player, message.isRightClick ? trashStack : ItemStack.f_41583_);
            } else {
                ItemStack trashStack = message.isRightClick ? actualMouseItem.m_41620_(1) : actualMouseItem;
                TrashHelper.setTrashItem((Player)player, trashStack);
                player.f_36096_.m_142503_(message.isRightClick ? actualMouseItem : ItemStack.f_41583_);
            }
        }
    }
}

