/*
 * Decompiled with CFR 0.152.
 */
package com.forsteri.createappliedkinetics.content.meProxy;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.me.storage.NetworkStorage;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.EmptyFluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class MEProxyInventoryHandler
implements IItemHandler,
IFluidHandler {
    NetworkStorage storage;

    public MEProxyInventoryHandler(NetworkStorage storage) {
        this.storage = storage;
    }

    List<AEFluidKey> getFluidKeys() {
        return this.storage.getAvailableStacks().keySet().stream().filter(aeKey -> aeKey instanceof AEFluidKey).map(aeKey -> (AEFluidKey)aeKey).toList();
    }

    List<AEItemKey> getItemKeys() {
        return this.storage.getAvailableStacks().keySet().stream().filter(aeKey -> aeKey instanceof AEItemKey).map(aeKey -> (AEItemKey)aeKey).toList();
    }

    public int getTanks() {
        return this.getFluidKeys().size();
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        if (tank >= this.getFluidKeys().size()) {
            return FluidStack.EMPTY;
        }
        return this.getFluidKeys().get(tank).toStack((int)this.storage.extract((AEKey)this.getFluidKeys().get(tank), Integer.MAX_VALUE, Actionable.SIMULATE, IActionSource.empty()));
    }

    public int getTankCapacity(int tank) {
        return Integer.MAX_VALUE;
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return this.storage.insert((AEKey)AEFluidKey.of((FluidStack)stack), (long)stack.getAmount(), Actionable.SIMULATE, IActionSource.empty()) > 0L;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return (int)this.storage.insert((AEKey)AEFluidKey.of((FluidStack)resource), (long)resource.getAmount(), action == IFluidHandler.FluidAction.EXECUTE ? Actionable.MODULATE : Actionable.SIMULATE, IActionSource.empty());
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        FluidStack copied = resource.copy();
        if (copied.getFluid() instanceof EmptyFluid) {
            return FluidStack.EMPTY;
        }
        copied.setAmount((int)this.storage.extract((AEKey)AEFluidKey.of((FluidStack)resource), (long)resource.getAmount(), action == IFluidHandler.FluidAction.EXECUTE ? Actionable.MODULATE : Actionable.SIMULATE, IActionSource.empty()));
        return copied.getAmount() > 0 ? copied : FluidStack.EMPTY;
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return this.drain(this.getFluidInTank(0), action);
    }

    public int getSlots() {
        return this.getItemKeys().size() + 16;
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        if (slot >= this.getItemKeys().size()) {
            return ItemStack.f_41583_;
        }
        return this.getItemKeys().get(slot).toStack((int)this.storage.extract((AEKey)this.getItemKeys().get(slot), Integer.MAX_VALUE, Actionable.SIMULATE, IActionSource.empty()));
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        ItemStack copied = stack.m_41777_();
        copied.m_41764_(copied.m_41613_() - (int)this.storage.insert((AEKey)AEItemKey.of((ItemStack)stack), (long)stack.m_41613_(), simulate ? Actionable.SIMULATE : Actionable.MODULATE, IActionSource.empty()));
        return copied;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack stackInSlot = this.getStackInSlot(slot).m_41777_();
        stackInSlot.m_41764_((int)this.storage.extract((AEKey)AEItemKey.of((ItemStack)this.getStackInSlot(slot)), (long)amount, simulate ? Actionable.SIMULATE : Actionable.MODULATE, IActionSource.empty()));
        return stackInSlot;
    }

    public int getSlotLimit(int slot) {
        return Integer.MAX_VALUE;
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return this.insertItem(slot, stack, true).m_41613_() == 0;
    }
}

