/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.illagersweararmor;

import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import tallestegg.illagersweararmor.IWAConfig;
import tallestegg.illagersweararmor.IWAHelper;
import tallestegg.illagersweararmor.loot_tables.IWALootTables;

@Mod.EventBusSubscriber(modid="zillagersweararmor")
public class IWASpawnEvents {
    @SubscribeEvent
    public static void finalizeSpawn(MobSpawnEvent.FinalizeSpawn event) {
        MobSpawnType spawnType = event.getSpawnType();
        Mob entity = event.getEntity();
        if (!IWAConfig.ArmorBlackList.contains(entity.m_20078_())) {
            Mob mob;
            if (entity instanceof Raider) {
                Raider raider = (Raider)entity;
                if ((entity instanceof AbstractIllager || entity instanceof Witch) && IWAConfig.IllagerArmor) {
                    if (raider.m_37885_() != null && spawnType == MobSpawnType.EVENT) {
                        raider.m_19880_().add("raidArmorSpawn");
                    } else {
                        raider.m_19880_().add("naturalArmorSpawn");
                    }
                }
            }
            if ((mob = event.getEntity()) instanceof Vex) {
                Vex vex = (Vex)mob;
                vex.m_19880_().add("naturalArmorSpawn");
            }
        }
    }

    @SubscribeEvent
    public static void tickEntity(LivingEvent.LivingTickEvent event) {
        Vex vex;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Raider) {
            Raider raider = (Raider)livingEntity;
            if (raider.m_19880_().contains("raidArmorSpawn")) {
                IWASpawnEvents.giveArmorOnRaids(raider, raider.m_217043_());
                raider.m_19880_().remove("raidArmorSpawn");
            } else if (raider.m_19880_().contains("naturalArmorSpawn")) {
                IWASpawnEvents.getItemsFromLootTable((LivingEntity)raider);
                raider.m_19880_().remove("naturalArmorSpawn");
            }
        }
        if ((livingEntity = event.getEntity()) instanceof Vex && (vex = (Vex)livingEntity).m_19880_().contains("naturalArmorSpawn")) {
            IWASpawnEvents.getItemsFromLootTable((LivingEntity)vex);
            vex.m_19880_().remove("naturalArmorSpawn");
        }
    }

    public static void giveArmorOnRaids(Raider raider, RandomSource pRandom) {
        if (raider.m_37885_() == null) {
            return;
        }
        if (pRandom.m_188501_() < IWAHelper.getWaveArmorChances(raider.m_37887_())) {
            IWASpawnEvents.getItemsFromLootTable((LivingEntity)raider);
        }
    }

    public static List<ItemStack> getItemsFromLootTable(LivingEntity entity) {
        Raider raider;
        boolean raiding = entity instanceof Raider && (raider = (Raider)entity).m_37885_() != null;
        LootTable loot = entity.m_9236_().m_7654_().m_278653_().m_278676_(IWASpawnEvents.getLootTable(entity, raiding));
        if (loot == LootTable.f_79105_) {
            String inRaid = raiding ? "_raid" : "";
            ResourceLocation lootTable = new ResourceLocation("zillagersweararmor", "entities/illager" + inRaid);
            loot = entity.m_9236_().m_7654_().m_278653_().m_278676_(lootTable);
        }
        LootParams.Builder lootcontext$builder = new LootParams.Builder((ServerLevel)entity.m_9236_()).m_287286_(LootContextParams.f_81455_, (Object)entity);
        return loot.m_287195_(lootcontext$builder.m_287235_(IWALootTables.SLOT));
    }

    public static ResourceLocation getLootTable(LivingEntity entity, boolean raid) {
        String illagerName = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_()).m_135815_();
        String inRaid = raid ? "_raid" : "";
        ResourceLocation lootTable = new ResourceLocation("zillagersweararmor", "entities/" + illagerName + inRaid);
        return lootTable;
    }
}

