/*
 * Decompiled with CFR 0.152.
 */
package com.teampotato.sparsestructuresreforged.mixin;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Decoder;
import com.teampotato.sparsestructuresreforged.CustomSpreadFactors;
import com.teampotato.sparsestructuresreforged.SparseStructures;
import java.io.Reader;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.core.WritableRegistry;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.RegistryDataLoader;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={RegistryDataLoader.class})
public abstract class RegistryDataLoaderMixin {
    @Inject(method={"loadRegistryContents"}, at={@At(value="INVOKE", remap=false, target="Lcom/mojang/serialization/Decoder;parse(Lcom/mojang/serialization/DynamicOps;Ljava/lang/Object;)Lcom/mojang/serialization/DataResult;")}, locals=LocalCapture.CAPTURE_FAILEXCEPTION)
    private static <E> void ssr$init(RegistryOps.RegistryInfoLookup lookup, ResourceManager manager, ResourceKey<? extends Registry<E>> registryKey, WritableRegistry<E> registry, Decoder<E> decoder, Map<ResourceKey<?>, Exception> exceptions, CallbackInfo ci, String string, FileToIdConverter converter, RegistryOps<JsonElement> registryOps, Iterator<Map.Entry<ResourceLocation, Resource>> iterator, Map.Entry<ResourceLocation, Resource> entry, ResourceLocation resourcelocation, ResourceKey<E> resourceKey, Resource resource, Reader reader, JsonElement jsonElement) {
        if (string.equals("worldgen/structure_set")) {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            JsonObject placement = jsonObject.getAsJsonObject("placement");
            if (placement.get("type").getAsString().equals("minecraft:concentric_rings")) {
                return;
            }
            double factor = SparseStructures.config.customSpreadFactors.stream().filter(s -> {
                if (s == null) {
                    return false;
                }
                String structure_set = resourceKey.m_135782_().toString();
                return structure_set.equals(s.structure()) || jsonObject.getAsJsonArray("structures").asList().stream().anyMatch(p -> p.getAsJsonObject().get("structure").getAsString().equals(s.structure()));
            }).findFirst().orElse(new CustomSpreadFactors("", SparseStructures.config.spreadFactor)).factor();
            int spacing = placement.get("spacing") == null ? 1 : (int)Math.min(placement.get("spacing").getAsDouble() * factor, 4096.0);
            int separation = placement.get("separation") == null ? 1 : (int)Math.min(placement.get("separation").getAsDouble() * factor, 4096.0);
            if (separation >= spacing) {
                if (spacing == 0) {
                    spacing = 1;
                }
                separation = spacing - 1;
            }
            placement.addProperty("spacing", (Number)spacing);
            placement.addProperty("separation", (Number)separation);
        }
    }
}

