/*
 * Decompiled with CFR 0.152.
 */
package uwu.lopyluna.create_dd.jei;

import com.simibubi.create.AllItems;
import com.simibubi.create.compat.jei.BlueprintTransferHandler;
import com.simibubi.create.compat.jei.ConversionRecipe;
import com.simibubi.create.compat.jei.CreateJEI;
import com.simibubi.create.compat.jei.DoubleItemIcon;
import com.simibubi.create.compat.jei.EmptyBackground;
import com.simibubi.create.compat.jei.ItemIcon;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.foundation.config.ConfigBase;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import com.simibubi.create.foundation.utility.Lang;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import uwu.lopyluna.create_dd.DDCreate;
import uwu.lopyluna.create_dd.block.DDBlocks;
import uwu.lopyluna.create_dd.configs.DDConfigs;
import uwu.lopyluna.create_dd.configs.server.DDRecipes;
import uwu.lopyluna.create_dd.item.DDItems;
import uwu.lopyluna.create_dd.jei.MysteriousConversion;
import uwu.lopyluna.create_dd.jei.fan.DDProcessingViaFanCategory;
import uwu.lopyluna.create_dd.jei.fan.FanFreezingCategory;
import uwu.lopyluna.create_dd.jei.fan.FanSuperheatingCategory;
import uwu.lopyluna.create_dd.recipe.DDRecipesTypes;
import uwu.lopyluna.create_dd.recipe.Recipes.FreezingRecipe;
import uwu.lopyluna.create_dd.recipe.Recipes.SuperheatingRecipe;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@JeiPlugin
public class DDcreateJEI
implements IModPlugin {
    private static final ResourceLocation MOD_ID = new ResourceLocation("create_dd", "jei_plugin");
    public IIngredientManager ingredientManager;
    private static final List<CreateRecipeCategory<?>> DDCategories = new ArrayList();

    @Nonnull
    public ResourceLocation getPluginUid() {
        return MOD_ID;
    }

    private void loadCategories() {
        DDCategories.clear();
        CreateRecipeCategory freezing = this.builder(FreezingRecipe.class).addTypedRecipes(DDRecipesTypes.FREEZING::getType).catalystStack(DDProcessingViaFanCategory.getFan("industrial_fan_freezing")).doubleItemIcon((ItemLike)AllItems.PROPELLER.get(), (ItemLike)Items.f_151055_).emptyBackground(178, 72).build("industrial_fan_freezing", FanFreezingCategory::new);
        CreateRecipeCategory<SuperheatingRecipe> superheating = this.builder(SuperheatingRecipe.class).addTypedRecipes(DDRecipesTypes.SUPERHEATING).catalystStack(DDProcessingViaFanCategory.getFan("industrial_fan_superheating")).doubleItemIcon((ItemLike)AllItems.PROPELLER.get(), (ItemLike)AllItems.BLAZE_CAKE.get()).emptyBackground(178, 72).build("industrial_fan_superheating", (CreateRecipeCategory.Factory<SuperheatingRecipe>)((CreateRecipeCategory.Factory)FanSuperheatingCategory::new));
        CreateRecipeCategory also_mysteryConversion = this.builder(ConversionRecipe.class).addRecipes(() -> MysteriousConversion.RECIPES).itemIcon((ItemLike)DDItems.CHROMATIC_COMPOUND.get()).emptyBackground(177, 50).build("also_mystery_conversion", MysteriousConversion::new);
    }

    public void registerRecipes(IRecipeRegistration registration) {
        this.ingredientManager = registration.getIngredientManager();
        DDCategories.forEach(c -> c.registerRecipes(registration));
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        this.loadCategories();
        registration.addRecipeCategories((IRecipeCategory[])DDCategories.toArray(IRecipeCategory[]::new));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        DDCategories.forEach(c -> c.registerCatalysts(registration));
        registration.getJeiHelpers().getRecipeType(new ResourceLocation("create", "pressing")).ifPresent(type -> registration.addRecipeCatalyst(new ItemStack((ItemLike)DDBlocks.hydraulic_press.get()), new RecipeType[]{type}));
        registration.getJeiHelpers().getRecipeType(new ResourceLocation("create", "sawing")).ifPresent(type -> registration.addRecipeCatalyst(new ItemStack((ItemLike)DDBlocks.BRONZE_SAW.get()), new RecipeType[]{type}));
        registration.getJeiHelpers().getRecipeType(new ResourceLocation("create", "block_cutting")).ifPresent(type -> registration.addRecipeCatalyst(new ItemStack((ItemLike)DDBlocks.BRONZE_SAW.get()), new RecipeType[]{type}));
        registration.getJeiHelpers().getRecipeType(new ResourceLocation("create", "wood_cutting")).ifPresent(type -> registration.addRecipeCatalyst(new ItemStack((ItemLike)DDBlocks.BRONZE_SAW.get()), new RecipeType[]{type}));
        registration.getJeiHelpers().getRecipeType(new ResourceLocation("create", "fan_washing")).ifPresent(type -> registration.addRecipeCatalyst(new ItemStack((ItemLike)DDBlocks.industrial_fan.get()), new RecipeType[]{type}));
        registration.getJeiHelpers().getRecipeType(new ResourceLocation("create", "fan_smoking")).ifPresent(type -> registration.addRecipeCatalyst(new ItemStack((ItemLike)DDBlocks.industrial_fan.get()), new RecipeType[]{type}));
        registration.getJeiHelpers().getRecipeType(new ResourceLocation("create", "fan_blasting")).ifPresent(type -> registration.addRecipeCatalyst(new ItemStack((ItemLike)DDBlocks.industrial_fan.get()), new RecipeType[]{type}));
        registration.getJeiHelpers().getRecipeType(new ResourceLocation("create", "fan_haunting")).ifPresent(type -> registration.addRecipeCatalyst(new ItemStack((ItemLike)DDBlocks.industrial_fan.get()), new RecipeType[]{type}));
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new BlueprintTransferHandler(), RecipeTypes.CRAFTING);
    }

    private <T extends Recipe<?>> CategoryBuilder<T> builder(Class<? extends T> recipeClass) {
        return new CategoryBuilder<T>(recipeClass);
    }

    public static void consumeAllRecipes(Consumer<Recipe<?>> consumer) {
        Objects.requireNonNull(Minecraft.m_91087_().m_91403_()).m_105141_().m_44051_().forEach(consumer);
    }

    private static class CategoryBuilder<T extends Recipe<?>> {
        private final Class<? extends T> recipeClass;
        private Predicate<DDRecipes> predicate = cRecipes -> true;
        private IDrawable background;
        private IDrawable icon;
        private final List<Consumer<List<T>>> recipeListConsumers = new ArrayList<Consumer<List<T>>>();
        private final List<Supplier<? extends ItemStack>> catalysts = new ArrayList<Supplier<? extends ItemStack>>();

        public CategoryBuilder(Class<? extends T> recipeClass) {
            this.recipeClass = recipeClass;
        }

        public CategoryBuilder<T> enableIf(Predicate<DDRecipes> predicate) {
            this.predicate = predicate;
            return this;
        }

        public CategoryBuilder<T> enableWhen(Function<DDRecipes, ConfigBase.ConfigBool> configValue) {
            this.predicate = c -> (Boolean)((ConfigBase.ConfigBool)configValue.apply((DDRecipes)c)).get();
            return this;
        }

        public CategoryBuilder<T> addRecipeListConsumer(Consumer<List<T>> consumer) {
            this.recipeListConsumers.add(consumer);
            return this;
        }

        public CategoryBuilder<T> addRecipes(Supplier<Collection<? extends T>> collection) {
            return this.addRecipeListConsumer(recipes -> recipes.addAll((Collection)collection.get()));
        }

        public CategoryBuilder<T> addAllRecipesIf(Predicate<Recipe<?>> pred) {
            return this.addRecipeListConsumer(recipes -> DDcreateJEI.consumeAllRecipes(recipe -> {
                if (pred.test((Recipe<?>)recipe)) {
                    recipes.add(recipe);
                }
            }));
        }

        public CategoryBuilder<T> addAllRecipesIf(Predicate<Recipe<?>> pred, Function<Recipe<?>, T> converter) {
            return this.addRecipeListConsumer(recipes -> DDcreateJEI.consumeAllRecipes(recipe -> {
                if (pred.test((Recipe<?>)recipe)) {
                    recipes.add((Recipe)converter.apply((Recipe<?>)recipe));
                }
            }));
        }

        public CategoryBuilder<T> addTypedRecipes(IRecipeTypeInfo recipeTypeEntry) {
            return this.addTypedRecipes(() -> ((IRecipeTypeInfo)recipeTypeEntry).getType());
        }

        public CategoryBuilder<T> addTypedRecipes(Supplier<net.minecraft.world.item.crafting.RecipeType<? extends T>> recipeType) {
            return this.addRecipeListConsumer(recipes -> CreateJEI.consumeTypedRecipes(recipes::add, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)recipeType.get())));
        }

        public CategoryBuilder<T> addTypedRecipes(Supplier<net.minecraft.world.item.crafting.RecipeType<? extends T>> recipeType, Function<Recipe<?>, T> converter) {
            return this.addRecipeListConsumer(recipes -> CreateJEI.consumeTypedRecipes(recipe -> recipes.add((Recipe)converter.apply((Recipe<?>)recipe)), (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)recipeType.get())));
        }

        public CategoryBuilder<T> addTypedRecipesIf(Supplier<net.minecraft.world.item.crafting.RecipeType<? extends T>> recipeType, Predicate<Recipe<?>> pred) {
            return this.addRecipeListConsumer(recipes -> CreateJEI.consumeTypedRecipes(recipe -> {
                if (pred.test((Recipe<?>)recipe)) {
                    recipes.add(recipe);
                }
            }, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)recipeType.get())));
        }

        public CategoryBuilder<T> addTypedRecipesExcluding(Supplier<net.minecraft.world.item.crafting.RecipeType<? extends T>> recipeType, Supplier<net.minecraft.world.item.crafting.RecipeType<? extends T>> excluded) {
            return this.addRecipeListConsumer(recipes -> {
                List<Recipe<?>> excludedRecipes = CategoryBuilder.DDgetTypedRecipes((net.minecraft.world.item.crafting.RecipeType)excluded.get());
                CreateJEI.consumeTypedRecipes(recipe -> {
                    for (Recipe excludedRecipe : excludedRecipes) {
                        if (!CategoryBuilder.DDdoInputsMatch(recipe, excludedRecipe)) continue;
                        return;
                    }
                    recipes.add(recipe);
                }, (net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)recipeType.get()));
            });
        }

        public CategoryBuilder<T> removeRecipes(Supplier<net.minecraft.world.item.crafting.RecipeType<? extends T>> recipeType) {
            return this.addRecipeListConsumer(recipes -> {
                List<Recipe<?>> excludedRecipes = CategoryBuilder.DDgetTypedRecipes((net.minecraft.world.item.crafting.RecipeType)recipeType.get());
                recipes.removeIf(recipe -> {
                    for (Recipe excludedRecipe : excludedRecipes) {
                        if (!CategoryBuilder.DDdoInputsMatch(recipe, excludedRecipe)) continue;
                        return true;
                    }
                    return false;
                });
            });
        }

        public static List<Recipe<?>> DDgetTypedRecipes(net.minecraft.world.item.crafting.RecipeType<?> type) {
            ArrayList recipes = new ArrayList();
            CreateJEI.consumeTypedRecipes(recipes::add, type);
            return recipes;
        }

        public static List<Recipe<?>> DDgetTypedRecipesExcluding(net.minecraft.world.item.crafting.RecipeType<?> type, Predicate<Recipe<?>> exclusionPred) {
            List<Recipe<?>> recipes = CategoryBuilder.DDgetTypedRecipes(type);
            recipes.removeIf(exclusionPred);
            return recipes;
        }

        public static boolean DDdoInputsMatch(Recipe<?> recipe1, Recipe<?> recipe2) {
            if (recipe1.m_7527_().isEmpty() || recipe2.m_7527_().isEmpty()) {
                return false;
            }
            ItemStack[] matchingStacks = ((Ingredient)recipe1.m_7527_().get(0)).m_43908_();
            if (matchingStacks.length == 0) {
                return false;
            }
            return ((Ingredient)recipe2.m_7527_().get(0)).test(matchingStacks[0]);
        }

        public CategoryBuilder<T> catalystStack(Supplier<ItemStack> supplier) {
            this.catalysts.add(supplier);
            return this;
        }

        public CategoryBuilder<T> catalyst(Supplier<ItemLike> supplier) {
            return this.catalystStack(() -> new ItemStack((ItemLike)((ItemLike)supplier.get()).m_5456_()));
        }

        public CategoryBuilder<T> icon(IDrawable icon) {
            this.icon = icon;
            return this;
        }

        public CategoryBuilder<T> itemIcon(ItemLike item) {
            this.icon((IDrawable)new ItemIcon(() -> new ItemStack(item)));
            return this;
        }

        public CategoryBuilder<T> doubleItemIcon(ItemLike item1, ItemLike item2) {
            this.icon((IDrawable)new DoubleItemIcon(() -> new ItemStack(item1), () -> new ItemStack(item2)));
            return this;
        }

        public CategoryBuilder<T> background(IDrawable background) {
            this.background = background;
            return this;
        }

        public CategoryBuilder<T> emptyBackground(int width, int height) {
            this.background((IDrawable)new EmptyBackground(width, height));
            return this;
        }

        public CreateRecipeCategory<T> build(String name, CreateRecipeCategory.Factory<T> factory) {
            Supplier<List> recipesSupplier = this.predicate.test(DDConfigs.server().recipes) ? () -> {
                ArrayList recipes = new ArrayList();
                for (Consumer consumer : this.recipeListConsumers) {
                    consumer.accept(recipes);
                }
                return recipes;
            } : Collections::emptyList;
            CreateRecipeCategory.Info info = new CreateRecipeCategory.Info(new RecipeType(DDCreate.asResource(name), this.recipeClass), (Component)Lang.translateDirect((String)("recipe." + name), (Object[])new Object[0]), this.background, this.icon, recipesSupplier, this.catalysts);
            CreateRecipeCategory category = factory.create(info);
            DDCategories.add(category);
            return category;
        }
    }
}

