/*
 * Decompiled with CFR 0.152.
 */
package uwu.lopyluna.create_dd.item.ItemProperties.sawtool;

import com.simibubi.create.AllTags;
import com.simibubi.create.content.equipment.armor.BacktankUtil;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModelRenderer;
import com.simibubi.create.foundation.item.render.SimpleCustomRenderer;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import uwu.lopyluna.create_dd.item.DDItems;
import uwu.lopyluna.create_dd.item.ItemProperties.BobTiers;
import uwu.lopyluna.create_dd.item.ItemProperties.sawtool.ForestRavagerRender;
import uwu.lopyluna.create_dd.item.ItemProperties.sawtool.RavagerAxeItem;
import uwu.lopyluna.create_dd.item.ItemProperties.sawtool.TreeCutter;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForestRavagerItem
extends RavagerAxeItem {
    public static int maxUses;
    private static boolean deforesting;

    public ForestRavagerItem(Item.Properties builder) {
        super(BobTiers.Ravager, 5.5f, -3.1f, builder);
    }

    public static void destroyTree(Level iWorld, BlockState state, BlockPos pos, Player player) {
        if (deforesting || !state.m_204336_(BlockTags.f_13106_) && !AllTags.AllBlockTags.SLIMY_LOGS.matches(state) || !player.m_6047_() || !(iWorld instanceof Level)) {
            return;
        }
        Level worldIn = iWorld;
        Vec3 vec = player.m_20154_();
        deforesting = true;
        TreeCutter.findTree((BlockGetter)worldIn, pos).destroyBlocks(worldIn, (LivingEntity)player, (dropPos, item) -> ForestRavagerItem.dropItemFromCutTree(worldIn, pos, vec, dropPos, item));
        deforesting = false;
    }

    @SubscribeEvent
    public static void onBlockDestroyed(BlockEvent.BreakEvent event) {
        ItemStack heldItemMainhand = event.getPlayer().m_21120_(InteractionHand.MAIN_HAND);
        if (!DDItems.forest_ravager.isIn(heldItemMainhand)) {
            return;
        }
        ForestRavagerItem.destroyTree((Level)event.getLevel(), event.getState(), event.getPos(), event.getPlayer());
    }

    public static void dropItemFromCutTree(Level world, BlockPos breakingPos, Vec3 fallDirection, BlockPos pos, ItemStack stack) {
        float distance = (float)Math.sqrt(pos.m_123331_((Vec3i)breakingPos));
        Vec3 dropPos = VecHelper.getCenterOf((Vec3i)pos);
        ItemEntity entity = new ItemEntity(world, dropPos.f_82479_, dropPos.f_82480_, dropPos.f_82481_, stack);
        entity.m_20256_(fallDirection.m_82490_((double)(distance / 20.0f)));
        world.m_7967_((Entity)entity);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept((IClientItemExtensions)SimpleCustomRenderer.create((Item)this, (CustomRenderedItemModelRenderer)new ForestRavagerRender()));
    }

    public boolean m_142522_(@NotNull ItemStack stack) {
        return BacktankUtil.isBarVisible((ItemStack)stack, (int)ForestRavagerItem.maxUses());
    }

    public int m_142158_(@NotNull ItemStack stack) {
        return BacktankUtil.getBarWidth((ItemStack)stack, (int)ForestRavagerItem.maxUses());
    }

    public int m_142159_(@NotNull ItemStack stack) {
        return BacktankUtil.getBarColor((ItemStack)stack, (int)ForestRavagerItem.maxUses());
    }

    public static int maxUses() {
        return BobTiers.Ravager.m_6609_();
    }

    static {
        deforesting = false;
    }
}

