/*
 * Decompiled with CFR 0.152.
 */
package uwu.lopyluna.create_dd.configs;

import com.simibubi.create.content.kinetics.BlockStressValues;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;
import uwu.lopyluna.create_dd.configs.DDConfigBase;
import uwu.lopyluna.create_dd.configs.client.DDClient;
import uwu.lopyluna.create_dd.configs.common.DDCommon;
import uwu.lopyluna.create_dd.configs.server.DDServer;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class DDConfigs {
    private static final Map<ModConfig.Type, DDConfigBase> CONFIGS = new EnumMap<ModConfig.Type, DDConfigBase>(ModConfig.Type.class);
    private static DDClient client;
    private static DDCommon common;
    private static DDServer server;

    public static DDClient client() {
        return client;
    }

    public static DDCommon common() {
        return common;
    }

    public static DDServer server() {
        return server;
    }

    public static DDConfigBase byType(ModConfig.Type type) {
        return CONFIGS.get(type);
    }

    private static <T extends DDConfigBase> T register(Supplier<T> factory, ModConfig.Type side) {
        Pair specPair = new ForgeConfigSpec.Builder().configure(builder -> {
            DDConfigBase config = (DDConfigBase)factory.get();
            config.registerAll((ForgeConfigSpec.Builder)builder);
            return config;
        });
        DDConfigBase config = (DDConfigBase)specPair.getLeft();
        config.specification = (ForgeConfigSpec)specPair.getRight();
        CONFIGS.put(side, config);
        return (T)config;
    }

    public static void register(ModLoadingContext context) {
        client = DDConfigs.register(DDClient::new, ModConfig.Type.CLIENT);
        common = DDConfigs.register(DDCommon::new, ModConfig.Type.COMMON);
        server = DDConfigs.register(DDServer::new, ModConfig.Type.SERVER);
        for (Map.Entry<ModConfig.Type, DDConfigBase> pair : CONFIGS.entrySet()) {
            context.registerConfig(pair.getKey(), (IConfigSpec)pair.getValue().specification);
        }
        BlockStressValues.registerProvider((String)context.getActiveNamespace(), (BlockStressValues.IStressValueProvider)DDConfigs.server().kinetics.stressValues);
    }

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading event) {
        for (DDConfigBase config : CONFIGS.values()) {
            if (config.specification != event.getConfig().getSpec()) continue;
            config.onLoad();
        }
    }

    @SubscribeEvent
    public static void onReload(ModConfigEvent.Reloading event) {
        for (DDConfigBase config : CONFIGS.values()) {
            if (config.specification != event.getConfig().getSpec()) continue;
            config.onReload();
        }
    }
}

