/*
 * Decompiled with CFR 0.152.
 */
package uwu.lopyluna.create_dd.block.BlockProperties.hydraulic_press;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.core.materials.oriented.OrientedData;
import com.mojang.math.Axis;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.ShaftInstance;
import com.simibubi.create.content.kinetics.press.PressingBehaviour;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import net.minecraft.core.Direction;
import org.joml.Quaternionf;
import uwu.lopyluna.create_dd.block.BlockProperties.hydraulic_press.HydraulicPressBlock;
import uwu.lopyluna.create_dd.block.BlockProperties.hydraulic_press.HydraulicPressBlockEntity;
import uwu.lopyluna.create_dd.block.BlockResources.DDBlockPartialModel;

public class HYPressInstance
extends ShaftInstance<HydraulicPressBlockEntity>
implements DynamicInstance {
    private final OrientedData pressHead;

    public HYPressInstance(MaterialManager materialManager, HydraulicPressBlockEntity blockEntity) {
        super(materialManager, (KineticBlockEntity)blockEntity);
        this.pressHead = (OrientedData)materialManager.defaultSolid().material(Materials.ORIENTED).getModel(DDBlockPartialModel.HYDRAULIC_PRESS_HEAD, this.blockState).createInstance();
        Quaternionf q = Axis.f_252436_.m_252977_(AngleHelper.horizontalAngle((Direction)((Direction)this.blockState.m_61143_(HydraulicPressBlock.HORIZONTAL_FACING))));
        this.pressHead.setRotation(q);
        this.transformModels();
    }

    public void beginFrame() {
        this.transformModels();
    }

    private void transformModels() {
        float renderedHeadOffset = this.getRenderedHeadOffset((HydraulicPressBlockEntity)this.blockEntity);
        this.pressHead.setPosition(this.getInstancePosition()).nudge(0.0f, -renderedHeadOffset, 0.0f);
    }

    private float getRenderedHeadOffset(HydraulicPressBlockEntity press) {
        PressingBehaviour pressingBehaviour = press.getPressingBehaviour();
        return pressingBehaviour.getRenderedHeadOffset(AnimationTickHolder.getPartialTicks()) * pressingBehaviour.mode.headOffset;
    }

    public void updateLight() {
        super.updateLight();
        this.relight(this.pos, new FlatLit[]{this.pressHead});
    }

    public void remove() {
        super.remove();
        this.pressHead.delete();
    }
}

