/*
 * Decompiled with CFR 0.152.
 */
package uwu.lopyluna.create_dd.block.BlockProperties.flywheel.engine;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class FurnaceEngineInteractions {
    private static final Map<Holder<Block>, InteractionHandler> HANDLERS = new HashMap<Holder<Block>, InteractionHandler>();
    private static final InteractionHandler DEFAULT_HANDLER = new InteractionHandler(){};

    public static void registerHandler(Holder<Block> block, InteractionHandler handler) {
        HANDLERS.put(block, handler);
    }

    public static InteractionHandler getHandler(Holder<Block> delegate) {
        return HANDLERS.getOrDefault(delegate, DEFAULT_HANDLER);
    }

    public static InteractionHandler getHandler(BlockState state) {
        return FurnaceEngineInteractions.getHandler((Holder<Block>)state.m_60734_().m_49966_().m_222976_());
    }

    public static void registerDefaults() {
        FurnaceEngineInteractions.registerHandler((Holder<Block>)Blocks.f_50620_.m_49966_().m_222976_(), InteractionHandler.ofCustomSpeedModifier(state -> Float.valueOf(2.0f)));
    }

    public static interface InteractionHandler {
        default public HeatSource getHeatSource(BlockState state) {
            if (state.m_60734_() instanceof AbstractFurnaceBlock && state.m_61138_((Property)AbstractFurnaceBlock.f_48684_)) {
                if (((Boolean)state.m_61143_((Property)AbstractFurnaceBlock.f_48684_)).booleanValue()) {
                    return HeatSource.ACTIVE;
                }
                return HeatSource.VALID;
            }
            return HeatSource.EMPTY;
        }

        default public float getSpeedModifier(BlockState state) {
            return 1.0f;
        }

        public static InteractionHandler of(final Function<BlockState, HeatSource> heatSourceFunc, final Function<BlockState, Float> speedModifierFunc) {
            return new InteractionHandler(){

                @Override
                public HeatSource getHeatSource(BlockState state) {
                    return (HeatSource)((Object)heatSourceFunc.apply(state));
                }

                @Override
                public float getSpeedModifier(BlockState state) {
                    return ((Float)speedModifierFunc.apply(state)).floatValue();
                }
            };
        }

        public static InteractionHandler ofCustomHeatSource(final Function<BlockState, HeatSource> heatSourceFunc) {
            return new InteractionHandler(){

                @Override
                public HeatSource getHeatSource(BlockState state) {
                    return (HeatSource)((Object)heatSourceFunc.apply(state));
                }
            };
        }

        public static InteractionHandler ofCustomSpeedModifier(final Function<BlockState, Float> speedModifierFunc) {
            return new InteractionHandler(){

                @Override
                public float getSpeedModifier(BlockState state) {
                    return ((Float)speedModifierFunc.apply(state)).floatValue();
                }
            };
        }
    }

    public static enum HeatSource {
        EMPTY,
        VALID,
        ACTIVE;


        public boolean isEmpty() {
            return this == EMPTY;
        }

        public boolean isValid() {
            return this != EMPTY;
        }

        public boolean isActive() {
            return this == ACTIVE;
        }
    }
}

