/*
 * Decompiled with CFR 0.152.
 */
package uwu.lopyluna.create_dd.block.BlockProperties.flywheel.engine;

import com.jozufozu.flywheel.core.PartialModel;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.utility.Iterate;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class EngineBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock,
IWrenchable {
    protected EngineBlock(BlockBehaviour.Properties builder) {
        super(builder);
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        return this.isValidPosition(state, (BlockGetter)worldIn, pos, (Direction)state.m_61143_((Property)f_54117_));
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        return InteractionResult.FAIL;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        FluidState ifluidstate = level.m_6425_(pos);
        Direction facing = context.m_43719_();
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(ifluidstate.m_76152_() == Fluids.f_76193_))).m_61124_((Property)f_54117_, (Comparable)(facing.m_122434_().m_122478_() ? context.m_8125_().m_122424_() : facing));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{f_54117_, BlockStateProperties.f_61362_}));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : Fluids.f_76191_.m_76145_();
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighbourState, LevelAccessor world, BlockPos pos, BlockPos neighbourPos) {
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            world.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return state;
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (worldIn.f_46443_) {
            return;
        }
        if (fromPos.equals((Object)EngineBlock.getBaseBlockPos(state, pos)) && !this.m_7898_(state, (LevelReader)worldIn, pos)) {
            worldIn.m_46961_(pos, true);
            return;
        }
    }

    private boolean isValidPosition(BlockState state, BlockGetter world, BlockPos pos, Direction facing) {
        BlockPos baseBlockPos = EngineBlock.getBaseBlockPos(state, pos);
        if (!this.isValidBaseBlock(world.m_8055_(baseBlockPos), world, pos)) {
            return false;
        }
        for (Direction otherFacing : Iterate.horizontalDirections) {
            BlockPos otherPos;
            BlockState otherState;
            if (otherFacing == facing || !((otherState = world.m_8055_(otherPos = baseBlockPos.m_121945_(otherFacing))).m_60734_() instanceof EngineBlock) || !EngineBlock.getBaseBlockPos(otherState, otherPos).equals((Object)baseBlockPos)) continue;
            return false;
        }
        return true;
    }

    public static BlockPos getBaseBlockPos(BlockState state, BlockPos pos) {
        return pos.m_121945_(((Direction)state.m_61143_((Property)f_54117_)).m_122424_());
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public abstract PartialModel getFrameModel();

    protected abstract boolean isValidBaseBlock(BlockState var1, BlockGetter var2, BlockPos var3);
}

