/*
 * Decompiled with CFR 0.152.
 */
package uwu.lopyluna.create_dd.block.BlockProperties.flywheel;

import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.utility.Lang;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import uwu.lopyluna.create_dd.block.BlockProperties.flywheel.FlywheelBlockEntity;
import uwu.lopyluna.create_dd.block.BlockProperties.flywheel.engine.EngineBlockEntity;
import uwu.lopyluna.create_dd.block.BlockProperties.flywheel.engine.FurnaceEngineBlock;
import uwu.lopyluna.create_dd.block.DDBlockEntityTypes;

public class FlywheelBlock
extends HorizontalKineticBlock
implements IBE<FlywheelBlockEntity> {
    public static final EnumProperty<ConnectionState> CONNECTION = EnumProperty.m_61587_((String)"connection", ConnectionState.class);

    public FlywheelBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(CONNECTION, (Comparable)((Object)ConnectionState.NONE)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{CONNECTION}));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction facing = Objects.requireNonNull(context.m_43723_()).m_6350_();
        if (context.m_43723_() != null && context.m_43723_().m_6144_()) {
            return (BlockState)this.m_49966_().m_61124_(HORIZONTAL_FACING, (Comparable)facing);
        }
        return (BlockState)this.m_49966_().m_61124_(HORIZONTAL_FACING, (Comparable)facing.m_122424_());
    }

    public static boolean isConnected(BlockState state) {
        return FlywheelBlock.getConnection(state) != null;
    }

    public static Direction getConnection(BlockState state) {
        Direction facing = (Direction)state.m_61143_(HORIZONTAL_FACING);
        ConnectionState connection = (ConnectionState)((Object)state.m_61143_(CONNECTION));
        if (connection == ConnectionState.LEFT) {
            return facing.m_122428_();
        }
        if (connection == ConnectionState.RIGHT) {
            return facing.m_122427_();
        }
        return null;
    }

    public static void setConnection(Level world, BlockPos pos, BlockState state, Direction direction) {
        Direction facing = (Direction)state.m_61143_(HORIZONTAL_FACING);
        ConnectionState connection = ConnectionState.NONE;
        if (direction == facing.m_122427_()) {
            connection = ConnectionState.RIGHT;
        }
        if (direction == facing.m_122428_()) {
            connection = ConnectionState.LEFT;
        }
        world.m_7731_(pos, (BlockState)state.m_61124_(CONNECTION, (Comparable)((Object)connection)), 18);
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face == ((Direction)state.m_61143_(HORIZONTAL_FACING)).m_122424_();
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.m_61143_(HORIZONTAL_FACING)).m_122434_();
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        BlockPos enginePos;
        Direction connection = FlywheelBlock.getConnection(state);
        if (connection == null) {
            return super.onWrenched(state, context);
        }
        if (context.m_43719_().m_122434_() == ((Direction)state.m_61143_(HORIZONTAL_FACING)).m_122434_()) {
            return InteractionResult.PASS;
        }
        Level world = context.m_43725_();
        BlockState engine = world.m_8055_(enginePos = context.m_8083_().m_5484_(connection, 2));
        if (engine.m_60734_() instanceof FurnaceEngineBlock) {
            ((FurnaceEngineBlock)engine.m_60734_()).withBlockEntityDo((BlockGetter)world, enginePos, EngineBlockEntity::detachWheel);
        }
        return super.onWrenched((BlockState)state.m_61124_(CONNECTION, (Comparable)((Object)ConnectionState.NONE)), context);
    }

    public Class<FlywheelBlockEntity> getBlockEntityClass() {
        return FlywheelBlockEntity.class;
    }

    public BlockEntityType<? extends FlywheelBlockEntity> getBlockEntityType() {
        return (BlockEntityType)DDBlockEntityTypes.FLYWHEEL.get();
    }

    public static enum ConnectionState implements StringRepresentable
    {
        NONE,
        LEFT,
        RIGHT;


        public String m_7912_() {
            return Lang.asId((String)this.name());
        }
    }
}

