/*
 * Decompiled with CFR 0.152.
 */
package uwu.lopyluna.create_dd.block.BlockProperties.cog_crank;

import com.jozufozu.flywheel.api.Instancer;
import com.jozufozu.flywheel.api.Material;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.kinetics.crank.HandCrankBlockEntity;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import uwu.lopyluna.create_dd.block.BlockProperties.cog_crank.CogCrankBlock;
import uwu.lopyluna.create_dd.block.BlockResources.DDBlockPartialModel;
import uwu.lopyluna.create_dd.block.DDBlocks;

public class CogCrankBlockEntity
extends HandCrankBlockEntity {
    public int inUse;
    public boolean backwards;
    public float independentAngle;
    public float chasingVelocity;

    public CogCrankBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void turn(boolean back) {
        boolean update = false;
        if (this.getGeneratedSpeed() == 0.0f || back != this.backwards) {
            update = true;
        }
        this.inUse = 10;
        this.backwards = back;
        if (update && !this.f_58857_.f_46443_) {
            this.updateGeneratedRotation();
        }
    }

    public float getIndependentAngle(float partialTicks) {
        return (this.independentAngle + partialTicks * this.chasingVelocity) / 360.0f;
    }

    public float getGeneratedSpeed() {
        Block block = this.m_58900_().m_60734_();
        if (!(block instanceof CogCrankBlock)) {
            return 0.0f;
        }
        CogCrankBlock crank = (CogCrankBlock)block;
        int speed = (this.inUse == 0 ? 0 : (this.clockwise() ? -1 : 1)) * crank.getRotationSpeed();
        return speed;
    }

    protected boolean clockwise() {
        return this.backwards;
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128405_("InUse", this.inUse);
        compound.m_128379_("Backwards", this.backwards);
        super.write(compound, clientPacket);
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        this.inUse = compound.m_128451_("InUse");
        this.backwards = compound.m_128471_("Backwards");
        super.read(compound, clientPacket);
    }

    public void tick() {
        super.tick();
        float actualSpeed = this.getSpeed();
        this.chasingVelocity += (actualSpeed * 10.0f / 3.0f - this.chasingVelocity) * 0.25f;
        this.independentAngle += this.chasingVelocity;
        if (this.inUse > 0) {
            --this.inUse;
            if (this.inUse == 0 && !this.f_58857_.f_46443_) {
                this.sequenceContext = null;
                this.updateGeneratedRotation();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public SuperByteBuffer getRenderedHandle() {
        BlockState blockState = this.m_58900_();
        Direction facing = blockState.m_61145_((Property)CogCrankBlock.FACING).orElse(Direction.UP);
        return CachedBufferer.partialFacing((PartialModel)DDBlockPartialModel.HAND_CRANK_HANDLE, (BlockState)blockState, (Direction)facing.m_122424_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public Instancer<ModelData> getRenderedHandleInstance(Material<ModelData> material) {
        BlockState blockState = this.m_58900_();
        Direction facing = blockState.m_61145_((Property)CogCrankBlock.FACING).orElse(Direction.UP);
        return material.getModel(DDBlockPartialModel.HAND_CRANK_HANDLE, blockState, facing.m_122424_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldRenderCog() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldRenderShaft() {
        return false;
    }

    protected Block getStressConfigKey() {
        return DDBlocks.cogCrank.has(this.m_58900_()) ? (Block)DDBlocks.cogCrank.get() : (Block)AllBlocks.COPPER_VALVE_HANDLE.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void tickAudio() {
        super.tickAudio();
        if (this.inUse > 0 && AnimationTickHolder.getTicks() % 10 == 0) {
            if (!DDBlocks.cogCrank.has(this.m_58900_())) {
                return;
            }
            AllSoundEvents.CRANKING.playAt(this.f_58857_, (Vec3i)this.f_58858_, (float)this.inUse / 2.5f, 0.65f + (float)(10 - this.inUse) / 10.0f, true);
        }
    }
}

