/*
 * Decompiled with CFR 0.152.
 */
package uwu.lopyluna.create_dd.block.BlockProperties;

import com.simibubi.create.content.equipment.wrench.IWrenchable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class SpectralRubyLampBlock
extends Block
implements IWrenchable {
    public static final IntegerProperty POWER = BlockStateProperties.f_61426_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final BooleanProperty INVERTED = BlockStateProperties.f_61441_;

    public SpectralRubyLampBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)POWER, (Comparable)Integer.valueOf(0))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)INVERTED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockState stateForPlacement = super.m_5573_(pContext);
        return (BlockState)stateForPlacement.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(pContext.m_43725_().m_276867_(pContext.m_8083_())));
    }

    public boolean m_7923_(BlockState pState) {
        return true;
    }

    public boolean m_7899_(BlockState pState) {
        return true;
    }

    public int m_6378_(BlockState pState, BlockGetter pLevel, BlockPos pPos, Direction pDirection) {
        if (pDirection == null) {
            return 0;
        }
        BlockState toState = pLevel.m_8055_(pPos.m_121945_(pDirection.m_122424_()));
        if (toState.m_60713_((Block)this)) {
            return 0;
        }
        if (toState.m_60713_(Blocks.f_50328_)) {
            return this.getDistanceToPowered(pLevel, pPos, pDirection);
        }
        if (toState.m_60713_((Block)this)) {
            return (Boolean)pState.m_61143_((Property)POWERED) != false ? 15 : 0;
        }
        return (Integer)pState.m_61143_((Property)POWER);
    }

    public void m_6861_(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        if (pLevel.f_46443_) {
            return;
        }
        boolean isPowered = (Boolean)pState.m_61143_((Property)POWERED);
        if (isPowered == pLevel.m_276867_(pPos)) {
            return;
        }
        if (isPowered) {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61122_((Property)POWERED), 2);
            return;
        }
        SpectralRubyLampBlock.updateSignalStrength(pState, pLevel, pPos);
        pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)), 2);
        pLevel.m_46672_(pPos, (Block)this);
        this.scheduleActivation(pLevel, pPos);
    }

    public void scheduleActivation(Level pLevel, BlockPos pPos) {
        if (!pLevel.m_183326_().m_183582_(pPos, (Object)this)) {
            pLevel.m_186460_(pPos, (Block)this, 1);
        }
    }

    public int getDistanceToPowered(BlockGetter level, BlockPos pos, Direction column) {
        BlockPos.MutableBlockPos currentPos = pos.m_122032_();
        for (int power = 15; power > 0; --power) {
            BlockState blockState = level.m_8055_((BlockPos)currentPos);
            if (!blockState.m_60713_((Block)this)) {
                return 0;
            }
            if (((Boolean)blockState.m_61143_((Property)POWERED)).booleanValue()) {
                return power;
            }
            currentPos.m_122173_(column);
        }
        return 0;
    }

    public static void updateSignalStrength(BlockState pState, Level pLevel, BlockPos pPos) {
        int i = pLevel.m_45517_(LightLayer.SKY, pPos) - pLevel.m_7445_();
        float f = pLevel.m_46490_(1.0f);
        boolean flag = (Boolean)pState.m_61143_((Property)INVERTED);
        if (flag) {
            i = 15 - i;
        } else if (i > 0) {
            float f1 = f < (float)Math.PI ? 0.0f : (float)Math.PI * 2;
            f += (f1 - f) * 0.2f;
            i = Math.round((float)i * Mth.m_14089_((float)f));
        }
        i = Mth.m_14045_((int)i, (int)0, (int)15);
        if ((Integer)pState.m_61143_((Property)POWER) != i) {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)POWER, (Comparable)Integer.valueOf(i)), 3);
        }
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRand) {
        boolean isInverted = (Boolean)pState.m_61143_((Property)INVERTED);
        boolean isPowered = (Boolean)pState.m_61143_((Property)POWERED);
        SpectralRubyLampBlock.updateSignalStrength(pState, (Level)pLevel, pPos);
        if (pLevel.f_46443_ && pLevel.m_6042_().f_223549_()) {
            return;
        }
        pLevel.m_7731_(pPos, pState, 4);
        pLevel.m_220407_(GameEvent.f_157792_, pPos, GameEvent.Context.m_223722_((BlockState)pState));
        SpectralRubyLampBlock.tickEntity((Level)pLevel, pPos, pState);
        SpectralRubyLampBlock.updateSignalStrength(pState, (Level)pLevel, pPos);
    }

    public static void tickEntity(Level pLevel, BlockPos pPos, BlockState pState) {
        if (pLevel.m_46467_() % 20L == 0L) {
            SpectralRubyLampBlock.updateSignalStrength(pState, pLevel, pPos);
        }
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pPlayer.m_36326_()) {
            if (pLevel.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            BlockState blockstate = (BlockState)pState.m_61122_((Property)INVERTED);
            pLevel.m_7731_(pPos, blockstate, 4);
            pLevel.m_220407_(GameEvent.f_157792_, pPos, GameEvent.Context.m_223719_((Entity)pPlayer, (BlockState)blockstate));
            SpectralRubyLampBlock.updateSignalStrength(blockstate, pLevel, pPos);
            return InteractionResult.CONSUME;
        }
        return super.m_6227_(pState, pLevel, pPos, pPlayer, pHand, pHit);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{POWERED, POWER, INVERTED});
    }
}

