/*
 * Decompiled with CFR 0.152.
 */
package uwu.lopyluna.create_dd.block.BlockPalette.gen;

import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.data.TagGen;
import com.simibubi.create.foundation.utility.Lang;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.nullness.NonnullType;
import java.util.Arrays;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import uwu.lopyluna.create_dd.DDCreate;
import uwu.lopyluna.create_dd.block.BlockPalette.DDPaletteStoneTypes;
import uwu.lopyluna.create_dd.block.BlockPalette.gen.DDPaletteBlockPattern;

public abstract class DDPaletteBlockPartial<B extends Block> {
    public static final DDPaletteBlockPartial<StairBlock> STAIR = new Stairs();
    public static final DDPaletteBlockPartial<SlabBlock> SLAB = new Slab(false);
    public static final DDPaletteBlockPartial<SlabBlock> UNIQUE_SLAB = new Slab(true);
    public static final DDPaletteBlockPartial<WallBlock> WALL = new Wall();
    public static final DDPaletteBlockPartial<?>[] ALL_PARTIALS = new DDPaletteBlockPartial[]{STAIR, SLAB, WALL};
    public static final DDPaletteBlockPartial<?>[] FOR_POLISHED = new DDPaletteBlockPartial[]{STAIR, UNIQUE_SLAB, WALL};
    private String name;

    private DDPaletteBlockPartial(String name) {
        this.name = name;
    }

    @NonnullType
    public BlockBuilder<B, CreateRegistrate> create(String variantName, DDPaletteBlockPattern pattern, BlockEntry<? extends Block> block, DDPaletteStoneTypes variant) {
        String patternName = Lang.nonPluralId((String)pattern.createName(variantName));
        String blockName = patternName + "_" + this.name;
        BlockBuilder blockBuilder = (BlockBuilder)DDCreate.REGISTRATE.block(blockName, p -> this.createBlock((Supplier<Block>)block)).blockstate((c, p) -> this.generateBlockState((DataGenContext<Block, B>)c, (RegistrateBlockstateProvider)p, variantName, pattern, (Supplier<? extends Block>)((Supplier<Block>)block))).recipe((c, p) -> this.createRecipes(variant, (BlockEntry<? extends Block>)((BlockEntry<Block>)block), (DataGenContext<Block, ? extends Block>)((DataGenContext<Block, Block>)c), (RegistrateRecipeProvider)p)).transform(b -> this.transformBlock((BlockBuilder<B, CreateRegistrate>)b, variantName, pattern));
        ItemBuilder itemBuilder = (ItemBuilder)blockBuilder.item().transform(b -> this.transformItem((ItemBuilder<BlockItem, BlockBuilder<B, CreateRegistrate>>)b, variantName, pattern));
        if (this.canRecycle()) {
            itemBuilder.tag(new TagKey[]{variant.materialTag});
        }
        return (BlockBuilder)itemBuilder.build();
    }

    protected ResourceLocation getTexture(String variantName, DDPaletteBlockPattern pattern, int index) {
        return DDPaletteBlockPattern.toLocation(variantName, pattern.getTexture(index));
    }

    protected BlockBuilder<B, CreateRegistrate> transformBlock(BlockBuilder<B, CreateRegistrate> builder, String variantName, DDPaletteBlockPattern pattern) {
        this.getBlockTags().forEach(xva$0 -> builder.tag(new TagKey[]{xva$0}));
        return (BlockBuilder)builder.transform(TagGen.pickaxeOnly());
    }

    protected ItemBuilder<BlockItem, BlockBuilder<B, CreateRegistrate>> transformItem(ItemBuilder<BlockItem, BlockBuilder<B, CreateRegistrate>> builder, String variantName, DDPaletteBlockPattern pattern) {
        this.getItemTags().forEach(xva$0 -> builder.tag(new TagKey[]{xva$0}));
        return builder;
    }

    protected boolean canRecycle() {
        return true;
    }

    protected abstract Iterable<TagKey<Block>> getBlockTags();

    protected abstract Iterable<TagKey<Item>> getItemTags();

    protected abstract B createBlock(Supplier<? extends Block> var1);

    protected abstract void createRecipes(DDPaletteStoneTypes var1, BlockEntry<? extends Block> var2, DataGenContext<Block, ? extends Block> var3, RegistrateRecipeProvider var4);

    protected abstract void generateBlockState(DataGenContext<Block, B> var1, RegistrateBlockstateProvider var2, String var3, DDPaletteBlockPattern var4, Supplier<? extends Block> var5);

    private static class Stairs
    extends DDPaletteBlockPartial<StairBlock> {
        public Stairs() {
            super("stairs");
        }

        @Override
        protected StairBlock createBlock(Supplier<? extends Block> block) {
            return new StairBlock(() -> ((Block)block.get()).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)block.get())));
        }

        @Override
        protected void generateBlockState(DataGenContext<Block, StairBlock> ctx, RegistrateBlockstateProvider prov, String variantName, DDPaletteBlockPattern pattern, Supplier<? extends Block> block) {
            prov.stairsBlock((StairBlock)ctx.get(), this.getTexture(variantName, pattern, 0));
        }

        @Override
        protected Iterable<TagKey<Block>> getBlockTags() {
            return Arrays.asList(BlockTags.f_13030_);
        }

        @Override
        protected Iterable<TagKey<Item>> getItemTags() {
            return Arrays.asList(ItemTags.f_13138_);
        }

        @Override
        protected void createRecipes(DDPaletteStoneTypes type, BlockEntry<? extends Block> patternBlock, DataGenContext<Block, ? extends Block> c, RegistrateRecipeProvider p) {
        }
    }

    private static class Slab
    extends DDPaletteBlockPartial<SlabBlock> {
        private boolean customSide;

        public Slab(boolean customSide) {
            super("slab");
            this.customSide = customSide;
        }

        @Override
        protected SlabBlock createBlock(Supplier<? extends Block> block) {
            return new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)block.get())));
        }

        @Override
        protected boolean canRecycle() {
            return false;
        }

        @Override
        protected void generateBlockState(DataGenContext<Block, SlabBlock> ctx, RegistrateBlockstateProvider prov, String variantName, DDPaletteBlockPattern pattern, Supplier<? extends Block> block) {
            String name = ctx.getName();
            ResourceLocation mainTexture = this.getTexture(variantName, pattern, 0);
            ResourceLocation sideTexture = this.customSide ? this.getTexture(variantName, pattern, 1) : mainTexture;
            ModelBuilder bottom = prov.models().slab(name, sideTexture, mainTexture, mainTexture);
            ModelBuilder top = prov.models().slabTop(name + "_top", sideTexture, mainTexture, mainTexture);
            Object doubleSlab = this.customSide ? prov.models().cubeColumn(name + "_double", sideTexture, mainTexture) : prov.models().getExistingFile(prov.modLoc(pattern.createName(variantName)));
            prov.slabBlock((SlabBlock)ctx.get(), (ModelFile)bottom, (ModelFile)top, (ModelFile)doubleSlab);
        }

        @Override
        protected Iterable<TagKey<Block>> getBlockTags() {
            return Arrays.asList(BlockTags.f_13031_);
        }

        @Override
        protected Iterable<TagKey<Item>> getItemTags() {
            return Arrays.asList(ItemTags.f_13139_);
        }

        @Override
        protected void createRecipes(DDPaletteStoneTypes type, BlockEntry<? extends Block> patternBlock, DataGenContext<Block, ? extends Block> c, RegistrateRecipeProvider p) {
        }

        @Override
        protected BlockBuilder<SlabBlock, CreateRegistrate> transformBlock(BlockBuilder<SlabBlock, CreateRegistrate> builder, String variantName, DDPaletteBlockPattern pattern) {
            return super.transformBlock(builder, variantName, pattern);
        }
    }

    private static class Wall
    extends DDPaletteBlockPartial<WallBlock> {
        public Wall() {
            super("wall");
        }

        @Override
        protected WallBlock createBlock(Supplier<? extends Block> block) {
            return new WallBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)block.get())));
        }

        @Override
        protected ItemBuilder<BlockItem, BlockBuilder<WallBlock, CreateRegistrate>> transformItem(ItemBuilder<BlockItem, BlockBuilder<WallBlock, CreateRegistrate>> builder, String variantName, DDPaletteBlockPattern pattern) {
            builder.model((c, p) -> p.wallInventory(c.getName(), this.getTexture(variantName, pattern, 0)));
            return super.transformItem(builder, variantName, pattern);
        }

        @Override
        protected void generateBlockState(DataGenContext<Block, WallBlock> ctx, RegistrateBlockstateProvider prov, String variantName, DDPaletteBlockPattern pattern, Supplier<? extends Block> block) {
            prov.wallBlock((WallBlock)ctx.get(), pattern.createName(variantName), this.getTexture(variantName, pattern, 0));
        }

        @Override
        protected Iterable<TagKey<Block>> getBlockTags() {
            return Arrays.asList(BlockTags.f_13032_);
        }

        @Override
        protected Iterable<TagKey<Item>> getItemTags() {
            return Arrays.asList(ItemTags.f_13140_);
        }

        @Override
        protected void createRecipes(DDPaletteStoneTypes type, BlockEntry<? extends Block> patternBlock, DataGenContext<Block, ? extends Block> c, RegistrateRecipeProvider p) {
        }
    }
}

