/*
 * Decompiled with CFR 0.152.
 */
package uwu.lopyluna.create_dd.access;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import uwu.lopyluna.create_dd.access.DDTransportedItemStack;

public class DDTransportedItemStackHandlerBehaviour
extends TransportedItemStackHandlerBehaviour {
    public static final BehaviourType<DDTransportedItemStackHandlerBehaviour> TYPE = new BehaviourType();
    private ProcessingCallback processingCallback;
    private PositionGetter positionGetter;

    public DDTransportedItemStackHandlerBehaviour(SmartBlockEntity be, TransportedItemStackHandlerBehaviour.ProcessingCallback processingCallback) {
        super(be, processingCallback);
    }

    public DDTransportedItemStackHandlerBehaviour withStackPlacement(PositionGetter function) {
        this.positionGetter = function;
        return this;
    }

    public void DDhandleProcessingOnAllItems(Function<DDTransportedItemStack, TransportedResult> processFunction) {
        this.DDhandleCenteredProcessingOnAllItems(0.51f, processFunction);
    }

    public void handleProcessingOnItem(DDTransportedItemStack item, TransportedResult processOutput) {
        this.DDhandleCenteredProcessingOnAllItems(0.51f, t -> {
            if (t == item) {
                return processOutput;
            }
            return null;
        });
    }

    public void DDhandleCenteredProcessingOnAllItems(float maxDistanceFromCenter, Function<DDTransportedItemStack, TransportedResult> processFunction) {
        this.processingCallback.applyToAllItems(maxDistanceFromCenter, processFunction);
    }

    public Vec3 getWorldPositionOf(DDTransportedItemStack transported) {
        return this.positionGetter.getWorldPositionVector(transported);
    }

    public BehaviourType<?> getType() {
        return TYPE;
    }

    @FunctionalInterface
    public static interface PositionGetter {
        public Vec3 getWorldPositionVector(DDTransportedItemStack var1);
    }

    public static class TransportedResult {
        List<DDTransportedItemStack> outputs;
        DDTransportedItemStack heldOutput;
        private static final TransportedResult DO_NOTHING = new TransportedResult(null, null);
        private static final TransportedResult REMOVE_ITEM = new TransportedResult((List<DDTransportedItemStack>)ImmutableList.of(), null);

        public static TransportedResult doNothing() {
            return DO_NOTHING;
        }

        public static TransportedResult removeItem() {
            return REMOVE_ITEM;
        }

        public static TransportedResult convertTo(DDTransportedItemStack output) {
            return new TransportedResult((List<DDTransportedItemStack>)ImmutableList.of((Object)((Object)output)), null);
        }

        public static TransportedResult convertTo(List<DDTransportedItemStack> outputs) {
            return new TransportedResult(outputs, null);
        }

        public static TransportedResult convertToAndLeaveHeld(List<DDTransportedItemStack> outputs, DDTransportedItemStack heldOutput) {
            return new TransportedResult(outputs, heldOutput);
        }

        private TransportedResult(List<DDTransportedItemStack> outputs, DDTransportedItemStack heldOutput) {
            this.outputs = outputs;
            this.heldOutput = heldOutput;
        }

        public boolean doesNothing() {
            return this.outputs == null;
        }

        public boolean didntChangeFrom(ItemStack stackBefore) {
            return this.doesNothing() || this.outputs.size() == 1 && this.outputs.get((int)0).stack.equals(stackBefore, false) && !this.hasHeldOutput();
        }

        public List<DDTransportedItemStack> getOutputs() {
            if (this.outputs == null) {
                throw new IllegalStateException("Do not call getOutputs() on a Result that doesNothing().");
            }
            return this.outputs;
        }

        public boolean hasHeldOutput() {
            return this.heldOutput != null;
        }

        @Nullable
        public DDTransportedItemStack getHeldOutput() {
            if (this.heldOutput == null) {
                throw new IllegalStateException("Do not call getHeldOutput() on a Result with hasHeldOutput() == false.");
            }
            return this.heldOutput;
        }
    }

    @FunctionalInterface
    public static interface ProcessingCallback {
        public void applyToAllItems(float var1, Function<DDTransportedItemStack, TransportedResult> var2);
    }
}

