/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.ribbits.network;

import com.yungnickyoung.minecraft.ribbits.RibbitsCommon;
import com.yungnickyoung.minecraft.ribbits.client.sound.PlayerInstrumentSoundInstance;
import com.yungnickyoung.minecraft.ribbits.client.sound.RibbitInstrumentSoundInstance;
import com.yungnickyoung.minecraft.ribbits.data.RibbitInstrument;
import com.yungnickyoung.minecraft.ribbits.entity.RibbitEntity;
import com.yungnickyoung.minecraft.ribbits.mixin.interfaces.client.ISoundManagerDuck;
import com.yungnickyoung.minecraft.ribbits.mixin.mixins.client.accessor.ClientLevelAccessor;
import com.yungnickyoung.minecraft.ribbits.module.RibbitInstrumentModule;
import com.yungnickyoung.minecraft.ribbits.module.SoundModule;
import com.yungnickyoung.minecraft.ribbits.network.PlayerMusicStartS2CPacket;
import com.yungnickyoung.minecraft.ribbits.network.PlayerMusicStopS2CPacket;
import com.yungnickyoung.minecraft.ribbits.network.RibbitMusicStartAllS2CPacket;
import com.yungnickyoung.minecraft.ribbits.network.RibbitMusicStartSingleS2CPacket;
import com.yungnickyoung.minecraft.ribbits.network.RibbitMusicStopSingleS2CPacket;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class ClientPacketHandlerForge {
    public static void handleStartSingleRibbitInstrument(RibbitMusicStartSingleS2CPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ClientLevel clientLevel = Minecraft.m_91087_().f_91073_;
        UUID entityId = packet.getRibbitId();
        RibbitInstrument instrument = RibbitInstrumentModule.getInstrument(packet.getInstrumentId());
        int tickOffset = packet.getTickOffset();
        if (clientLevel != null) {
            RibbitEntity ribbit = (RibbitEntity)((ClientLevelAccessor)clientLevel).callGetEntities().m_142694_(entityId);
            if (ribbit == null) {
                RibbitsCommon.LOGGER.error("Received Start Music packet for a ribbit with UUID {} that doesn't exist!", (Object)entityId);
                return;
            }
            if (instrument == null) {
                RibbitsCommon.LOGGER.error("Tried to play music for a ribbit with null instrument!");
                return;
            }
            if (instrument == RibbitInstrumentModule.NONE) {
                RibbitsCommon.LOGGER.error("Tried to play music for a ribbit with NONE instrument!");
                return;
            }
            SoundEvent instrumentSoundEvent = instrument.getSoundEvent();
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new RibbitInstrumentSoundInstance(ribbit, tickOffset, instrumentSoundEvent));
        }
    }

    public static void handleStartAllRibbitInstruments(RibbitMusicStartAllS2CPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ClientLevel clientLevel = Minecraft.m_91087_().f_91073_;
        List<UUID> entityIds = packet.getRibbitIds();
        List<ResourceLocation> instrumentIds = packet.getInstrumentIds();
        int tickOffset = packet.getTickOffset();
        if (entityIds.size() != instrumentIds.size()) {
            RibbitsCommon.LOGGER.error("Received handleStartAllPacket with {} ribbits and {} instruments!", (Object)entityIds.size(), (Object)instrumentIds.size());
            return;
        }
        if (clientLevel != null) {
            for (int i = 0; i < entityIds.size(); ++i) {
                RibbitEntity ribbit = (RibbitEntity)((ClientLevelAccessor)clientLevel).callGetEntities().m_142694_(entityIds.get(i));
                if (ribbit == null) {
                    RibbitsCommon.LOGGER.error("Received handleStartAllPacket for a ribbit with UUID {} that doesn't exist!", (Object)entityIds.get(i));
                    return;
                }
                RibbitInstrument instrument = RibbitInstrumentModule.getInstrument(instrumentIds.get(i));
                if (instrument == null) {
                    RibbitsCommon.LOGGER.error("Tried to play music in handleStartAllPacket for a ribbit with null instrument!");
                    return;
                }
                if (instrument == RibbitInstrumentModule.NONE) {
                    RibbitsCommon.LOGGER.error("Tried to play music in handleStartAllPacket for a ribbit with NONE instrument!");
                    return;
                }
                SoundEvent instrumentSoundEvent = instrument.getSoundEvent();
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new RibbitInstrumentSoundInstance(ribbit, tickOffset, instrumentSoundEvent));
            }
        }
    }

    public static void handleStopSingleRibbitInstrument(RibbitMusicStopSingleS2CPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ClientLevel clientLevel = Minecraft.m_91087_().f_91073_;
        UUID entityId = packet.getRibbitId();
        if (clientLevel != null) {
            RibbitEntity ribbit = (RibbitEntity)((ClientLevelAccessor)clientLevel).callGetEntities().m_142694_(entityId);
            if (ribbit == null) {
                RibbitsCommon.LOGGER.error("Received Stop Music packet for a ribbit with UUID {} that doesn't exist!", (Object)entityId);
                return;
            }
            ((ISoundManagerDuck)Minecraft.m_91087_().m_91106_()).ribbits$stopRibbitsMusic(entityId);
        }
    }

    public static void handleStartPlayerInstrument(PlayerMusicStartS2CPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ClientLevel clientLevel = Minecraft.m_91087_().f_91073_;
        UUID performerId = packet.getPerformerId();
        if (clientLevel != null) {
            Entity performer = (Entity)((ClientLevelAccessor)clientLevel).callGetEntities().m_142694_(performerId);
            if (performer == null) {
                RibbitsCommon.LOGGER.error("Received Start Maraca packet for Player performer with UUID {} that doesn't exist!", (Object)performerId);
                return;
            }
            if (!(performer instanceof Player)) {
                RibbitsCommon.LOGGER.error("Received Start Maraca packet for non-Player performer with UUID {}!", (Object)performerId);
                return;
            }
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new PlayerInstrumentSoundInstance((Player)performer, -1, (SoundEvent)SoundModule.MUSIC_MARACA.get()));
        }
    }

    public static void handleStopPlayerInstrument(PlayerMusicStopS2CPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ClientLevel clientLevel = Minecraft.m_91087_().f_91073_;
        UUID performerId = packet.getPerformerId();
        if (clientLevel != null) {
            Entity performer = (Entity)((ClientLevelAccessor)clientLevel).callGetEntities().m_142694_(performerId);
            if (performer == null) {
                RibbitsCommon.LOGGER.error("Received Stop Maraca packet for Player performer with UUID {} that doesn't exist!", (Object)performerId);
                return;
            }
            if (!(performer instanceof Player)) {
                RibbitsCommon.LOGGER.error("Received Stop Maraca packet for non-Player performer with UUID {}!", (Object)performerId);
                return;
            }
            ((ISoundManagerDuck)Minecraft.m_91087_().m_91106_()).ribbits$stopMaraca(performerId);
        }
    }
}

