/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.ribbits.entity;

import com.google.common.collect.Sets;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.yungnickyoung.minecraft.ribbits.RibbitsCommon;
import com.yungnickyoung.minecraft.ribbits.data.RibbitData;
import com.yungnickyoung.minecraft.ribbits.data.RibbitInstrument;
import com.yungnickyoung.minecraft.ribbits.data.RibbitProfession;
import com.yungnickyoung.minecraft.ribbits.entity.goal.RibbitApplyBuffGoal;
import com.yungnickyoung.minecraft.ribbits.entity.goal.RibbitFishGoal;
import com.yungnickyoung.minecraft.ribbits.entity.goal.RibbitGoHomeGoal;
import com.yungnickyoung.minecraft.ribbits.entity.goal.RibbitPlayMusicGoal;
import com.yungnickyoung.minecraft.ribbits.entity.goal.RibbitStrollGoal;
import com.yungnickyoung.minecraft.ribbits.entity.goal.RibbitWaterCropsGoal;
import com.yungnickyoung.minecraft.ribbits.entity.trade.ItemListing;
import com.yungnickyoung.minecraft.ribbits.module.EntityDataSerializerModule;
import com.yungnickyoung.minecraft.ribbits.module.RibbitInstrumentModule;
import com.yungnickyoung.minecraft.ribbits.module.RibbitProfessionModule;
import com.yungnickyoung.minecraft.ribbits.module.RibbitTradeModule;
import com.yungnickyoung.minecraft.ribbits.module.RibbitUmbrellaTypeModule;
import com.yungnickyoung.minecraft.ribbits.module.SoundModule;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class RibbitEntity
extends AgeableMob
implements GeoEntity,
Merchant {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private static final RawAnimation IDLE_HOLDING_1 = RawAnimation.begin().thenPlay("idle_holding_1");
    private static final RawAnimation IDLE_HOLDING_2 = RawAnimation.begin().thenPlay("idle_holding_2");
    private static final RawAnimation IDLE_HOLDING_HAT = RawAnimation.begin().thenPlay("idle_holding_hat");
    private static final RawAnimation IDLE_HOLDING_FISHERMAN = RawAnimation.begin().thenPlay("idle_holding_fisherman");
    private static final RawAnimation WALK = RawAnimation.begin().thenPlay("walk");
    private static final RawAnimation WALK_HOLDING_1 = RawAnimation.begin().thenPlay("walk_holding_1");
    private static final RawAnimation WALK_HOLDING_2 = RawAnimation.begin().thenPlay("walk_holding_2");
    private static final RawAnimation WALK_HOLDING_HAT = RawAnimation.begin().thenPlay("walk_holding_hat");
    private static final RawAnimation WALK_HOLDING_FISHERMAN = RawAnimation.begin().thenPlay("walk_holding_fisherman");
    private static final RawAnimation SORCERER_BUFF = RawAnimation.begin().thenPlay("spell");
    private static final RawAnimation SORCERER_BUFF_HOLDING = RawAnimation.begin().thenPlay("spell_holding");
    private static final RawAnimation FISH = RawAnimation.begin().thenPlay("fishing");
    private static final RawAnimation FISH_HOLDING = RawAnimation.begin().thenPlay("fishing_holding");
    private static final RawAnimation WATER_CROPS = RawAnimation.begin().thenPlay("water_crops");
    private static final RawAnimation WATER_CROPS_HOLDING = RawAnimation.begin().thenPlay("water_crops_holding");
    @Nullable
    private Player tradingPlayer;
    @Nullable
    protected MerchantOffers offers;
    private long lastRestockGameTime;
    private int numberOfRestocksToday;
    private long lastRestockCheckDayTime;
    private final RibbitPlayMusicGoal musicGoal = new RibbitPlayMusicGoal(this, 1.0, 2000, 3000);
    private final RibbitWaterCropsGoal waterCropsGoal = new RibbitWaterCropsGoal(this, 16.0, 1.0f, 1200);
    private final RibbitFishGoal fishGoal = new RibbitFishGoal(this, 16.0, 1.0f, 600, 1800);
    private final RibbitApplyBuffGoal applyBuffGoal = new RibbitApplyBuffGoal(this, 32.0, 12000);
    private static final EntityDataAccessor<RibbitData> RIBBIT_DATA = SynchedEntityData.m_135353_(RibbitEntity.class, EntityDataSerializerModule.RIBBIT_DATA_SERIALIZER);
    private static final EntityDataAccessor<Boolean> PLAYING_INSTRUMENT = SynchedEntityData.m_135353_(RibbitEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> UMBRELLA_FALLING = SynchedEntityData.m_135353_(RibbitEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> WATERING = SynchedEntityData.m_135353_(RibbitEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> FISHING = SynchedEntityData.m_135353_(RibbitEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> BUFFING = SynchedEntityData.m_135353_(RibbitEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private RibbitData sidedRibbitData = new RibbitData(RibbitProfessionModule.NITWIT, RibbitUmbrellaTypeModule.UMBRELLA_1, RibbitInstrumentModule.NONE);
    private boolean isPlayingInstrument = false;
    private boolean isUmbrellaFalling = false;
    private boolean isWatering = false;
    private boolean isFishing = false;
    private boolean isBuffing = false;
    private int ticksPlayingMusic;
    private BlockPos homePosition;
    private Set<RibbitEntity> ribbitsPlayingMusic = new HashSet<RibbitEntity>();
    private Set<Player> playersHearingMusic = new HashSet<Player>();
    private Set<RibbitInstrument> bandMembers = new HashSet<RibbitInstrument>();
    private RibbitEntity masterRibbit;
    private int buffCooldown = 0;
    private int waterCropsCooldown = 0;

    public RibbitEntity(EntityType<RibbitEntity> entityType, Level level) {
        super(entityType, level);
        ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
        this.reassessGoals();
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new OpenDoorGoal((Mob)this, true));
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new RibbitGoHomeGoal(this, 1.8f, 1.0f, 60));
        this.f_21345_.m_25352_(2, (Goal)new PanicGoal((PathfinderMob)this, 1.5));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(4, (Goal)new RibbitStrollGoal(this, 1.0, 16));
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            if (this.m_20096_() && this.getUmbrellaFalling()) {
                this.setUmbrellaFalling(false);
            }
            if (this.f_19789_ >= 2.0f || this.getUmbrellaFalling()) {
                Vec3 velocity = this.m_20184_();
                this.m_183634_();
                this.m_20334_(velocity.f_82479_, -0.1, velocity.f_82481_);
                this.setUmbrellaFalling(true);
            }
            if (this.buffCooldown > 0) {
                --this.buffCooldown;
            }
            if (this.waterCropsCooldown > 0) {
                --this.waterCropsCooldown;
            }
            if (this.shouldRestock()) {
                this.restock();
            }
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(RIBBIT_DATA, (Object)new RibbitData(RibbitProfessionModule.NITWIT, RibbitUmbrellaTypeModule.UMBRELLA_1, RibbitInstrumentModule.NONE));
        this.f_19804_.m_135372_(PLAYING_INSTRUMENT, (Object)false);
        this.f_19804_.m_135372_(UMBRELLA_FALLING, (Object)false);
        this.f_19804_.m_135372_(WATERING, (Object)false);
        this.f_19804_.m_135372_(FISHING, (Object)false);
        this.f_19804_.m_135372_(BUFFING, (Object)false);
    }

    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128425_("RibbitData", 10)) {
            DataResult dataResult = RibbitData.CODEC.parse(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128423_("RibbitData")));
            dataResult.resultOrPartial(arg_0 -> ((Logger)RibbitsCommon.LOGGER).error(arg_0)).ifPresent(this::setRibbitData);
        }
        if (tag.m_128425_("Offers", 10)) {
            this.offers = new MerchantOffers(tag.m_128469_("Offers"));
        }
        this.homePosition = tag.m_128441_("HomePosX") && tag.m_128441_("HomePosY") && tag.m_128441_("HomePosZ") ? new BlockPos(tag.m_128451_("HomePosX"), tag.m_128451_("HomePosY"), tag.m_128451_("HomePosZ")) : new BlockPos((Vec3i)this.m_20183_());
        this.reassessGoals();
    }

    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        RibbitData.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.getRibbitData()).resultOrPartial(arg_0 -> ((Logger)RibbitsCommon.LOGGER).error(arg_0)).ifPresent(t -> tag.m_128365_("RibbitData", t));
        MerchantOffers merchantOffers = this.m_6616_();
        if (!merchantOffers.isEmpty()) {
            tag.m_128365_("Offers", (Tag)merchantOffers.m_45388_());
        }
        if (this.homePosition != null) {
            tag.m_128405_("HomePosX", this.homePosition.m_123341_());
            tag.m_128405_("HomePosY", this.homePosition.m_123342_());
            tag.m_128405_("HomePosZ", this.homePosition.m_123343_());
        }
    }

    public void m_7350_(EntityDataAccessor<?> dataAccessor) {
        super.m_7350_(dataAccessor);
        if (RIBBIT_DATA.equals(dataAccessor)) {
            this.sidedRibbitData = (RibbitData)this.f_19804_.m_135370_(RIBBIT_DATA);
        } else if (UMBRELLA_FALLING.equals(dataAccessor)) {
            this.isUmbrellaFalling = (Boolean)this.f_19804_.m_135370_(UMBRELLA_FALLING);
        } else if (PLAYING_INSTRUMENT.equals(dataAccessor)) {
            this.isPlayingInstrument = (Boolean)this.f_19804_.m_135370_(PLAYING_INSTRUMENT);
        } else if (FISHING.equals(dataAccessor)) {
            this.isFishing = (Boolean)this.f_19804_.m_135370_(FISHING);
        } else if (WATERING.equals(dataAccessor)) {
            this.isWatering = (Boolean)this.f_19804_.m_135370_(WATERING);
        } else if (BUFFING.equals(dataAccessor)) {
            this.isBuffing = (Boolean)this.f_19804_.m_135370_(BUFFING);
        }
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag tag) {
        SpawnGroupData data = super.m_6518_(level, difficulty, spawnType, groupData, tag);
        if (spawnType == MobSpawnType.SPAWN_EGG) {
            if (tag.m_128441_("Profession")) {
                String[] professionId = tag.m_128461_("Profession").split(":");
                RibbitProfession profession = RibbitProfessionModule.getProfession(new ResourceLocation(professionId[0], professionId[1]));
                this.setRibbitData(new RibbitData(profession, RibbitUmbrellaTypeModule.getRandomUmbrellaType(), RibbitInstrumentModule.NONE));
            }
        } else {
            CompoundTag ribbitDataTag = tag != null ? tag.m_128469_("RibbitData") : new CompoundTag();
            RibbitProfession profession = RibbitProfessionModule.NITWIT;
            if (ribbitDataTag.m_128425_("profession", 8)) {
                profession = RibbitProfessionModule.getProfession(new ResourceLocation(ribbitDataTag.m_128461_("profession")));
            }
            this.setRibbitData(new RibbitData(profession, RibbitUmbrellaTypeModule.getRandomUmbrellaType(), RibbitInstrumentModule.NONE));
        }
        this.reassessGoals();
        this.homePosition = this.m_20183_();
        return data;
    }

    public InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        if (player.m_36341_() && itemStack.m_150930_(Items.f_151049_)) {
            this.homePosition = this.m_20183_();
            this.m_9236_().m_7605_((Entity)this, (byte)12);
            if (!player.m_150110_().f_35937_) {
                itemStack.m_41774_(1);
            }
        } else if (this.m_6084_() && !this.isTrading() && !this.m_5803_()) {
            if (this.m_6162_()) {
                return InteractionResult.PASS;
            }
            boolean bl = this.m_6616_().isEmpty();
            if (bl) {
                return InteractionResult.PASS;
            }
            if (!this.m_9236_().f_46443_ && !this.offers.isEmpty()) {
                this.startTrading(player);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, interactionHand);
    }

    public void reassessGoals() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        this.f_21345_.m_25363_((Goal)this.musicGoal);
        this.f_21345_.m_25363_((Goal)this.waterCropsGoal);
        this.f_21345_.m_25363_((Goal)this.fishGoal);
        this.f_21345_.m_25363_((Goal)this.applyBuffGoal);
        if (this.getRibbitData().getProfession().equals(RibbitProfessionModule.NITWIT)) {
            this.f_21345_.m_25352_(5, (Goal)this.musicGoal);
        } else if (this.getRibbitData().getProfession().equals(RibbitProfessionModule.GARDENER)) {
            this.f_21345_.m_25352_(5, (Goal)this.waterCropsGoal);
        } else if (this.getRibbitData().getProfession().equals(RibbitProfessionModule.FISHERMAN)) {
            this.f_21345_.m_25352_(5, (Goal)this.fishGoal);
        } else if (this.getRibbitData().getProfession().equals(RibbitProfessionModule.SORCERER)) {
            this.f_21345_.m_25352_(5, (Goal)this.applyBuffGoal);
        }
    }

    public float m_6113_() {
        return super.m_6113_();
    }

    public void m_7822_(byte flag) {
        if (flag == 12) {
            this.addParticlesAroundSelf((ParticleOptions)ParticleTypes.f_123750_);
        }
        super.m_7822_(flag);
    }

    protected void addParticlesAroundSelf(ParticleOptions particleOptions) {
        for (int i = 0; i < 5; ++i) {
            double d = this.f_19796_.m_188583_() * 0.02;
            double e = this.f_19796_.m_188583_() * 0.02;
            double f = this.f_19796_.m_188583_() * 0.02;
            this.m_9236_().m_7106_(particleOptions, this.m_20208_(1.0), this.m_20187_() + 1.0, this.m_20262_(1.0), d, e, f);
        }
    }

    public double m_6049_() {
        return 0.3;
    }

    public int m_8132_() {
        return 0;
    }

    public int m_8085_() {
        return 0;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob parent) {
        return null;
    }

    public void setInstrument(RibbitInstrument instrument) {
        this.getRibbitData().setInstrument(instrument);
        this.f_19804_.m_276349_(RIBBIT_DATA, (Object)this.getRibbitData(), true);
    }

    public int getBuffCooldown() {
        return this.buffCooldown;
    }

    public void setBuffCooldown(int cooldown) {
        this.buffCooldown = cooldown;
    }

    public int getWaterCropsCooldown() {
        return this.waterCropsCooldown;
    }

    public void setWaterCropsCooldown(int cooldown) {
        this.waterCropsCooldown = cooldown;
    }

    public RibbitData getRibbitData() {
        return this.sidedRibbitData;
    }

    public void setRibbitData(RibbitData data) {
        this.f_19804_.m_135381_(RIBBIT_DATA, (Object)data);
    }

    public BlockPos getHomePosition() {
        return this.homePosition;
    }

    public boolean getPlayingInstrument() {
        return this.isPlayingInstrument;
    }

    public void setPlayingInstrument(boolean playingInstrument) {
        this.f_19804_.m_135381_(PLAYING_INSTRUMENT, (Object)playingInstrument);
    }

    public boolean getUmbrellaFalling() {
        return this.isUmbrellaFalling;
    }

    public void setUmbrellaFalling(boolean umbrellaFalling) {
        this.f_19804_.m_135381_(UMBRELLA_FALLING, (Object)umbrellaFalling);
    }

    public boolean getWatering() {
        return this.isWatering;
    }

    public void setWatering(boolean isWatering) {
        this.f_19804_.m_135381_(WATERING, (Object)isWatering);
    }

    public boolean getFishing() {
        return this.isFishing;
    }

    public void setFishing(boolean isFishing) {
        this.f_19804_.m_135381_(FISHING, (Object)isFishing);
    }

    public boolean getBuffing() {
        return this.isBuffing;
    }

    public void setBuffing(boolean isBuffing) {
        this.f_19804_.m_135381_(BUFFING, (Object)isBuffing);
    }

    public int getTicksPlayingMusic() {
        return this.ticksPlayingMusic;
    }

    public void setTicksPlayingMusic(int ticksPlayingMusic) {
        this.ticksPlayingMusic = ticksPlayingMusic;
    }

    public Set<RibbitEntity> getRibbitsPlayingMusic() {
        return this.ribbitsPlayingMusic;
    }

    public void setRibbitsPlayingMusic(Set<RibbitEntity> ribbitsPlayingMusic) {
        this.ribbitsPlayingMusic = new HashSet<RibbitEntity>(ribbitsPlayingMusic);
    }

    public void addRibbitToPlayingMusic(RibbitEntity ribbit) {
        this.ribbitsPlayingMusic.add(ribbit);
    }

    public void removeRibbitFromPlayingMusic(RibbitEntity ribbit) {
        this.ribbitsPlayingMusic.remove((Object)ribbit);
    }

    public Set<Player> getPlayersHearingMusic() {
        return this.playersHearingMusic;
    }

    public void setPlayersHearingMusic(Set<Player> playersHearingMusic) {
        this.playersHearingMusic = new HashSet<Player>(playersHearingMusic);
    }

    public RibbitEntity getMasterRibbit() {
        return this.masterRibbit;
    }

    public void setMasterRibbit(RibbitEntity masterRibbit) {
        this.masterRibbit = masterRibbit;
    }

    public boolean isMasterRibbit() {
        return this.equals((Object)this.getMasterRibbit());
    }

    public void findNewMasterRibbit() {
        RibbitEntity newMaster = this.getRibbitsPlayingMusic().stream().filter(ribbit -> ribbit != this).findAny().orElse(null);
        if (newMaster != null) {
            for (RibbitEntity ribbit2 : this.getRibbitsPlayingMusic()) {
                ribbit2.setMasterRibbit(newMaster);
            }
            this.getRibbitsPlayingMusic().remove((Object)this);
            this.removeBandMember(this.getRibbitData().getInstrument());
            newMaster.setRibbitsPlayingMusic(this.getRibbitsPlayingMusic());
            newMaster.setPlayersHearingMusic(this.getPlayersHearingMusic());
            newMaster.setTicksPlayingMusic(this.getTicksPlayingMusic());
            newMaster.setBandMembers(this.getBandMembers());
        }
        this.getRibbitsPlayingMusic().clear();
        this.getPlayersHearingMusic().clear();
        this.setTicksPlayingMusic(0);
        this.clearBandMembers();
    }

    public boolean isBandFull() {
        return this.bandMembers.size() == RibbitInstrumentModule.getNumInstruments();
    }

    public void addBandMember(RibbitInstrument instrument) {
        this.bandMembers.add(instrument);
    }

    public void removeBandMember(RibbitInstrument instrument) {
        this.bandMembers.remove(instrument);
    }

    public void clearBandMembers() {
        this.bandMembers.clear();
    }

    public Set<RibbitInstrument> getBandMembers() {
        return this.bandMembers;
    }

    public void setBandMembers(Set<RibbitInstrument> bandMembers) {
        this.bandMembers = new HashSet<RibbitInstrument>(bandMembers);
    }

    public void m_142687_(Entity.RemovalReason reason) {
        if (this.isMasterRibbit()) {
            this.findNewMasterRibbit();
        } else if (this.isPlayingInstrument && this.getMasterRibbit() != null) {
            this.getMasterRibbit().getRibbitsPlayingMusic().remove((Object)this);
            this.getMasterRibbit().removeBandMember(this.getRibbitData().getInstrument());
        }
        super.m_142687_(reason);
    }

    public static AttributeSupplier.Builder createRibbitAttributes() {
        return RibbitEntity.m_21552_().m_22268_(Attributes.f_22276_, 15.0).m_22268_(Attributes.f_22279_, 0.125).m_22268_(Attributes.f_22281_, 1.0);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)SoundModule.ENTITY_RIBBIT_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource $$0) {
        return (SoundEvent)SoundModule.ENTITY_RIBBIT_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundModule.ENTITY_RIBBIT_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState blockstate) {
        super.m_7355_(pos, blockstate);
        this.m_5496_((SoundEvent)SoundModule.ENTITY_RIBBIT_STEP.get(), 1.0f, 1.0f);
    }

    public boolean isPrideRibbit() {
        Random rand = new Random(this.m_20148_().getLeastSignificantBits());
        return RibbitEntity.isPrideMonth() && this.getRibbitData().getProfession().equals(RibbitProfessionModule.NITWIT) && rand.nextFloat() < 0.33f;
    }

    private static boolean isPrideMonth() {
        if (RibbitsCommon.CONFIG.prideFlagAllYear) {
            return true;
        }
        LocalDate date = LocalDate.now();
        int month = date.get(ChronoField.MONTH_OF_YEAR);
        return month == 6;
    }

    public boolean m_20285_() {
        BlockPos pos = this.m_20183_();
        return this.m_9236_().m_46758_(pos) || this.m_9236_().m_46758_(BlockPos.m_274561_((double)pos.m_123341_(), (double)this.m_20191_().f_82292_, (double)pos.m_123343_()));
    }

    private <E extends GeoAnimatable> PlayState predicate(AnimationState<E> state) {
        if (this.getUmbrellaFalling()) {
            state.getController().setAnimation(this.getRibbitData().getProfession().equals(RibbitProfessionModule.FISHERMAN) || this.isPrideRibbit() ? IDLE_HOLDING_2 : IDLE_HOLDING_1);
        } else if (this.getPlayingInstrument() && this.getRibbitData().getInstrument() != RibbitInstrumentModule.NONE) {
            state.getController().setAnimation(RawAnimation.begin().thenPlay(this.getRibbitData().getInstrument().getAnimationName()));
        } else if (this.getBuffing()) {
            state.getController().setAnimation(this.m_20285_() ? SORCERER_BUFF_HOLDING : SORCERER_BUFF);
        } else if (this.getFishing()) {
            state.getController().setAnimation(this.m_20285_() ? FISH_HOLDING : FISH);
        } else if (this.getWatering()) {
            state.getController().setAnimation(this.m_20285_() ? WATER_CROPS_HOLDING : WATER_CROPS);
        } else if (state.isMoving()) {
            if (this.getRibbitData().getProfession().equals(RibbitProfessionModule.FISHERMAN)) {
                state.getController().setAnimation(this.m_20285_() ? WALK_HOLDING_FISHERMAN : WALK_HOLDING_2);
            } else if (this.isPrideRibbit()) {
                state.getController().setAnimation(WALK_HOLDING_2);
            } else if (this.getRibbitData().getProfession().equals(RibbitProfessionModule.SORCERER) || this.getRibbitData().getProfession().equals(RibbitProfessionModule.GARDENER)) {
                state.getController().setAnimation(this.m_20285_() ? WALK_HOLDING_HAT : WALK);
            } else {
                state.getController().setAnimation(this.m_20285_() ? WALK_HOLDING_1 : WALK);
            }
        } else if (this.getRibbitData().getProfession().equals(RibbitProfessionModule.FISHERMAN)) {
            state.getController().setAnimation(this.m_20285_() ? IDLE_HOLDING_FISHERMAN : IDLE_HOLDING_2);
        } else if (this.isPrideRibbit()) {
            state.getController().setAnimation(IDLE_HOLDING_2);
        } else if (this.getRibbitData().getProfession().equals(RibbitProfessionModule.SORCERER) || this.getRibbitData().getProfession().equals(RibbitProfessionModule.GARDENER)) {
            state.getController().setAnimation(this.m_20285_() ? IDLE_HOLDING_HAT : IDLE);
        } else {
            state.getController().setAnimation(this.m_20285_() ? IDLE_HOLDING_1 : IDLE);
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Nullable
    public Player m_7962_() {
        return this.tradingPlayer;
    }

    public MerchantOffers m_6616_() {
        if (this.offers == null) {
            this.offers = new MerchantOffers();
            this.updateTrades();
        }
        return this.offers;
    }

    public void m_6255_(MerchantOffers merchantOffers) {
    }

    public void m_6996_(MerchantOffer merchantOffer) {
        merchantOffer.m_45374_();
        this.f_21363_ = -this.m_8100_();
        this.rewardTradeXp(merchantOffer);
    }

    protected void rewardTradeXp(MerchantOffer merchantOffer) {
        int i = 3 + this.f_19796_.m_188503_(4);
        if (merchantOffer.m_45383_()) {
            this.m_9236_().m_7967_((Entity)new ExperienceOrb(this.m_9236_(), this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), i));
        }
    }

    public void m_7713_(ItemStack itemStack) {
        if (!this.m_9236_().f_46443_ && this.f_21363_ > -this.m_8100_() + 20) {
            this.f_21363_ = -this.m_8100_();
        }
    }

    protected void updateTrades() {
        RibbitData ribbitData = this.getRibbitData();
        ItemListing[] itemListings = RibbitTradeModule.TRADES.get(ribbitData.getProfession());
        if (itemListings == null || itemListings.length == 0) {
            return;
        }
        MerchantOffers merchantOffers = this.m_6616_();
        this.addOffersFromItemListings(merchantOffers, itemListings, 4);
    }

    protected void addOffersFromItemListings(MerchantOffers merchantOffers, ItemListing[] itemListings, int numOffers) {
        HashSet set = Sets.newHashSet();
        if (itemListings.length > numOffers) {
            while (set.size() < numOffers) {
                set.add(this.f_19796_.m_188503_(itemListings.length));
            }
        } else {
            for (int j = 0; j < itemListings.length; ++j) {
                set.add(j);
            }
        }
        for (Integer integer : set) {
            ItemListing itemListing = itemListings[integer];
            MerchantOffer merchantOffer = itemListing.getOffer((Entity)this, this.f_19796_);
            if (merchantOffer == null) continue;
            merchantOffers.add((Object)merchantOffer);
        }
        if (this.getRibbitData().getProfession().equals(RibbitProfessionModule.MERCHANT)) {
            merchantOffers.add((Object)RibbitTradeModule.MARACA_TRADE.getOffer((Entity)this, this.f_19796_));
        }
    }

    private void startTrading(Player player) {
        this.m_7189_(player);
        this.m_45301_(player, this.m_5446_(), 0);
    }

    public void m_7189_(@Nullable Player player) {
        boolean bl = this.m_7962_() != null && player == null;
        this.tradingPlayer = player;
        if (bl) {
            this.stopTrading();
        }
    }

    protected void stopTrading() {
        this.m_7189_(null);
        this.resetSpecialPrices();
    }

    private void resetSpecialPrices() {
        for (MerchantOffer merchantOffer : this.m_6616_()) {
            merchantOffer.m_45376_();
        }
    }

    public boolean m_7862_() {
        return true;
    }

    public void restock() {
        this.updateDemand();
        for (MerchantOffer merchantOffer : this.m_6616_()) {
            merchantOffer.m_45372_();
        }
        this.resendOffersToTradingPlayer();
        this.lastRestockGameTime = this.m_9236_().m_46467_();
        ++this.numberOfRestocksToday;
    }

    private void resendOffersToTradingPlayer() {
        MerchantOffers merchantOffers = this.m_6616_();
        Player player = this.m_7962_();
        if (player != null && !merchantOffers.isEmpty()) {
            player.m_7662_(player.f_36096_.f_38840_, merchantOffers, 0, this.m_7809_(), this.m_7826_(), this.m_7862_());
        }
    }

    private boolean needsToRestock() {
        for (MerchantOffer merchantOffer : this.m_6616_()) {
            if (!merchantOffer.m_45382_()) continue;
            return true;
        }
        return false;
    }

    private boolean allowedToRestock() {
        return this.numberOfRestocksToday == 0 || this.numberOfRestocksToday < 2 && this.m_9236_().m_46467_() > this.lastRestockGameTime + 2400L;
    }

    public boolean shouldRestock() {
        long l = this.lastRestockGameTime + 12000L;
        long m = this.m_9236_().m_46467_();
        boolean bl = m > l;
        long n = this.m_9236_().m_46468_();
        if (this.lastRestockCheckDayTime > 0L) {
            long p = n / 24000L;
            long o = this.lastRestockCheckDayTime / 24000L;
            bl |= p > o;
        }
        this.lastRestockCheckDayTime = n;
        if (bl) {
            this.lastRestockGameTime = m;
            this.resetNumberOfRestocks();
        }
        return this.allowedToRestock() && this.needsToRestock();
    }

    private void resetNumberOfRestocks() {
        this.catchUpDemand();
        this.numberOfRestocksToday = 0;
    }

    private void catchUpDemand() {
        int i = 2 - this.numberOfRestocksToday;
        if (i > 0) {
            for (MerchantOffer merchantOffer : this.m_6616_()) {
                merchantOffer.m_45372_();
            }
        }
        for (int j = 0; j < i; ++j) {
            this.updateDemand();
        }
        this.resendOffersToTradingPlayer();
    }

    private void updateDemand() {
        for (MerchantOffer merchantOffer : this.m_6616_()) {
            merchantOffer.m_45369_();
        }
    }

    public boolean isTrading() {
        return this.tradingPlayer != null;
    }

    public int m_7809_() {
        return 0;
    }

    public void m_6621_(int i) {
    }

    public boolean m_7826_() {
        return false;
    }

    public SoundEvent m_7596_() {
        return null;
    }

    public boolean m_183595_() {
        return this.m_9236_().m_5776_();
    }
}

