/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.block.entity.forge.input;

import com.mojang.serialization.Codec;
import com.stal111.forbidden_arcanus.common.block.entity.forge.HephaestusForgeBlockEntity;
import com.stal111.forbidden_arcanus.common.block.entity.forge.essence.EssenceType;
import com.stal111.forbidden_arcanus.common.block.entity.forge.input.HephaestusForgeInput;
import com.stal111.forbidden_arcanus.common.block.entity.forge.input.HephaestusForgeInputType;
import com.stal111.forbidden_arcanus.core.init.other.ModForgeInputTypes;
import java.util.Map;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.valhelsia.valhelsia_core.api.common.util.ItemStackUtils;

public class ExtractEnchantmentsInput
extends HephaestusForgeInput {
    public static final Codec<ExtractEnchantmentsInput> CODEC = Codec.unit(ExtractEnchantmentsInput::new);

    public ExtractEnchantmentsInput() {
        super(EssenceType.EXPERIENCE);
    }

    @Override
    public boolean canInputStack(ItemStack stack) {
        return stack.m_41793_();
    }

    @Override
    public int getInputValue(EssenceType inputType, ItemStack stack, RandomSource random) {
        int xp = this.getEnchantmentXp(stack);
        if (xp <= 0) {
            return 0;
        }
        int i = (int)Math.ceil((double)xp / 2.0);
        return i + random.m_188503_(i);
    }

    @Override
    public void finishInput(EssenceType inputType, ItemStack stack, HephaestusForgeBlockEntity tileEntity, int slot, int inputValue) {
        if (inputValue != 0) {
            tileEntity.setStack(slot, ItemStackUtils.removeEnchantments((ItemStack)stack));
        }
    }

    @Override
    public HephaestusForgeInputType<?> type() {
        return (HephaestusForgeInputType)ModForgeInputTypes.EXTRACT_ENCHANTMENTS.get();
    }

    private int getEnchantmentXp(ItemStack stack) {
        int xp = 0;
        Map map = EnchantmentHelper.m_44831_((ItemStack)stack);
        for (Map.Entry entry : map.entrySet()) {
            Enchantment enchantment = (Enchantment)entry.getKey();
            Integer integer = (Integer)entry.getValue();
            if (enchantment.m_6589_()) continue;
            xp += enchantment.m_6183_(integer.intValue());
        }
        return xp;
    }
}

