/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.structure;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import dev.worldgen.lithostitched.LithostitchedCommon;
import dev.worldgen.lithostitched.access.StructurePoolAccess;
import dev.worldgen.lithostitched.config.ConfigHandler;
import dev.worldgen.lithostitched.worldgen.poolelement.DelegatingPoolElement;
import dev.worldgen.lithostitched.worldgen.structure.AlternateJigsawConfig;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.EmptyPoolElement;
import net.minecraft.world.level.levelgen.structure.pools.JigsawJunction;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.mutable.MutableObject;

public class AlternateJigsawGenerator {
    public static Optional<Structure.GenerationStub> generate(Structure.GenerationContext context, AlternateJigsawConfig config, boolean vanilla, int size, BlockPos pos) {
        BlockPos blockPos;
        RegistryAccess dynamicRegistryManager = context.f_226621_();
        ChunkGenerator chunkGenerator = context.f_226622_();
        StructureTemplateManager structureTemplateManager = context.f_226625_();
        LevelHeightAccessor heightLimitView = context.f_226629_();
        WorldgenRandom random = context.f_226626_();
        Registry registry = dynamicRegistryManager.m_175515_(Registries.f_256948_);
        Rotation blockRotation = Rotation.m_221990_((RandomSource)random);
        StructurePoolElement startingElement = ((StructureTemplatePool)config.startPool().m_203334_()).m_227355_((RandomSource)random);
        if (startingElement == EmptyPoolElement.f_210175_) {
            return Optional.empty();
        }
        Optional<ResourceLocation> startJigsawName = config.startJigsawName();
        if (startJigsawName.isPresent()) {
            ResourceLocation identifier = startJigsawName.get();
            Optional<BlockPos> optional = AlternateJigsawGenerator.findStartingJigsawPos(startingElement, identifier, pos, blockRotation, structureTemplateManager, random);
            if (optional.isEmpty()) {
                LithostitchedCommon.LOGGER.error("No starting jigsaw {} found in start pool {}", (Object)identifier, (Object)config.startPool().m_203543_().map(key -> key.m_135782_().toString()).orElse("<unregistered>"));
                return Optional.empty();
            }
            blockPos = optional.get();
        } else {
            blockPos = pos;
        }
        BlockPos vec3i = blockPos.m_121996_((Vec3i)pos);
        BlockPos blockPos2 = pos.m_121996_((Vec3i)vec3i);
        PoolElementStructurePiece poolStructurePiece = new PoolElementStructurePiece(structureTemplateManager, startingElement, blockPos2, startingElement.m_210540_(), blockRotation, startingElement.m_214015_(structureTemplateManager, blockPos2, blockRotation));
        BoundingBox blockBox = poolStructurePiece.m_73547_();
        int i = (blockBox.m_162399_() + blockBox.m_162395_()) / 2;
        int j = (blockBox.m_162401_() + blockBox.m_162398_()) / 2;
        int k = config.projectStartToHeightmap().map(type -> pos.m_123342_() + chunkGenerator.m_223221_(i, j, type, heightLimitView, context.f_226624_())).orElseGet(() -> ((BlockPos)blockPos2).m_123342_());
        int l = blockBox.m_162396_() + poolStructurePiece.m_72647_();
        poolStructurePiece.m_6324_(0, k - l, 0);
        int m = k + vec3i.m_123342_();
        return Optional.of(new Structure.GenerationStub(new BlockPos(i, m, j), collector -> {
            ArrayList list = Lists.newArrayList();
            list.add(poolStructurePiece);
            if (size > 0) {
                int maxDistanceFromCenter = config.maxDistanceFromCenter();
                AABB box = new AABB((double)(i - maxDistanceFromCenter), (double)(m - maxDistanceFromCenter), (double)(j - maxDistanceFromCenter), (double)(i + maxDistanceFromCenter + 1), (double)(m + maxDistanceFromCenter + 1), (double)(j + maxDistanceFromCenter + 1));
                VoxelShape voxelShape = Shapes.m_83113_((VoxelShape)Shapes.m_83064_((AABB)box), (VoxelShape)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)blockBox)), (BooleanOp)BooleanOp.f_82685_);
                AlternateJigsawGenerator.generate(vanilla, context.f_226624_(), size, config.useExpansionHack(), chunkGenerator, structureTemplateManager, heightLimitView, (RandomSource)random, (Registry<StructureTemplatePool>)registry, poolStructurePiece, list, voxelShape);
                Objects.requireNonNull(collector);
                list.forEach(arg_0 -> ((StructurePiecesBuilder)collector).m_142679_(arg_0));
            }
        }));
    }

    private static Optional<BlockPos> findStartingJigsawPos(StructurePoolElement pool, ResourceLocation id, BlockPos pos, Rotation rotation, StructureTemplateManager structureManager, WorldgenRandom random) {
        List list = pool.m_213638_(structureManager, pos, rotation, (RandomSource)random);
        Optional<BlockPos> optional = Optional.empty();
        for (StructureTemplate.StructureBlockInfo structureBlockInfo : list) {
            ResourceLocation identifier;
            if (structureBlockInfo.f_74677_() == null || !id.equals((Object)(identifier = ResourceLocation.m_135820_((String)structureBlockInfo.f_74677_().m_128461_("name"))))) continue;
            optional = Optional.of(structureBlockInfo.f_74675_());
            break;
        }
        return optional;
    }

    private static void generate(boolean vanilla, RandomState noiseConfig, int maxSize, boolean useExpansionHack, ChunkGenerator chunkGenerator, StructureTemplateManager structureTemplateManager, LevelHeightAccessor heightLimitView, RandomSource random, Registry<StructureTemplatePool> structurePoolRegistry, PoolElementStructurePiece firstPiece, List<PoolElementStructurePiece> pieces, VoxelShape pieceShape) {
        StructurePoolGenerator structurePoolGenerator = new StructurePoolGenerator(vanilla, structurePoolRegistry, maxSize, chunkGenerator, structureTemplateManager, pieces, random);
        structurePoolGenerator.structurePieces.addLast(new ShapedPoolStructurePiece(firstPiece, (MutableObject<VoxelShape>)new MutableObject((Object)pieceShape), 0));
        while (!structurePoolGenerator.structurePieces.isEmpty()) {
            ShapedPoolStructurePiece shapedPoolStructurePiece = structurePoolGenerator.structurePieces.removeFirst();
            structurePoolGenerator.generatePiece(shapedPoolStructurePiece.piece, shapedPoolStructurePiece.pieceShape, shapedPoolStructurePiece.currentSize, useExpansionHack, heightLimitView, noiseConfig);
        }
    }

    static final class StructurePoolGenerator {
        private final boolean vanilla;
        private final Registry<StructureTemplatePool> registry;
        private final int maxSize;
        private final ChunkGenerator chunkGenerator;
        private final StructureTemplateManager structureTemplateManager;
        private final List<? super PoolElementStructurePiece> piecesToPlace;
        private final RandomSource random;
        private final Map<StructurePoolElement, Integer> groupCounts = new HashMap<StructurePoolElement, Integer>();
        final Deque<ShapedPoolStructurePiece> structurePieces = Queues.newArrayDeque();

        StructurePoolGenerator(boolean vanilla, Registry<StructureTemplatePool> registry, int maxSize, ChunkGenerator chunkGenerator, StructureTemplateManager structureTemplateManager, List<? super PoolElementStructurePiece> children, RandomSource random) {
            this.vanilla = vanilla;
            this.registry = registry;
            this.maxSize = maxSize;
            this.chunkGenerator = chunkGenerator;
            this.structureTemplateManager = structureTemplateManager;
            this.piecesToPlace = children;
            this.random = random;
        }

        void generatePiece(PoolElementStructurePiece parentPiece, MutableObject<VoxelShape> voxelShape, int depth, boolean useExpansionHack, LevelHeightAccessor world, RandomState noiseConfig) {
            StructurePoolElement anchorElement = parentPiece.m_209918_();
            MutableObject<VoxelShape> parentShape = new MutableObject<VoxelShape>();
            for (StructureTemplate.StructureBlockInfo anchorJigsawInfo : anchorElement.m_213638_(this.structureTemplateManager, parentPiece.m_72646_(), parentPiece.m_6830_(), this.random)) {
                MutableObject<VoxelShape> childShape;
                BoundingBox parentBoundingBox = parentPiece.m_73547_();
                BlockPos candidateConnectorPos = anchorJigsawInfo.f_74675_().m_121945_(JigsawBlock.m_54250_((BlockState)anchorJigsawInfo.f_74676_()));
                int k = -1;
                Holder<StructureTemplatePool> poolEntry = this.getStructurePoolEntry(StructurePoolGenerator.getPoolKey(anchorJigsawInfo));
                if (poolEntry == null) continue;
                boolean connectorInParentBoundingBox = parentBoundingBox.m_71051_((Vec3i)candidateConnectorPos);
                if (connectorInParentBoundingBox) {
                    childShape = parentShape;
                    if (parentShape.getValue() == null) {
                        parentShape.setValue((Object)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)parentBoundingBox)));
                    }
                } else {
                    childShape = voxelShape;
                }
                MutableObject checkedPools = new MutableObject(new ArrayList());
                this.findAndTestChildCandidates(poolEntry, (MutableObject<List<ResourceKey<StructureTemplatePool>>>)checkedPools, parentPiece, anchorJigsawInfo, childShape, k, depth, useExpansionHack, world, noiseConfig, true);
            }
        }

        private void findAndTestChildCandidates(Holder<StructureTemplatePool> entry, MutableObject<List<ResourceKey<StructureTemplatePool>>> checkedPools, PoolElementStructurePiece parentPiece, StructureTemplate.StructureBlockInfo anchorJigsawInfo, MutableObject<VoxelShape> mutableObject2, int k, int depth, boolean useExpansionHack, LevelHeightAccessor world, RandomState noiseConfig, boolean firstIteration) {
            List<StructurePoolElement> childCandidates = this.getPoolElements((ResourceKey<StructureTemplatePool>)entry.m_203543_().orElse(Pools.f_127186_), checkedPools, depth, firstIteration);
            if (childCandidates.isEmpty()) {
                return;
            }
            boolean foundChild = this.findValidChildPiece(childCandidates, parentPiece, anchorJigsawInfo, mutableObject2, k, depth, useExpansionHack, world, noiseConfig);
            if (!foundChild) {
                this.findAndTestChildCandidates((Holder<StructureTemplatePool>)((StructureTemplatePool)entry.m_203334_()).m_254935_(), checkedPools, parentPiece, anchorJigsawInfo, mutableObject2, k, depth, useExpansionHack, world, noiseConfig, false);
            }
        }

        private List<StructurePoolElement> getPoolElements(ResourceKey<StructureTemplatePool> poolKey, MutableObject<List<ResourceKey<StructureTemplatePool>>> checkedPools, int depth, boolean firstIteration) {
            if (poolKey == Pools.f_127186_) {
                return List.of();
            }
            if (ConfigHandler.getConfig().breaksSeedParity() || !this.vanilla) {
                if (((List)checkedPools.getValue()).contains(poolKey)) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (ResourceKey checkedPoolKey : (List)checkedPools.getValue()) {
                        stringBuilder.append(checkedPoolKey.m_135782_()).append(" -> ");
                    }
                    stringBuilder.append(poolKey.m_135782_());
                    LithostitchedCommon.LOGGER.warn("Template pool fallback chain found: {}", (Object)stringBuilder);
                    return List.of();
                }
                ((List)checkedPools.getValue()).add(poolKey);
                Holder pool = (Holder)this.registry.m_203636_(poolKey).orElseThrow();
                if (depth == this.maxSize && firstIteration) {
                    pool = ((StructureTemplatePool)pool.m_203334_()).m_254935_();
                }
                return ((StructurePoolAccess)pool.m_203334_()).getLithostitchedTemplates().shuffle(this.random);
            }
            if (!firstIteration) {
                return List.of();
            }
            Holder pool = (Holder)this.registry.m_203636_(poolKey).orElseThrow();
            Holder fallback = ((StructureTemplatePool)pool.m_203334_()).m_254935_();
            ArrayList<StructurePoolElement> elements = new ArrayList<StructurePoolElement>();
            if (depth != this.maxSize) {
                elements.addAll(((StructureTemplatePool)pool.m_203334_()).m_227362_(this.random));
            }
            elements.addAll(((StructureTemplatePool)fallback.m_203334_()).m_227362_(this.random));
            return elements;
        }

        private boolean findValidChildPiece(List<StructurePoolElement> elements, PoolElementStructurePiece parentPiece, StructureTemplate.StructureBlockInfo anchorJigsawInfo, MutableObject<VoxelShape> mutableObject2, int k, int depth, boolean useExpansionHack, LevelHeightAccessor world, RandomState noiseConfig) {
            BlockPos anchorPos = anchorJigsawInfo.f_74675_();
            BlockPos candidateConnectorPos = anchorPos.m_121945_(JigsawBlock.m_54250_((BlockState)anchorJigsawInfo.f_74676_()));
            int parentMinY = parentPiece.m_73547_().m_162396_();
            int anchorDistanceToFloor = anchorPos.m_123342_() - parentMinY;
            StructureTemplatePool.Projection parentProjection = parentPiece.m_209918_().m_210539_();
            boolean parentRigid = parentProjection == StructureTemplatePool.Projection.RIGID;
            for (StructurePoolElement element : elements) {
                DelegatingPoolElement delegating;
                if (element == EmptyPoolElement.f_210175_) {
                    return true;
                }
                if (element instanceof DelegatingPoolElement && (delegating = (DelegatingPoolElement)element).config().shouldSkip(depth, this.groupCounts.getOrDefault((Object)delegating, 0))) continue;
                for (Rotation rotation : Rotation.m_221992_((RandomSource)this.random)) {
                    List connectorJigsaws = element.m_213638_(this.structureTemplateManager, BlockPos.f_121853_, rotation, this.random);
                    BoundingBox connectorBoundingBox = element.m_214015_(this.structureTemplateManager, BlockPos.f_121853_, rotation);
                    int l = useExpansionHack && connectorBoundingBox.m_71057_() <= 16 ? connectorJigsaws.stream().mapToInt(blockInfo -> {
                        if (!connectorBoundingBox.m_71051_((Vec3i)blockInfo.f_74675_().m_121945_(JigsawBlock.m_54250_((BlockState)blockInfo.f_74676_())))) {
                            return 0;
                        }
                        ResourceKey<StructureTemplatePool> registryKey2 = StructurePoolGenerator.getPoolKey(blockInfo);
                        Optional optional1 = this.registry.m_203636_(registryKey2);
                        Optional<Holder> optional2 = optional1.map(entry -> ((StructureTemplatePool)entry.m_203334_()).m_254935_());
                        int i2 = optional1.map(entry -> ((StructureTemplatePool)entry.m_203334_()).m_227357_(this.structureTemplateManager)).orElse(0);
                        int j2 = optional2.map(entry -> ((StructureTemplatePool)entry.m_203334_()).m_227357_(this.structureTemplateManager)).orElse(0);
                        return Math.max(i2, j2);
                    }).max().orElse(0) : 0;
                    for (StructureTemplate.StructureBlockInfo connectorJigsawInfo : connectorJigsaws) {
                        int t;
                        int r;
                        int p;
                        if (!JigsawBlock.m_54245_((StructureTemplate.StructureBlockInfo)anchorJigsawInfo, (StructureTemplate.StructureBlockInfo)connectorJigsawInfo)) continue;
                        BlockPos connectorPos = connectorJigsawInfo.f_74675_();
                        BlockPos blockPos5 = candidateConnectorPos.m_121996_((Vec3i)connectorPos);
                        BoundingBox blockBox3 = element.m_214015_(this.structureTemplateManager, blockPos5, rotation);
                        int m = blockBox3.m_162396_();
                        StructureTemplatePool.Projection connectorProjection = element.m_210539_();
                        boolean connectorProjectionRigid = connectorProjection == StructureTemplatePool.Projection.RIGID;
                        int connectorY = connectorPos.m_123342_();
                        int o = anchorDistanceToFloor - connectorY + JigsawBlock.m_54250_((BlockState)anchorJigsawInfo.f_74676_()).m_122430_();
                        if (parentRigid && connectorProjectionRigid) {
                            p = parentMinY + o;
                        } else {
                            if (k == -1) {
                                k = this.chunkGenerator.m_223221_(anchorPos.m_123341_(), anchorPos.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, world, noiseConfig);
                            }
                            p = k - connectorY;
                        }
                        int q = p - m;
                        BoundingBox blockBox4 = blockBox3.m_71045_(0, q, 0);
                        BlockPos blockPos6 = blockPos5.m_7918_(0, q, 0);
                        if (l > 0) {
                            r = Math.max(l + 1, blockBox4.m_162400_() - blockBox4.m_162396_());
                            blockBox4.m_162371_(new BlockPos(blockBox4.m_162395_(), blockBox4.m_162396_() + r, blockBox4.m_162398_()));
                        }
                        if (Shapes.m_83157_((VoxelShape)((VoxelShape)mutableObject2.getValue()), (VoxelShape)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)blockBox4).m_82406_(0.25)), (BooleanOp)BooleanOp.f_82683_)) continue;
                        if (element instanceof DelegatingPoolElement) {
                            DelegatingPoolElement delegating2 = (DelegatingPoolElement)element;
                            this.groupCounts.put(delegating2, this.groupCounts.getOrDefault((Object)delegating2, 0) + 1);
                        }
                        mutableObject2.setValue((Object)Shapes.m_83148_((VoxelShape)((VoxelShape)mutableObject2.getValue()), (VoxelShape)Shapes.m_83064_((AABB)AABB.m_82321_((BoundingBox)blockBox4)), (BooleanOp)BooleanOp.f_82685_));
                        r = parentPiece.m_72647_();
                        int s = connectorProjectionRigid ? r - o : element.m_210540_();
                        PoolElementStructurePiece poolStructurePiece = new PoolElementStructurePiece(this.structureTemplateManager, element, blockPos6, s, rotation, blockBox4);
                        if (parentRigid) {
                            t = parentMinY + anchorDistanceToFloor;
                        } else if (connectorProjectionRigid) {
                            t = p + connectorY;
                        } else {
                            if (k == -1) {
                                k = this.chunkGenerator.m_223221_(anchorPos.m_123341_(), anchorPos.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, world, noiseConfig);
                            }
                            t = k + o / 2;
                        }
                        parentPiece.m_209916_(new JigsawJunction(candidateConnectorPos.m_123341_(), t - anchorDistanceToFloor + r, candidateConnectorPos.m_123343_(), o, connectorProjection));
                        poolStructurePiece.m_209916_(new JigsawJunction(anchorPos.m_123341_(), t - connectorY + s, anchorPos.m_123343_(), -o, parentProjection));
                        this.piecesToPlace.add((PoolElementStructurePiece)poolStructurePiece);
                        if (depth < this.maxSize) {
                            this.structurePieces.addLast(new ShapedPoolStructurePiece(poolStructurePiece, mutableObject2, depth + 1));
                        }
                        return true;
                    }
                }
            }
            return false;
        }

        private Holder<StructureTemplatePool> getStructurePoolEntry(ResourceKey<StructureTemplatePool> key) {
            Optional optional = this.registry.m_203636_(key);
            if (optional.isEmpty()) {
                LithostitchedCommon.LOGGER.warn("Non-existent template pool reference: {}", (Object)key.m_135782_());
            } else {
                Holder regularPool = (Holder)optional.get();
                if (((StructureTemplatePool)regularPool.m_203334_()).m_210590_() == 0) {
                    if (!regularPool.m_203565_(Pools.f_127186_)) {
                        LithostitchedCommon.LOGGER.warn("Empty template pool reference: {}", (Object)key.m_135782_());
                    }
                } else {
                    return regularPool;
                }
            }
            return null;
        }

        private static ResourceKey<StructureTemplatePool> getPoolKey(StructureTemplate.StructureBlockInfo blockInfo) {
            return ResourceKey.m_135785_((ResourceKey)Registries.f_256948_, (ResourceLocation)new ResourceLocation(blockInfo.f_74677_().m_128461_("pool")));
        }
    }

    private record ShapedPoolStructurePiece(PoolElementStructurePiece piece, MutableObject<VoxelShape> pieceShape, int currentSize) {
    }
}

