/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.observer;

import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.filter.FilterItemStack;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.graph.DimensionPalette;
import com.simibubi.create.content.trains.graph.TrackEdge;
import com.simibubi.create.content.trains.graph.TrackGraph;
import com.simibubi.create.content.trains.graph.TrackNodeLocation;
import com.simibubi.create.content.trains.signal.SignalPropagator;
import com.simibubi.create.content.trains.signal.SingleBlockEntityEdgePoint;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TrackObserver
extends SingleBlockEntityEdgePoint {
    private int activated = 0;
    private FilterItemStack filter = FilterItemStack.empty();
    private UUID currentTrain = null;

    @Override
    public void blockEntityAdded(BlockEntity blockEntity, boolean front) {
        super.blockEntityAdded(blockEntity, front);
        FilteringBehaviour filteringBehaviour = BlockEntityBehaviour.get(blockEntity, FilteringBehaviour.TYPE);
        if (filteringBehaviour != null) {
            this.setFilterAndNotify(blockEntity.m_58904_(), filteringBehaviour.getFilter());
        }
    }

    @Override
    public void tick(TrackGraph graph, boolean preTrains) {
        super.tick(graph, preTrains);
        if (this.isActivated()) {
            --this.activated;
        }
        if (!this.isActivated()) {
            this.currentTrain = null;
        }
    }

    public void setFilterAndNotify(Level level, ItemStack filter) {
        this.filter = FilterItemStack.of(filter.m_41777_());
        this.notifyTrains(level);
    }

    private void notifyTrains(Level level) {
        TrackGraph graph = Create.RAILWAYS.sided((LevelAccessor)level).getGraph((LevelAccessor)level, (TrackNodeLocation)((Object)this.edgeLocation.getFirst()));
        if (graph == null) {
            return;
        }
        TrackEdge edge = graph.getConnection(this.edgeLocation.map(graph::locateNode));
        if (edge == null) {
            return;
        }
        SignalPropagator.notifyTrains(graph, edge);
    }

    public FilterItemStack getFilter() {
        return this.filter;
    }

    public UUID getCurrentTrain() {
        return this.currentTrain;
    }

    public boolean isActivated() {
        return this.activated > 0;
    }

    public void keepAlive(Train train) {
        this.activated = 8;
        this.currentTrain = train.id;
    }

    @Override
    public void read(CompoundTag nbt, boolean migration, DimensionPalette dimensions) {
        super.read(nbt, migration, dimensions);
        this.activated = nbt.m_128451_("Activated");
        this.filter = FilterItemStack.of(nbt.m_128469_("Filter"));
        if (nbt.m_128441_("TrainId")) {
            this.currentTrain = nbt.m_128342_("TrainId");
        }
    }

    @Override
    public void read(FriendlyByteBuf buffer, DimensionPalette dimensions) {
        super.read(buffer, dimensions);
    }

    @Override
    public void write(CompoundTag nbt, DimensionPalette dimensions) {
        super.write(nbt, dimensions);
        nbt.m_128405_("Activated", this.activated);
        nbt.m_128365_("Filter", (Tag)this.filter.serializeNBT());
        if (this.currentTrain != null) {
            nbt.m_128362_("TrainId", this.currentTrain);
        }
    }

    @Override
    public void write(FriendlyByteBuf buffer, DimensionPalette dimensions) {
        super.write(buffer, dimensions);
    }
}

