/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.registry.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.Components;
import dev.ithundxr.createnumismatics.Numismatics;
import dev.ithundxr.createnumismatics.content.backend.BankAccount;
import dev.ithundxr.createnumismatics.content.backend.Coin;
import dev.ithundxr.createnumismatics.content.bank.blaze_banker.BankAccountBehaviour;
import dev.ithundxr.createnumismatics.registry.commands.arguments.EnumArgument;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.BlockGetter;

public class PayCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"pay").requires(cs -> cs.m_6761_(2))).then(Commands.m_82127_((String)"banker").then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> {
            BlockPos pos = BlockPosArgument.m_118242_((CommandContext)ctx, (String)"pos");
            int amount = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount");
            BankAccountBehaviour bankAct = (BankAccountBehaviour)BlockEntityBehaviour.get((BlockGetter)((CommandSourceStack)ctx.getSource()).m_81372_(), (BlockPos)pos, BankAccountBehaviour.TYPE);
            if (bankAct == null) {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Components.literal((String)("There is no Blaze Banker at " + pos.m_123344_())));
                return -1;
            }
            UUID id = bankAct.getAccountUUID();
            return PayCommand.execute((CommandContext<CommandSourceStack>)ctx, id, BankAccount.Type.BLAZE_BANKER, false, "Blaze Banker at (" + pos.m_123344_() + ")", amount);
        })).then(Commands.m_82129_((String)"coin", EnumArgument.enumArgument(Coin.class)).executes(ctx -> {
            BlockPos pos = BlockPosArgument.m_118242_((CommandContext)ctx, (String)"pos");
            int amount = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount");
            Coin coin = (Coin)((Object)((Object)ctx.getArgument("coin", Coin.class)));
            BankAccountBehaviour bankAct = (BankAccountBehaviour)BlockEntityBehaviour.get((BlockGetter)((CommandSourceStack)ctx.getSource()).m_81372_(), (BlockPos)pos, BankAccountBehaviour.TYPE);
            if (bankAct == null) {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Components.literal((String)("There is no Blaze Banker at " + pos.m_123344_())));
                return -1;
            }
            UUID id = bankAct.getAccountUUID();
            return PayCommand.execute((CommandContext<CommandSourceStack>)ctx, id, BankAccount.Type.BLAZE_BANKER, false, "Blaze Banker at (" + pos.m_123344_() + ")", amount, coin);
        })))))).then(Commands.m_82129_((String)"player", (ArgumentType)GameProfileArgument.m_94584_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> {
            Collection accounts = GameProfileArgument.m_94590_((CommandContext)ctx, (String)"player");
            int amount = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount");
            int sum = 0;
            for (GameProfile account : accounts) {
                sum += PayCommand.execute((CommandContext<CommandSourceStack>)ctx, account.getId(), BankAccount.Type.PLAYER, true, account.getName(), amount);
            }
            return sum;
        })).then(Commands.m_82129_((String)"coin", EnumArgument.enumArgument(Coin.class)).executes(ctx -> {
            Collection accounts = GameProfileArgument.m_94590_((CommandContext)ctx, (String)"player");
            int amount = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount");
            Coin coin = (Coin)((Object)((Object)ctx.getArgument("coin", Coin.class)));
            int sum = 0;
            for (GameProfile account : accounts) {
                sum += PayCommand.execute((CommandContext<CommandSourceStack>)ctx, account.getId(), BankAccount.Type.PLAYER, true, account.getName(), amount, coin);
            }
            return sum;
        }))));
    }

    private static int execute(CommandContext<CommandSourceStack> ctx, UUID account, BankAccount.Type type, boolean create, String name, int amount) {
        return PayCommand.execute(ctx, account, type, create, name, amount, Coin.SPUR);
    }

    private static int execute(CommandContext<CommandSourceStack> ctx, UUID account, BankAccount.Type type, boolean create, String name, int amount, Coin coin) {
        int spurValue = coin.toSpurs(amount);
        if (PayCommand.pay(account, spurValue, create, type)) {
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Components.literal((String)("Paid " + amount + " " + coin.getName(amount) + " to " + name + ".")), true);
            return spurValue;
        }
        ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Components.literal((String)("Could not find account for " + name + ".")));
        return 0;
    }

    private static boolean pay(UUID id, int amount, boolean create, BankAccount.Type type) {
        BankAccount account;
        BankAccount bankAccount = account = create ? Numismatics.BANK.getOrCreateAccount(id, type) : Numismatics.BANK.getAccount(id);
        if (account == null) {
            return false;
        }
        account.deposit(amount);
        return true;
    }
}

