/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.content.vendor;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.equipment.goggles.IHaveHoveringInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Lang;
import dev.ithundxr.createnumismatics.Numismatics;
import dev.ithundxr.createnumismatics.content.backend.BankAccount;
import dev.ithundxr.createnumismatics.content.backend.Coin;
import dev.ithundxr.createnumismatics.content.backend.Trusted;
import dev.ithundxr.createnumismatics.content.backend.behaviours.SliderStylePriceBehaviour;
import dev.ithundxr.createnumismatics.content.backend.trust_list.TrustListContainer;
import dev.ithundxr.createnumismatics.content.backend.trust_list.TrustListHolder;
import dev.ithundxr.createnumismatics.content.backend.trust_list.TrustListMenu;
import dev.ithundxr.createnumismatics.content.bank.CardItem;
import dev.ithundxr.createnumismatics.content.coins.CoinItem;
import dev.ithundxr.createnumismatics.content.coins.DiscreteCoinBag;
import dev.ithundxr.createnumismatics.content.vendor.VendorBlock;
import dev.ithundxr.createnumismatics.content.vendor.VendorMenu;
import dev.ithundxr.createnumismatics.registry.NumismaticsAdvancements;
import dev.ithundxr.createnumismatics.registry.NumismaticsBlocks;
import dev.ithundxr.createnumismatics.registry.NumismaticsMenuTypes;
import dev.ithundxr.createnumismatics.registry.NumismaticsPackets;
import dev.ithundxr.createnumismatics.registry.NumismaticsTags;
import dev.ithundxr.createnumismatics.registry.packets.OpenTrustListPacket;
import dev.ithundxr.createnumismatics.util.ItemUtil;
import dev.ithundxr.createnumismatics.util.TextUtils;
import dev.ithundxr.createnumismatics.util.UsernameUtils;
import dev.ithundxr.createnumismatics.util.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VendorBlockEntity
extends SmartBlockEntity
implements Trusted,
TrustListHolder,
IHaveHoveringInformation,
WorldlyContainer,
MenuProvider {
    public final Container cardContainer = new SimpleContainer(1){

        public void m_6596_() {
            super.m_6596_();
            VendorBlockEntity.this.m_6596_();
        }
    };
    public final Container sellingContainer = new SimpleContainer(1){

        public void m_6596_() {
            super.m_6596_();
            VendorBlockEntity.this.m_6596_();
            VendorBlockEntity.this.correctStock();
        }
    };
    @Nullable
    protected UUID owner;
    protected final List<UUID> trustList = new ArrayList<UUID>();
    public final TrustListContainer trustListContainer = new TrustListContainer(this.trustList, () -> ((VendorBlockEntity)this).m_6596_());
    protected final DiscreteCoinBag inventory = new DiscreteCoinBag();
    private boolean delayedDataSync = false;
    private SliderStylePriceBehaviour price;
    private Mode mode = Mode.SELL;
    public final NonNullList<ItemStack> items = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
    @Nullable
    private Boolean isCreativeVendorCached;

    public VendorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.price = new SliderStylePriceBehaviour(this, this::addCoin, this::getCoinCount);
        behaviours.add(this.price);
    }

    public int getCoinCount(Coin coin) {
        return this.inventory.getDiscrete(coin);
    }

    @Nullable
    public UUID getCardId() {
        ItemStack card = this.cardContainer.m_8020_(0);
        if (!(card.m_41720_() instanceof CardItem)) {
            return null;
        }
        return CardItem.get(card);
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        if (this.owner != null) {
            tag.m_128362_("Owner", this.owner);
        }
        if (!this.inventory.isEmpty()) {
            tag.m_128365_("CoinInventory", (Tag)this.inventory.save(new CompoundTag()));
        }
        if (!this.cardContainer.m_8020_(0).m_41619_()) {
            tag.m_128365_("Card", (Tag)this.cardContainer.m_8020_(0).m_41739_(new CompoundTag()));
        }
        if (!this.getSellingItem().m_41619_()) {
            tag.m_128365_("Selling", (Tag)this.getSellingItem().m_41739_(new CompoundTag()));
        }
        if (!this.trustListContainer.m_7983_()) {
            tag.m_128365_("TrustListInv", (Tag)this.trustListContainer.save(new CompoundTag()));
        }
        if (!this.items.isEmpty()) {
            tag.m_128365_("Inventory", (Tag)ContainerHelper.m_18973_((CompoundTag)new CompoundTag(), this.items));
        }
        tag.m_128405_("Mode", this.mode.ordinal());
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.owner = tag.m_128403_("Owner") ? tag.m_128342_("Owner") : null;
        this.inventory.clear();
        if (tag.m_128425_("CoinInventory", 10)) {
            this.inventory.load(tag.m_128469_("CoinInventory"));
        }
        if (tag.m_128425_("Card", 10)) {
            ItemStack cardStack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("Card"));
            this.cardContainer.m_6836_(0, cardStack);
        } else {
            this.cardContainer.m_6836_(0, ItemStack.f_41583_);
        }
        if (tag.m_128425_("Selling", 10)) {
            ItemStack sellingStack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("Selling"));
            this.sellingContainer.m_6836_(0, sellingStack);
        } else {
            this.sellingContainer.m_6836_(0, ItemStack.f_41583_);
        }
        this.trustListContainer.m_6211_();
        this.trustList.clear();
        if (tag.m_128425_("TrustListInv", 10)) {
            this.trustListContainer.load(tag.m_128469_("TrustListInv"));
        }
        this.items.clear();
        if (tag.m_128425_("Inventory", 10)) {
            ContainerHelper.m_18980_((CompoundTag)tag.m_128469_("Inventory"), this.items);
        }
        this.mode = Mode.values()[tag.m_128451_("Mode")];
    }

    /*
     * Unable to fully structure code
     */
    public boolean isCreativeVendor() {
        block2: {
            if (this.isCreativeVendorCached != null) break block2;
            var2_1 = this.m_58900_().m_60734_();
            if (!(var2_1 instanceof VendorBlock)) ** GOTO lbl-1000
            vendorBlock = (VendorBlock)var2_1;
            if (vendorBlock.isCreativeVendor) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
            this.isCreativeVendorCached = v0;
        }
        return this.isCreativeVendorCached;
    }

    @Override
    public boolean isTrustedInternal(Player player) {
        if (Utils.isDevEnv()) {
            return player.m_6844_(EquipmentSlot.FEET).m_150930_(Items.f_42479_);
        }
        if (this.isCreativeVendor()) {
            return player != null && player.m_7500_();
        }
        return this.owner == null || this.owner.equals(player.m_20148_()) || this.trustList.contains(player.m_20148_());
    }

    public void addCoin(Coin coin, int count) {
        BankAccount account;
        UUID depositAccount = this.getDepositAccount();
        if (depositAccount != null && (account = Numismatics.BANK.getAccount(depositAccount)) != null) {
            account.deposit(coin, count);
            return;
        }
        this.inventory.add(coin, count);
        this.m_6596_();
    }

    @Nullable
    public UUID getDepositAccount() {
        ItemStack cardStack = this.cardContainer.m_8020_(0);
        if (cardStack.m_41619_()) {
            return null;
        }
        if (!NumismaticsTags.AllItemTags.CARDS.matches(cardStack)) {
            return null;
        }
        return CardItem.get(cardStack);
    }

    public void lazyTick() {
        BankAccount account;
        UUID depositAccount;
        super.lazyTick();
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        if (this.delayedDataSync) {
            this.delayedDataSync = false;
            this.sendData();
        }
        if ((depositAccount = this.getDepositAccount()) != null && !this.inventory.isEmpty() && (account = Numismatics.BANK.getAccount(depositAccount)) != null) {
            for (Coin coin : Coin.values()) {
                int count = this.inventory.getDiscrete(coin);
                this.inventory.subtract(coin, count);
                account.deposit(coin, count);
                this.notifyUpdate();
            }
        }
    }

    void notifyDelayedDataSync() {
        this.delayedDataSync = true;
    }

    @Override
    public ImmutableList<UUID> getTrustList() {
        return ImmutableList.copyOf(this.trustList);
    }

    @Override
    public Container getTrustListBackingContainer() {
        return this.trustListContainer;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean addToTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        ItemStack sellingStack = this.getSellingItem();
        if (sellingStack.m_41619_()) {
            return false;
        }
        switch (this.mode) {
            case SELL: {
                if (this.hasStock()) break;
                Lang.builder().add(Components.translatable((String)"gui.numismatics.vendor.out_of_stock")).style(ChatFormatting.DARK_RED).forGoggles(tooltip);
                String ownerName = UsernameUtils.INSTANCE.getName(this.owner, null);
                if (ownerName == null) break;
                Lang.builder().add(Components.translatable((String)"gui.numismatics.vendor.generic_named", (Object[])new Object[]{ownerName})).style(ChatFormatting.DARK_RED).forGoggles(tooltip);
                break;
            }
            case BUY: {
                String ownerName;
                if (!this.hasSpace()) {
                    Lang.builder().add(Components.translatable((String)"gui.numismatics.vendor.full")).style(ChatFormatting.DARK_RED).forGoggles(tooltip);
                    ownerName = UsernameUtils.INSTANCE.getName(this.owner, null);
                    if (ownerName == null) break;
                    Lang.builder().add(Components.translatable((String)"gui.numismatics.vendor.generic_named", (Object[])new Object[]{ownerName})).style(ChatFormatting.DARK_RED).forGoggles(tooltip);
                    break;
                }
                if (this.hasEnoughMoney()) break;
                Lang.builder().add(Components.translatable((String)"gui.numismatics.vendor.insufficient_funds")).style(ChatFormatting.DARK_RED).forGoggles(tooltip);
                ownerName = UsernameUtils.INSTANCE.getName(this.owner, null);
                if (ownerName == null) break;
                Lang.builder().add(Components.translatable((String)"gui.numismatics.vendor.generic_named", (Object[])new Object[]{ownerName})).style(ChatFormatting.DARK_RED).forGoggles(tooltip);
            }
        }
        Couple<Integer> cogsAndSpurs = Coin.COG.convert(this.getTotalPrice());
        int cogs = (Integer)cogsAndSpurs.getFirst();
        int spurs = (Integer)cogsAndSpurs.getSecond();
        MutableComponent balanceLabel = Components.translatable((String)"block.numismatics.vendor.tooltip.price", (Object[])new Object[]{TextUtils.formatInt(cogs), Coin.COG.getName(cogs), spurs});
        Lang.builder().add(Components.translatable((String)this.mode.getOpposite().getActionTranslationKey())).forGoggles(tooltip);
        boolean isFirst = true;
        for (Component component : Screen.m_280152_((Minecraft)Minecraft.m_91087_(), (ItemStack)sellingStack)) {
            MutableComponent mutable = component.m_6881_();
            if (isFirst) {
                isFirst = false;
                if (sellingStack.m_41613_() != 1) {
                    mutable.m_7220_((Component)Components.translatable((String)"gui.numismatics.vendor.count", (Object[])new Object[]{sellingStack.m_41613_()}).m_130940_(ChatFormatting.GREEN));
                }
            }
            Lang.builder().add(mutable).forGoggles(tooltip);
        }
        tooltip.add(Components.immutableEmpty());
        Lang.builder().add(balanceLabel.m_130940_(Coin.closest((int)this.getTotalPrice()).rarity.f_43022_)).forGoggles(tooltip);
        for (MutableComponent mutableComponent : this.price.getCondensedPriceBreakdown()) {
            Lang.builder().add(mutableComponent).forGoggles(tooltip);
        }
        return true;
    }

    @NotNull
    public Component m_5446_() {
        return Components.translatable((String)(this.isCreativeVendor() ? "block.numismatics.creative_vendor" : "block.numismatics.vendor"));
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, @NotNull Inventory inventory, @NotNull Player player) {
        if (!this.isTrusted(player)) {
            return null;
        }
        return new VendorMenu((MenuType)NumismaticsMenuTypes.VENDOR.get(), i, inventory, this);
    }

    public int getTotalPrice() {
        return this.price.getTotalPrice();
    }

    public int getPrice(Coin coin) {
        return this.price.getPrice(coin);
    }

    public void setPrice(Coin coin, int price) {
        this.price.setPrice(coin, price);
    }

    public ItemStack getSellingItem() {
        return this.sellingContainer.m_8020_(0);
    }

    public int @NotNull [] m_7071_(@NotNull Direction side) {
        int[] nArray;
        if (this.mode == Mode.BUY) {
            int[] nArray2;
            if (side == Direction.DOWN) {
                int[] nArray3 = new int[9];
                nArray3[0] = 0;
                nArray3[1] = 1;
                nArray3[2] = 2;
                nArray3[3] = 3;
                nArray3[4] = 4;
                nArray3[5] = 5;
                nArray3[6] = 6;
                nArray3[7] = 7;
                nArray2 = nArray3;
                nArray3[8] = 8;
            } else {
                nArray2 = new int[]{};
            }
            return nArray2;
        }
        if (side == Direction.DOWN) {
            nArray = new int[]{};
        } else {
            int[] nArray4 = new int[9];
            nArray4[0] = 0;
            nArray4[1] = 1;
            nArray4[2] = 2;
            nArray4[3] = 3;
            nArray4[4] = 4;
            nArray4[5] = 5;
            nArray4[6] = 6;
            nArray4[7] = 7;
            nArray = nArray4;
            nArray4[8] = 8;
        }
        return nArray;
    }

    public boolean m_7013_(int index, @NotNull ItemStack stack) {
        return this.mode == Mode.SELL && this.matchesSellingItem(stack);
    }

    public boolean m_7155_(int index, @NotNull ItemStack itemStack, @Nullable Direction direction) {
        return direction != Direction.DOWN && this.m_7013_(index, itemStack);
    }

    public boolean m_7157_(int index, @NotNull ItemStack stack, @NotNull Direction direction) {
        return direction == Direction.DOWN && this.mode == Mode.BUY;
    }

    public int m_6643_() {
        return 9;
    }

    public boolean m_7983_() {
        for (ItemStack stack : this.items) {
            if (stack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ItemStack m_8020_(int slot) {
        return slot >= 0 && slot < this.items.size() ? (ItemStack)this.items.get(slot) : ItemStack.f_41583_;
    }

    @NotNull
    public ItemStack m_7407_(int slot, int amount) {
        ItemStack itemStack = ContainerHelper.m_18969_(this.items, (int)slot, (int)amount);
        if (!itemStack.m_41619_()) {
            this.m_6596_();
        }
        return itemStack;
    }

    @NotNull
    public ItemStack m_8016_(int slot) {
        ItemStack itemStack = (ItemStack)this.items.get(slot);
        if (itemStack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        this.items.set(slot, (Object)ItemStack.f_41583_);
        return itemStack;
    }

    public void m_6836_(int slot, @NotNull ItemStack stack) {
        this.items.set(slot, (Object)stack);
        if (!stack.m_41619_() && stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        this.m_6596_();
    }

    public boolean m_6542_(@NotNull Player player) {
        return Container.m_272074_((BlockEntity)this, (Player)player);
    }

    public void m_6211_() {
        this.items.clear();
        this.m_6596_();
    }

    @NotNull
    @Contract(value="_ -> new")
    private CompoundTag cleanTags(@NotNull CompoundTag tag) {
        tag = tag.m_6426_();
        tag.m_128473_("RepairCost");
        tag.m_128473_("Count");
        ListTag enchants = tag.m_128437_("Enchantments", 10);
        if (!enchants.isEmpty()) {
            ArrayList tags = new ArrayList(enchants);
            tags.sort((a, b) -> {
                if (a.equals(b)) {
                    return 0;
                }
                if (a instanceof CompoundTag) {
                    CompoundTag ca = (CompoundTag)a;
                    if (b instanceof CompoundTag) {
                        int comp;
                        CompoundTag cb = (CompoundTag)b;
                        if (ca.m_128425_("id", 8) && cb.m_128425_("id", 8) && (comp = ca.m_128461_("id").compareTo(cb.m_128461_("id"))) != 0) {
                            return comp;
                        }
                        return ca.m_128448_("lvl") - cb.m_128448_("lvl");
                    }
                }
                return 0;
            });
            enchants = new ListTag();
            enchants.addAll(tags);
            tag.m_128365_("Enchantments", (Tag)enchants);
        }
        return tag;
    }

    public boolean matchesSellingItem(@NotNull ItemStack b) {
        ItemStack a = this.getSellingItem();
        if (a.m_41619_() || b.m_41619_()) {
            return false;
        }
        if (!ItemStack.m_41656_((ItemStack)a, (ItemStack)b)) {
            return false;
        }
        CompoundTag an = a.m_41783_();
        CompoundTag bn = b.m_41783_();
        if (an == null || bn == null) {
            return an == bn;
        }
        an = this.cleanTags(an);
        bn = this.cleanTags(bn);
        return an.equals((Object)bn);
    }

    protected void condenseItems() {
        NonNullList newItems = NonNullList.m_122780_((int)this.items.size(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < this.items.size(); ++i) {
            newItems.set(i, (Object)((ItemStack)this.items.get(i)));
        }
        this.items.clear();
        for (ItemStack stack : newItems) {
            ItemUtil.moveItemStackTo(stack, (Container)this, false);
        }
        this.notifyUpdate();
    }

    protected void correctStock() {
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack stack = (ItemStack)this.items.get(i);
            if (this.matchesSellingItem(stack) || stack.m_41619_() || this.f_58857_ == null) continue;
            Containers.m_18992_((Level)this.f_58857_, (double)this.m_58899_().m_123341_(), (double)(this.m_58899_().m_123342_() + 1), (double)this.m_58899_().m_123343_(), (ItemStack)stack);
            this.items.set(i, (Object)ItemStack.f_41583_);
        }
        this.notifyUpdate();
    }

    public void dropContents(Level level, BlockPos pos) {
        Containers.m_19002_((Level)level, (BlockPos)pos, (Container)this);
        Containers.m_19002_((Level)level, (BlockPos)pos, (Container)this.cardContainer);
        Containers.m_19002_((Level)level, (BlockPos)pos, (Container)this.sellingContainer);
        this.inventory.dropContents(level, pos);
    }

    private boolean hasStock() {
        if (this.isCreativeVendor()) {
            return true;
        }
        for (ItemStack stack : this.items) {
            if (!this.matchesSellingItem(stack) || stack.m_41613_() < this.getSellingItem().m_41613_()) continue;
            return true;
        }
        return false;
    }

    private boolean hasSpace() {
        if (this.isCreativeVendor()) {
            return true;
        }
        ItemStack buying = this.getSellingItem();
        int space = 0;
        for (ItemStack stack : this.items) {
            if (stack.m_41619_()) {
                space += buying.m_41741_();
                continue;
            }
            if (!this.matchesSellingItem(stack) || stack.m_41613_() >= stack.m_41741_()) continue;
            space += stack.m_41741_() - stack.m_41613_();
        }
        return space >= buying.m_41613_();
    }

    private boolean hasEnoughMoney() {
        if (this.isCreativeVendor()) {
            return true;
        }
        if (this.price.canPayOut()) {
            return true;
        }
        if (this.getCardId() != null) {
            BankAccount account = Numismatics.BANK.getAccount(this.getCardId());
            return account != null && account.isAuthorized(this.owner) && account.getBalance() >= this.price.getTotalPrice();
        }
        return false;
    }

    public void tryTransaction(Player player, InteractionHand hand) {
        switch (this.mode) {
            case SELL: {
                this.trySellTo(player, hand);
                break;
            }
            case BUY: {
                this.tryBuyFrom(player, hand);
            }
        }
    }

    private void trySellTo(Player player, InteractionHand hand) {
        if (this.f_58857_ == null) {
            return;
        }
        ItemStack selling = this.getSellingItem();
        if (selling.m_41619_()) {
            return;
        }
        this.condenseItems();
        if (this.isCreativeVendor()) {
            if (this.price.deduct(player, hand, false)) {
                ItemStack output = selling.m_41777_();
                ItemUtil.givePlayerItem(player, output);
                this.giveSellingAdvancements(player);
                this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11686_, SoundSource.BLOCKS, 0.5f, 1.0f);
                this.notifyUpdate();
            } else {
                player.m_5661_((Component)Components.translatable((String)"gui.numismatics.vendor.insufficient_funds").m_130940_(ChatFormatting.DARK_RED), true);
                this.f_58857_.m_5594_(null, this.m_58899_(), AllSoundEvents.DENY.getMainEvent(), SoundSource.BLOCKS, 0.5f, 1.0f);
            }
        } else {
            for (ItemStack stack : this.items) {
                if (!this.matchesSellingItem(stack) || stack.m_41613_() < selling.m_41613_()) continue;
                if (this.price.deduct(player, hand, true)) {
                    ItemStack output = stack.m_41620_(selling.m_41613_());
                    ItemUtil.givePlayerItem(player, output);
                    this.giveSellingAdvancements(player);
                    this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11686_, SoundSource.BLOCKS, 0.5f, 1.0f);
                    this.notifyUpdate();
                } else {
                    player.m_5661_((Component)Components.translatable((String)"gui.numismatics.vendor.insufficient_funds").m_130940_(ChatFormatting.DARK_RED), true);
                    this.f_58857_.m_5594_(null, this.m_58899_(), AllSoundEvents.DENY.getMainEvent(), SoundSource.BLOCKS, 0.5f, 1.0f);
                }
                return;
            }
            String ownerName = UsernameUtils.INSTANCE.getName(this.owner, null);
            if (ownerName != null) {
                player.m_5661_((Component)Components.translatable((String)"gui.numismatics.vendor.out_of_stock.named", (Object[])new Object[]{ownerName}).m_130940_(ChatFormatting.DARK_RED), true);
                this.f_58857_.m_5594_(null, this.m_58899_(), AllSoundEvents.DENY.getMainEvent(), SoundSource.BLOCKS, 0.5f, 1.0f);
            } else {
                player.m_5661_((Component)Components.translatable((String)"gui.numismatics.vendor.out_of_stock").m_130940_(ChatFormatting.DARK_RED), true);
                this.f_58857_.m_5594_(null, this.m_58899_(), AllSoundEvents.DENY.getMainEvent(), SoundSource.BLOCKS, 0.5f, 1.0f);
            }
        }
    }

    private void giveSellingAdvancements(Player player) {
        ItemStack selling = this.getSellingItem();
        Item item = selling.m_41720_();
        if (item instanceof CoinItem) {
            CoinItem coin = (CoinItem)item;
            NumismaticsAdvancements.MONEY_LAUNDERING.awardTo(player);
            int soldValue = coin.coin.toSpurs(selling.m_41613_());
            int paidValue = this.price.getTotalPrice();
            if (soldValue > paidValue) {
                NumismaticsAdvancements.IS_THIS_LEGAL.awardTo(player);
            } else if (soldValue < paidValue) {
                NumismaticsAdvancements.QUESTIONABLE_INVESTMENT.awardTo(player);
            }
        }
    }

    private void tryBuyFrom(Player player, InteractionHand hand) {
        BankAccount account;
        if (this.f_58857_ == null) {
            return;
        }
        ItemStack buying = this.getSellingItem();
        if (buying.m_41619_()) {
            return;
        }
        ItemStack handStack = player.m_21120_(hand);
        if (handStack.m_41619_()) {
            player.m_5661_((Component)Components.translatable((String)"gui.numismatics.vendor.no_item_in_hand").m_130940_(ChatFormatting.DARK_RED), true);
            this.f_58857_.m_5594_(null, this.m_58899_(), AllSoundEvents.DENY.getMainEvent(), SoundSource.BLOCKS, 0.5f, 1.0f);
            return;
        }
        if (!this.matchesSellingItem(handStack)) {
            player.m_5661_((Component)Components.translatable((String)"gui.numismatics.vendor.incorrect_item").m_130940_(ChatFormatting.DARK_RED), true);
            this.f_58857_.m_5594_(null, this.m_58899_(), AllSoundEvents.DENY.getMainEvent(), SoundSource.BLOCKS, 0.5f, 1.0f);
            return;
        }
        if (handStack.m_41613_() < buying.m_41613_()) {
            player.m_5661_((Component)Components.translatable((String)"gui.numismatics.vendor.too_few_items").m_130940_(ChatFormatting.DARK_RED), true);
            this.f_58857_.m_5594_(null, this.m_58899_(), AllSoundEvents.DENY.getMainEvent(), SoundSource.BLOCKS, 0.5f, 1.0f);
            return;
        }
        if (!this.hasSpace()) {
            String ownerName = UsernameUtils.INSTANCE.getName(this.owner, null);
            if (ownerName != null) {
                player.m_5661_((Component)Components.translatable((String)"gui.numismatics.vendor.full.named", (Object[])new Object[]{ownerName}).m_130940_(ChatFormatting.DARK_RED), true);
                this.f_58857_.m_5594_(null, this.m_58899_(), AllSoundEvents.DENY.getMainEvent(), SoundSource.BLOCKS, 0.5f, 1.0f);
            } else {
                player.m_5661_((Component)Components.translatable((String)"gui.numismatics.vendor.full").m_130940_(ChatFormatting.DARK_RED), true);
                this.f_58857_.m_5594_(null, this.m_58899_(), AllSoundEvents.DENY.getMainEvent(), SoundSource.BLOCKS, 0.5f, 1.0f);
            }
            return;
        }
        if (this.isCreativeVendor() || this.price.canPayOut()) {
            handStack.m_41774_(buying.m_41613_());
            player.m_21008_(hand, handStack);
            this.addBoughtItem(buying.m_41777_());
            if (!this.isCreativeVendor()) {
                this.price.deductFromSelf(false);
            }
            this.price.pay(player);
            this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11686_, SoundSource.BLOCKS, 0.5f, 1.0f);
            this.notifyUpdate();
            return;
        }
        if (this.getCardId() != null && (account = Numismatics.BANK.getAccount(this.getCardId())) != null && account.isAuthorized(this.owner) && account.deduct(this.price.getTotalPrice())) {
            handStack.m_41774_(buying.m_41613_());
            player.m_21008_(hand, handStack);
            this.addBoughtItem(buying.m_41777_());
            this.price.pay(player);
            this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11686_, SoundSource.BLOCKS, 0.5f, 1.0f);
            this.notifyUpdate();
            return;
        }
        String ownerName = UsernameUtils.INSTANCE.getName(this.owner, null);
        if (ownerName != null) {
            player.m_5661_((Component)Components.translatable((String)"gui.numismatics.vendor.insufficient_funds.named", (Object[])new Object[]{ownerName}).m_130940_(ChatFormatting.DARK_RED), true);
        } else {
            player.m_5661_((Component)Components.translatable((String)"gui.numismatics.vendor.insufficient_funds").m_130940_(ChatFormatting.DARK_RED), true);
        }
        this.f_58857_.m_5594_(null, this.m_58899_(), AllSoundEvents.DENY.getMainEvent(), SoundSource.BLOCKS, 0.5f, 1.0f);
    }

    private void addBoughtItem(ItemStack stack) {
        if (!this.matchesSellingItem(stack)) {
            return;
        }
        if (this.isCreativeVendor()) {
            return;
        }
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack item = (ItemStack)this.items.get(i);
            if (item.m_41619_() || this.matchesSellingItem(item)) {
                if (item.m_41613_() + stack.m_41613_() <= item.m_41741_()) {
                    this.items.set(i, (Object)this.getSellingItem().m_255036_(item.m_41613_() + stack.m_41613_()));
                    return;
                }
                int diff = item.m_41741_() - item.m_41613_();
                this.items.set(i, (Object)this.getSellingItem().m_255036_(item.m_41741_()));
                stack.m_41774_(diff);
            }
            if (stack.m_41619_()) break;
        }
        this.notifyUpdate();
    }

    @Override
    public void openTrustListMenu(ServerPlayer player) {
        TrustListMenu.openMenu(this, player, this.isCreativeVendor() ? NumismaticsBlocks.CREATIVE_VENDOR.asStack() : NumismaticsBlocks.VENDOR.asStack());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void openTrustList() {
        if (this.f_58857_ == null || !this.f_58857_.f_46443_) {
            return;
        }
        NumismaticsPackets.PACKETS.send(new OpenTrustListPacket<VendorBlockEntity>(this));
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.m_6596_();
        }
    }

    public static enum Mode {
        SELL,
        BUY;


        public static List<Component> getComponents() {
            return ImmutableList.copyOf(Arrays.stream(Mode.values()).map(Mode::getTranslationKey).map(Components::translatable).iterator());
        }

        public String getTranslationKey() {
            return "gui.numismatics.vendor.mode." + this.name().toLowerCase(Locale.ROOT);
        }

        public String getActionTranslationKey() {
            return this.getTranslationKey() + ".action";
        }

        public Mode getOpposite() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case SELL -> BUY;
                case BUY -> SELL;
            };
        }
    }
}

