/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.content.bank;

import com.simibubi.create.foundation.utility.Components;
import dev.ithundxr.createnumismatics.util.UsernameUtils;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CardItem
extends Item {
    public final DyeColor color;

    public CardItem(Item.Properties properties, DyeColor color) {
        super(properties);
        this.color = color;
    }

    public static ItemStack clear(ItemStack itemStack) {
        if (!itemStack.m_41782_()) {
            return itemStack;
        }
        CompoundTag tag = itemStack.m_41783_();
        tag.m_128473_("AccountID");
        itemStack.m_41751_(tag);
        return itemStack;
    }

    public static ItemStack set(ItemStack itemStack, UUID id) {
        CompoundTag tag = itemStack.m_41784_();
        tag.m_128362_("AccountID", id);
        itemStack.m_41751_(tag);
        return itemStack;
    }

    @Nullable
    public static UUID get(ItemStack itemStack) {
        if (!CardItem.isBound(itemStack)) {
            return null;
        }
        CompoundTag tag = itemStack.m_41783_();
        return tag.m_128342_("AccountID");
    }

    public static boolean isBound(ItemStack itemStack) {
        return itemStack.m_41782_() && itemStack.m_41783_().m_128403_("AccountID");
    }

    @Nullable
    public static String getPlayerName(ItemStack itemStack) {
        if (!CardItem.isBound(itemStack)) {
            return null;
        }
        return UsernameUtils.INSTANCE.getName(CardItem.get(itemStack), null);
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag isAdvanced) {
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
        if (CardItem.isBound(stack)) {
            String name = CardItem.getPlayerName(stack);
            if (name == null) {
                tooltipComponents.add((Component)Components.translatable((String)"item.numismatics.card.tooltip.bound").m_130940_(ChatFormatting.GREEN));
            } else {
                tooltipComponents.add((Component)Components.translatable((String)"item.numismatics.card.tooltip.bound.to", (Object[])new Object[]{name}).m_130940_(ChatFormatting.GREEN));
            }
        } else {
            tooltipComponents.add((Component)Components.translatable((String)"item.numismatics.card.tooltip.blank"));
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, @NotNull InteractionHand usedHand) {
        ItemStack handStack = player.m_21120_(usedHand);
        if (level.f_46443_) {
            return InteractionResultHolder.m_19090_((Object)handStack);
        }
        if (CardItem.isBound(handStack)) {
            if (player.m_6144_()) {
                CardItem.clear(handStack);
                player.m_5661_((Component)Components.translatable((String)"item.numismatics.id_card.tooltip.cleared"), true);
                return InteractionResultHolder.m_19090_((Object)handStack);
            }
        } else {
            CardItem.set(handStack, player.m_20148_());
            level.m_5594_(null, new BlockPos(player.m_146903_(), player.m_146904_(), player.m_146907_()), SoundEvents.f_11686_, SoundSource.BLOCKS, 0.5f, 1.0f);
            player.m_5661_((Component)Components.translatable((String)"item.numismatics.id_card.tooltip.bound"), true);
            return InteractionResultHolder.m_19090_((Object)handStack);
        }
        return InteractionResultHolder.m_19098_((Object)handStack);
    }
}

