/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.content.backend.behaviours;

import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.Components;
import dev.ithundxr.createnumismatics.Numismatics;
import dev.ithundxr.createnumismatics.content.backend.BankAccount;
import dev.ithundxr.createnumismatics.content.backend.Coin;
import dev.ithundxr.createnumismatics.content.bank.CardItem;
import dev.ithundxr.createnumismatics.content.coins.CoinItem;
import dev.ithundxr.createnumismatics.registry.NumismaticsTags;
import dev.ithundxr.createnumismatics.util.ItemUtil;
import dev.ithundxr.createnumismatics.util.TextUtils;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class SliderStylePriceBehaviour
extends BlockEntityBehaviour {
    public static final BehaviourType<SliderStylePriceBehaviour> TYPE = new BehaviourType("slider-style price");
    protected final EnumMap<Coin, Integer> prices = new EnumMap(Coin.class);
    protected final BiConsumer<Coin, Integer> addCoin;
    protected final Function<Coin, Integer> getCount;
    private int totalPrice = 0;

    public SliderStylePriceBehaviour(SmartBlockEntity be, BiConsumer<Coin, Integer> addCoin, Function<Coin, Integer> getCount) {
        super(be);
        this.addCoin = addCoin;
        this.getCount = getCount;
    }

    public BehaviourType<?> getType() {
        return TYPE;
    }

    private void calculateTotalPrice() {
        this.totalPrice = 0;
        for (Map.Entry<Coin, Integer> entry : this.prices.entrySet()) {
            this.totalPrice += entry.getKey().toSpurs(entry.getValue());
        }
    }

    public int getTotalPrice() {
        return this.totalPrice;
    }

    public int getPrice(Coin coin) {
        return this.prices.getOrDefault((Object)coin, 0);
    }

    public void setPrice(Coin coin, int price) {
        this.prices.put(coin, price);
        this.calculateTotalPrice();
    }

    public void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        CompoundTag priceTag = new CompoundTag();
        for (Coin coin : Coin.values()) {
            priceTag.m_128405_(coin.getName(), this.getPrice(coin));
        }
        tag.m_128365_("Prices", (Tag)priceTag);
    }

    public void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.prices.clear();
        if (tag.m_128425_("Prices", 10)) {
            CompoundTag priceTag = tag.m_128469_("Prices");
            for (Coin coin : Coin.values()) {
                int count;
                if (!priceTag.m_128425_(coin.getName(), 3) || (count = priceTag.m_128451_(coin.getName())) <= 0) continue;
                this.setPrice(coin, count);
            }
        }
        this.calculateTotalPrice();
    }

    public boolean deduct(@NotNull Player player, @NotNull InteractionHand hand, boolean addToSource) {
        int totalPrice = this.getTotalPrice();
        ItemStack handStack = player.m_21120_(hand);
        if (NumismaticsTags.AllItemTags.CARDS.matches(handStack)) {
            UUID id;
            BankAccount account;
            if (CardItem.isBound(handStack) && (account = Numismatics.BANK.getAccount(id = CardItem.get(handStack))) != null && account.isAuthorized(player) && account.deduct(totalPrice)) {
                if (addToSource) {
                    for (Map.Entry<Coin, Integer> entry : this.prices.entrySet()) {
                        this.addCoin.accept(entry.getKey(), entry.getValue());
                    }
                }
                return true;
            }
        } else if (CoinItem.extract(player, hand, this.prices, false)) {
            if (addToSource) {
                for (Map.Entry<Coin, Integer> entry : this.prices.entrySet()) {
                    this.addCoin.accept(entry.getKey(), entry.getValue());
                }
            }
            return true;
        }
        return false;
    }

    public boolean canPayOut() {
        return this.deductFromSelf(true);
    }

    public boolean deductFromSelf(boolean simulate) {
        if (!simulate && !this.canPayOut()) {
            return false;
        }
        for (Map.Entry<Coin, Integer> entry : this.prices.entrySet()) {
            Coin coin = entry.getKey();
            int price = entry.getValue();
            int count = this.getCount.apply(coin);
            if (count < price) {
                return false;
            }
            if (simulate) continue;
            this.addCoin.accept(coin, -price);
        }
        return true;
    }

    public void pay(Player player) {
        for (Map.Entry<Coin, Integer> entry : this.prices.entrySet()) {
            int count;
            Coin coin = entry.getKey();
            for (int toPay = entry.getValue().intValue(); toPay > 0; toPay -= count) {
                count = Math.min(toPay, 64);
                ItemStack stack = coin.asStack(count);
                ItemUtil.givePlayerItem(player, stack);
            }
        }
    }

    public List<MutableComponent> getCondensedPriceBreakdown() {
        ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
        int[] columnWidths = new int[]{0, 0, 0};
        int columnIdx = 0;
        for (int i = 0; i < Coin.values().length; ++i) {
            Coin coin = Coin.values()[i];
            int count = this.prices.getOrDefault((Object)coin, 0);
            if (count <= 0) continue;
            columnWidths[columnIdx] = Math.max(columnWidths[columnIdx], String.valueOf(count).length());
            columnIdx = (columnIdx + 1) % 3;
        }
        MutableComponent current = null;
        int countOnCurrent = 0;
        for (int i = 0; i < Coin.values().length; ++i) {
            Coin coin = Coin.values()[i];
            int count = this.prices.getOrDefault((Object)coin, 0);
            if (count <= 0) continue;
            if (current == null) {
                current = Components.empty();
            }
            if (countOnCurrent++ >= 3) {
                components.add(current);
                current = Components.empty();
                countOnCurrent = 1;
            }
            if (countOnCurrent > 1) {
                current.m_130946_("  |  ");
            }
            current.m_130946_(TextUtils.leftPad(String.valueOf(count), '\uf017', columnWidths[countOnCurrent - 1]) + " " + coin.fontChar);
        }
        if (current != null) {
            components.add(current);
        }
        return components;
    }

    public List<MutableComponent> getExtendedPriceBreakdown() {
        ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
        for (int i = Coin.values().length - 1; i >= 0; --i) {
            Coin coin = Coin.values()[i];
            int count = this.prices.getOrDefault((Object)coin, 0);
            if (count <= 0) continue;
            components.add(Components.literal((String)(count + " ")).m_7220_((Component)Components.translatable((String)coin.getTranslationKey())).m_130946_(" " + coin.fontChar));
        }
        return components;
    }
}

