/*
 * Decompiled with CFR 0.152.
 */
package dev.tr3ymix.cfm_circuit_breaker.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.client.DeferredElectricRenderer;
import com.mrcrayfish.furniture.refurbished.client.ExtraModels;
import com.mrcrayfish.furniture.refurbished.client.LinkHandler;
import com.mrcrayfish.furniture.refurbished.electricity.Connection;
import com.mrcrayfish.furniture.refurbished.electricity.IElectricityNode;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class CircuitBreakerBlockEntityRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    private static final Set<Connection> DRAWN_CONNECTIONS = new HashSet<Connection>();
    private static final int DEFAULT_COLOR = -16777056;
    private static final int POWERED_COLOR = -16711936;
    private static final int CROSSING_ZONE_COLOR = -3983818;

    public CircuitBreakerBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void m_6922_(@NotNull T node, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int light, int overlay) {
        CircuitBreakerBlockEntityRenderer.drawNodeAndConnection((IElectricityNode)node);
    }

    public static void drawNodeAndConnection(IElectricityNode node) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null && LinkHandler.isHoldingWrench()) {
            DeferredElectricRenderer renderer = DeferredElectricRenderer.get();
            LinkHandler handler = LinkHandler.get();
            boolean isLookingAt = handler.isTargetNode(node);
            if (isLookingAt && !handler.isLinking() && !node.isNodeConnectionLimitReached() || handler.isLinkingNode(node) || handler.canLinkToNode(node.getNodeLevel(), node) && handler.isTargetNode(node)) {
                AABB box = node.getNodeInteractBox();
                int color = handler.getLinkColour(node.getNodeLevel());
                renderer.deferDraw((poseStack, vertexConsumer) -> {
                    poseStack.m_85836_();
                    BlockPos pos = node.getNodePosition();
                    poseStack.m_252880_((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_());
                    Matrix4f matrix = poseStack.m_85850_().m_252922_();
                    renderer.drawInvertedColouredBox(matrix, vertexConsumer, box.m_82400_(0.03125), color, 0.7f);
                    poseStack.m_85849_();
                });
            }
            for (Connection connection : node.getNodeConnections()) {
                if (DRAWN_CONNECTIONS.contains(connection)) continue;
                DRAWN_CONNECTIONS.add(connection);
                renderer.deferDraw((pose, consumer) -> {
                    pose.m_85836_();
                    BlockPos pos = node.getNodePosition();
                    pose.m_252880_((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_());
                    pose.m_85837_(0.5, 0.5, 0.5);
                    Vec3 delta = Vec3.m_82528_((Vec3i)connection.getPosB().m_121996_((Vec3i)connection.getPosA()));
                    double yaw = Math.atan2(-delta.f_82481_, delta.f_82479_) + Math.PI;
                    double pitch = Math.atan2(delta.m_165924_(), delta.f_82480_) + 1.5707963705062866;
                    boolean selected = !handler.isLinking() && connection.equals((Object)handler.getTargetConnection());
                    int color = CircuitBreakerBlockEntityRenderer.getConnectionColour(connection, node.getNodeLevel());
                    float offset = (float)(Math.sin((double)Util.m_137550_() / 500.0) + 1.0) / 2.0f * 0.2f;
                    AABB box = new AABB(0.0, -0.03125, -0.03125, delta.m_82553_(), 0.03125, 0.03125);
                    pose.m_252781_(Axis.f_252436_.m_252961_((float)yaw));
                    pose.m_252781_(Axis.f_252403_.m_252961_((float)pitch));
                    Matrix4f matrix = pose.m_85850_().m_252922_();
                    renderer.drawColouredBox(matrix, consumer, box, color, 0.7f + offset);
                    renderer.drawColouredBox(matrix, consumer, box.m_82400_(0.03125), color, 0.5f + offset);
                    if (selected) {
                        renderer.drawColouredBox(matrix, consumer, box.m_82400_(0.03125), -1, 0.8f);
                    }
                    pose.m_85849_();
                });
            }
            renderer.deferDraw((pose, consumer) -> {
                pose.m_85836_();
                BlockPos pos = node.getNodePosition();
                pose.m_252880_((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_());
                Matrix4f matrix = pose.m_85850_().m_252922_();
                renderer.drawTexturedBox(matrix, consumer, node.getNodeInteractBox(), 0.0f, 0.0f, 0.25f, 0.25f);
                pose.m_85849_();
            });
        }
    }

    private static int getConnectionColour(Connection connection, Level level) {
        if (connection.isCrossingPowerableZone(level)) {
            return -3983818;
        }
        return connection.isPowered(level) ? -16711936 : -16777056;
    }

    private static BakedModel getNodeModel(IElectricityNode node) {
        if (node.isNodeConnectionLimitReached()) {
            return ExtraModels.ELECTRIC_NODE_ERROR.getModel();
        }
        LinkHandler handler = LinkHandler.get();
        if (handler.isLinking() && !handler.isLinkingNode(node)) {
            return handler.canLinkToNode(node.getNodeLevel(), node) ? ExtraModels.ELECTRIC_NODE_SUCCESS.getModel() : ExtraModels.ELECTRIC_NODE_ERROR.getModel();
        }
        return node.isNodePowered() ? ExtraModels.ELECTRIC_NODE_NEUTRAL.getModel() : ExtraModels.ELECTRIC_NODE_POWER.getModel();
    }

    public boolean m_5932_(@NotNull T node) {
        return true;
    }

    public int m_142163_() {
        return (Integer)Config.CLIENT.electricityViewDistance.get();
    }

    @NotNull
    public AABB getRenderBoundingBox(@NotNull T node) {
        return new AABB(((IElectricityNode)node).getNodePosition()).m_82400_((double)((Integer)Config.CLIENT.electricityViewDistance.get()).intValue());
    }

    public static void clearDrawn() {
        DRAWN_CONNECTIONS.clear();
    }

    public static Set<Connection> getDrawnConnections() {
        return DRAWN_CONNECTIONS;
    }
}

