/*
 * Decompiled with CFR 0.152.
 */
package com.vice.balancedflight.mixins;

import com.vice.balancedflight.BalancedFlight;
import com.vice.balancedflight.foundation.config.BalancedFlightConfig;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class BalancedFlightMixinPlugin
implements IMixinConfigPlugin {
    private static final String MIXIN_PACKAGE_ROOT = "com.vice.balancedflight.mixins.";

    public void onLoad(String mixinPackage) {
        BalancedFlightConfig.init();
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        String mixin;
        if (!mixinClassName.startsWith(MIXIN_PACKAGE_ROOT)) {
            BalancedFlight.LOGGER.error("Expected mixin '{}' to start with package root '{}', treating as foreign and disabling!", (Object)mixinClassName, (Object)MIXIN_PACKAGE_ROOT);
            return false;
        }
        if (!BalancedFlightConfig.ConfigSpec.isLoaded()) {
            BalancedFlight.LOGGER.error("Trying to use mixin plugin without config loaded");
        }
        if ((mixin = mixinClassName.substring(MIXIN_PACKAGE_ROOT.length())).equals("ElytraMixin") || mixin.equals("ElytraServerMixin") || mixin.equals("ElytraUpdateMixin")) {
            return (Boolean)BalancedFlightConfig.ElytraAnchor.get() != false || (Boolean)BalancedFlightConfig.ElytraAscended.get() != false;
        }
        if (mixin.equals("ElytraRocketShiftKeyMixin")) {
            return (Boolean)BalancedFlightConfig.infiniteRockets.get();
        }
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

