/*
 * Decompiled with CFR 0.152.
 */
package com.vice.balancedflight.foundation.render;

import com.jozufozu.flywheel.backend.Backend;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.cache.texture.AnimatableTexture;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.util.RenderUtils;

public class GeckoCreateRenderer<T extends KineticBlockEntity>
extends KineticBlockEntityRenderer
implements GeoRenderer<T> {
    public static Vector3f XN = new Vector3f(-1.0f, 0.0f, 0.0f);
    public static Vector3f XP = new Vector3f(1.0f, 0.0f, 0.0f);
    public static Vector3f YN = new Vector3f(0.0f, -1.0f, 0.0f);
    public static Vector3f YP = new Vector3f(0.0f, 1.0f, 0.0f);
    public static Vector3f ZN = new Vector3f(0.0f, 0.0f, -1.0f);
    public static Vector3f ZP = new Vector3f(0.0f, 0.0f, 1.0f);
    public static Vector3f ZERO = new Vector3f(0.0f, 0.0f, 0.0f);
    private final BlockEntityRenderer<T> customRenderer;
    private final GeoModel<T> modelProvider;
    protected T animatable;
    protected Matrix4f blockRenderTranslations = new Matrix4f();
    protected Matrix4f modelRenderTranslations = new Matrix4f();

    public GeckoCreateRenderer(BlockEntityRendererProvider.Context context, GeoModel<T> modelProvider, BlockEntityRenderer<T> customRenderer) {
        super(context);
        this.modelProvider = modelProvider;
        this.customRenderer = customRenderer;
    }

    public void defaultRender(PoseStack poseStack, T animatable, MultiBufferSource bufferSource, @Nullable RenderType renderType, @Nullable VertexConsumer buffer, float yaw, float partialTick, int packedLight) {
        this.animatable = animatable;
        super.defaultRender(poseStack, animatable, bufferSource, renderType, buffer, yaw, partialTick, packedLight);
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 0.01f, 0.0f);
        poseStack.m_85837_(0.5, 0.0, 0.5);
        this.customRenderer.m_6922_(animatable, partialTick, poseStack, bufferSource, packedLight, this.getPackedOverlay((GeoAnimatable)animatable, 0.0f));
        poseStack.m_85849_();
    }

    protected void renderSafe(BlockEntity blockEntity, float v, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int i1) {
        this.renderSafe((KineticBlockEntity)blockEntity, v, poseStack, multiBufferSource, i, i1);
    }

    protected void renderSafe(KineticBlockEntity te, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        this.renderGecko(te, partialTicks, ms, buffer, light);
        if (Backend.canUseInstancing((Level)te.m_58904_())) {
            return;
        }
        this.renderCreate(te, te.m_58899_(), te.m_58900_(), partialTicks, ms, buffer, light, overlay);
    }

    public void renderCreate(@Nullable KineticBlockEntity te, @Nullable BlockPos pos, BlockState blockState, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
    }

    public void renderGecko(T tile, float partialTicks, PoseStack stack, MultiBufferSource bufferIn, int packedLightIn) {
        this.defaultRender(stack, tile, bufferIn, null, null, 0.0f, partialTicks, packedLightIn);
    }

    public void actuallyRender(PoseStack poseStack, T animatable, BakedGeoModel model, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        poseStack.m_85836_();
        if (!isReRender) {
            AnimationState animationState = new AnimationState(animatable, 0.0f, 0.0f, partialTick, false);
            long instanceId = this.getInstanceId((GeoAnimatable)animatable);
            animationState.setData(DataTickets.TICK, (Object)((GeoAnimatable)animatable).getTick(animatable));
            animationState.setData(DataTickets.BLOCK_ENTITY, animatable);
            this.modelProvider.addAdditionalStateData(animatable, instanceId, (arg_0, arg_1) -> ((AnimationState)animationState).setData(arg_0, arg_1));
            poseStack.m_252880_(0.0f, 0.01f, 0.0f);
            poseStack.m_85837_(0.5, 0.0, 0.5);
            this.rotateBlock(this.getFacing(animatable), poseStack);
            this.modelProvider.handleAnimations(animatable, instanceId, animationState);
        }
        this.modelRenderTranslations = new Matrix4f((Matrix4fc)poseStack.m_85850_().m_252922_());
        super.actuallyRender(poseStack, animatable, model, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        poseStack.m_85849_();
    }

    public void renderRecursively(PoseStack poseStack, T animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (bone.isTrackingMatrices()) {
            Matrix4f poseState = new Matrix4f((Matrix4fc)poseStack.m_85850_().m_252922_());
            Matrix4f localMatrix = RenderUtils.invertAndMultiplyMatrices((Matrix4f)poseState, (Matrix4f)this.blockRenderTranslations);
            Matrix4f worldState = new Matrix4f((Matrix4fc)localMatrix);
            BlockPos pos = this.animatable.m_58899_();
            bone.setModelSpaceMatrix(RenderUtils.invertAndMultiplyMatrices((Matrix4f)poseState, (Matrix4f)this.modelRenderTranslations));
            bone.setLocalSpaceMatrix(localMatrix);
            bone.setWorldSpaceMatrix(worldState.translate((Vector3fc)new Vector3f((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_())));
        }
        super.renderRecursively(poseStack, animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }

    protected void rotateBlock(Direction facing, PoseStack stack) {
        switch (facing) {
            case SOUTH: {
                stack.m_252781_(Axis.m_253057_((Vector3f)YP).m_252977_(180.0f));
                break;
            }
            case WEST: {
                stack.m_252781_(Axis.m_253057_((Vector3f)YP).m_252977_(90.0f));
                break;
            }
            case NORTH: {
                stack.m_252781_(Axis.m_253057_((Vector3f)YP).m_252977_(0.0f));
                break;
            }
            case EAST: {
                stack.m_252781_(Axis.m_253057_((Vector3f)YP).m_252977_(270.0f));
                break;
            }
            case UP: {
                stack.m_252781_(Axis.m_253057_((Vector3f)XP).m_252977_(90.0f));
                break;
            }
            case DOWN: {
                stack.m_252781_(Axis.m_253057_((Vector3f)XN).m_252977_(90.0f));
            }
        }
    }

    private Direction getFacing(T tile) {
        BlockState blockState = tile.m_58900_();
        if (blockState.m_61138_((Property)HorizontalDirectionalBlock.f_54117_)) {
            return (Direction)blockState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        }
        if (blockState.m_61138_((Property)DirectionalBlock.f_52588_)) {
            return (Direction)blockState.m_61143_((Property)DirectionalBlock.f_52588_);
        }
        return Direction.NORTH;
    }

    public GeoModel<T> getGeoModel() {
        return this.modelProvider;
    }

    public T getAnimatable() {
        return this.animatable;
    }

    public ResourceLocation getTextureLocation(T instance) {
        return this.modelProvider.getTextureResource(instance);
    }

    public void updateAnimatedTextureFrame(T animatable) {
        AnimatableTexture.setAndUpdate((ResourceLocation)this.getTextureLocation(animatable), (int)(animatable.m_58899_().m_123341_() + animatable.m_58899_().m_123342_() + animatable.m_58899_().m_123343_() + (int)((GeoAnimatable)animatable).getTick(animatable)));
    }

    public void fireCompileRenderLayersEvent() {
    }

    public boolean firePreRenderEvent(PoseStack poseStack, BakedGeoModel model, MultiBufferSource bufferSource, float partialTick, int packedLight) {
        return true;
    }

    public void firePostRenderEvent(PoseStack poseStack, BakedGeoModel model, MultiBufferSource bufferSource, float partialTick, int packedLight) {
    }
}

