/*
 * Decompiled with CFR 0.152.
 */
package com.vice.balancedflight.foundation.network;

import com.vice.balancedflight.foundation.network.BalancedFlightNetwork;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.ServerLifecycleHooks;

public class CustomNetworkMessage {
    private final UUID player;
    private final String message;

    public CustomNetworkMessage(FriendlyByteBuf buffer) {
        this.player = buffer.m_130259_();
        this.message = buffer.m_130136_(Short.MAX_VALUE);
    }

    public CustomNetworkMessage(UUID player, String message) {
        this.player = player;
        this.message = message;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130077_(this.player);
        buf.m_130070_(this.message);
    }

    public void handler(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if ("FIRE_ROCKET".equals(this.message)) {
                CustomNetworkMessage.FireRocket(this.player);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static void Send(Level world, Player player, String message) {
        if (world.f_46443_) {
            BalancedFlightNetwork.INSTANCE.sendToServer((Object)new CustomNetworkMessage(player.m_36316_().getId(), message));
        }
        if (!world.f_46443_) {
            BalancedFlightNetwork.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new CustomNetworkMessage(player.m_36316_().getId(), "FIRE_ROCKET"));
        }
    }

    private static void FireRocket(UUID uuid) {
        ServerPlayer player = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(uuid);
        if (player == null) {
            return;
        }
        ItemStack itemstack = new ItemStack((ItemLike)Items.f_42688_, 64);
        player.m_9236_().m_7967_((Entity)new FireworkRocketEntity(player.m_9236_(), itemstack, (LivingEntity)player));
    }
}

