/*
 * Decompiled with CFR 0.152.
 */
package com.vice.balancedflight.foundation.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.vice.balancedflight.foundation.config.ConfigBuilder;
import java.nio.file.Path;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.loading.FMLPaths;

public class BalancedFlightConfig {
    public static ForgeConfigSpec ConfigSpec;
    public static ForgeConfigSpec.ConfigValue<Boolean> enableElytraFlightFromGround;
    public static ForgeConfigSpec.ConfigValue<Boolean> enableTakeOff;
    public static ForgeConfigSpec.ConfigValue<Boolean> infiniteRockets;
    public static ForgeConfigSpec.ConfigValue<Boolean> ElytraAnchor;
    public static ForgeConfigSpec.ConfigValue<Boolean> ElytraAscended;
    public static ForgeConfigSpec.ConfigValue<Boolean> disableFallDamageWhenWearingRing;
    public static ForgeConfigSpec.ConfigValue<Boolean> disableFallDamageNearAnchor;
    public static ForgeConfigSpec.ConfigValue<Boolean> disableElytraDamage;
    public static ForgeConfigSpec.ConfigValue<Boolean> CreativeAnchor;
    public static ForgeConfigSpec.ConfigValue<Boolean> CreativeAscended;
    public static ForgeConfigSpec.ConfigValue<Double> anchorDistanceMultiplier;

    public static void init() {
        if (ConfigSpec.isLoaded()) {
            return;
        }
        BalancedFlightConfig.loadConfig(FMLPaths.CONFIGDIR.get().resolve("balanced_flight.toml"));
    }

    private static void loadConfig(Path path) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        ConfigSpec.setConfig((CommentedConfig)configData);
    }

    static {
        ConfigBuilder builder = new ConfigBuilder("Balanced Flight Settings");
        builder.Block("Flight Options", b -> {
            CreativeAscended = b.define("Ascended Ring Gives Unlimited Creative Flight (will fall back to Basic tier inside range)", true);
            ElytraAscended = b.define("Ascended Ring Also Works As Elytra", true);
            CreativeAnchor = b.define("Flight Anchor Gives Creative Flight", true);
            ElytraAnchor = b.define("Flight Anchor Gives Elytra Flight", false);
        });
        builder.Block("Balancing Config", b -> {
            anchorDistanceMultiplier = b.defineInRange("Anchor Distance Multiplier (0d -> 10d, default 1d)", 1.0, 0.0, 10.0);
            disableFallDamageWhenWearingRing = b.define("Disable Fall Damage When Wearing Ascended Ring", true);
            disableFallDamageNearAnchor = b.define("Disable Fall Damage Near Flight Anchor", true);
        });
        builder.Block("Enhanced Elytra Mechanics", b -> {
            disableElytraDamage = b.define("Disable Elytra Damage", true);
            enableElytraFlightFromGround = b.define("Enable Elytra Flight From Ground", true);
            enableTakeOff = b.define("Enable Take Off Mechanic", true);
            infiniteRockets = b.define("Infinite Rockets", true);
        });
        ConfigSpec = builder.Save();
    }
}

