/*
 * Decompiled with CFR 0.152.
 */
package com.vice.balancedflight.foundation.compat;

import com.vice.balancedflight.BalancedFlight;
import com.vice.balancedflight.content.angelRing.FlightRing;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.InterModComms;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotTypeMessage;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class AscendedRingCurio
implements ICurio {
    private final FlightRing parent;

    public AscendedRingCurio(FlightRing parent) {
        this.parent = parent;
    }

    public static ICapabilityProvider initCapabilities(FlightRing stack) {
        final AscendedRingCurio curio = new AscendedRingCurio(stack);
        return new ICapabilityProvider(){
            private final LazyOptional<ICurio> curioOpt = LazyOptional.of(() -> curio);

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                return CuriosCapability.ITEM.orEmpty(cap, this.curioOpt);
            }
        };
    }

    public static void sendImc() {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder("flight_ring").build());
    }

    public static boolean HasAscendedRing(Player player) {
        return CuriosApi.getCuriosHelper().findEquippedCurio((Item)BalancedFlight.ASCENDED_FLIGHT_RING.get(), (LivingEntity)player).isPresent();
    }

    public boolean canEquip(String identifier, LivingEntity entityLivingBase) {
        return !AscendedRingCurio.HasAscendedRing((Player)entityLivingBase);
    }

    public boolean canEquipFromUse(SlotContext slotContext) {
        return true;
    }

    public ItemStack getStack() {
        return new ItemStack((ItemLike)this.parent);
    }

    public boolean showAttributesTooltip(String identifier) {
        return true;
    }

    public void playRightClickEquipSound(LivingEntity entityLivingBase) {
        entityLivingBase.m_5496_(SoundEvents.f_11674_, 1.0f, 1.0f);
    }
}

