/*
 * Decompiled with CFR 0.152.
 */
package com.vice.balancedflight.content.flightAnchor.render;

import com.jozufozu.flywheel.api.InstanceData;
import com.jozufozu.flywheel.api.Instancer;
import com.jozufozu.flywheel.api.Material;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.util.AnimationTickHolder;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityInstance;
import com.simibubi.create.content.kinetics.base.flwdata.RotatingData;
import com.simibubi.create.foundation.utility.Iterate;
import com.vice.balancedflight.content.flightAnchor.entity.FlightAnchorEntity;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Vector3f;

public class FlightAnchorKineticInstance
extends KineticBlockEntityInstance<FlightAnchorEntity>
implements DynamicInstance {
    protected final EnumMap<Direction, RotatingData> keys = new EnumMap(Direction.class);
    protected Direction sourceFacing;

    public FlightAnchorKineticInstance(MaterialManager materialManager, FlightAnchorEntity blockEntity) {
        super(materialManager, (KineticBlockEntity)blockEntity);
        Direction.Axis boxAxis = ((Direction)this.blockState.m_61143_((Property)BlockStateProperties.f_61374_)).m_122434_();
        this.updateSourceFacing();
        Material rotatingMaterial = this.getRotatingMaterial();
        for (Direction direction : Iterate.directions) {
            Direction.Axis axis = direction.m_122434_();
            if (boxAxis == axis || axis == Direction.Axis.Y) continue;
            Instancer shaft = rotatingMaterial.getModel(AllPartialModels.SHAFT_HALF, this.blockState, direction);
            RotatingData key = (RotatingData)shaft.createInstance();
            key.setRotationAxis(Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.NEGATIVE, (Direction.Axis)axis).m_253071_()).setRotationalSpeed(blockEntity.getSpeed()).setRotationOffset(this.getRotationOffset(axis)).setColor((KineticBlockEntity)blockEntity).setPosition(new Vector3f((float)this.getInstancePosition().m_123341_(), (float)this.getInstancePosition().m_123342_() - 0.5f, (float)this.getInstancePosition().m_123343_())).setBlockLight(this.world.m_45517_(LightLayer.BLOCK, this.pos)).setSkyLight(this.world.m_45517_(LightLayer.SKY, this.pos));
            this.keys.put(direction, key);
        }
    }

    public void beginFrame() {
        float placedTime;
        float time = AnimationTickHolder.getRenderTime();
        if (time - (placedTime = ((FlightAnchorEntity)this.blockEntity).placedRenderTime) > 40.0f || time - placedTime < 25.0f) {
            return;
        }
        BlockPos pos = this.getInstancePosition();
        float scale = Mth.m_144920_((float)0.01f, (float)1.0f, (float)(Mth.m_14036_((float)(time - (placedTime += 25.0f)), (float)0.0f, (float)5.0f) / 5.0f)) / 2.0f;
        Vector3f posF = new Vector3f((float)pos.m_123341_(), (float)pos.m_123342_() + scale - 0.5f, (float)pos.m_123343_());
        for (RotatingData kvp : this.keys.values()) {
            kvp.setPosition(posF);
        }
    }

    protected void updateSourceFacing() {
        if (((FlightAnchorEntity)this.blockEntity).hasSource()) {
            BlockPos source = ((FlightAnchorEntity)this.blockEntity).source.m_121996_((Vec3i)this.pos);
            this.sourceFacing = Direction.m_122372_((float)source.m_123341_(), (float)source.m_123342_(), (float)source.m_123343_());
        } else {
            this.sourceFacing = null;
        }
    }

    public void update() {
        this.updateSourceFacing();
        for (Map.Entry<Direction, RotatingData> kvp : this.keys.entrySet()) {
            this.updateRotation(kvp.getValue(), kvp.getKey().m_122434_(), ((FlightAnchorEntity)this.blockEntity).getSpeed());
        }
    }

    public void updateLight() {
        this.relight(this.pos, this.keys.values().stream());
    }

    public void remove() {
        this.keys.values().forEach(InstanceData::delete);
        this.keys.clear();
    }
}

