/*
 * Decompiled with CFR 0.152.
 */
package com.vice.balancedflight.content.flightAnchor.entity;

import com.google.common.collect.Lists;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.ponder.PonderWorld;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.vice.balancedflight.content.flightAnchor.entity.FlightAnchorEntity;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;

public class FlightAnchorBehaviour
extends BlockEntityBehaviour {
    public static final BehaviourType<FlightAnchorBehaviour> TYPE = new BehaviourType();

    public FlightAnchorBehaviour(SmartBlockEntity be) {
        super(be);
    }

    public BehaviourType<?> getType() {
        return TYPE;
    }

    public void setActive(boolean active) {
        if (this.getWorld() instanceof PonderWorld) {
            return;
        }
        if (!active) {
            FlightAnchorEntity.ActiveAnchors.remove(this.getPos());
            FlightAnchorBehaviour.playSound(this.getWorld(), this.getPos(), SoundEvents.f_11738_);
            return;
        }
        if (FlightAnchorEntity.ActiveAnchors.containsKey(this.getPos())) {
            return;
        }
        FlightAnchorEntity.ActiveAnchors.put(this.getPos(), (FlightAnchorEntity)this.blockEntity);
        FlightAnchorBehaviour.playSound(this.getWorld(), this.getPos(), SoundEvents.f_11736_);
    }

    public void initialize() {
        if (this.getWorld().f_46443_) {
            ((FlightAnchorEntity)this.blockEntity).placedRenderTime = AnimationTickHolder.getRenderTime((LevelAccessor)this.getWorld());
        }
    }

    public void unload() {
        this.setActive(false);
    }

    public void tick() {
        super.tick();
        FlightAnchorEntity flightAnchor = (FlightAnchorEntity)this.blockEntity;
        boolean wasActive = flightAnchor.isActive;
        flightAnchor.isActive = flightAnchor.isSpeedRequirementFulfilled();
        if (flightAnchor.isActive && !wasActive) {
            this.setActive(true);
        } else if (!flightAnchor.isActive && wasActive) {
            this.setActive(false);
            flightAnchor.beamSections.clear();
            flightAnchor.checkingBeamSections.clear();
        }
        if (flightAnchor.isActive) {
            FlightAnchorBehaviour.beaconTick(this.getWorld(), this.getPos(), flightAnchor);
        }
    }

    public void lazyTick() {
    }

    public static void beaconTick(Level level, BlockPos blockPos, FlightAnchorEntity entity) {
        BlockPos blockpos;
        if (level instanceof PonderWorld) {
            PonderWorld ponderWorld = (PonderWorld)level;
            if (entity.beamSections.size() > 0) {
                return;
            }
            entity.beamSections.add(new BeaconBlockEntity.BeaconBeamSection(DyeColor.WHITE.m_41068_()));
            return;
        }
        int i = blockPos.m_123341_();
        int j = blockPos.m_123342_();
        int k = blockPos.m_123343_();
        if (entity.lastCheckY < j) {
            blockpos = blockPos;
            entity.checkingBeamSections = Lists.newArrayList();
            entity.lastCheckY = blockPos.m_123342_() - 1;
        } else {
            blockpos = new BlockPos(i, entity.lastCheckY + 1, k);
        }
        BeaconBlockEntity.BeaconBeamSection beaconblockentity$beaconbeamsection = entity.checkingBeamSections.isEmpty() ? null : entity.checkingBeamSections.get(entity.checkingBeamSections.size() - 1);
        int l = level.m_6924_(Heightmap.Types.WORLD_SURFACE, i, k);
        for (int i1 = 0; i1 < 10 && blockpos.m_123342_() <= l; ++i1) {
            BlockState blockstate = level.m_8055_(blockpos);
            float[] afloat = blockstate.getBeaconColorMultiplier((LevelReader)level, blockpos, blockPos);
            if (afloat != null) {
                if (entity.checkingBeamSections.size() <= 1) {
                    beaconblockentity$beaconbeamsection = new BeaconBlockEntity.BeaconBeamSection(afloat);
                    entity.checkingBeamSections.add(beaconblockentity$beaconbeamsection);
                } else if (beaconblockentity$beaconbeamsection != null) {
                    if (Arrays.equals(afloat, beaconblockentity$beaconbeamsection.m_58722_())) {
                        beaconblockentity$beaconbeamsection.m_58719_();
                    } else {
                        beaconblockentity$beaconbeamsection = new BeaconBlockEntity.BeaconBeamSection(new float[]{(beaconblockentity$beaconbeamsection.m_58722_()[0] + afloat[0]) / 2.0f, (beaconblockentity$beaconbeamsection.m_58722_()[1] + afloat[1]) / 2.0f, (beaconblockentity$beaconbeamsection.m_58722_()[2] + afloat[2]) / 2.0f});
                        entity.checkingBeamSections.add(beaconblockentity$beaconbeamsection);
                    }
                }
            } else {
                if (beaconblockentity$beaconbeamsection == null || blockstate.m_60739_((BlockGetter)level, blockpos) >= 15 && !blockstate.m_60713_(Blocks.f_50752_)) {
                    entity.checkingBeamSections.clear();
                    entity.lastCheckY = l;
                    break;
                }
                beaconblockentity$beaconbeamsection.m_58719_();
            }
            blockpos = blockpos.m_7494_();
            ++entity.lastCheckY;
        }
        if (level.m_46467_() % 80L == 0L && !entity.beamSections.isEmpty()) {
            FlightAnchorBehaviour.playSound(level, blockPos, SoundEvents.f_11737_);
        }
        if (entity.lastCheckY >= l) {
            entity.lastCheckY = level.m_141937_() - 1;
            entity.beamSections = entity.checkingBeamSections;
        }
    }

    public static void playSound(Level p_155104_, BlockPos p_155105_, SoundEvent p_155106_) {
        p_155104_.m_5594_(null, p_155105_, p_155106_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    private static void applyEffects(Level level, BlockPos blockPos, int radius) {
        if (level.f_46443_) {
            return;
        }
        AABB aabb = new AABB(blockPos).m_82400_((double)(radius * 10 + 10)).m_82363_(0.0, (double)level.m_141928_(), 0.0);
        List list = level.m_45976_(Player.class, aabb);
        for (Player player : list) {
        }
    }
}

