/*
 * Decompiled with CFR 0.152.
 */
package com.vice.balancedflight;

import com.simibubi.create.AllCreativeModeTabs;
import com.simibubi.create.content.kinetics.BlockStressDefaults;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.KineticStats;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.item.TooltipModifier;
import com.simibubi.create.foundation.ponder.PonderLocalization;
import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.util.entry.BlockEntityEntry;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import com.vice.balancedflight.AllCreativeTabs;
import com.vice.balancedflight.AllGeckoRenderers;
import com.vice.balancedflight.AllLangMessages;
import com.vice.balancedflight.AllPonderScenes;
import com.vice.balancedflight.BalancedFlightClient;
import com.vice.balancedflight.content.angelRing.FlightRing;
import com.vice.balancedflight.content.flightAnchor.FlightAnchorBlock;
import com.vice.balancedflight.content.flightAnchor.FlightAnchorItem;
import com.vice.balancedflight.content.flightAnchor.entity.FlightAnchorEntity;
import com.vice.balancedflight.content.flightAnchor.render.FlightAnchorKineticInstance;
import com.vice.balancedflight.foundation.RegistrateExtensions;
import com.vice.balancedflight.foundation.config.BalancedFlightConfig;
import com.vice.balancedflight.foundation.data.recipe.BalancedFlightRecipeGen;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="balancedflight")
public class BalancedFlight {
    public static final String MODID = "balancedflight";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final CreateRegistrate CREATE_REGISTRATE = CreateRegistrate.create((String)"balancedflight");
    public static final BlockEntry<? extends Block> FLIGHT_ANCHOR_BLOCK = ((BlockBuilder)RegistrateExtensions.geckoItem(((BlockBuilder)((CreateRegistrate)CREATE_REGISTRATE.object("flight_anchor")).block(FlightAnchorBlock::new).transform((NonNullFunction)BlockStressDefaults.setImpact((double)256.0))).properties(properties -> BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60978_(10.0f).m_60918_(SoundType.f_56725_).m_60955_()).defaultLoot().tag(new TagKey[]{BlockTags.f_144282_}).tag(new TagKey[]{BlockTags.f_144285_}), FlightAnchorItem::new).initialProperties(() -> new Item.Properties().m_41487_(1)).build()).register();
    public static final BlockEntityEntry<FlightAnchorEntity> FLIGHT_ANCHOR_BLOCK_ENTITY = CREATE_REGISTRATE.blockEntity("flight_anchor", FlightAnchorEntity::new).instance(() -> FlightAnchorKineticInstance::new).validBlock(FLIGHT_ANCHOR_BLOCK).renderer(() -> AllGeckoRenderers.FlightAnchorGeckoRenderer.TileRenderer::apply).register();
    public static final ItemEntry<? extends Item> ASCENDED_FLIGHT_RING = CREATE_REGISTRATE.item("ascended_flight_ring", FlightRing::new).initialProperties(() -> new Item.Properties().m_41487_(1)).register();

    public BalancedFlight() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        CREATE_REGISTRATE.registerEventListeners(modEventBus);
        BalancedFlightConfig.init();
        MinecraftForge.EVENT_BUS.register((Object)this);
        AllLangMessages.init();
        AllCreativeTabs.register(modEventBus);
        modEventBus.addListener(EventPriority.LOWEST, BalancedFlight::gatherData);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> BalancedFlightClient.onCtorClient(modEventBus, forgeEventBus));
    }

    public static void gatherData(GatherDataEvent event) {
        CREATE_REGISTRATE.addDataGenerator(ProviderType.LANG, prov -> {
            prov.add((CreativeModeTab)AllCreativeTabs.CREATIVE_TAB.get(), "Create: Balanced Flight");
            prov.add("curios.identifier.flight_ring", "Flight Ring");
        });
        DataGenerator gen = event.getGenerator();
        PackOutput output = gen.getPackOutput();
        if (event.includeServer()) {
            gen.addProvider(true, (DataProvider)new BalancedFlightRecipeGen(output));
        }
        AllPonderScenes.register();
        PonderLocalization.provideRegistrateLang((AbstractRegistrate)CREATE_REGISTRATE);
    }

    static {
        CREATE_REGISTRATE.setCreativeTab(AllCreativeModeTabs.BASE_CREATIVE_TAB);
        CREATE_REGISTRATE.setTooltipModifierFactory(item -> new ItemDescription.Modifier(item, TooltipHelper.Palette.STANDARD_CREATE).andThen(TooltipModifier.mapNull((TooltipModifier)KineticStats.create((Item)item))));
    }
}

