/*
 * Decompiled with CFR 0.152.
 */
package com.yellowbrossproductions.illageandspillage.events;

import com.yellowbrossproductions.illageandspillage.Config;
import com.yellowbrossproductions.illageandspillage.entities.CameraShakeEntity;
import com.yellowbrossproductions.illageandspillage.util.EntityUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public enum ClientEventHandler {
    INSTANCE;


    @SubscribeEvent
    public void onSetupCamera(ViewportEvent.ComputeCameraAngles event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (((Boolean)Config.ClientConfig.cameraShakesAllowed.get()).booleanValue() && !Minecraft.m_91087_().m_91104_() && player != null) {
            float delta = Minecraft.m_91087_().m_91296_();
            float ticksExistedDelta = (float)player.f_19797_ + delta;
            float shakeAmplitude = 0.0f;
            for (CameraShakeEntity cameraShake : player.m_9236_().m_45976_(CameraShakeEntity.class, player.m_20191_().m_82400_(100.0))) {
                if (!(cameraShake.m_20270_((Entity)player) < cameraShake.getRadius())) continue;
                shakeAmplitude += cameraShake.getShakeAmount((Player)player, delta);
            }
            if (shakeAmplitude > 1.0f) {
                shakeAmplitude = 1.0f;
            }
            event.setPitch((float)((double)event.getPitch() + (double)shakeAmplitude * Math.cos(ticksExistedDelta * 3.0f + 2.0f) * 25.0));
            event.setYaw((float)((double)event.getYaw() + (double)shakeAmplitude * Math.cos(ticksExistedDelta * 5.0f + 1.0f) * 25.0));
            event.setRoll((float)((double)event.getRoll() + (double)shakeAmplitude * Math.cos(ticksExistedDelta * 4.0f) * 25.0));
        }
    }

    @SubscribeEvent
    public void onPreRenderHUD(RenderGuiOverlayEvent.Pre event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && player.m_20159_() && EntityUtil.isEntityCrazyRagno(player.m_20202_()) && event.getOverlay().id().equals((Object)VanillaGuiOverlay.HELMET.id())) {
            Minecraft.m_91087_().f_91065_.m_93063_((Component)Component.m_237115_((String)"entity.illageandspillage.no_escape"), false);
        }
    }
}

