/*
 * Decompiled with CFR 0.152.
 */
package com.yellowbrossproductions.illageandspillage.entities.projectile;

import com.yellowbrossproductions.illageandspillage.init.ModEntityTypes;
import com.yellowbrossproductions.illageandspillage.packet.PacketHandler;
import com.yellowbrossproductions.illageandspillage.packet.ParticlePacket;
import com.yellowbrossproductions.illageandspillage.util.EntityUtil;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;

public class AxeEntity
extends AbstractHurtingProjectile {
    public Mob shooter = null;
    private boolean canExplode = false;

    public AxeEntity(EntityType<? extends AbstractHurtingProjectile> p_36833_, Level p_36834_) {
        super(p_36833_, p_36834_);
    }

    public AxeEntity(Level p_181151_, LivingEntity p_181152_, double p_181153_, double p_181154_, double p_181155_) {
        super((EntityType)ModEntityTypes.Axe.get(), p_181152_, p_181153_, p_181154_, p_181155_, p_181151_);
        this.m_5602_((Entity)p_181152_);
    }

    public void m_8119_() {
        this.m_20331_(true);
        if (this.canExplode) {
            this.explode(1.0);
            if (!this.m_9236_().f_46443_) {
                this.m_146870_();
            }
        }
        this.makeParticles();
        if (this.f_19797_ >= 100 && !this.m_9236_().f_46443_) {
            this.m_146870_();
        }
        super.m_8119_();
        this.m_146922_(this.m_6080_());
        this.m_5616_(this.m_146908_());
    }

    protected boolean m_5931_() {
        return false;
    }

    protected void m_5790_(EntityHitResult p_37259_) {
        boolean canHurt;
        super.m_5790_(p_37259_);
        AxeEntity attacker = this.shooter != null ? this.shooter : this;
        boolean bl = canHurt = attacker == this || EntityUtil.canHurtThisMob(p_37259_.m_82443_(), this.shooter);
        if (canHurt) {
            this.canExplode = true;
        }
    }

    protected void m_6532_(HitResult p_37406_) {
        super.m_6532_(p_37406_);
        if (!(p_37406_ instanceof EntityHitResult)) {
            this.canExplode = true;
        }
    }

    public void makeParticles() {
        if (!this.m_9236_().f_46443_) {
            for (ServerPlayer serverPlayer : ((ServerLevel)this.m_9236_()).m_6907_()) {
                if (!(serverPlayer.m_20280_((Entity)this) < 4096.0)) continue;
                ParticlePacket packet = new ParticlePacket();
                for (int i = 0; i < 1; ++i) {
                    double d0 = -0.5 + this.f_19796_.m_188583_();
                    double d1 = -0.5 + this.f_19796_.m_188583_();
                    double d2 = -0.5 + this.f_19796_.m_188583_();
                    packet.queueParticle((ParticleOptions)ParticleTypes.f_123797_, false, new Vec3(this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0)), new Vec3(d0, d1, d2));
                }
                PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)packet);
            }
        }
    }

    public void makeExplodeParticles() {
        if (!this.m_9236_().f_46443_) {
            for (ServerPlayer serverPlayer : ((ServerLevel)this.m_9236_()).m_6907_()) {
                double d2;
                double d1;
                double d0;
                int i;
                if (!(serverPlayer.m_20280_((Entity)this) < 4096.0)) continue;
                ParticlePacket packet = new ParticlePacket();
                for (i = 0; i < 10; ++i) {
                    d0 = -0.5 + this.f_19796_.m_188583_();
                    d1 = -0.5 + this.f_19796_.m_188583_();
                    d2 = -0.5 + this.f_19796_.m_188583_();
                    packet.queueParticle((ParticleOptions)ParticleTypes.f_123759_, false, new Vec3(this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0)), new Vec3(d0, d1, d2));
                }
                for (i = 0; i < 20; ++i) {
                    d0 = -0.5 + this.f_19796_.m_188583_();
                    d1 = -0.5 + this.f_19796_.m_188583_();
                    d2 = -0.5 + this.f_19796_.m_188583_();
                    packet.queueParticle((ParticleOptions)ParticleTypes.f_123797_, false, new Vec3(this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0)), new Vec3(d0, d1, d2));
                }
                for (i = 0; i < 6; ++i) {
                    d0 = -0.5 + this.f_19796_.m_188583_();
                    d1 = -0.5 + this.f_19796_.m_188583_();
                    d2 = -0.5 + this.f_19796_.m_188583_();
                    packet.queueParticle((ParticleOptions)ParticleTypes.f_123813_, false, new Vec3(this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0)), new Vec3(d0, d1, d2));
                }
                PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)packet);
            }
        }
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean m_6097_() {
        return false;
    }

    public void setShooter(Mob shooter) {
        this.shooter = shooter;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return source.m_276093_(DamageTypes.f_286979_) && super.m_6469_(source, amount);
    }

    private void explode(double size) {
        List list = this.m_9236_().m_6249_((Entity)this, new AABB(this.m_20185_() - size, this.m_20186_() - size, this.m_20189_() - size, this.m_20185_() + size, this.m_20186_() + size, this.m_20189_() + size), Entity::m_6084_);
        AxeEntity attacker = this.shooter != null ? this.shooter : this;
        this.makeExplodeParticles();
        this.m_5496_(SoundEvents.f_12313_, 2.0f, 1.0f);
        for (Entity entity : list) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity;
            if (entity == attacker || !entity.m_6084_() || entity.m_20147_() || entity.m_5833_()) continue;
            living.m_6469_(this.m_269291_().m_269390_((Entity)living, (Entity)attacker), 8.0f);
            living.f_19802_ = 0;
            EntityUtil.disableShield(living, 200);
        }
    }
}

