/*
 * Decompiled with CFR 0.152.
 */
package com.yellowbrossproductions.illageandspillage.entities;

import com.yellowbrossproductions.illageandspillage.Config;
import com.yellowbrossproductions.illageandspillage.client.sound.BossMusicPlayer;
import com.yellowbrossproductions.illageandspillage.entities.CameraShakeEntity;
import com.yellowbrossproductions.illageandspillage.entities.CrocofangEntity;
import com.yellowbrossproductions.illageandspillage.entities.IllagerSoulEntity;
import com.yellowbrossproductions.illageandspillage.entities.ImpEntity;
import com.yellowbrossproductions.illageandspillage.entities.MobSpiritEntity;
import com.yellowbrossproductions.illageandspillage.entities.SpiritHandEntity;
import com.yellowbrossproductions.illageandspillage.entities.goal.WatchBossIntroGoal;
import com.yellowbrossproductions.illageandspillage.entities.projectile.SoulBeamEntity;
import com.yellowbrossproductions.illageandspillage.init.ModEntityTypes;
import com.yellowbrossproductions.illageandspillage.packet.PacketHandler;
import com.yellowbrossproductions.illageandspillage.packet.ParticlePacket;
import com.yellowbrossproductions.illageandspillage.util.EffectRegisterer;
import com.yellowbrossproductions.illageandspillage.util.EntityUtil;
import com.yellowbrossproductions.illageandspillage.util.IllageAndSpillageSoundEvents;
import com.yellowbrossproductions.illageandspillage.util.ItemRegisterer;
import com.yellowbrossproductions.illageandspillage.util.ModTags;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.PacketDistributor;

public class SpiritcallerEntity
extends AbstractIllager {
    public ServerBossEvent bossEvent;
    private static final EntityDataAccessor<Boolean> SHOULD_DELETE_ITSELF = SynchedEntityData.m_135353_(SpiritcallerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> NEARBY_ILLAGERS = SynchedEntityData.m_135353_(SpiritcallerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> ACTIVE = SynchedEntityData.m_135353_(SpiritcallerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> WINGS_FRAME = SynchedEntityData.m_135353_(SpiritcallerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> RITUAL = SynchedEntityData.m_135353_(SpiritcallerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> ARMS_UPWARD = SynchedEntityData.m_135353_(SpiritcallerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SPINNING = SynchedEntityData.m_135353_(SpiritcallerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> PHASED_OUT = SynchedEntityData.m_135353_(SpiritcallerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> SOUL_POWER = SynchedEntityData.m_135353_(SpiritcallerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> FAKING = SynchedEntityData.m_135353_(SpiritcallerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> CHARGING = SynchedEntityData.m_135353_(SpiritcallerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> FORCEFIELD = SynchedEntityData.m_135353_(SpiritcallerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> CLAP = SynchedEntityData.m_135353_(SpiritcallerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SHOW_SPIRIT_HANDS = SynchedEntityData.m_135353_(SpiritcallerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> CHARGING_LASER = SynchedEntityData.m_135353_(SpiritcallerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SHOOTING_LASER = SynchedEntityData.m_135353_(SpiritcallerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private float clientSideWingsAnimationO;
    private float clientSideWingsAnimation;
    private int ritualTicks;
    private int attackTicks;
    private int attackType;
    private int stealSoulsCooldown;
    private int spinDirection;
    private final List<LivingEntity> stolen_mobs = new ArrayList<LivingEntity>();
    private final List<MobSpiritEntity> spirits = new ArrayList<MobSpiritEntity>();
    int SPIRIT_STEAL = 1;
    int SOUL_SWARM = 2;
    int IMP_RISE = 3;
    int SPIRIT_HANDS = 4;
    int SOUL_LASER = 5;
    int ANTICHEESE = 6;
    double chargeX;
    double chargeY;
    double chargeZ;
    double targetX;
    double targetY;
    double targetZ;
    private int chargeTime;
    private int attackCooldown;
    private int spiritSwarmCooldown;
    private int impRiseCooldown;
    private int spiritHandsCooldown;
    private int soulLaserCooldown;
    private int antiCheeseCooldown;
    private int dodgeCooldown;
    private int impAttacks;
    double laserX;
    double laserY;
    double laserZ;
    int stuckTime;
    private DamageSource lastDamageSource;

    public SpiritcallerEntity(EntityType<? extends AbstractIllager> p_i48556_1_, Level p_i48556_2_) {
        super(p_i48556_1_, p_i48556_2_);
        this.f_21364_ = 50;
        this.bossEvent = (ServerBossEvent)new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.PROGRESS).m_7003_(true);
        this.bossEvent.m_8321_(false);
        this.m_21051_(Attributes.f_22276_).m_22100_(((Double)Config.CommonConfig.spiritcaller_health.get()).doubleValue());
        this.m_5634_(Float.MAX_VALUE);
    }

    public void m_6457_(ServerPlayer p_20119_) {
        super.m_6457_(p_20119_);
        this.bossEvent.m_6543_(p_20119_);
    }

    public void m_6452_(ServerPlayer p_20119_) {
        super.m_6452_(p_20119_);
        this.bossEvent.m_6539_(p_20119_);
    }

    protected void m_8024_() {
        super.m_8024_();
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new AntiCheeseGoal());
        this.f_21345_.m_25352_(0, (Goal)new StealSoulsGoal());
        this.f_21345_.m_25352_(0, (Goal)new SoulSwarmGoal());
        this.f_21345_.m_25352_(0, (Goal)new ImpRiseGoal());
        this.f_21345_.m_25352_(0, (Goal)new SpiritHandsGoal());
        this.f_21345_.m_25352_(0, (Goal)new SoulLaserGoal());
        this.f_21345_.m_25352_(1, (Goal)new AlwaysWatchTargetGoal());
        this.f_21345_.m_25352_(2, (Goal)new Raider.HoldGroundAttackGoal((Raider)this, (AbstractIllager)this, 10.0f));
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 15.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true).m_26146_(300));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, (double)0.35f).m_22268_(Attributes.f_22276_, 1.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22277_, 96.0);
    }

    public boolean m_142535_(float p_147187_, float p_147188_, DamageSource p_147189_) {
        return false;
    }

    public boolean m_6779_(LivingEntity p_213336_1_) {
        return !this.areIllagersNearby() && super.m_6779_(p_213336_1_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHOULD_DELETE_ITSELF, (Object)false);
        this.f_19804_.m_135372_(NEARBY_ILLAGERS, (Object)false);
        this.f_19804_.m_135372_(ACTIVE, (Object)false);
        this.f_19804_.m_135372_(WINGS_FRAME, (Object)0);
        this.f_19804_.m_135372_(RITUAL, (Object)false);
        this.f_19804_.m_135372_(ARMS_UPWARD, (Object)false);
        this.f_19804_.m_135372_(SPINNING, (Object)false);
        this.f_19804_.m_135372_(PHASED_OUT, (Object)false);
        this.f_19804_.m_135372_(SOUL_POWER, (Object)0);
        this.f_19804_.m_135372_(FAKING, (Object)false);
        this.f_19804_.m_135372_(CHARGING, (Object)false);
        this.f_19804_.m_135372_(FORCEFIELD, (Object)false);
        this.f_19804_.m_135372_(CLAP, (Object)false);
        this.f_19804_.m_135372_(SHOW_SPIRIT_HANDS, (Object)false);
        this.f_19804_.m_135372_(CHARGING_LASER, (Object)false);
        this.f_19804_.m_135372_(SHOOTING_LASER, (Object)false);
    }

    public void m_7380_(CompoundTag p_37870_) {
        super.m_7380_(p_37870_);
        if (this.isActive()) {
            p_37870_.m_128379_("active", true);
        }
        p_37870_.m_128405_("SoulPower", this.getSoulPower());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.bossEvent.m_6456_(this.m_5446_());
        this.setActive(tag.m_128471_("active"));
        this.setSoulPower(tag.m_128451_("SoulPower"));
        if (tag.m_128425_("Health", 99)) {
            this.f_19804_.m_135381_(f_20961_, (Object)Float.valueOf(Mth.m_14036_((float)tag.m_128457_("Health"), (float)0.0f, (float)this.m_21233_())));
        }
    }

    public void m_21153_(float p_21154_) {
        float healthValue = p_21154_ - this.m_21223_();
        if (healthValue > 0.0f || !this.areIllagersNearby() && this.isActive() || healthValue <= -1.0E12f) {
            super.m_21153_(p_21154_);
        }
    }

    public void m_7895_(int p_213660_1_, boolean p_213660_2_) {
    }

    public SoundEvent getBossMusic() {
        LocalDate localdate = LocalDate.now();
        int i = localdate.get(ChronoField.DAY_OF_MONTH);
        int j = localdate.get(ChronoField.MONTH_OF_YEAR);
        return j == 4 && i == 1 ? (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_SPIRITCALLER_MUSIC_APRIL.get() : (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_SPIRITCALLER_MUSIC.get();
    }

    protected boolean canPlayMusic() {
        return !this.m_20067_() && this.m_5448_() instanceof Player && this.m_5448_() != null;
    }

    public boolean canPlayerHearMusic(Player player) {
        return player != null && this.m_6779_((LivingEntity)player) && this.m_20270_((Entity)player) < 2500.0f;
    }

    public void m_7822_(byte id) {
        if (id == 67) {
            BossMusicPlayer.playBossMusic((Raider)this);
        } else if (id == 68) {
            BossMusicPlayer.stopBossMusic((Raider)this);
        } else {
            super.m_7822_(id);
        }
    }

    public void makeExplodeParticles() {
        if (!this.m_9236_().f_46443_) {
            Iterator var1 = ((ServerLevel)this.m_9236_()).m_6907_().iterator();
            while (true) {
                double d2;
                double d1;
                double d0;
                int i;
                if (!var1.hasNext()) {
                    return;
                }
                ServerPlayer serverPlayer = (ServerPlayer)var1.next();
                if (!(serverPlayer.m_20280_((Entity)this) < 4096.0)) continue;
                ParticlePacket packet = new ParticlePacket();
                for (i = 0; i < 250; ++i) {
                    d0 = (-0.5 + this.f_19796_.m_188583_()) / 2.0;
                    d1 = (-0.5 + this.f_19796_.m_188583_()) / 2.0;
                    d2 = (-0.5 + this.f_19796_.m_188583_()) / 2.0;
                    packet.queueParticle((ParticleOptions)ParticleTypes.f_123799_, false, new Vec3(this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0)), new Vec3(d0, d1, d2));
                }
                for (i = 0; i < 200; ++i) {
                    d0 = (-0.5 + this.f_19796_.m_188583_()) / 2.0;
                    d1 = (-0.5 + this.f_19796_.m_188583_()) / 2.0;
                    d2 = (-0.5 + this.f_19796_.m_188583_()) / 2.0;
                    packet.queueParticle((ParticleOptions)ParticleTypes.f_123759_, false, new Vec3(this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0)), new Vec3(d0, d1, d2));
                }
                for (i = 0; i < 150; ++i) {
                    d0 = (-0.5 + this.f_19796_.m_188583_()) / 2.0;
                    d1 = (-0.5 + this.f_19796_.m_188583_()) / 2.0;
                    d2 = (-0.5 + this.f_19796_.m_188583_()) / 2.0;
                    packet.queueParticle((ParticleOptions)ParticleTypes.f_123755_, false, new Vec3(this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0)), new Vec3(d0, d1, d2));
                }
                ServerPlayer finalServerPlayer = serverPlayer;
                PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> finalServerPlayer), (Object)packet);
            }
        }
    }

    public void makeCheeseParticles() {
        if (!this.m_9236_().f_46443_) {
            Iterator var1 = ((ServerLevel)this.m_9236_()).m_6907_().iterator();
            while (true) {
                double d2;
                double d1;
                double d0;
                int i;
                if (!var1.hasNext()) {
                    return;
                }
                ServerPlayer serverPlayer = (ServerPlayer)var1.next();
                if (!(serverPlayer.m_20280_((Entity)this) < 4096.0)) continue;
                ParticlePacket packet = new ParticlePacket();
                for (i = 0; i < 250; ++i) {
                    d0 = (-0.5 + this.f_19796_.m_188583_()) / 2.0;
                    d1 = (-0.5 + this.f_19796_.m_188583_()) / 2.0;
                    d2 = (-0.5 + this.f_19796_.m_188583_()) / 2.0;
                    packet.queueParticle((ParticleOptions)ParticleTypes.f_123744_, false, new Vec3(this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0)), new Vec3(d0, d1, d2));
                }
                for (i = 0; i < 200; ++i) {
                    d0 = (-0.5 + this.f_19796_.m_188583_()) / 2.0;
                    d1 = (-0.5 + this.f_19796_.m_188583_()) / 2.0;
                    d2 = (-0.5 + this.f_19796_.m_188583_()) / 2.0;
                    packet.queueParticle((ParticleOptions)ParticleTypes.f_123744_, false, new Vec3(this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0)), new Vec3(d0, d1, d2));
                }
                for (i = 0; i < 150; ++i) {
                    d0 = (-0.5 + this.f_19796_.m_188583_()) / 2.0;
                    d1 = (-0.5 + this.f_19796_.m_188583_()) / 2.0;
                    d2 = (-0.5 + this.f_19796_.m_188583_()) / 2.0;
                    packet.queueParticle((ParticleOptions)ParticleTypes.f_123744_, false, new Vec3(this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0)), new Vec3(d0, d1, d2));
                }
                ServerPlayer finalServerPlayer = serverPlayer;
                PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> finalServerPlayer), (Object)packet);
            }
        }
    }

    public boolean m_6087_() {
        return !this.isPhasedOut() && super.m_6087_();
    }

    public boolean m_6097_() {
        return !this.isPhasedOut() && super.m_6097_();
    }

    public boolean m_5789_() {
        return !this.isPhasedOut() && super.m_5789_();
    }

    public void makePoofParticles(Entity entity, Level level) {
        if (!level.f_46443_) {
            for (int i = 0; i < 20; ++i) {
                double d0 = this.f_19796_.m_188583_() * 0.02;
                double d1 = this.f_19796_.m_188583_() * 0.02;
                double d2 = this.f_19796_.m_188583_() * 0.02;
                ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123759_, entity.m_20208_(1.0), entity.m_20187_(), entity.m_20262_(1.0), 1, d0, d1, d2, 0.0);
            }
        }
    }

    public void m_8119_() {
        List attackingMobs;
        LivingEntity toBeAttacked;
        this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
        this.updateMobList();
        List list = this.m_9236_().m_6443_(Raider.class, this.m_20191_().m_82400_(100.0), predicate -> predicate.m_37886_() && !predicate.m_6095_().m_204039_(ModTags.EntityTypes.ILLAGER_BOSSES));
        if (((Boolean)Config.CommonConfig.spiritcaller_forcefield.get()).booleanValue() && this.m_37886_()) {
            if (!this.m_9236_().f_46443_) {
                this.setIllagersNearby(!list.isEmpty());
            }
            if (this.areIllagersNearby()) {
                this.m_6710_(null);
            }
        }
        if (this.m_37886_() && this.m_37885_() != null && this.m_37885_().m_37771_() == 7 && this.shouldRemoveItself() && ((Boolean)Config.CommonConfig.spiritcaller_onlyOneAllowed.get()).booleanValue()) {
            this.m_37885_().m_37740_((Raider)this, true);
            if (!this.m_9236_().f_46443_) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
        if (EntityUtil.displayBossBar((Raider)this) && this.isActive() && !this.bossEvent.m_8323_()) {
            this.bossEvent.m_8321_(true);
        } else if (this.bossEvent.m_8323_()) {
            this.bossEvent.m_8321_(false);
        }
        if (this.ritualTicks > 0 && !this.isActive() && this.m_6084_()) {
            ++this.ritualTicks;
            if (this.ritualTicks == 30) {
                if (((Boolean)Config.CommonConfig.mobs_watch_intros.get()).booleanValue()) {
                    List list1 = this.m_9236_().m_45976_(Mob.class, this.m_20191_().m_82400_(50.0));
                    for (Mob mob : list1) {
                        mob.f_21345_.m_25352_(0, (Goal)new WatchBossIntroGoal(mob, this));
                    }
                }
                EntityUtil.mobFollowingSound(this.m_9236_(), (Entity)this, (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_SPIRITCALLER_INTRO.get(), 2.0f, 1.0f, false);
                if (!this.m_9236_().f_46443_) {
                    this.setRitual(true);
                }
            }
            if (this.ritualTicks >= 145) {
                LightningBolt lightning = (LightningBolt)EntityType.f_20465_.m_20615_(this.m_9236_());
                assert (lightning != null);
                lightning.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                lightning.m_20874_(true);
                this.m_5496_(SoundEvents.f_12089_, 3.0f, 1.0f);
                this.m_5496_(SoundEvents.f_12090_, 10000.0f, 1.0f);
                this.m_9236_().m_7967_((Entity)lightning);
                CameraShakeEntity.cameraShake(this.m_9236_(), this.m_20182_(), 50.0f, 0.2f, 0, 10);
                if (!this.m_9236_().f_46443_) {
                    this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 4.0f, Level.ExplosionInteraction.NONE);
                    this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 4.0f, Level.ExplosionInteraction.NONE);
                    this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 4.0f, Level.ExplosionInteraction.NONE);
                }
                this.attackCooldown = 100;
                this.setActive(true);
                this.setRitual(false);
            }
        }
        if (!this.m_9236_().f_46443_ && this.isActive() && this.getBossMusic() != null) {
            if (this.canPlayMusic()) {
                this.m_9236_().m_7605_((Entity)this, (byte)67);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)68);
            }
        }
        this.attackTicks = this.attackType > 0 ? ++this.attackTicks : 0;
        if (this.stealSoulsCooldown > 0 && this.stolen_mobs.isEmpty()) {
            --this.stealSoulsCooldown;
        }
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
        if (this.isActive() && this.attackType == 0 && this.m_5448_() != null && this.f_19797_ % 20 == 10) {
            if (!this.m_142582_((Entity)this.m_5448_())) {
                ++this.stuckTime;
            } else if (this.stuckTime > 0) {
                --this.stuckTime;
            }
        }
        if (this.spiritSwarmCooldown > 0) {
            --this.spiritSwarmCooldown;
        }
        if (this.impRiseCooldown > 0) {
            --this.impRiseCooldown;
        }
        if (this.spiritHandsCooldown > 0) {
            --this.spiritHandsCooldown;
        }
        if (this.soulLaserCooldown > 0) {
            --this.soulLaserCooldown;
        }
        if (this.antiCheeseCooldown > 0) {
            --this.antiCheeseCooldown;
        }
        if (this.m_6084_()) {
            if (this.attackType == this.SPIRIT_STEAL && !this.stolen_mobs.isEmpty()) {
                Iterator<LivingEntity> iterator = this.stolen_mobs.iterator();
                while (iterator.hasNext()) {
                    LivingEntity stolen_mob;
                    toBeAttacked = stolen_mob = iterator.next();
                    toBeAttacked.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 0.0f);
                    toBeAttacked.m_20334_(-0.5 + this.f_19796_.m_188500_(), toBeAttacked.m_20184_().f_82480_, -0.5 + this.f_19796_.m_188500_());
                }
            }
            if (this.attackType == this.SOUL_SWARM) {
                if (this.attackTicks > 10 && this.attackTicks <= 55) {
                    for (int i = 0; i < this.getSoulPower() + 1; ++i) {
                        if (this.m_9236_().f_46443_) continue;
                        IllagerSoulEntity soul = (IllagerSoulEntity)((EntityType)ModEntityTypes.IllagerSoul.get()).m_20615_(this.m_9236_());
                        assert (soul != null);
                        soul.m_6034_(this.m_20185_() + (double)(-10 - this.getSoulPower() + this.f_19796_.m_188503_(20 + this.getSoulPower() * 2)), this.m_20186_() + (double)(-1 + this.f_19796_.m_188503_(10 + this.getSoulPower() * 2)), this.m_20189_() + (double)(-10 - this.getSoulPower() + this.f_19796_.m_188503_(20 + this.getSoulPower() * 2)));
                        soul.setOwner((LivingEntity)this);
                        soul.setAngelOrDevil(this.f_19796_.m_188499_());
                        soul.m_6710_(this.m_5448_());
                        soul.m_20334_(0.0, 0.1, 0.0);
                        if (this.m_5647_() != null) {
                            this.m_9236_().m_6188_().m_6546_(soul.m_20149_(), this.m_9236_().m_6188_().m_83489_(this.m_5647_().m_5758_()));
                        }
                        this.m_9236_().m_7967_((Entity)soul);
                    }
                }
                if (this.attackTicks == 18 && !this.m_9236_().f_46443_) {
                    this.setArmsUpward(false);
                    this.setSpinning(true);
                }
                if (this.attackTicks > 18 && this.attackTicks < 55 && !this.m_9236_().f_46443_) {
                    this.setFaking(this.f_19796_.m_188499_());
                }
                if (this.attackTicks == 55) {
                    if (!this.m_9236_().f_46443_) {
                        this.setSpinning(false);
                        this.setArmsUpward(true);
                        this.setFaking(true);
                    }
                    this.m_20334_(0.0, 0.3, 0.0);
                }
            }
            if (this.attackType == this.IMP_RISE) {
                if (this.attackTicks == 37) {
                    this.setArmsUpward(false);
                    this.setClap(true);
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_SPIRITCALLER_CLAP.get(), 2.0f, 1.0f);
                }
                if (this.attackTicks == 40) {
                    this.impAttacks = this.f_19796_.m_188503_(3) + 1;
                    if (this.impAttacks == 1) {
                        this.createLineImps();
                    }
                    if (this.impAttacks == 2) {
                        this.createRandomImps();
                    }
                    if (this.impAttacks == 3) {
                        this.createRingImps();
                    }
                }
                if (this.attackTicks == 50) {
                    this.setArmsUpward(true);
                    this.setClap(false);
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_SPIRITCALLER_IMPRISE.get(), 2.0f, 1.0f);
                }
                if (this.attackTicks == 87) {
                    this.setArmsUpward(false);
                    this.setClap(true);
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_SPIRITCALLER_CLAP.get(), 2.0f, 1.0f);
                }
                if (this.attackTicks == 90) {
                    this.impAttacks = this.f_19796_.m_188503_(3) + 1;
                    if (this.impAttacks == 1) {
                        this.createLineImps();
                    }
                    if (this.impAttacks == 2) {
                        this.createRandomImps();
                    }
                    if (this.impAttacks == 3) {
                        this.createRingImps();
                    }
                }
                if (this.attackTicks == 100) {
                    this.setArmsUpward(true);
                    this.setClap(false);
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_SPIRITCALLER_IMPRISE.get(), 2.0f, 1.0f);
                }
                if (this.attackTicks == 137) {
                    this.setArmsUpward(false);
                    this.setClap(true);
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_SPIRITCALLER_CLAP.get(), 2.0f, 1.0f);
                }
                if (this.attackTicks == 140) {
                    this.impAttacks = this.f_19796_.m_188503_(3) + 1;
                    if (this.impAttacks == 1) {
                        this.createLineImps();
                    }
                    if (this.impAttacks == 2) {
                        this.createRandomImps();
                    }
                    if (this.impAttacks == 3) {
                        this.createRingImps();
                    }
                }
            }
            if (this.attackType == this.SPIRIT_HANDS) {
                if (this.attackTicks == 19) {
                    this.setShowSpiritHands(true);
                }
                if (this.attackTicks == 37) {
                    this.setSpinning(false);
                    this.setClap(true);
                }
                if (this.attackTicks == 40) {
                    this.setShowSpiritHands(false);
                    SpiritHandEntity hand1 = (SpiritHandEntity)((EntityType)ModEntityTypes.SpiritHand.get()).m_20615_(this.m_9236_());
                    assert (hand1 != null);
                    hand1.m_6034_(this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_());
                    hand1.setGoodOrEvil(true);
                    hand1.m_20334_((-0.5 + this.f_19796_.m_188500_()) / 2.0, (-0.5 + this.f_19796_.m_188500_()) / 2.0, (-0.5 + this.f_19796_.m_188500_()) / 2.0);
                    hand1.setOwner((LivingEntity)this);
                    hand1.m_6710_(this.m_5448_());
                    hand1.setPower(this.getSoulPower());
                    if (this.m_5647_() != null) {
                        this.m_9236_().m_6188_().m_6546_(hand1.m_20149_(), this.m_9236_().m_6188_().m_83489_(this.m_5647_().m_5758_()));
                    }
                    this.m_9236_().m_7967_((Entity)hand1);
                    SpiritHandEntity hand2 = (SpiritHandEntity)((EntityType)ModEntityTypes.SpiritHand.get()).m_20615_(this.m_9236_());
                    assert (hand2 != null);
                    hand2.m_6034_(this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_());
                    hand2.setGoodOrEvil(false);
                    hand2.m_20334_((-0.5 + this.f_19796_.m_188500_()) / 2.0, (-0.5 + this.f_19796_.m_188500_()) / 2.0, (-0.5 + this.f_19796_.m_188500_()) / 2.0);
                    hand2.setOwner((LivingEntity)this);
                    hand2.m_6710_(this.m_5448_());
                    if (this.m_5647_() != null) {
                        this.m_9236_().m_6188_().m_6546_(hand2.m_20149_(), this.m_9236_().m_6188_().m_83489_(this.m_5647_().m_5758_()));
                    }
                    hand2.setPower(this.getSoulPower());
                    this.m_9236_().m_7967_((Entity)hand2);
                }
            }
            if (this.attackType == this.SOUL_LASER) {
                Object beam = null;
                if (this.m_5448_() != null && this.attackTicks < 85) {
                    this.setLaserPosition(this.m_5448_().m_20185_(), this.m_5448_().m_20186_() + (double)this.m_5448_().m_20192_(), this.m_5448_().m_20189_());
                }
                if (this.laserX != 0.0 || this.laserY != 0.0 || this.laserZ != 0.0) {
                    this.m_21563_().m_24950_(this.laserX, this.laserY, this.laserZ, 100.0f, 100.0f);
                }
                if (this.attackTicks == 100) {
                    this.setChargingLaser(false);
                    this.setShootingLaser(true);
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_SPIRITCALLER_LASER.get(), 2.0f, 1.0f);
                    if (!this.m_9236_().f_46443_) {
                        beam = new SoulBeamEntity((EntityType<? extends SoulBeamEntity>)((EntityType)ModEntityTypes.SoulBeam.get()), this.m_9236_(), (LivingEntity)this, this.m_20185_() + (double)0.8f * Math.sin((double)(-this.m_146908_()) * Math.PI / 180.0), this.m_20186_() + 1.0, this.m_20189_() + (double)0.8f * Math.cos((double)(-this.m_146908_()) * Math.PI / 180.0), (float)((double)(this.f_20885_ + 90.0f) * Math.PI / 180.0), (float)((double)(-this.m_146909_()) * Math.PI / 180.0), 40, this.getSoulPower());
                        this.m_9236_().m_7967_(beam);
                    }
                }
                if (this.attackTicks >= 100) {
                    this.m_20334_(0.0, 0.0, 0.0);
                    if (beam != null) {
                        float radius2 = 1.1f;
                        double x = this.m_20185_() + (double)0.8f * Math.sin((double)(-this.m_146908_()) * Math.PI / 180.0) + (double)radius2 * Math.sin((double)(-this.f_20885_) * Math.PI / 180.0) * Math.cos((double)(-this.m_146909_()) * Math.PI / 180.0);
                        double y = this.m_20186_() + 1.0 + (double)radius2 * Math.sin((double)(-this.m_146909_()) * Math.PI / 180.0);
                        double z = this.m_20189_() + (double)0.8f * Math.cos((double)(-this.m_146908_()) * Math.PI / 180.0) + (double)radius2 * Math.cos((double)(-this.f_20885_) * Math.PI / 180.0) * Math.cos((double)(-this.m_146909_()) * Math.PI / 180.0);
                        beam.m_6034_(x, y, z);
                        float yaw = this.f_20885_ + 90.0f;
                        float power = -this.m_146909_();
                        ((SoulBeamEntity)((Object)beam)).setYaw((float)((double)yaw * Math.PI / 180.0));
                        ((SoulBeamEntity)((Object)beam)).setPitch((float)((double)power * Math.PI / 180.0));
                        ((SoulBeamEntity)((Object)beam)).setPower(this.getSoulPower());
                    }
                }
            }
            if (this.attackType == this.ANTICHEESE) {
                if (this.attackTicks % 2 == 1 && this.attackTicks < 40) {
                    if (this.isFaking()) {
                        this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_MOBSPIRIT_HURT.get(), 0.5f, 1.0f);
                    }
                    this.setFaking(!this.isFaking());
                }
                if (this.attackTicks == 40 && this.m_5448_() != null) {
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_SPIRITCALLER_ANTICHEESE.get(), 2.0f, 1.0f);
                    this.setArmsUpward(false);
                    this.makePoofParticles((Entity)this, this.m_9236_());
                    this.setPhasedOut(true);
                }
                if (this.isPhasedOut() && this.m_5448_() != null) {
                    if (this.attackTicks <= 100) {
                        this.m_146884_(this.m_5448_().m_20182_());
                    }
                    this.m_20095_();
                    this.m_20334_(0.0, 0.0, 0.0);
                }
                if (this.attackTicks == 120) {
                    CameraShakeEntity.cameraShake(this.m_9236_(), this.m_20182_(), 30.0f, 0.3f, 0, 15);
                    for (Entity entity : this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82400_(15.0))) {
                        if (!entity.m_6084_() || !(this.m_20280_(entity) < 36.0)) continue;
                        entity.f_19864_ = true;
                        entity.m_20254_(8);
                    }
                    if (!this.m_9236_().f_46443_) {
                        this.makeCheeseParticles();
                        this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 3.0f, Level.ExplosionInteraction.NONE);
                        this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 3.0f, Level.ExplosionInteraction.NONE);
                        this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 3.0f, Level.ExplosionInteraction.NONE);
                    }
                    this.setPhasedOut(false);
                    this.setFaking(false);
                    this.setClap(true);
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_SPIRITCALLER_CLAP.get(), 2.0f, 1.0f);
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_SPIRITCALLER_ANTICHEESE.get(), 2.0f, 1.0f);
                    this.createRandomImps();
                }
            }
        }
        if (this.m_6084_()) {
            if (this.chargeX != 0.0 && this.chargeY != 0.0 && this.chargeZ != 0.0) {
                ++this.chargeTime;
                this.m_20334_(this.chargeX, this.chargeY, this.chargeZ);
                if (!this.m_9236_().f_46443_) {
                    this.setCharging(true);
                }
                if (this.m_20185_() - this.targetX < 1.0 && this.m_20185_() - this.targetX > -1.0 && this.m_20186_() - this.targetY < 1.0 && this.m_20186_() - this.targetY > -1.0 && this.m_20189_() - this.targetZ < 1.0 && this.m_20189_() - this.targetZ > -1.0 || this.chargeTime > 60) {
                    if (!this.m_9236_().f_46443_) {
                        this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 2.0f, Level.ExplosionInteraction.NONE);
                        this.setFaking(false);
                    }
                    this.setCharge(0.0, 0.0, 0.0);
                    this.setTargetPosition(0.0, 0.0, 0.0);
                    this.m_20334_(0.0, 0.5, 0.0);
                }
            } else {
                this.chargeTime = 0;
                if (!this.m_9236_().f_46443_) {
                    this.setCharging(false);
                }
            }
        }
        if (!this.m_9236_().f_46443_) {
            this.setForcefield(!this.stolen_mobs.isEmpty());
        }
        if (this.isActive()) {
            attackingMobs = this.m_9236_().m_6443_(Projectile.class, this.m_20191_().m_82400_(10.0), predicate -> this.m_20280_((Entity)predicate) <= 90.0);
            for (Object attackingMob : attackingMobs) {
                Projectile thing = (Projectile)attackingMob;
                Vec3 aActualMotion = new Vec3(thing.m_20185_() - thing.f_19854_, thing.m_20186_() - thing.f_19791_, thing.m_20189_() - thing.f_19856_);
                if (aActualMotion.m_82553_() < 0.1 || thing.f_19797_ <= 1) continue;
                float dot = (float)thing.m_20184_().m_82541_().m_82526_(this.m_20182_().m_82520_(0.0, 1.5, 0.0).m_82546_(thing.m_20182_()).m_82541_());
                if (this.dodgeCooldown >= 1) continue;
                if ((double)dot > 0.94) {
                    Vec3 dodgeVec = thing.m_20184_().m_82537_(new Vec3(0.0, 1.0, 0.0)).m_82541_().m_82490_(1.2);
                    Vec3 newPosLeft = this.m_20318_(1.0f).m_82549_(dodgeVec.m_82490_(2.0));
                    Vec3 newPosRight = this.m_20318_(1.0f).m_82549_(dodgeVec.m_82490_(-2.0));
                    Vec3 diffLeft = newPosLeft.m_82546_(thing.m_20182_());
                    Vec3 diffRight = newPosRight.m_82546_(thing.m_20182_());
                    if (diffRight.m_82526_(thing.m_20184_()) > diffLeft.m_82526_(thing.m_20184_())) {
                        dodgeVec = dodgeVec.m_82490_(-1.0);
                    }
                    this.m_20256_(this.m_20184_().m_82549_(dodgeVec.m_82490_(0.5)));
                }
                this.dodgeCooldown = 10;
            }
            if (this.dodgeCooldown > 0) {
                --this.dodgeCooldown;
            }
        }
        super.m_8119_();
        if (this.isActive() || this.isRitual()) {
            this.m_146922_(this.m_6080_());
            this.f_20883_ = this.m_146908_();
        }
        if (this.isSpinning()) {
            ++this.spinDirection;
            if (this.spinDirection > 4) {
                this.spinDirection = 1;
            }
            this.f_20883_ = this.spinDirection * 90;
        }
        if (this.isChargingLaser() && this.m_9236_().f_46443_) {
            float f = this.f_20883_ * ((float)Math.PI / 180) + Mth.m_14089_((float)((float)this.f_19797_ * 0.6662f)) * 0.25f;
            float radius2 = Mth.m_14089_((float)f);
            float f2 = Mth.m_14031_((float)f);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20185_() - (double)radius2 * 0.8, this.m_20186_() + 2.5, this.m_20189_() - (double)f2 * 0.8, 0.1, 0.1, 0.2);
        }
        if (this.isActive()) {
            this.m_20242_(true);
            this.nextWingsFrame();
            if (this.getWingsFrames() == 12 && this.m_6084_() && !this.isPhasedOut()) {
                this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_SPIRITCALLER_WINGS.get(), 2.0f, 1.0f);
            }
            if (this.getWingsFrames() >= 25) {
                this.resetWingsFrame();
            }
            if (this.m_9236_().f_46443_) {
                this.clientSideWingsAnimationO = this.clientSideWingsAnimation;
                this.clientSideWingsAnimation = Mth.m_14036_((float)(this.clientSideWingsAnimation + 1.0f), (float)0.0f, (float)25.0f);
            }
            if (!this.isCharging() && this.m_5448_() != null) {
                LivingEntity entity = this.m_5448_();
                double x = this.m_20185_() - entity.m_20185_();
                double y = this.m_20186_() - entity.m_20186_();
                double z = this.m_20189_() - entity.m_20189_();
                double d = Math.sqrt(x * x + y * y + z * z);
                float power = 0.08f;
                double motionX = this.m_20184_().f_82479_ - x / d * (double)power * 0.2;
                double motionY = this.m_20184_().f_82480_ - y / d * (double)power * 0.2;
                double motionZ = this.m_20184_().f_82481_ - z / d * (double)power * 0.2;
                if (this.m_20280_((Entity)entity) > 120.0) {
                    this.m_20334_(motionX, motionY, motionZ);
                }
            }
            if (!this.isCharging()) {
                if (this.m_5448_() != null) {
                    if (this.m_9236_().m_8055_(this.m_20183_().m_6625_(5)) == Blocks.f_50016_.m_49966_() && this.m_9236_().m_8055_(this.m_20183_().m_6625_(4)) == Blocks.f_50016_.m_49966_() && this.m_9236_().m_8055_(this.m_20183_().m_6625_(3)) == Blocks.f_50016_.m_49966_() && this.m_9236_().m_8055_(this.m_20183_().m_6625_(2)) == Blocks.f_50016_.m_49966_() && this.m_9236_().m_8055_(this.m_20183_().m_6625_(1)) == Blocks.f_50016_.m_49966_()) {
                        if (this.m_20184_().f_82480_ > 0.0) {
                            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.01, 0.0));
                        }
                    } else {
                        this.m_20256_(this.m_20184_().m_82520_(0.0, 0.04, 0.0));
                    }
                } else if (this.m_9236_().m_8055_(this.m_20183_().m_6625_(1)) != Blocks.f_50016_.m_49966_()) {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, 0.04, 0.0));
                } else {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, -0.01, 0.0));
                }
            }
        }
        attackingMobs = this.m_9236_().m_6443_(Mob.class, this.m_20191_().m_82400_(100.0), predicate -> predicate.m_5448_() == this);
        if (!this.stolen_mobs.isEmpty() && !this.isArmsUpward()) {
            toBeAttacked = this.stolen_mobs.get(this.f_19796_.m_188503_(this.stolen_mobs.size()));
            for (Object attackingMob : attackingMobs) {
                Mob attacker = (Mob)attackingMob;
                if (this.f_19796_.m_188503_(2) == 0 && !this.spirits.isEmpty()) {
                    attacker.m_6710_((LivingEntity)this.spirits.get(this.f_19796_.m_188503_(this.spirits.size())));
                    continue;
                }
                if (this.canStolenMobBeAttacked(toBeAttacked, (LivingEntity)attacker)) {
                    attacker.m_6710_(toBeAttacked);
                    continue;
                }
                if (!this.spirits.isEmpty()) {
                    attacker.m_6710_((LivingEntity)this.spirits.get(this.f_19796_.m_188503_(this.spirits.size())));
                    continue;
                }
                attacker.m_6710_(null);
            }
        }
    }

    public void m_7334_(Entity p_21294_) {
        if (!this.isPhasedOut()) {
            super.m_7334_(p_21294_);
        }
    }

    protected void m_6138_() {
        if (!this.isPhasedOut()) {
            super.m_6138_();
        }
    }

    public boolean m_20329_(Entity p_20330_) {
        return (p_20330_ instanceof CrocofangEntity || p_20330_ instanceof Ravager) && super.m_20329_(p_20330_);
    }

    protected void createLineImps() {
        if (this.m_5448_() != null) {
            LivingEntity livingentity = this.m_5448_();
            double d0 = Math.min(livingentity.m_20186_(), this.m_20186_() - 5.0);
            double d1 = Math.max(livingentity.m_20186_(), this.m_20186_() - 5.0) + 1.0;
            float f = (float)Mth.m_14136_((double)(livingentity.m_20189_() - this.m_20189_()), (double)(livingentity.m_20185_() - this.m_20185_()));
            for (int l = 0; l < 16; ++l) {
                double d2 = 1.25 * (double)(l + 1);
                this.createSpellEntity(this.m_20185_() + (double)Mth.m_14089_((float)f) * d2, this.m_20189_() + (double)Mth.m_14031_((float)f) * d2, d0, d1, l);
            }
        }
    }

    protected void createRandomImps() {
        if (this.m_5448_() != null) {
            LivingEntity livingentity = this.m_5448_();
            double d0 = Math.min(livingentity.m_20186_(), this.m_20186_() - 5.0);
            double d1 = Math.max(livingentity.m_20186_(), this.m_20186_() - 5.0) + 1.0;
            for (int l = 0; l < 30; ++l) {
                this.createSpellEntity(this.m_20185_() + (double)(-15 + this.f_19796_.m_188503_(30)), this.m_20189_() + (double)(-15 + this.f_19796_.m_188503_(30)), d0, d1, l);
            }
        }
    }

    protected void createRingImps() {
        if (this.m_5448_() != null) {
            LivingEntity livingentity = this.m_5448_();
            double d0 = Math.min(livingentity.m_20186_(), this.m_20186_() - 5.0);
            double d1 = Math.max(livingentity.m_20186_(), this.m_20186_() - 5.0) + 1.0;
            this.createSpellEntity(livingentity.m_20185_() - 3.0, livingentity.m_20189_() - 0.0, d0, d1, 0);
            this.createSpellEntity(livingentity.m_20185_() - 2.0, livingentity.m_20189_() + 1.0, d0, d1, 1);
            this.createSpellEntity(livingentity.m_20185_() - 1.0, livingentity.m_20189_() + 2.0, d0, d1, 2);
            this.createSpellEntity(livingentity.m_20185_() - 0.0, livingentity.m_20189_() + 3.0, d0, d1, 3);
            this.createSpellEntity(livingentity.m_20185_() + 1.0, livingentity.m_20189_() + 2.0, d0, d1, 4);
            this.createSpellEntity(livingentity.m_20185_() + 2.0, livingentity.m_20189_() + 1.0, d0, d1, 5);
            this.createSpellEntity(livingentity.m_20185_() + 3.0, livingentity.m_20189_() - 0.0, d0, d1, 6);
            this.createSpellEntity(livingentity.m_20185_() + 2.0, livingentity.m_20189_() - 1.0, d0, d1, 7);
            this.createSpellEntity(livingentity.m_20185_() + 1.0, livingentity.m_20189_() - 2.0, d0, d1, 8);
            this.createSpellEntity(livingentity.m_20185_() - 0.0, livingentity.m_20189_() - 3.0, d0, d1, 9);
            this.createSpellEntity(livingentity.m_20185_() - 1.0, livingentity.m_20189_() - 2.0, d0, d1, 10);
            this.createSpellEntity(livingentity.m_20185_() - 2.0, livingentity.m_20189_() - 1.0, d0, d1, 11);
            this.createSpellEntity(livingentity.m_20185_() - 0.0, livingentity.m_20189_() - 0.0, d0, d1, 12);
        }
    }

    private void createSpellEntity(double p_190876_1_, double p_190876_3_, double p_190876_5_, double p_190876_7_, int time) {
        BlockPos blockpos = BlockPos.m_274561_((double)p_190876_1_, (double)p_190876_7_, (double)p_190876_3_);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1 = blockpos.m_7495_();
            BlockState blockstate = this.m_9236_().m_8055_(blockpos1);
            if (!blockstate.m_60783_((BlockGetter)this.m_9236_(), blockpos1, Direction.UP)) continue;
            if (!this.m_9236_().m_46859_(blockpos) && !(voxelshape = (blockstate1 = this.m_9236_().m_8055_(blockpos)).m_60812_((BlockGetter)this.m_9236_(), blockpos)).m_83281_()) {
                d0 = voxelshape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)p_190876_5_) - 1);
        if (flag) {
            ImpEntity imp = (ImpEntity)((EntityType)ModEntityTypes.Imp.get()).m_20615_(this.m_9236_());
            assert (imp != null);
            imp.m_6034_((double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_() + d0, (double)blockpos.m_123343_() + 0.5);
            imp.setOwner((LivingEntity)this);
            imp.setPower(this.getSoulPower());
            imp.m_6710_(this.m_5448_());
            imp.setWaitTime(time);
            imp.m_6842_(true);
            if (this.m_5647_() != null) {
                this.m_9236_().m_6188_().m_6546_(imp.m_20149_(), this.m_9236_().m_6188_().m_83489_(this.m_5647_().m_5758_()));
            }
            this.m_9236_().m_7967_((Entity)imp);
        }
    }

    public boolean m_6128_() {
        return this.isCharging() || this.spiritSwarmCooldown > 140;
    }

    public boolean canStolenMobBeAttacked(LivingEntity entity, LivingEntity attacker) {
        if (((List)Config.CommonConfig.spiritcaller_wontAttack.get()).contains(entity.m_20078_())) {
            return false;
        }
        if (entity.m_5647_() != null) {
            return entity.m_5647_().m_6260_();
        }
        if (entity instanceof MobSpiritEntity) {
            return ((MobSpiritEntity)entity).getOwner() != attacker;
        }
        return attacker != entity;
    }

    public void m_6667_(DamageSource p_37847_) {
        if (this.m_37886_() && this.m_37885_() != null) {
            this.m_37885_().f_37673_ = 0L;
        }
        if (this.isActive()) {
            if (!this.m_9236_().f_46443_) {
                this.setPhasedOut(false);
                this.attackTicks = 0;
                this.f_21345_.m_25386_().forEach(WrappedGoal::m_8041_);
            }
            if (this.f_20889_ > 0) {
                this.f_20889_ = 10000;
            }
            this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_SPIRITCALLER_DEATHANIMATION.get(), 3.0f, 1.0f);
        } else {
            super.m_6667_(p_37847_);
        }
    }

    protected void m_6153_() {
        if (this.isActive()) {
            this.setCharging(false);
            this.setFaking(false);
            this.setSpinning(false);
            this.setArmsUpward(false);
            this.setClap(false);
            ++this.f_20919_;
            this.m_20334_(0.0, 0.05, 0.0);
            List list1 = this.m_9236_().m_6443_(MobSpiritEntity.class, this.m_20191_().m_82400_(100.0), predicate -> predicate.getOwner() == this);
            List list2 = this.m_9236_().m_6443_(IllagerSoulEntity.class, this.m_20191_().m_82400_(100.0), predicate -> predicate.getOwner() == this);
            List list3 = this.m_9236_().m_6443_(ImpEntity.class, this.m_20191_().m_82400_(100.0), predicate -> predicate.getOwner() == this);
            List list4 = this.m_9236_().m_6443_(SpiritHandEntity.class, this.m_20191_().m_82400_(100.0), predicate -> predicate.getOwner() == this);
            for (MobSpiritEntity spirit : list1) {
                spirit.m_6074_();
            }
            for (IllagerSoulEntity soul : list2) {
                soul.m_6074_();
            }
            for (ImpEntity imp : list3) {
                imp.m_146870_();
            }
            for (SpiritHandEntity hand : list4) {
                hand.m_6074_();
            }
            if (this.f_20919_ == 131) {
                LightningBolt lightning = (LightningBolt)EntityType.f_20465_.m_20615_(this.m_9236_());
                assert (lightning != null);
                lightning.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                lightning.m_20874_(true);
                this.m_5496_(SoundEvents.f_12089_, 3.0f, 1.0f);
                this.m_5496_(SoundEvents.f_12090_, 10000.0f, 1.0f);
                this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_MAGISPELLER_KABOOMER_EXPLODE.get(), 6.0f, 1.0f);
                this.m_9236_().m_7967_((Entity)lightning);
                CameraShakeEntity.cameraShake(this.m_9236_(), this.m_20182_(), 50.0f, 0.6f, 0, 20);
                if (!this.m_9236_().f_46443_) {
                    this.makeExplodeParticles();
                    double range = 4.0;
                    this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 5.0f, Level.ExplosionInteraction.NONE);
                    this.m_9236_().m_254849_((Entity)this, this.m_20185_() + range, this.m_20186_(), this.m_20189_() + range, 5.0f, Level.ExplosionInteraction.NONE);
                    this.m_9236_().m_254849_((Entity)this, this.m_20185_() + range, this.m_20186_(), this.m_20189_() - range, 5.0f, Level.ExplosionInteraction.NONE);
                    this.m_9236_().m_254849_((Entity)this, this.m_20185_() - range, this.m_20186_(), this.m_20189_() + range, 5.0f, Level.ExplosionInteraction.NONE);
                    this.m_9236_().m_254849_((Entity)this, this.m_20185_() - range, this.m_20186_(), this.m_20189_() - range, 5.0f, Level.ExplosionInteraction.NONE);
                    this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_() + range, this.m_20189_(), 5.0f, Level.ExplosionInteraction.NONE);
                    this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_() - range, this.m_20189_(), 5.0f, Level.ExplosionInteraction.NONE);
                }
                this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_SPIRITCALLER_DEATH.get(), 3.0f, 1.0f);
                this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_SPIRITCALLER_DESCENT.get(), 3.0f, 1.0f);
                super.m_6667_(this.lastDamageSource != null ? this.lastDamageSource : this.m_269291_().m_269264_());
                if (!this.m_9236_().f_46443_) {
                    this.m_142687_(Entity.RemovalReason.KILLED);
                }
            }
        } else {
            super.m_6153_();
        }
    }

    protected void m_6668_(DamageSource source) {
        if (this.m_6125_() && this.m_9236_().m_46469_().m_46207_(GameRules.f_46135_) && this.f_20889_ > 0 && (source.m_7640_() instanceof IllagerSoulEntity || source.m_7640_() instanceof SoulBeamEntity || source.m_7640_() instanceof ImpEntity)) {
            this.m_9236_().m_7967_((Entity)new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)ItemRegisterer.SPIRITCALLER_DISC.get())));
        }
        super.m_6668_(source);
    }

    public boolean isForcefieldProtected() {
        return (Boolean)this.f_19804_.m_135370_(FORCEFIELD);
    }

    public void setForcefield(boolean forcefield) {
        this.f_19804_.m_135381_(FORCEFIELD, (Object)forcefield);
    }

    public boolean shouldRemoveItself() {
        return (Boolean)this.f_19804_.m_135370_(SHOULD_DELETE_ITSELF);
    }

    public void setShouldDeleteItself(boolean shouldDelete) {
        this.f_19804_.m_135381_(SHOULD_DELETE_ITSELF, (Object)shouldDelete);
    }

    public boolean areIllagersNearby() {
        return (Boolean)this.f_19804_.m_135370_(NEARBY_ILLAGERS) != false && this.ritualTicks < 1 && !this.isActive();
    }

    public void setIllagersNearby(boolean illagersNearby) {
        this.f_19804_.m_135381_(NEARBY_ILLAGERS, (Object)illagersNearby);
    }

    public boolean isActive() {
        return (Boolean)this.f_19804_.m_135370_(ACTIVE);
    }

    public void setActive(boolean active) {
        this.f_19804_.m_135381_(ACTIVE, (Object)active);
    }

    public void nextWingsFrame() {
        this.f_19804_.m_135381_(WINGS_FRAME, (Object)(this.getWingsFrames() + 1));
    }

    public int getWingsFrames() {
        return (Integer)this.f_19804_.m_135370_(WINGS_FRAME);
    }

    public boolean isRitual() {
        return (Boolean)this.f_19804_.m_135370_(RITUAL);
    }

    public void setRitual(boolean ritual) {
        this.f_19804_.m_135381_(RITUAL, (Object)ritual);
    }

    public boolean isArmsUpward() {
        return (Boolean)this.f_19804_.m_135370_(ARMS_UPWARD);
    }

    public void setArmsUpward(boolean arms) {
        this.f_19804_.m_135381_(ARMS_UPWARD, (Object)arms);
    }

    public void setSoulPower(int souls) {
        this.f_19804_.m_135381_(SOUL_POWER, (Object)souls);
    }

    public int getSoulPower() {
        return (Integer)this.f_19804_.m_135370_(SOUL_POWER);
    }

    public void resetWingsFrame() {
        this.f_19804_.m_135381_(WINGS_FRAME, (Object)0);
        if (this.m_9236_().f_46443_) {
            this.clientSideWingsAnimation = 0.0f;
        }
    }

    public boolean isSpinning() {
        return (Boolean)this.f_19804_.m_135370_(SPINNING);
    }

    public void setSpinning(boolean spinning) {
        this.f_19804_.m_135381_(SPINNING, (Object)spinning);
    }

    public boolean isPhasedOut() {
        return (Boolean)this.f_19804_.m_135370_(PHASED_OUT);
    }

    public void setPhasedOut(boolean phasedOut) {
        this.f_19804_.m_135381_(PHASED_OUT, (Object)phasedOut);
    }

    public boolean isFaking() {
        return (Boolean)this.f_19804_.m_135370_(FAKING);
    }

    public void setFaking(boolean faking) {
        this.f_19804_.m_135381_(FAKING, (Object)faking);
    }

    public boolean isCharging() {
        return (Boolean)this.f_19804_.m_135370_(CHARGING);
    }

    public void setCharging(boolean charge) {
        this.f_19804_.m_135381_(CHARGING, (Object)charge);
    }

    public boolean isClap() {
        return (Boolean)this.f_19804_.m_135370_(CLAP);
    }

    public void setClap(boolean spinning) {
        this.f_19804_.m_135381_(CLAP, (Object)spinning);
    }

    public float getWingsAnimationScale(float p_29570_) {
        return Mth.m_14179_((float)p_29570_, (float)this.clientSideWingsAnimationO, (float)this.clientSideWingsAnimation) / 3.0f;
    }

    public boolean m_7490_() {
        return false;
    }

    public boolean shouldShowSpiritHands() {
        return (Boolean)this.f_19804_.m_135370_(SHOW_SPIRIT_HANDS);
    }

    public void setShowSpiritHands(boolean hands) {
        this.f_19804_.m_135381_(SHOW_SPIRIT_HANDS, (Object)hands);
    }

    public boolean isChargingLaser() {
        return (Boolean)this.f_19804_.m_135370_(CHARGING_LASER);
    }

    public void setChargingLaser(boolean chargingLaser) {
        this.f_19804_.m_135381_(CHARGING_LASER, (Object)chargingLaser);
    }

    public boolean isShootingLaser() {
        return (Boolean)this.f_19804_.m_135370_(SHOOTING_LASER);
    }

    public void setShootingLaser(boolean laser) {
        this.f_19804_.m_135381_(SHOOTING_LASER, (Object)laser);
    }

    public void updateMobList() {
        int i;
        if (!this.stolen_mobs.isEmpty()) {
            for (i = 0; i < this.stolen_mobs.size(); ++i) {
                LivingEntity mob = this.stolen_mobs.get(i);
                if (mob.m_6084_()) continue;
                this.stolen_mobs.remove(i);
                --i;
            }
        }
        if (!this.spirits.isEmpty()) {
            for (i = 0; i < this.spirits.size(); ++i) {
                MobSpiritEntity spirit = this.spirits.get(i);
                if (spirit.m_6084_()) continue;
                if (spirit.getOriginalMob() != null) {
                    this.stolen_mobs.removeIf(original -> original == spirit.getOriginalMob());
                }
                this.spirits.remove(i);
                --i;
            }
        }
    }

    public void makeParticles() {
        for (int i = 0; i < 250; ++i) {
            double d0 = (-0.5 + this.f_19796_.m_188583_()) / 2.0;
            double d1 = (-0.5 + this.f_19796_.m_188583_()) / 2.0;
            double d2 = (-0.5 + this.f_19796_.m_188583_()) / 2.0;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 1.0, this.m_20262_(1.0), d0, d1, d2);
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.isPhasedOut() && !source.m_276093_(DamageTypes.f_268724_) && !source.m_276093_(DamageTypes.f_286979_)) {
            return false;
        }
        if (!(this.isActive() || source.m_276093_(DamageTypes.f_268724_) || source.m_276093_(DamageTypes.f_286979_))) {
            amount = 0.0f;
            if (source.m_7639_() != null && this.ritualTicks == 0 && !this.areIllagersNearby()) {
                this.ritualTicks = 1;
                if (this.m_37886_() && this.m_37885_() != null) {
                    this.m_37885_().f_37673_ = 0L;
                }
            }
        }
        if ((this.areIllagersNearby() || this.isForcefieldProtected()) && !source.m_276093_(DamageTypes.f_268724_) && !source.m_276093_(DamageTypes.f_286979_)) {
            return false;
        }
        if (source.m_7639_() instanceof IllagerSoulEntity && ((IllagerSoulEntity)source.m_7639_()).getOwner() == this) {
            return false;
        }
        if (source.m_269533_(DamageTypeTags.f_268524_)) {
            amount /= 2.0f;
        }
        this.lastDamageSource = source;
        return super.m_6469_(source, amount);
    }

    public int getRitualTicks() {
        return this.ritualTicks;
    }

    public boolean m_21532_() {
        return (Boolean)Config.CommonConfig.ULTIMATE_NIGHTMARE.get() == false;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_213386_1_, DifficultyInstance p_213386_2_, MobSpawnType p_213386_3_, @Nullable SpawnGroupData p_213386_4_, @Nullable CompoundTag p_213386_5_) {
        if (p_213386_3_ == MobSpawnType.EVENT) {
            this.setShouldDeleteItself(true);
        }
        return super.m_6518_(p_213386_1_, p_213386_2_, p_213386_3_, p_213386_4_, p_213386_5_);
    }

    public SoundEvent m_7930_() {
        return this.isRitual() || this.isPhasedOut() ? null : (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_SPIRITCALLER_CELEBRATE.get();
    }

    protected SoundEvent m_7515_() {
        return this.isRitual() || this.isPhasedOut() ? null : (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_SPIRITCALLER_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource p_184601_1_) {
        return (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_SPIRITCALLER_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return this.isActive() ? null : (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_SPIRITCALLER_DEATH.get();
    }

    public boolean doesAttackMeetNormalRequirements() {
        return this.attackType == 0 && !this.areIllagersNearby() && this.m_5448_() != null && this.m_142582_((Entity)this.m_5448_()) && this.isActive() && !this.isFaking();
    }

    public boolean isTargetOnGround() {
        return this.m_5448_() != null && this.m_5448_().m_20096_();
    }

    public boolean areStealableMobsNearby() {
        List list = this.m_9236_().m_6443_(Mob.class, this.m_20191_().m_82400_(15.0), predicate -> ((List)Config.CommonConfig.spiritcaller_stealableMobs.get()).contains(predicate.m_20078_()) && !predicate.m_20147_() && predicate != this);
        return !list.isEmpty();
    }

    public boolean checkForStolenMobs() {
        return this.stolen_mobs.isEmpty() || !this.areStolenMobsNearby();
    }

    public boolean areStolenMobsNearby() {
        List list = this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82400_(100.0), predicate -> ((List)Config.CommonConfig.spiritcaller_stealableMobs.get()).contains(predicate.m_20078_()) && !predicate.m_20147_() && predicate.m_21023_((MobEffect)EffectRegisterer.DISABILITY.get()));
        return !list.isEmpty();
    }

    public void setCharge(double x, double y, double z) {
        this.chargeX = x;
        this.chargeY = y;
        this.chargeZ = z;
    }

    public void setTargetPosition(double x, double y, double z) {
        this.targetX = x;
        this.targetY = y;
        this.targetZ = z;
    }

    public void setLaserPosition(double x, double y, double z) {
        this.laserX = x;
        this.laserY = y;
        this.laserZ = z;
    }

    class AntiCheeseGoal
    extends Goal {
        AntiCheeseGoal() {
        }

        public boolean m_8036_() {
            return SpiritcallerEntity.this.stuckTime > 5 && SpiritcallerEntity.this.attackType == 0 && !SpiritcallerEntity.this.areIllagersNearby() && SpiritcallerEntity.this.m_5448_() != null && SpiritcallerEntity.this.isActive() && !SpiritcallerEntity.this.isFaking() && SpiritcallerEntity.this.antiCheeseCooldown < 1 && SpiritcallerEntity.this.attackCooldown < 1;
        }

        public boolean m_8045_() {
            if (SpiritcallerEntity.this.attackTicks == 40 && SpiritcallerEntity.this.m_5448_() == null) {
                return false;
            }
            return SpiritcallerEntity.this.attackTicks <= 140;
        }

        public void m_8056_() {
            SpiritcallerEntity.this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_SPIRITCALLER_IMPRISE.get(), 4.0f, 1.0f);
            SpiritcallerEntity.this.setArmsUpward(true);
            SpiritcallerEntity.this.setFaking(true);
            SpiritcallerEntity.this.attackType = SpiritcallerEntity.this.ANTICHEESE;
        }

        public void m_8041_() {
            SpiritcallerEntity.this.attackType = 0;
            SpiritcallerEntity.this.attackCooldown = 20;
            SpiritcallerEntity.this.antiCheeseCooldown = 40;
            SpiritcallerEntity.this.stuckTime = 0;
            SpiritcallerEntity.this.setFaking(false);
            SpiritcallerEntity.this.setArmsUpward(false);
            SpiritcallerEntity.this.setClap(false);
        }
    }

    class StealSoulsGoal
    extends Goal {
        StealSoulsGoal() {
        }

        public boolean m_8036_() {
            return SpiritcallerEntity.this.doesAttackMeetNormalRequirements() && (!SpiritcallerEntity.this.stolen_mobs.isEmpty() || SpiritcallerEntity.this.areStealableMobsNearby()) && SpiritcallerEntity.this.stealSoulsCooldown < 1 && SpiritcallerEntity.this.attackCooldown < 1;
        }

        public boolean m_8045_() {
            return SpiritcallerEntity.this.attackTicks <= 55;
        }

        public void m_8056_() {
            EntityUtil.mobFollowingSound(SpiritcallerEntity.this.m_9236_(), (Entity)SpiritcallerEntity.this, (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_SPIRITCALLER_STEALSPIRITS.get(), 2.0f, 1.0f, false);
            SpiritcallerEntity.this.setArmsUpward(true);
            SpiritcallerEntity.this.attackType = SpiritcallerEntity.this.SPIRIT_STEAL;
            List stealingMobs = SpiritcallerEntity.this.m_9236_().m_6443_(Mob.class, SpiritcallerEntity.this.m_20191_().m_82400_(15.0), predicate -> ((List)Config.CommonConfig.spiritcaller_stealableMobs.get()).contains(predicate.m_20078_()) && !predicate.m_20147_() && predicate != SpiritcallerEntity.this);
            if (!stealingMobs.isEmpty()) {
                for (int i = 0; i < stealingMobs.size(); ++i) {
                    LivingEntity mob = (LivingEntity)stealingMobs.get(i);
                    if (!mob.m_6084_()) {
                        stealingMobs.remove(i);
                        --i;
                    }
                    SpiritcallerEntity.this.stolen_mobs.add(mob);
                }
            }
            List hands = SpiritcallerEntity.this.m_9236_().m_6443_(SpiritHandEntity.class, SpiritcallerEntity.this.m_20191_().m_82400_(100.0), predicate -> predicate.getOwner() == SpiritcallerEntity.this);
            for (SpiritHandEntity hand : hands) {
                hand.m_6074_();
            }
        }

        public void m_8041_() {
            SpiritcallerEntity.this.setArmsUpward(false);
            SpiritcallerEntity.this.attackType = 0;
            SpiritcallerEntity.this.attackCooldown = 20;
            SpiritcallerEntity.this.stealSoulsCooldown = 900;
            if (!SpiritcallerEntity.this.stolen_mobs.isEmpty()) {
                for (LivingEntity entity : SpiritcallerEntity.this.stolen_mobs) {
                    if (SpiritcallerEntity.this.m_9236_().f_46443_) continue;
                    MobSpiritEntity spirit = (MobSpiritEntity)((EntityType)ModEntityTypes.MobSpirit.get()).m_20615_(SpiritcallerEntity.this.m_9236_());
                    assert (spirit != null);
                    spirit.m_6034_(entity.m_20185_(), entity.m_20186_() + 1.0, entity.m_20189_());
                    spirit.setOwner((LivingEntity)SpiritcallerEntity.this);
                    spirit.setOriginalMob(entity);
                    spirit.m_20334_(0.0, 0.5, 0.0);
                    spirit.m_6710_(SpiritcallerEntity.this.m_5448_());
                    if (SpiritcallerEntity.this.m_5647_() != null) {
                        SpiritcallerEntity.this.m_9236_().m_6188_().m_6546_(spirit.m_20149_(), SpiritcallerEntity.this.m_9236_().m_6188_().m_83489_(SpiritcallerEntity.this.m_5647_().m_5758_()));
                    }
                    spirit.setGoodOrEvil(!(entity instanceof Enemy));
                    if (entity instanceof SpiritcallerEntity) {
                        spirit.setSpiritcaller(true);
                    }
                    SpiritcallerEntity.this.m_9236_().m_7967_((Entity)spirit);
                    entity.m_20334_(0.0, 0.3, 0.0);
                    SpiritcallerEntity.this.spirits.add(spirit);
                }
            }
        }
    }

    class SoulSwarmGoal
    extends Goal {
        SoulSwarmGoal() {
        }

        public boolean m_8036_() {
            return SpiritcallerEntity.this.doesAttackMeetNormalRequirements() && SpiritcallerEntity.this.checkForStolenMobs() && SpiritcallerEntity.this.f_19796_.m_188503_(12) == 0 && SpiritcallerEntity.this.stealSoulsCooldown >= 0 && SpiritcallerEntity.this.spiritSwarmCooldown < 1 && SpiritcallerEntity.this.m_21223_() < SpiritcallerEntity.this.m_21233_() / 2.0f && SpiritcallerEntity.this.attackCooldown < 1;
        }

        public boolean m_8045_() {
            return SpiritcallerEntity.this.attackTicks <= 70;
        }

        public void m_8056_() {
            EntityUtil.mobFollowingSound(SpiritcallerEntity.this.m_9236_(), (Entity)SpiritcallerEntity.this, (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_SPIRITCALLER_SPIRITSWARM.get(), 2.0f, 1.0f, false);
            SpiritcallerEntity.this.setArmsUpward(true);
            SpiritcallerEntity.this.attackType = SpiritcallerEntity.this.SOUL_SWARM;
        }

        public void m_8041_() {
            SpiritcallerEntity.this.attackType = 0;
            SpiritcallerEntity.this.attackCooldown = 20;
            SpiritcallerEntity.this.spiritSwarmCooldown = 200;
            SpiritcallerEntity.this.setArmsUpward(false);
            if (SpiritcallerEntity.this.m_5448_() != null) {
                SpiritcallerEntity.this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_SPIRITCALLER_SOULSCREAM.get(), 3.0f, SpiritcallerEntity.this.m_6100_());
                LivingEntity entity = SpiritcallerEntity.this.m_5448_();
                double x = SpiritcallerEntity.this.m_20185_() - entity.m_20185_();
                double y = SpiritcallerEntity.this.m_20186_() - entity.m_20186_();
                double z = SpiritcallerEntity.this.m_20189_() - entity.m_20189_();
                double d = Math.sqrt(x * x + y * y + z * z);
                float power = 3.5f;
                double motionX = SpiritcallerEntity.this.m_20184_().f_82479_ - x / d * (double)power * 0.2;
                double motionY = SpiritcallerEntity.this.m_20184_().f_82480_ - y / d * (double)power * 0.2;
                double motionZ = SpiritcallerEntity.this.m_20184_().f_82481_ - z / d * (double)power * 0.2;
                SpiritcallerEntity.this.setTargetPosition(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
                SpiritcallerEntity.this.setCharge(motionX, motionY, motionZ);
            } else if (!SpiritcallerEntity.this.m_9236_().f_46443_) {
                SpiritcallerEntity.this.setFaking(false);
            }
            if (SpiritcallerEntity.this.getSoulPower() > 0) {
                SpiritcallerEntity.this.setSoulPower(SpiritcallerEntity.this.getSoulPower() - 1);
            }
        }
    }

    class ImpRiseGoal
    extends Goal {
        ImpRiseGoal() {
        }

        public boolean m_8036_() {
            return SpiritcallerEntity.this.doesAttackMeetNormalRequirements() && SpiritcallerEntity.this.checkForStolenMobs() && SpiritcallerEntity.this.f_19796_.m_188503_(8) == 0 && SpiritcallerEntity.this.stealSoulsCooldown >= 0 && SpiritcallerEntity.this.impRiseCooldown < 1 && SpiritcallerEntity.this.isTargetOnGround() && SpiritcallerEntity.this.attackCooldown < 1;
        }

        public boolean m_8045_() {
            return SpiritcallerEntity.this.attackTicks <= 150;
        }

        public void m_8056_() {
            SpiritcallerEntity.this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_SPIRITCALLER_IMPRISE.get(), 2.0f, 1.0f);
            SpiritcallerEntity.this.setArmsUpward(true);
            SpiritcallerEntity.this.attackType = SpiritcallerEntity.this.IMP_RISE;
        }

        public void m_8041_() {
            SpiritcallerEntity.this.attackType = 0;
            SpiritcallerEntity.this.attackCooldown = 20;
            SpiritcallerEntity.this.impRiseCooldown = 100;
            SpiritcallerEntity.this.setArmsUpward(false);
            SpiritcallerEntity.this.setClap(false);
            if (SpiritcallerEntity.this.getSoulPower() > 0) {
                SpiritcallerEntity.this.setSoulPower(SpiritcallerEntity.this.getSoulPower() - 1);
            }
        }
    }

    class SpiritHandsGoal
    extends Goal {
        SpiritHandsGoal() {
        }

        public boolean m_8036_() {
            return SpiritcallerEntity.this.doesAttackMeetNormalRequirements() && SpiritcallerEntity.this.checkForStolenMobs() && SpiritcallerEntity.this.f_19796_.m_188503_(8) == 0 && SpiritcallerEntity.this.stealSoulsCooldown >= 0 && SpiritcallerEntity.this.spiritHandsCooldown < 1 && SpiritcallerEntity.this.attackCooldown < 1;
        }

        public boolean m_8045_() {
            return SpiritcallerEntity.this.attackTicks <= 50;
        }

        public void m_8056_() {
            EntityUtil.mobFollowingSound(SpiritcallerEntity.this.m_9236_(), (Entity)SpiritcallerEntity.this, (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_SPIRITCALLER_SPIRITHANDS.get(), 2.0f, 1.0f, false);
            SpiritcallerEntity.this.setSpinning(true);
            SpiritcallerEntity.this.attackType = SpiritcallerEntity.this.SPIRIT_HANDS;
        }

        public void m_8041_() {
            SpiritcallerEntity.this.attackType = 0;
            SpiritcallerEntity.this.attackCooldown = 20;
            SpiritcallerEntity.this.spiritHandsCooldown = 900;
            SpiritcallerEntity.this.setClap(false);
            if (SpiritcallerEntity.this.getSoulPower() > 0) {
                SpiritcallerEntity.this.setSoulPower(SpiritcallerEntity.this.getSoulPower() - 1);
            }
        }
    }

    class SoulLaserGoal
    extends Goal {
        public SoulLaserGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return SpiritcallerEntity.this.doesAttackMeetNormalRequirements() && SpiritcallerEntity.this.checkForStolenMobs() && SpiritcallerEntity.this.f_19796_.m_188503_(8) == 0 && SpiritcallerEntity.this.stealSoulsCooldown >= 0 && SpiritcallerEntity.this.soulLaserCooldown < 1 && SpiritcallerEntity.this.attackCooldown < 1;
        }

        public boolean m_8045_() {
            return SpiritcallerEntity.this.attackTicks <= 140;
        }

        public void m_8056_() {
            EntityUtil.mobFollowingSound(SpiritcallerEntity.this.m_9236_(), (Entity)SpiritcallerEntity.this, (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_SPIRITCALLER_CHARGELASER.get(), 2.0f, 1.0f, false);
            SpiritcallerEntity.this.setChargingLaser(true);
            SpiritcallerEntity.this.attackType = SpiritcallerEntity.this.SOUL_LASER;
        }

        public void m_8041_() {
            SpiritcallerEntity.this.attackType = 0;
            SpiritcallerEntity.this.attackCooldown = 20;
            SpiritcallerEntity.this.soulLaserCooldown = 100;
            SpiritcallerEntity.this.setLaserPosition(0.0, 0.0, 0.0);
            SpiritcallerEntity.this.setShootingLaser(false);
            if (SpiritcallerEntity.this.getSoulPower() > 0) {
                SpiritcallerEntity.this.setSoulPower(SpiritcallerEntity.this.getSoulPower() - 1);
            }
        }
    }

    class AlwaysWatchTargetGoal
    extends Goal {
        public AlwaysWatchTargetGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            return SpiritcallerEntity.this.m_5448_() != null;
        }

        public boolean m_8045_() {
            return SpiritcallerEntity.this.m_5448_() != null;
        }

        public void m_8037_() {
            SpiritcallerEntity.this.m_21573_().m_26573_();
            if (SpiritcallerEntity.this.m_5448_() != null) {
                SpiritcallerEntity.this.m_21563_().m_24960_((Entity)SpiritcallerEntity.this.m_5448_(), 100.0f, 100.0f);
            }
            SpiritcallerEntity.this.f_21344_.m_26573_();
        }
    }
}

