/*
 * Decompiled with CFR 0.152.
 */
package com.yellowbrossproductions.illageandspillage.entities;

import com.yellowbrossproductions.illageandspillage.entities.CameraShakeEntity;
import com.yellowbrossproductions.illageandspillage.entities.IllagerAttack;
import com.yellowbrossproductions.illageandspillage.util.IllageAndSpillageSoundEvents;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

public class SpiritHandEntity
extends PathfinderMob
implements IllagerAttack {
    private static final EntityDataAccessor<Boolean> GOOD_OR_EVIL = SynchedEntityData.m_135353_(SpiritHandEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> ATTACK_TYPE = SynchedEntityData.m_135353_(SpiritHandEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private LivingEntity owner;
    private boolean attacking = false;
    private int attackTicks;
    private int actualAttackTicks;
    int power;
    double chargeX;
    double chargeY;
    double chargeZ;
    double targetX;
    double targetY;
    double targetZ;

    public SpiritHandEntity(EntityType<? extends PathfinderMob> p_33002_, Level p_33003_) {
        super(p_33002_, p_33003_);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new AlwaysWatchTargetGoal());
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 15.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, (double)0.35f).m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22277_, 50.0);
    }

    public boolean m_6097_() {
        return false;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(GOOD_OR_EVIL, (Object)true);
        this.f_19804_.m_135372_(ATTACK_TYPE, (Object)0);
    }

    public void m_7380_(CompoundTag p_21484_) {
        super.m_7380_(p_21484_);
        p_21484_.m_128379_("IsGoodOrEvil", this.isGoodOrEvil());
    }

    public void m_7378_(CompoundTag p_21450_) {
        super.m_7378_(p_21450_);
        this.setGoodOrEvil(p_21450_.m_128471_("IsGoodOrEvil"));
    }

    protected boolean m_8028_() {
        return true;
    }

    public void m_8119_() {
        this.f_19794_ = true;
        super.m_8119_();
        this.m_20242_(true);
        this.m_146922_(this.m_6080_());
        this.f_20883_ = this.m_146908_();
        this.m_20256_(this.m_20184_().m_82520_((-0.5 + this.f_19796_.m_188500_()) / 20.0, (-0.5 + this.f_19796_.m_188500_()) / 20.0, (-0.5 + this.f_19796_.m_188500_()) / 20.0));
        if (this.m_5448_() != null) {
            ++this.attackTicks;
            List list = this.m_9236_().m_6443_(SpiritHandEntity.class, this.m_20191_().m_82400_(100.0), SpiritHandEntity::isAttacking);
            if (this.attackTicks > 100 && this.actualAttackTicks < 1 && this.f_19796_.m_188503_(12) == 0) {
                if (list.isEmpty()) {
                    this.setAttacking(true);
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_SPIRITCALLER_SPIRITHAND_WARN.get(), 4.0f, this.m_6100_());
                    if (this.f_19796_.m_188499_()) {
                        if (!this.m_9236_().f_46443_) {
                            this.setAttackType(1);
                        }
                    } else if (!this.m_9236_().f_46443_) {
                        this.setAttackType(2);
                    }
                } else {
                    this.attackTicks = 0;
                }
            }
            if (this.isAttacking()) {
                ++this.actualAttackTicks;
                if (this.getAttackType() == 1) {
                    if (this.isGoodOrEvil()) {
                        if (this.actualAttackTicks < 100) {
                            LivingEntity entity = this.m_5448_();
                            double x = this.m_20185_() - entity.m_20185_();
                            double y = this.m_20186_() - (entity.m_20186_() - 0.3);
                            double z = this.m_20189_() - entity.m_20189_();
                            double d = Math.sqrt(x * x + y * y + z * z);
                            float power = 0.2f;
                            double motionX = this.m_20184_().f_82479_ - x / d * (double)power * 0.2;
                            double motionY = this.m_20184_().f_82480_ - y / d * (double)power * 0.2;
                            double motionZ = this.m_20184_().f_82481_ - z / d * (double)power * 0.2;
                            if (this.m_20280_((Entity)entity) > 1.5) {
                                this.m_20334_(motionX, motionY, motionZ);
                            } else {
                                this.m_20334_(this.m_20184_().f_82479_ / 2.0, this.m_20184_().f_82480_ / 2.0, this.m_20184_().f_82481_ / 2.0);
                            }
                        } else {
                            this.m_20334_(0.0, 0.5 + (double)(this.power / 8), 0.0);
                            for (LivingEntity entity : this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82400_(1.0))) {
                                entity.f_19864_ = true;
                                entity.m_20334_(entity.m_20184_().f_82479_, 0.5 + (double)(this.power / 8), entity.m_20184_().f_82481_);
                                entity.m_6001_(entity.m_20184_().f_82479_, 0.5 + (double)(this.power / 8), entity.m_20184_().f_82481_);
                            }
                            if (this.actualAttackTicks > 120 - this.power * 2) {
                                this.attackTicks = 0;
                                this.actualAttackTicks = 0;
                                this.setAttacking(false);
                                if (!this.m_9236_().f_46443_) {
                                    this.setAttackType(0);
                                }
                            }
                        }
                    } else if (this.actualAttackTicks < 100) {
                        LivingEntity entity = this.m_5448_();
                        double x = this.m_20185_() - entity.m_20185_();
                        double y = this.m_20186_() - (entity.m_20186_() + (double)entity.m_20192_() + 1.0 + (double)this.actualAttackTicks / 25.0);
                        double z = this.m_20189_() - entity.m_20189_();
                        double d = Math.sqrt(x * x + y * y + z * z);
                        float power = 0.2f;
                        double motionX = this.m_20184_().f_82479_ - x / d * (double)power * 0.2;
                        double motionY = this.m_20184_().f_82480_ - y / d * (double)power * 0.2;
                        double motionZ = this.m_20184_().f_82481_ - z / d * (double)power * 0.2;
                        if (this.m_20280_((Entity)entity) > 1.5) {
                            this.m_20334_(motionX, motionY, motionZ);
                        } else {
                            this.m_20334_(this.m_20184_().f_82479_ / 2.0, this.m_20184_().f_82480_ / 2.0, this.m_20184_().f_82481_ / 2.0);
                        }
                    } else {
                        this.m_20334_(0.0, -0.7 + (double)(this.power / 8), 0.0);
                        for (LivingEntity entity : this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82400_(1.0))) {
                            entity.f_19864_ = true;
                            entity.m_20334_(entity.m_20184_().f_82479_, -0.7 + (double)(this.power / 8), entity.m_20184_().f_82481_);
                            entity.m_6001_(entity.m_20184_().f_82479_, -0.7 + (double)(this.power / 8), entity.m_20184_().f_82481_);
                        }
                        if (this.actualAttackTicks > 120 - this.power * 2 || !this.m_9236_().m_8055_(this.m_20183_()).m_60795_()) {
                            this.attackTicks = 0;
                            this.actualAttackTicks = 0;
                            this.setAttacking(false);
                            if (!this.m_9236_().f_46443_) {
                                this.setAttackType(0);
                                CameraShakeEntity.cameraShake(this.m_9236_(), this.m_20182_(), 30.0f, 0.3f, 0, 15);
                                this.m_9236_().m_254849_((Entity)this.getOwner(), this.m_20185_(), this.m_20186_(), this.m_20189_(), 2.5f, Level.ExplosionInteraction.NONE);
                            }
                        }
                    }
                } else {
                    if (this.actualAttackTicks >= 100 && this.m_5448_() != null && this.targetX == 0.0 && this.targetY == 0.0 && this.targetZ == 0.0) {
                        LivingEntity entity = this.m_5448_();
                        double x = this.m_20185_() - entity.m_20185_();
                        double y = this.m_20186_() - entity.m_20186_();
                        double z = this.m_20189_() - entity.m_20189_();
                        double d = Math.sqrt(x * x + y * y + z * z);
                        float power = 6.0f;
                        double motionX = this.m_20184_().f_82479_ - x / d * (double)power * 0.2;
                        double motionY = this.m_20184_().f_82480_ - y / d * (double)power * 0.2;
                        double motionZ = this.m_20184_().f_82481_ - z / d * (double)power * 0.2;
                        this.setTargetPosition(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
                        this.setCharge(motionX, motionY, motionZ);
                    }
                    if (this.chargeX != 0.0 && this.chargeY != 0.0 && this.chargeZ != 0.0) {
                        this.m_20334_(this.chargeX, this.chargeY, this.chargeZ);
                        if (this.m_20185_() - this.targetX < 1.0 && this.m_20185_() - this.targetX > -1.0 && this.m_20186_() - this.targetY < 1.0 && this.m_20186_() - this.targetY > -1.0 && this.m_20189_() - this.targetZ < 1.0 && this.m_20189_() - this.targetZ > -1.0) {
                            this.actualAttackTicks = 141;
                        }
                    }
                    if (this.actualAttackTicks > 140) {
                        this.attackTicks = 0;
                        this.actualAttackTicks = 0;
                        this.setAttacking(false);
                        if (!this.m_9236_().f_46443_) {
                            this.setAttackType(0);
                            CameraShakeEntity.cameraShake(this.m_9236_(), this.m_20182_(), 30.0f, 0.3f, 0, 15);
                            this.m_9236_().m_254849_((Entity)this.getOwner(), this.m_20185_(), this.m_20186_(), this.m_20189_(), 2.5f, Level.ExplosionInteraction.NONE);
                        }
                        this.setCharge(0.0, 0.0, 0.0);
                        this.setTargetPosition(0.0, 0.0, 0.0);
                    }
                }
            }
        } else {
            this.attackTicks = 0;
            this.actualAttackTicks = 0;
            this.setAttacking(false);
            if (!this.m_9236_().f_46443_) {
                this.setAttackType(0);
            }
        }
        if (this.getOwner() instanceof Mob) {
            this.m_6710_(((Mob)this.getOwner()).m_5448_());
        }
        if (this.m_9236_().m_8055_(this.m_20183_().m_7495_()) != Blocks.f_50016_.m_49966_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, 0.01, 0.0));
        } else if (this.m_20184_().f_82480_ > 0.0) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.01, 0.0));
        }
        if (this.f_19797_ > 600) {
            this.m_6074_();
        }
        this.stopAttackersFromAttacking();
    }

    public void stopAttackersFromAttacking() {
        List list = this.m_9236_().m_45976_(Mob.class, this.m_20191_().m_82400_(100.0));
        for (Mob attacker : list) {
            if (attacker.m_21188_() == this && this.getOwner() != null) {
                attacker.m_6703_(this.getOwner());
            }
            if (attacker.m_5448_() != this || this.getOwner() == null) continue;
            attacker.m_6710_(this.getOwner());
        }
    }

    public boolean m_7327_(Entity p_21372_) {
        return false;
    }

    public void setOwner(LivingEntity owner) {
        this.owner = owner;
    }

    @Override
    public LivingEntity getOwner() {
        return this.owner;
    }

    public void setPower(int power) {
        this.power = power;
    }

    public boolean m_21532_() {
        return true;
    }

    public boolean isGoodOrEvil() {
        return (Boolean)this.f_19804_.m_135370_(GOOD_OR_EVIL);
    }

    public void setGoodOrEvil(boolean goodOrEvil) {
        this.f_19804_.m_135381_(GOOD_OR_EVIL, (Object)goodOrEvil);
    }

    public void setCharge(double x, double y, double z) {
        this.chargeX = x;
        this.chargeY = y;
        this.chargeZ = z;
    }

    public void setTargetPosition(double x, double y, double z) {
        this.targetX = x;
        this.targetY = y;
        this.targetZ = z;
    }

    protected SoundEvent m_7975_(DamageSource p_33034_) {
        return null;
    }

    public boolean m_7337_(Entity entity) {
        return false;
    }

    public boolean m_5829_() {
        return false;
    }

    public boolean m_6087_() {
        return false;
    }

    protected void m_7324_(Entity entityIn) {
    }

    public void m_7334_(Entity entityIn) {
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return (source.m_276093_(DamageTypes.f_268724_) || source.m_276093_(DamageTypes.f_286979_)) && super.m_6469_(source, amount);
    }

    protected SoundEvent m_5592_() {
        return null;
    }

    public boolean isAttacking() {
        return this.attacking;
    }

    public void setAttacking(boolean attacking) {
        this.attacking = attacking;
    }

    public int getAttackType() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_TYPE);
    }

    public void setAttackType(int a) {
        this.f_19804_.m_135381_(ATTACK_TYPE, (Object)a);
    }

    public void m_7822_(byte p_21375_) {
        if (p_21375_ != 60) {
            super.m_7822_(p_21375_);
        }
    }

    class AlwaysWatchTargetGoal
    extends Goal {
        public AlwaysWatchTargetGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            return SpiritHandEntity.this.m_5448_() != null;
        }

        public boolean m_8045_() {
            return SpiritHandEntity.this.m_5448_() != null;
        }

        public void m_8037_() {
            SpiritHandEntity.this.m_21573_().m_26573_();
            if (SpiritHandEntity.this.m_5448_() != null && SpiritHandEntity.this.actualAttackTicks < 100) {
                SpiritHandEntity.this.m_21563_().m_24960_((Entity)SpiritHandEntity.this.m_5448_(), 100.0f, 100.0f);
            }
            if (SpiritHandEntity.this.actualAttackTicks >= 100) {
                SpiritHandEntity.this.m_21563_().m_24950_(SpiritHandEntity.this.targetX, SpiritHandEntity.this.targetY, SpiritHandEntity.this.targetZ, 100.0f, 100.0f);
            }
            SpiritHandEntity.this.f_21344_.m_26573_();
        }
    }
}

