/*
 * Decompiled with CFR 0.152.
 */
package com.yellowbrossproductions.illageandspillage.entities;

import com.yellowbrossproductions.illageandspillage.Config;
import com.yellowbrossproductions.illageandspillage.client.model.animation.ICanBeAnimated;
import com.yellowbrossproductions.illageandspillage.client.sound.BossMusicPlayer;
import com.yellowbrossproductions.illageandspillage.entities.CameraShakeEntity;
import com.yellowbrossproductions.illageandspillage.entities.CrashagerEntity;
import com.yellowbrossproductions.illageandspillage.entities.CrocofangEntity;
import com.yellowbrossproductions.illageandspillage.entities.DispenserEntity;
import com.yellowbrossproductions.illageandspillage.entities.FakeMagispellerEntity;
import com.yellowbrossproductions.illageandspillage.entities.KaboomerEntity;
import com.yellowbrossproductions.illageandspillage.entities.MagiHealEntity;
import com.yellowbrossproductions.illageandspillage.entities.goal.MeleeButStopGoal;
import com.yellowbrossproductions.illageandspillage.entities.goal.StareAtDeadMagiGoal;
import com.yellowbrossproductions.illageandspillage.entities.projectile.MagiArrowEntity;
import com.yellowbrossproductions.illageandspillage.entities.projectile.MagiFireballEntity;
import com.yellowbrossproductions.illageandspillage.init.ModEntityTypes;
import com.yellowbrossproductions.illageandspillage.packet.PacketHandler;
import com.yellowbrossproductions.illageandspillage.packet.ParticlePacket;
import com.yellowbrossproductions.illageandspillage.util.EntityUtil;
import com.yellowbrossproductions.illageandspillage.util.IllageAndSpillageSoundEvents;
import com.yellowbrossproductions.illageandspillage.util.ItemRegisterer;
import com.yellowbrossproductions.illageandspillage.util.ModTags;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.EvokerFangs;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.network.PacketDistributor;

public class MagispellerEntity
extends AbstractIllager
implements ICanBeAnimated {
    public ServerBossEvent bossEvent;
    private static final EntityDataAccessor<Boolean> NEARBY_ILLAGERS = SynchedEntityData.m_135353_(MagispellerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SHOULD_DELETE_ITSELF = SynchedEntityData.m_135353_(MagispellerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> ACTIVE = SynchedEntityData.m_135353_(MagispellerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SHOW_ARMS = SynchedEntityData.m_135353_(MagispellerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> GLOW_STATE = SynchedEntityData.m_135353_(MagispellerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SHAKE_AMOUNT = SynchedEntityData.m_135353_(MagispellerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> FAKING = SynchedEntityData.m_135353_(MagispellerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> ARROW_STATE = SynchedEntityData.m_135353_(MagispellerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> WAVING_ARMS = SynchedEntityData.m_135353_(MagispellerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> BALLOON = SynchedEntityData.m_135353_(MagispellerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DEATH = SynchedEntityData.m_135353_(MagispellerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> ANIMATION_STATE = SynchedEntityData.m_135353_(MagispellerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ATTACK_TYPE = SynchedEntityData.m_135353_(MagispellerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ATTACK_TICKS = SynchedEntityData.m_135353_(MagispellerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public AnimationState fireballAnimationState = new AnimationState();
    public AnimationState lifestealAnimationState = new AnimationState();
    public AnimationState fakersAnimationState = new AnimationState();
    public AnimationState vexesAnimationState = new AnimationState();
    public AnimationState fangrunAnimationState = new AnimationState();
    public AnimationState potionsAnimationState = new AnimationState();
    public AnimationState crossbowspinAnimationState = new AnimationState();
    public AnimationState crashagerAnimationState = new AnimationState();
    public AnimationState dispenserAnimationState = new AnimationState();
    public AnimationState knockbackAnimationState = new AnimationState();
    public AnimationState kaboomerAnimationState = new AnimationState();
    public AnimationState deathAnimationState = new AnimationState();
    private int fireballCooldown;
    private int lifestealCooldown;
    private int fakersCooldown;
    private int vexesCooldown;
    private int fangrunCooldown;
    private int throwPotionsCooldown;
    private int crossbowSpinCooldown;
    private int crashagerCooldown;
    private int dispenserCooldown;
    private int healCooldown;
    private int kaboomerCooldown;
    private final int FIREBALL_ATTACK = 1;
    private final int LIFESTEAL_ATTACK = 2;
    private final int FAKERS_ATTACK = 3;
    private final int VEXES_ATTACK = 4;
    private final int FANGRUN_ATTACK = 5;
    private final int POTIONS_ATTACK = 6;
    private final int CROSSBOWSPIN_ATTACK = 7;
    private final int CRASHAGER_ATTACK = 8;
    private final int DISPENSER_ATTACK = 9;
    private final int HEAL_ATTACK = 10;
    private final int KNOCKBACK_ATTACK = 11;
    private final int KABOOMER_ATTACK = 12;
    private MagiFireballEntity fireball = null;
    private int pullPower;
    private final List<FakeMagispellerEntity> clones = new ArrayList<FakeMagispellerEntity>();
    private int waitTimeFaker;
    private int spinDirection;
    private float damageTaken;
    private boolean gotHealed;
    private int balloonCooldown;
    private Entity mobToLaughAt;
    public int customDeathTime;
    private ItemEntity totem = null;
    private DamageSource lastDamageSource;
    private boolean shouldDropDisc = false;

    public MagispellerEntity(EntityType<? extends AbstractIllager> p_i48556_1_, Level p_i48556_2_) {
        super(p_i48556_1_, p_i48556_2_);
        this.f_21364_ = 100;
        this.bossEvent = (ServerBossEvent)new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.PROGRESS).m_7003_(((Boolean)Config.CommonConfig.bosses_darken_sky.get()).booleanValue());
        this.bossEvent.m_8321_(false);
        this.m_21051_(Attributes.f_22276_).m_22100_(((Double)Config.CommonConfig.magispeller_health.get()).doubleValue());
        this.m_5634_(Float.MAX_VALUE);
    }

    public void m_6457_(ServerPlayer p_20119_) {
        super.m_6457_(p_20119_);
        this.bossEvent.m_6543_(p_20119_);
    }

    public void m_6452_(ServerPlayer p_20119_) {
        super.m_6452_(p_20119_);
        this.bossEvent.m_6539_(p_20119_);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new KaboomerGoal());
        this.f_21345_.m_25352_(0, (Goal)new HealGoal());
        this.f_21345_.m_25352_(0, (Goal)new DispenserGoal());
        this.f_21345_.m_25352_(0, (Goal)new CrashagerGoal());
        this.f_21345_.m_25352_(0, (Goal)new CrossbowSpinGoal());
        this.f_21345_.m_25352_(0, (Goal)new ThrowPotionsGoal());
        this.f_21345_.m_25352_(0, (Goal)new FangRunGoal());
        this.f_21345_.m_25352_(0, (Goal)new SummonVexesGoal());
        this.f_21345_.m_25352_(0, (Goal)new FakersGoal());
        this.f_21345_.m_25352_(0, (Goal)new LifestealGoal());
        this.f_21345_.m_25352_(0, (Goal)new ShootFireballGoal());
        this.f_21345_.m_25352_(0, (Goal)new KnockbackGoal());
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new StareAtTargetGoal());
        this.f_21345_.m_25352_(2, (Goal)new Raider.HoldGroundAttackGoal((Raider)this, (AbstractIllager)this, 10.0f));
        this.f_21345_.m_25352_(3, (Goal)new MeleeButStopGoal((PathfinderMob)this, 1.0, false, 10.0));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 15.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, (double)0.35f).m_22268_(Attributes.f_22276_, 1.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22277_, 96.0);
    }

    protected void m_8024_() {
        super.m_8024_();
        this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
        LivingEntity entity = this.m_5448_();
        if (this.isFaking() && this.f_19796_.m_188503_(10) == 0 && entity != null && this.m_20280_((Entity)entity) > 1024.0) {
            this.teleportTowards((Entity)entity);
        }
    }

    public boolean m_142535_(float p_225503_1_, float p_225503_2_, DamageSource p_147189_) {
        return !this.isFaking() && super.m_142535_(p_225503_1_, p_225503_2_, p_147189_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(NEARBY_ILLAGERS, (Object)false);
        this.f_19804_.m_135372_(SHOULD_DELETE_ITSELF, (Object)false);
        this.f_19804_.m_135372_(ACTIVE, (Object)false);
        this.f_19804_.m_135372_(ANIMATION_STATE, (Object)0);
        this.f_19804_.m_135372_(ATTACK_TYPE, (Object)0);
        this.f_19804_.m_135372_(ATTACK_TICKS, (Object)0);
        this.f_19804_.m_135372_(SHOW_ARMS, (Object)false);
        this.f_19804_.m_135372_(GLOW_STATE, (Object)0);
        this.f_19804_.m_135372_(SHAKE_AMOUNT, (Object)0);
        this.f_19804_.m_135372_(FAKING, (Object)false);
        this.f_19804_.m_135372_(ARROW_STATE, (Object)0);
        this.f_19804_.m_135372_(WAVING_ARMS, (Object)false);
        this.f_19804_.m_135372_(BALLOON, (Object)false);
        this.f_19804_.m_135372_(DEATH, (Object)false);
    }

    public boolean m_6779_(LivingEntity p_213336_1_) {
        return !this.areIllagersNearby() && super.m_6779_(p_213336_1_);
    }

    public int getGlowState() {
        return (Integer)this.f_19804_.m_135370_(GLOW_STATE);
    }

    public void setGlowState(int glowState) {
        this.f_19804_.m_135381_(GLOW_STATE, (Object)glowState);
    }

    public int getShakeAmount() {
        return (Integer)this.f_19804_.m_135370_(SHAKE_AMOUNT);
    }

    public void setShakeAmount(int shake) {
        this.f_19804_.m_135381_(SHAKE_AMOUNT, (Object)shake);
    }

    public int getAttackType() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_TYPE);
    }

    public void setAttackType(int attackType) {
        this.f_19804_.m_135381_(ATTACK_TYPE, (Object)attackType);
    }

    public int getAttackTicks() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_TICKS);
    }

    public void setAttackTicks(int attackTicks) {
        this.f_19804_.m_135381_(ATTACK_TICKS, (Object)attackTicks);
    }

    public boolean isFaking() {
        return (Boolean)this.f_19804_.m_135370_(FAKING);
    }

    public void setFaking(boolean faking) {
        this.f_19804_.m_135381_(FAKING, (Object)faking);
    }

    public int getArrowState() {
        return (Integer)this.f_19804_.m_135370_(ARROW_STATE);
    }

    public void setArrowState(int arrow) {
        this.f_19804_.m_135381_(ARROW_STATE, (Object)arrow);
    }

    public boolean isCustomDeath() {
        return (Boolean)this.f_19804_.m_135370_(DEATH);
    }

    public void setCustomDeath(boolean death) {
        this.f_19804_.m_135381_(DEATH, (Object)death);
    }

    public void m_7380_(CompoundTag p_213281_1_) {
        super.m_7380_(p_213281_1_);
        if (this.isActive()) {
            p_213281_1_.m_128379_("active", true);
        }
        if (this.isBalloon()) {
            p_213281_1_.m_128379_("IsBalloon", true);
        }
    }

    public void m_7378_(CompoundTag p_70037_1_) {
        super.m_7378_(p_70037_1_);
        this.bossEvent.m_6456_(this.m_5446_());
        this.setActive(p_70037_1_.m_128471_("active"));
        this.setBalloon(p_70037_1_.m_128471_("IsBalloon"));
    }

    public void m_21153_(float p_21154_) {
        float healthValue = p_21154_ - this.m_21223_();
        if (healthValue > 0.0f || !this.areIllagersNearby() && this.isActive() || healthValue <= -1.0E12f) {
            if (healthValue < -20.0f && healthValue > -1.0E12f) {
                p_21154_ = this.m_21223_() - 20.0f;
            }
            super.m_21153_(p_21154_);
        }
    }

    public void m_7895_(int p_213660_1_, boolean p_213660_2_) {
    }

    protected float m_6431_(Pose p_213348_1_, EntityDimensions p_213348_2_) {
        return 1.66f;
    }

    public SoundEvent getBossMusic() {
        return (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_MAGISPELLER_MUSIC.get();
    }

    protected boolean canPlayMusic() {
        return !this.m_20067_() && this.m_5448_() instanceof Player && this.m_5448_() != null;
    }

    public boolean canPlayerHearMusic(Player player) {
        return player != null && this.m_6779_((LivingEntity)player) && this.m_20270_((Entity)player) < 2500.0f;
    }

    public void m_7822_(byte id) {
        if (id == 67) {
            BossMusicPlayer.playBossMusic((Raider)this);
        } else if (id == 68) {
            BossMusicPlayer.stopBossMusic((Raider)this);
        } else {
            super.m_7822_(id);
        }
    }

    public void m_8119_() {
        double z;
        double y;
        float f1;
        LivingEntity entity;
        List list = this.m_9236_().m_6443_(Raider.class, this.m_20191_().m_82400_(100.0), predicate -> predicate.m_37886_() && !predicate.m_6095_().m_204039_(ModTags.EntityTypes.ILLAGER_BOSSES));
        if (((Boolean)Config.CommonConfig.magispeller_forcefield.get()).booleanValue() && this.m_37886_()) {
            if (!this.m_9236_().f_46443_) {
                this.setIllagersNearby(!list.isEmpty());
            }
            if (this.areIllagersNearby()) {
                this.m_6710_(null);
            }
        }
        if (this.m_37886_() && this.m_37885_() != null && this.m_37885_().m_37771_() == 7 && this.shouldRemoveItself() && ((Boolean)Config.CommonConfig.magispeller_onlyOneAllowed.get()).booleanValue()) {
            this.m_37885_().m_37740_((Raider)this, true);
            if (!this.m_9236_().f_46443_) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
        if (EntityUtil.displayBossBar((Raider)this) && this.isActive() && !this.bossEvent.m_8323_()) {
            this.bossEvent.m_8321_(true);
        } else if (this.bossEvent.m_8323_()) {
            this.bossEvent.m_8321_(false);
        }
        if (!this.m_9236_().f_46443_ && this.isActive() && this.getBossMusic() != null) {
            if (this.canPlayMusic()) {
                this.m_9236_().m_7605_((Entity)this, (byte)67);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)68);
            }
        }
        if (this.getAttackType() > 0) {
            this.setAttackTicks(this.getAttackTicks() + 1);
        } else {
            this.setAttackTicks(0);
        }
        if (this.getAttackType() == 0) {
            if (this.fireballCooldown > 0) {
                --this.fireballCooldown;
            }
            if (this.lifestealCooldown > 0) {
                --this.lifestealCooldown;
            }
            if (this.fakersCooldown > 0 && !this.isFaking()) {
                --this.fakersCooldown;
            }
            if (this.vexesCooldown > 0) {
                --this.vexesCooldown;
            }
            if (this.fangrunCooldown > 0) {
                --this.fangrunCooldown;
            }
            if (this.throwPotionsCooldown > 0) {
                --this.throwPotionsCooldown;
            }
            if (this.crossbowSpinCooldown > 0) {
                --this.crossbowSpinCooldown;
            }
            if (this.crashagerCooldown > 0 && !this.isRidingIllusion()) {
                --this.crashagerCooldown;
            }
            if (this.dispenserCooldown > 0) {
                --this.dispenserCooldown;
            }
            if (this.kaboomerCooldown > 0 && !this.isRidingIllusion()) {
                --this.kaboomerCooldown;
            }
        }
        if (this.healCooldown > 0) {
            --this.healCooldown;
        }
        if (this.waitTimeFaker > 0) {
            --this.waitTimeFaker;
        }
        if (this.balloonCooldown > 0) {
            --this.balloonCooldown;
        }
        if (this.m_5448_() == null && !this.clones.isEmpty()) {
            for (FakeMagispellerEntity clone : this.clones) {
                clone.m_6074_();
            }
        }
        if (this.isFaking() && this.clones.isEmpty() && !this.m_9236_().f_46443_) {
            this.setFaking(false);
        }
        this.updateCloneList();
        if (this.m_6084_()) {
            double motionZ;
            double motionY;
            double motionX;
            float power;
            double d;
            if (this.getAttackType() == this.FIREBALL_ATTACK) {
                entity = this.m_5448_();
                if (this.getAttackTicks() == 8) {
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_MAGISPELLER_FIREBALL_START.get(), 2.0f, 1.0f);
                    this.makeFireParticles();
                    CameraShakeEntity.cameraShake(this.m_9236_(), this.m_20182_(), 30.0f, 0.3f, 0, 15);
                    if (!this.m_9236_().f_46443_) {
                        this.setGlowState(1);
                    }
                    this.m_21559_(true);
                }
                if (this.getAttackTicks() == 14) {
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_MAGISPELLER_FIREBALL.get(), 2.0f, 1.0f);
                    if (!this.m_9236_().f_46443_) {
                        this.fireball = new MagiFireballEntity((EntityType<? extends LargeFireball>)((EntityType)ModEntityTypes.MagiFireball.get()), this.m_9236_());
                        this.m_9236_().m_7967_((Entity)this.fireball);
                    }
                }
                if (this.fireball != null && this.getAttackTicks() < 58) {
                    f1 = 1.1f;
                    double x = this.m_20185_() + (double)0.8f * Math.sin((double)(-this.m_146908_()) * Math.PI / 180.0) + (double)f1 * Math.sin((double)(-this.f_20885_) * Math.PI / 180.0) * Math.cos((double)(-this.m_146909_()) * Math.PI / 180.0);
                    y = this.m_20186_() + 1.3 + (double)f1 * Math.sin((double)(-this.m_146909_()) * Math.PI / 180.0);
                    z = this.m_20189_() + (double)0.8f * Math.cos((double)(-this.m_146908_()) * Math.PI / 180.0) + (double)f1 * Math.cos((double)(-this.f_20885_) * Math.PI / 180.0) * Math.cos((double)(-this.m_146909_()) * Math.PI / 180.0);
                    this.fireball.f_19864_ = true;
                    this.fireball.m_6034_(x, y, z);
                    this.fireball.setMagispeller((LivingEntity)this);
                }
                if (this.getAttackTicks() == 55) {
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_MAGISPELLER_SWING_BAT.get(), 2.0f, 1.0f);
                }
                if (this.getAttackTicks() == 58) {
                    this.makeFireParticles();
                    if (!this.m_9236_().f_46443_) {
                        this.setGlowState(0);
                    }
                    if (this.fireball != null && entity != null) {
                        this.fireball.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 0.0f);
                    }
                }
            }
            if (this.getAttackType() == this.LIFESTEAL_ATTACK) {
                if (this.getAttackTicks() < 30) {
                    this.makeLifestealParticles1();
                    if (!this.m_9236_().f_46443_) {
                        this.setGlowState(this.f_19796_.m_188499_() ? 0 : 2);
                    }
                }
                if (this.getAttackTicks() == 31) {
                    if (!this.m_9236_().f_46443_) {
                        this.setGlowState(2);
                    }
                    this.pullPower = 0;
                }
                if (this.getAttackTicks() == 36) {
                    EntityUtil.mobFollowingSound(this.m_9236_(), (Entity)this, (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_MAGISPELLER_LIFESTEAL.get(), 2.0f, 1.0f, false);
                }
                if (this.getAttackTicks() >= 36) {
                    ++this.pullPower;
                    if (!this.m_9236_().f_46443_ && this.getAttackTicks() % 3 == 1) {
                        this.setShakeAmount(this.getShakeAmount() + 1);
                    }
                    this.makeLifestealParticles3();
                    for (Entity entity1 : this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82400_(15.0))) {
                        if (!EntityUtil.canHurtThisMob(entity1, (Mob)this) || !entity1.m_6084_() || !this.isMobNotInCreativeMode(entity1)) continue;
                        double x = this.m_20185_() - entity1.m_20185_();
                        y = this.m_20186_() - entity1.m_20186_();
                        z = this.m_20189_() - entity1.m_20189_();
                        d = Math.sqrt(x * x + y * y + z * z);
                        power = (float)this.pullPower / 103.0f;
                        motionX = entity1.m_20184_().f_82479_ + x / d * (double)power * 0.2;
                        motionY = entity1.m_20184_().f_82480_ + y / d * (double)power * 0.2;
                        motionZ = entity1.m_20184_().f_82481_ + z / d * (double)power * 0.2;
                        entity1.f_19864_ = true;
                        entity1.m_20334_(motionX, motionY, motionZ);
                        entity1.m_6001_(motionX, motionY, motionZ);
                        this.makeLifestealParticles2(entity1);
                        if (!(this.m_20280_(entity1) < 9.0) || !(entity1 instanceof LivingEntity)) continue;
                        if (((LivingEntity)entity1).f_20916_ <= 0 && !entity1.m_20147_()) {
                            float healthStolen = (((LivingEntity)entity1).m_21233_() - ((LivingEntity)entity1).m_21223_()) / 3.0f + 1.0f;
                            healthStolen = Math.min(healthStolen, 10.0f);
                            healthStolen = (Boolean)Config.CommonConfig.nightmare_mode.get() != false ? (float)((double)healthStolen * (Double)Config.CommonConfig.magi_damage_multiplier.get()) : healthStolen;
                            this.m_5634_(healthStolen);
                            entity1.m_6469_(this.m_269291_().m_269104_((Entity)this, (Entity)this), healthStolen);
                        }
                        entity1.f_19864_ = true;
                        entity1.m_20334_(-x / d * 2.0, -y / d * 2.0, -z / d * 2.0);
                        entity1.m_6001_(-x / d * 2.0, -y / d * 2.0, -z / d * 2.0);
                    }
                }
            }
            if (this.getAttackType() == this.FAKERS_ATTACK) {
                if (this.getAttackTicks() < 43) {
                    if (!this.m_9236_().f_46443_ && this.getAttackTicks() % 3 == 1) {
                        this.setShakeAmount(this.getShakeAmount() + 1);
                    }
                    this.makeFakerParticles();
                } else if (this.getAttackTicks() <= 48) {
                    if (!this.m_9236_().f_46443_) {
                        this.setShakeAmount(this.getShakeAmount() / 5);
                    }
                } else if (this.getAttackTicks() == 49 && !this.m_9236_().f_46443_) {
                    this.setShakeAmount(0);
                }
                if (this.getAttackTicks() == 16 && !this.m_9236_().f_46443_) {
                    this.setGlowState(3);
                }
            }
            if (this.getAttackType() == this.VEXES_ATTACK && this.getAttackTicks() == 20) {
                this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_MAGISPELLER_CAST_SPELL.get(), 1.0f, 1.0f);
                if (!this.m_9236_().f_46443_) {
                    ServerLevel serverworld = (ServerLevel)this.m_9236_();
                    BlockPos blockpos = this.m_20183_();
                    for (int i = 0; i < 5; ++i) {
                        Vex vex = (Vex)EntityType.f_20491_.m_20615_(this.m_9236_());
                        assert (vex != null);
                        vex.m_6034_(this.m_20185_(), this.m_20186_() + 3.0, this.m_20189_());
                        vex.m_6518_((ServerLevelAccessor)serverworld, this.m_9236_().m_6436_(blockpos), MobSpawnType.MOB_SUMMONED, null, null);
                        vex.m_6710_(this.m_5448_());
                        if (this.m_5647_() != null) {
                            this.m_9236_().m_6188_().m_6546_(vex.m_20149_(), this.m_9236_().m_6188_().m_83489_(this.m_5647_().m_5758_()));
                        }
                        Objects.requireNonNull(vex.m_21051_(Attributes.f_22276_)).m_22100_(2.0);
                        vex.m_33987_(100);
                        vex.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                        vex.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
                        this.m_9236_().m_7967_((Entity)vex);
                    }
                }
            }
            if (this.getAttackType() == this.FANGRUN_ATTACK) {
                Entity entity1;
                if (this.getAttackTicks() >= 6 && this.getAttackTicks() < 49) {
                    if (this.getShakeAmount() > 0 && !this.m_9236_().f_46443_) {
                        this.setShakeAmount(this.getShakeAmount() - 1);
                    }
                    this.createFangs(false);
                    if (this.getAttackTicks() == 6) {
                        this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_MAGISPELLER_FANGRUN_START.get(), 1.0f, 1.0f);
                        EntityUtil.mobFollowingSound(this.m_9236_(), (Entity)this, (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_MAGISPELLER_FANGRUN.get(), 2.0f, 1.0f, false);
                        this.makeFangRunParticles();
                        CameraShakeEntity.cameraShake(this.m_9236_(), this.m_20182_(), 30.0f, 0.3f, 0, 20);
                        if (!this.m_9236_().f_46443_) {
                            this.setGlowState(4);
                        }
                        for (Entity value : this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82400_(15.0))) {
                            entity1 = value;
                            if (!EntityUtil.canHurtThisMob(entity1, (Mob)this) || !entity1.m_6084_()) continue;
                            double x = this.m_20185_() - entity1.m_20185_();
                            y = this.m_20186_() - entity1.m_20186_();
                            z = this.m_20189_() - entity1.m_20189_();
                            d = Math.sqrt(x * x + y * y + z * z);
                            if (!(this.m_20280_(entity1) < 9.0)) continue;
                            entity1.f_19864_ = true;
                            entity1.m_20334_(-x / d * 3.0, -y / d * 0.5, -z / d * 3.0);
                            entity1.m_6001_(-x / d * 3.0, -y / d * 0.5, -z / d * 3.0);
                        }
                    }
                }
                if (this.getAttackTicks() >= 49) {
                    this.createFangs(true);
                    this.m_5496_(SoundEvents.f_11865_, 1.0f, this.m_6100_());
                    for (Entity value : this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82400_(15.0))) {
                        entity1 = value;
                        if (!EntityUtil.canHurtThisMob(entity1, (Mob)this) || !entity1.m_6084_()) continue;
                        double x = this.m_20185_() - entity1.m_20185_();
                        y = this.m_20186_() - entity1.m_20186_();
                        z = this.m_20189_() - entity1.m_20189_();
                        d = Math.sqrt(x * x + y * y + z * z);
                        if (!(this.m_20280_(entity1) < 9.0)) continue;
                        entity1.f_19864_ = true;
                        entity1.m_20334_(-x / d * 3.0, -y / d * 0.5, -z / d * 3.0);
                        entity1.m_6001_(-x / d * 3.0, -y / d * 0.5, -z / d * 3.0);
                    }
                }
            }
            if (this.getAttackType() == this.POTIONS_ATTACK) {
                if (this.getAttackTicks() == 10) {
                    EntityUtil.mobFollowingSound(this.m_9236_(), (Entity)this, (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_MAGISPELLER_POTIONS.get(), 2.0f, 1.0f, false);
                }
                if (this.getAttackTicks() > 22) {
                    for (int i = 0; i < 2; ++i) {
                        if (this.m_9236_().f_46443_) continue;
                        ThrownPotion potionentity = new ThrownPotion(this.m_9236_(), (LivingEntity)this);
                        potionentity.m_37446_(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42736_), (Potion)Potions.f_43617_));
                        potionentity.m_146926_(-20.0f);
                        potionentity.m_6686_(-2.0 + this.f_19796_.m_188500_() + this.f_19796_.m_188500_() + this.f_19796_.m_188500_() + this.f_19796_.m_188500_(), 5.0 + this.f_19796_.m_188500_() + this.f_19796_.m_188500_(), -2.0 + this.f_19796_.m_188500_() + this.f_19796_.m_188500_() + this.f_19796_.m_188500_() + this.f_19796_.m_188500_(), 0.75f, 8.0f);
                        potionentity.m_20256_(potionentity.m_20184_().m_82520_(0.0, 0.5, 0.0));
                        this.m_9236_().m_7967_((Entity)potionentity);
                    }
                }
                if (this.getAttackTicks() >= 10) {
                    this.makePotionParticles();
                }
            }
            if (this.getAttackType() == this.CROSSBOWSPIN_ATTACK) {
                if (this.getAttackTicks() <= 12) {
                    for (int i = 0; i < 5; ++i) {
                        if (this.m_9236_().f_46443_) continue;
                        MagiArrowEntity arrow = new MagiArrowEntity(this.m_9236_(), (LivingEntity)this);
                        arrow.m_6034_(this.m_20185_(), this.m_20186_() + 2.0, this.m_20189_());
                        arrow.f_19794_ = true;
                        arrow.m_20242_(true);
                        arrow.m_20334_((-0.5 + this.f_19796_.m_188500_()) * 0.6, 0.5, (-0.5 + this.f_19796_.m_188500_()) * 0.6);
                        arrow.m_5602_((Entity)this);
                        this.m_9236_().m_7967_((Entity)arrow);
                    }
                } else if (this.getAttackTicks() <= 41) {
                    for (MagiArrowEntity arrow : this.m_9236_().m_45976_(MagiArrowEntity.class, this.m_20191_().m_82400_(50.0))) {
                        if (!arrow.m_36797_() || arrow.m_19749_() != this) continue;
                        double x = this.m_20185_() - arrow.m_20185_();
                        y = this.m_20186_() - arrow.m_20186_();
                        z = this.m_20189_() - arrow.m_20189_();
                        d = Math.sqrt(x * x + y * y + z * z);
                        power = 2.0f;
                        motionX = x / d * (double)power * 0.2;
                        motionY = y / d * (double)power * 0.2;
                        motionZ = z / d * (double)power * 0.2;
                        arrow.m_20334_(motionX, motionY, motionZ);
                        this.makeArrowParticles((Entity)arrow);
                        if (!(this.m_20280_((Entity)arrow) < 2.0)) continue;
                        arrow.m_146870_();
                        this.m_5496_(SoundEvents.f_11841_, 2.0f, this.m_6100_());
                    }
                }
                if (this.getAttackTicks() == 41) {
                    this.setAnimationState(0);
                    if (this.m_5448_() != null) {
                        EntityUtil.mobFollowingSound(this.m_9236_(), (Entity)this, (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_MAGISPELLER_SPIN.get(), 1.0f, 1.0f, false);
                        if (!this.m_9236_().f_46443_) {
                            this.setArrowState(1);
                        }
                        if (!this.m_9236_().f_46443_) {
                            this.m_20334_((this.m_5448_().m_20185_() - this.m_20185_()) * 2.0 * 0.16, 0.5, (this.m_5448_().m_20189_() - this.m_20189_()) * 2.0 * 0.16);
                        }
                    }
                }
                if (this.getAttackTicks() == 49) {
                    this.m_5496_(SoundEvents.f_11846_, 1.0f, 1.0f);
                }
                if (this.getAttackTicks() == 59 && this.m_5448_() != null) {
                    if (!this.m_9236_().f_46443_) {
                        this.setArrowState(2);
                    }
                    EntityUtil.mobFollowingSound(this.m_9236_(), (Entity)this, (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_MAGISPELLER_ARROWBARRAGE.get(), 2.0f, 1.0f, false);
                }
                if (this.getAttackTicks() >= 59 && this.m_5448_() != null) {
                    this.fireArrow(this.m_5448_(), 1.0f, 0.5f);
                }
            }
            if (this.getAttackType() == this.CRASHAGER_ATTACK) {
                if (this.getAttackTicks() < 68) {
                    this.m_20334_(0.0, 0.06, 0.0);
                    this.makeCrashagerParticles1();
                    if (!this.m_9236_().f_46443_) {
                        this.setGlowState(this.f_19796_.m_188499_() ? 0 : 3);
                    }
                }
                if (this.getAttackTicks() == 68) {
                    if (!this.m_9236_().f_46443_) {
                        this.setGlowState(0);
                        this.setShakeAmount(0);
                    }
                    if (this.m_5448_() != null) {
                        CrashagerEntity ravager = null;
                        if (!this.m_9236_().f_46443_) {
                            ravager = (CrashagerEntity)((EntityType)ModEntityTypes.Crashager.get()).m_20615_(this.m_9236_());
                        }
                        if (ravager != null) {
                            ravager.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                            ravager.m_6710_(this.m_5448_());
                            ravager.setOwner((Mob)this);
                            if (this.m_5647_() != null) {
                                this.m_9236_().m_6188_().m_6546_(ravager.m_20149_(), this.m_9236_().m_6188_().m_83489_(this.m_5647_().m_5758_()));
                            }
                            this.m_9236_().m_7967_((Entity)ravager);
                            this.m_20329_((Entity)ravager);
                            this.makeCrashagerParticles2((Entity)ravager);
                        }
                    }
                }
            }
            if (this.getAttackType() == this.DISPENSER_ATTACK) {
                if (this.getAttackTicks() == 4) {
                    this.makeDispenserParticles();
                    if (!this.m_9236_().f_46443_) {
                        this.setGlowState(5);
                    }
                }
                if (this.getAttackTicks() == 20) {
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_MAGISPELLER_LOAD.get(), 2.0f, 1.0f);
                }
                if (this.getAttackTicks() == 30) {
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_MAGISPELLER_SHOOT.get(), 2.0f, 1.0f);
                    if (!this.m_9236_().f_46443_) {
                        DispenserEntity dispenser = (DispenserEntity)((EntityType)ModEntityTypes.Dispenser.get()).m_20615_(this.m_9236_());
                        assert (dispenser != null);
                        dispenser.m_6034_(this.m_20185_(), this.m_20186_() + 3.0, this.m_20189_());
                        dispenser.m_20334_((double)(-2 + this.f_19796_.m_188503_(5)) * 0.4, 0.6, (double)(-2 + this.f_19796_.m_188503_(5)) * 0.4);
                        if (this.m_5647_() != null) {
                            this.m_9236_().m_6188_().m_6546_(dispenser.m_20149_(), this.m_9236_().m_6188_().m_83489_(this.m_5647_().m_5758_()));
                        }
                        dispenser.setOwner((Mob)this);
                        dispenser.setInMotion(true);
                        this.m_9236_().m_7967_((Entity)dispenser);
                    }
                }
            }
            if (this.getAttackType() == this.HEAL_ATTACK) {
                if (this.damageTaken > 30.0f) {
                    this.gotHealed = false;
                }
                this.makeHealProgressParticles();
                for (Entity entity1 : this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82400_(15.0))) {
                    if (!EntityUtil.canHurtThisMob(entity1, (Mob)this) || !entity1.m_6084_()) continue;
                    double x = this.m_20185_() - entity1.m_20185_();
                    y = this.m_20186_() - entity1.m_20186_();
                    z = this.m_20189_() - entity1.m_20189_();
                    d = Math.sqrt(x * x + y * y + z * z);
                    if (!((double)this.m_20270_(entity1) < 10.0) || !this.isMobNotInCreativeMode(entity1)) continue;
                    entity1.f_19864_ = true;
                    entity1.m_20256_(entity1.m_20184_().m_82520_(-x / d * 0.015, -y / d * 0.03, -z / d * 0.015));
                }
            }
            if (this.getAttackType() == this.KNOCKBACK_ATTACK && this.getAttackTicks() == 5) {
                this.m_5496_(SoundEvents.f_12314_, 2.0f, 1.0f);
                for (Entity entity1 : this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82400_(15.0))) {
                    if (!EntityUtil.canHurtThisMob(entity1, (Mob)this) || !entity1.m_6084_()) continue;
                    double x = this.m_20185_() - entity1.m_20185_();
                    y = this.m_20186_() - entity1.m_20186_();
                    z = this.m_20189_() - entity1.m_20189_();
                    d = Math.sqrt(x * x + y * y + z * z);
                    if (!((double)this.m_20270_(entity1) < 3.0) || !this.isMobNotInCreativeMode(entity1)) continue;
                    entity1.f_19864_ = true;
                    entity1.m_20256_(entity1.m_20184_().m_82520_(-x / d * 5.0, -y / d * 0.3, -z / d * 5.0));
                    entity1.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 6.0f);
                }
            }
            if (this.getAttackType() == this.KABOOMER_ATTACK && this.getAttackTicks() > 5 && !this.m_9236_().f_46443_) {
                this.setGlowState(this.f_19796_.m_188499_() ? 0 : 3);
                this.setShakeAmount(this.getShakeAmount() + 1);
            }
        }
        if (this.m_5448_() != null && this.isActive() && this.m_6084_() && (double)this.m_20270_((Entity)this.m_5448_()) < 6.0 * ((double)this.m_5448_().m_20205_() + 0.4) && this.canAttackBackUp() && this.m_20096_() && !this.isFaking()) {
            double x = this.m_20186_() - this.m_5448_().m_20186_();
            y = this.m_20189_() - this.m_5448_().m_20189_();
            z = Math.sqrt(x * x + x * x + y * y);
            this.m_20256_(this.m_20184_().m_82492_(-x / z * 0.06, 0.0, -y / z * 0.06));
        }
        if (this.f_19789_ > 5.0f && this.balloonCooldown < 1 && (this.getAttackType() == 0 || this.getAttackType() == this.HEAL_ATTACK) && this.isActive() && ((Boolean)Config.CommonConfig.magispeller_balloonAllowed.get()).booleanValue() && this.m_6084_()) {
            this.m_5496_(SoundEvents.f_12473_, 3.0f, 0.5f);
            if (!this.m_9236_().f_46443_) {
                this.setShowArms(true);
                this.setBalloon(true);
            }
            this.f_19789_ = 0.0f;
            this.gotHealed = false;
            this.m_20334_(this.m_20184_().f_82479_, 0.7, this.m_20184_().f_82481_);
            this.balloonCooldown = 10;
        }
        if (this.isBalloon()) {
            this.f_19789_ = 0.0f;
            if (!this.m_9236_().f_46443_) {
                this.setShowArms(true);
            }
            if (this.m_5448_() != null) {
                entity = this.m_5448_();
                double x1 = this.m_20185_() - entity.m_20185_();
                double y1 = this.m_20186_() - entity.m_20186_();
                double z1 = this.m_20189_() - entity.m_20189_();
                double d = Math.sqrt(x1 * x1 + y1 * y1 + z1 * z1);
                float power = 0.08f;
                double motionX = this.m_20184_().f_82479_ - x1 / d * (double)power * 0.2;
                double motionY = this.m_20184_().f_82480_ - y1 / d * (double)power * 0.2;
                double motionZ = this.m_20184_().f_82481_ - z1 / d * (double)power * 0.2;
                this.m_20334_(motionX, motionY, motionZ);
                if (this.m_9236_().m_8055_(this.m_20183_().m_6625_(5)) == Blocks.f_50016_.m_49966_() && this.m_9236_().m_8055_(this.m_20183_().m_6625_(4)) == Blocks.f_50016_.m_49966_() && this.m_9236_().m_8055_(this.m_20183_().m_6625_(3)) == Blocks.f_50016_.m_49966_() && this.m_9236_().m_8055_(this.m_20183_().m_6625_(2)) == Blocks.f_50016_.m_49966_() && this.m_9236_().m_8055_(this.m_20183_().m_6625_(1)) == Blocks.f_50016_.m_49966_()) {
                    if (this.m_20184_().f_82480_ > 0.0) {
                        this.m_20256_(this.m_20184_().m_82520_(0.0, -0.01, 0.0));
                    }
                } else {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, 0.04, 0.0));
                }
            } else if (this.m_9236_().m_8055_(this.m_20183_().m_6625_(1)) != Blocks.f_50016_.m_49966_()) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, 0.04, 0.0));
            } else {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.01, 0.0));
            }
            if (this.m_5448_() != null && (double)this.m_20270_((Entity)this.m_5448_()) < 10.0 && this.m_142582_((Entity)this.m_5448_()) && this.balloonCooldown < 1 || !this.m_6084_()) {
                this.m_5496_(SoundEvents.f_11929_, 3.0f, 1.0f);
                this.balloonCooldown = 200;
                if (!this.m_9236_().f_46443_) {
                    this.setBalloon(false);
                }
            }
        }
        super.m_8119_();
        if (this.isWavingArms()) {
            this.m_20334_(0.0, this.m_20184_().f_82480_, 0.0);
        }
        if (this.shouldShowArms()) {
            this.m_146922_(this.m_6080_());
            this.f_20883_ = this.m_146908_();
        }
        if (this.getArrowState() == 1) {
            ++this.spinDirection;
            if (this.spinDirection > 4) {
                this.spinDirection = 1;
            }
            this.f_20883_ = this.spinDirection * 90;
        }
        if (this.isWavingArms() && this.m_9236_().f_46443_) {
            float f = this.f_20883_ * ((float)Math.PI / 180) + Mth.m_14089_((float)((float)this.f_19797_ * 0.6662f)) * 0.25f;
            f1 = Mth.m_14089_((float)f);
            float f2 = Mth.m_14031_((float)f);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20185_() + (double)f1 * 0.6, this.m_20186_() + 1.8, this.m_20189_() + (double)f2 * 0.6, 0.1, 0.1, 0.2);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20185_() - (double)f1 * 0.6, this.m_20186_() + 1.8, this.m_20189_() - (double)f2 * 0.6, 0.1, 0.1, 0.2);
        }
    }

    public boolean isWavingArms() {
        return (Boolean)this.f_19804_.m_135370_(WAVING_ARMS);
    }

    public void setWavingArms(boolean waving) {
        this.f_19804_.m_135381_(WAVING_ARMS, (Object)waving);
    }

    public boolean isRidingIllusion() {
        return this.m_20202_() instanceof CrashagerEntity || this.m_20202_() instanceof KaboomerEntity;
    }

    public boolean m_20329_(Entity p_20330_) {
        return (p_20330_ instanceof CrashagerEntity || p_20330_ instanceof KaboomerEntity || p_20330_ instanceof CrocofangEntity || p_20330_ instanceof Ravager) && super.m_20329_(p_20330_);
    }

    public void updateCloneList() {
        if (!this.clones.isEmpty()) {
            for (int i = 0; i < this.clones.size(); ++i) {
                FakeMagispellerEntity clone = this.clones.get(i);
                if (clone.m_6084_()) continue;
                this.clones.remove(i);
                --i;
            }
        }
    }

    public void makeFireParticles() {
        if (!this.m_9236_().f_46443_) {
            Iterator var1 = ((ServerLevel)this.m_9236_()).m_6907_().iterator();
            while (true) {
                if (!var1.hasNext()) {
                    return;
                }
                ServerPlayer serverPlayer = (ServerPlayer)var1.next();
                if (!(serverPlayer.m_20280_((Entity)this) < 4096.0)) continue;
                ParticlePacket packet = new ParticlePacket();
                for (int i = 0; i < 75; ++i) {
                    double d0 = (-0.5 + this.f_19796_.m_188583_()) / 4.0;
                    double d1 = (-0.5 + this.f_19796_.m_188583_()) / 4.0;
                    double d2 = (-0.5 + this.f_19796_.m_188583_()) / 4.0;
                    packet.queueParticle((ParticleOptions)ParticleTypes.f_123744_, false, new Vec3(this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0)), new Vec3(d0, d1, d2));
                }
                ServerPlayer finalServerPlayer = serverPlayer;
                PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> finalServerPlayer), (Object)packet);
            }
        }
    }

    public void makeLifestealParticles1() {
        if (!this.m_9236_().f_46443_) {
            Iterator var1 = ((ServerLevel)this.m_9236_()).m_6907_().iterator();
            while (true) {
                if (!var1.hasNext()) {
                    return;
                }
                ServerPlayer serverPlayer = (ServerPlayer)var1.next();
                if (!(serverPlayer.m_20280_((Entity)this) < 4096.0)) continue;
                ParticlePacket packet = new ParticlePacket();
                for (int i = 0; i < 2; ++i) {
                    double randomX = this.m_20185_() - 5.0 + (double)this.f_19796_.m_188503_(10);
                    double randomY = this.m_20186_() - 5.0 + (double)this.f_19796_.m_188503_(10);
                    double randomZ = this.m_20189_() - 5.0 + (double)this.f_19796_.m_188503_(10);
                    double d0 = (this.m_20185_() - randomX) / 4.0;
                    double d1 = (this.m_20186_() - randomY) / 4.0;
                    double d2 = (this.m_20189_() - randomZ) / 4.0;
                    packet.queueParticle((ParticleOptions)ParticleTypes.f_123759_, false, new Vec3(randomX, randomY, randomZ), new Vec3(d0, d1, d2));
                }
                ServerPlayer finalServerPlayer = serverPlayer;
                PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> finalServerPlayer), (Object)packet);
            }
        }
    }

    public void makeLifestealParticles2(Entity caught) {
        if (!this.m_9236_().f_46443_) {
            Iterator var2 = ((ServerLevel)this.m_9236_()).m_6907_().iterator();
            while (true) {
                if (!var2.hasNext()) {
                    return;
                }
                ServerPlayer serverPlayer = (ServerPlayer)var2.next();
                if (!(serverPlayer.m_20280_((Entity)this) < 4096.0)) continue;
                ParticlePacket packet = new ParticlePacket();
                for (int i = 0; i < 2; ++i) {
                    packet.queueParticle((ParticleOptions)ParticleTypes.f_123797_, false, new Vec3(caught.m_20208_(0.5), caught.m_20187_(), caught.m_20262_(0.5)), new Vec3(0.0, 0.0, 0.0));
                }
                ServerPlayer finalServerPlayer = serverPlayer;
                PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> finalServerPlayer), (Object)packet);
            }
        }
    }

    public void makeLifestealParticles3() {
        if (!this.m_9236_().f_46443_) {
            Iterator var1 = ((ServerLevel)this.m_9236_()).m_6907_().iterator();
            while (true) {
                if (!var1.hasNext()) {
                    return;
                }
                ServerPlayer serverPlayer = (ServerPlayer)var1.next();
                if (!(serverPlayer.m_20280_((Entity)this) < 4096.0)) continue;
                ParticlePacket packet = new ParticlePacket();
                for (int i = 0; i < 6; ++i) {
                    double randomX = this.m_20185_() - 5.0 + (double)this.f_19796_.m_188503_(10);
                    double randomY = this.m_20186_() - 5.0 + (double)this.f_19796_.m_188503_(10);
                    double randomZ = this.m_20189_() - 5.0 + (double)this.f_19796_.m_188503_(10);
                    double d0 = (this.m_20185_() - randomX) / 4.0;
                    double d1 = (this.m_20186_() - randomY) / 4.0;
                    double d2 = (this.m_20189_() - randomZ) / 4.0;
                    packet.queueParticle((ParticleOptions)ParticleTypes.f_175830_, false, new Vec3(randomX, randomY, randomZ), new Vec3(d0, d1, d2));
                }
                ServerPlayer finalServerPlayer = serverPlayer;
                PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> finalServerPlayer), (Object)packet);
            }
        }
    }

    public void makeFakerParticles() {
        if (!this.m_9236_().f_46443_) {
            Iterator var1 = ((ServerLevel)this.m_9236_()).m_6907_().iterator();
            while (true) {
                double d2;
                double d1;
                double d0;
                int i;
                if (!var1.hasNext()) {
                    return;
                }
                ServerPlayer serverPlayer = (ServerPlayer)var1.next();
                if (!(serverPlayer.m_20280_((Entity)this) < 4096.0)) continue;
                ParticlePacket packet = new ParticlePacket();
                for (i = 0; i < 2; ++i) {
                    d0 = this.m_20185_() - 5.0 + (double)this.f_19796_.m_188503_(10);
                    d1 = this.m_20186_() - 5.0 + (double)this.f_19796_.m_188503_(10);
                    d2 = this.m_20189_() - 5.0 + (double)this.f_19796_.m_188503_(10);
                    double d3 = (this.m_20185_() - d0) / 4.0;
                    double d4 = (this.m_20186_() - d1) / 4.0;
                    double d5 = (this.m_20189_() - d2) / 4.0;
                    packet.queueParticle((ParticleOptions)ParticleTypes.f_175830_, false, new Vec3(d3, d4, d5), new Vec3(d3, d4, d5));
                }
                for (i = 0; i < 2; ++i) {
                    d0 = (-0.5 + this.f_19796_.m_188583_()) / 4.0;
                    d1 = (-0.5 + this.f_19796_.m_188583_()) / 4.0;
                    d2 = (-0.5 + this.f_19796_.m_188583_()) / 4.0;
                    packet.queueParticle((ParticleOptions)ParticleTypes.f_123760_, false, new Vec3(this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0)), new Vec3(d0, d1, d2));
                }
                ServerPlayer finalServerPlayer = serverPlayer;
                PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> finalServerPlayer), (Object)packet);
            }
        }
    }

    public void makeFangRunParticles() {
        if (!this.m_9236_().f_46443_) {
            Iterator var1 = ((ServerLevel)this.m_9236_()).m_6907_().iterator();
            while (true) {
                if (!var1.hasNext()) {
                    return;
                }
                ServerPlayer serverPlayer = (ServerPlayer)var1.next();
                if (!(serverPlayer.m_20280_((Entity)this) < 4096.0)) continue;
                ParticlePacket packet = new ParticlePacket();
                for (int i = 0; i < 75; ++i) {
                    double d0 = (-0.5 + this.f_19796_.m_188583_()) / 4.0;
                    double d1 = (-0.5 + this.f_19796_.m_188583_()) / 4.0;
                    double d2 = (-0.5 + this.f_19796_.m_188583_()) / 4.0;
                    packet.queueParticle((ParticleOptions)ParticleTypes.f_175830_, false, new Vec3(this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0)), new Vec3(d0, d1, d2));
                }
                ServerPlayer finalServerPlayer = serverPlayer;
                PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> finalServerPlayer), (Object)packet);
            }
        }
    }

    public void makePotionParticles() {
        if (!this.m_9236_().f_46443_) {
            Iterator var1 = ((ServerLevel)this.m_9236_()).m_6907_().iterator();
            while (true) {
                if (!var1.hasNext()) {
                    return;
                }
                ServerPlayer serverPlayer = (ServerPlayer)var1.next();
                if (!(serverPlayer.m_20280_((Entity)this) < 4096.0)) continue;
                ParticlePacket packet = new ParticlePacket();
                for (int i = 0; i < 3; ++i) {
                    double d0 = (-0.5 + this.f_19796_.m_188583_()) / 4.0;
                    double d1 = (-0.5 + this.f_19796_.m_188583_()) / 4.0;
                    double d2 = (-0.5 + this.f_19796_.m_188583_()) / 4.0;
                    packet.queueParticle((ParticleOptions)ParticleTypes.f_123766_, false, new Vec3(this.m_20208_(1.0) + (-0.5 + this.f_19796_.m_188500_()) * 0.8, this.m_20187_() - (-0.5 + this.f_19796_.m_188500_()) * 0.4, this.m_20262_(1.0) + (-0.5 + this.f_19796_.m_188500_()) * 0.8), new Vec3(d0, d1, d2));
                }
                ServerPlayer finalServerPlayer = serverPlayer;
                PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> finalServerPlayer), (Object)packet);
            }
        }
    }

    public void makeArrowParticles(Entity caught) {
        if (!this.m_9236_().f_46443_) {
            Iterator var2 = ((ServerLevel)this.m_9236_()).m_6907_().iterator();
            while (true) {
                if (!var2.hasNext()) {
                    return;
                }
                ServerPlayer serverPlayer = (ServerPlayer)var2.next();
                if (!(serverPlayer.m_20280_((Entity)this) < 4096.0)) continue;
                ParticlePacket packet = new ParticlePacket();
                for (int i = 0; i < 2; ++i) {
                    packet.queueParticle((ParticleOptions)ParticleTypes.f_175830_, false, new Vec3(caught.m_20208_(0.5), caught.m_20187_(), caught.m_20262_(0.5)), new Vec3(0.0, 0.0, 0.0));
                }
                ServerPlayer finalServerPlayer = serverPlayer;
                PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> finalServerPlayer), (Object)packet);
            }
        }
    }

    public void makeCrashagerParticles1() {
        if (!this.m_9236_().f_46443_) {
            Iterator var1 = ((ServerLevel)this.m_9236_()).m_6907_().iterator();
            while (true) {
                double d2;
                double d1;
                double d0;
                int i;
                if (!var1.hasNext()) {
                    return;
                }
                ServerPlayer serverPlayer = (ServerPlayer)var1.next();
                if (!(serverPlayer.m_20280_((Entity)this) < 4096.0)) continue;
                ParticlePacket packet = new ParticlePacket();
                for (i = 0; i < 2; ++i) {
                    d0 = -0.5 + this.f_19796_.m_188583_();
                    d1 = -0.5 + this.f_19796_.m_188583_();
                    d2 = -0.5 + this.f_19796_.m_188583_();
                    packet.queueParticle((ParticleOptions)ParticleTypes.f_175830_, false, new Vec3(this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0)), new Vec3(d0, d1, d2));
                }
                for (i = 0; i < 2; ++i) {
                    d0 = -0.5 + this.f_19796_.m_188583_();
                    d1 = -0.5 + this.f_19796_.m_188583_();
                    d2 = -0.5 + this.f_19796_.m_188583_();
                    packet.queueParticle((ParticleOptions)ParticleTypes.f_123797_, false, new Vec3(this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0)), new Vec3(d0, d1, d2));
                }
                ServerPlayer finalServerPlayer = serverPlayer;
                PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> finalServerPlayer), (Object)packet);
            }
        }
    }

    public void makeCrashagerParticles2(Entity caught) {
        if (!this.m_9236_().f_46443_) {
            Iterator var2 = ((ServerLevel)this.m_9236_()).m_6907_().iterator();
            while (true) {
                double d2;
                double d1;
                double d0;
                int i;
                if (!var2.hasNext()) {
                    return;
                }
                ServerPlayer serverPlayer = (ServerPlayer)var2.next();
                if (!(serverPlayer.m_20280_((Entity)this) < 4096.0)) continue;
                ParticlePacket packet = new ParticlePacket();
                for (i = 0; i < 75; ++i) {
                    d0 = -0.5 + this.f_19796_.m_188583_();
                    d1 = -0.5 + this.f_19796_.m_188583_();
                    d2 = -0.5 + this.f_19796_.m_188583_();
                    packet.queueParticle((ParticleOptions)ParticleTypes.f_175830_, false, new Vec3(caught.m_20208_(0.5), caught.m_20187_(), caught.m_20262_(0.5)), new Vec3(d0, d1, d2));
                }
                for (i = 0; i < 50; ++i) {
                    d0 = -0.5 + this.f_19796_.m_188583_();
                    d1 = -0.5 + this.f_19796_.m_188583_();
                    d2 = -0.5 + this.f_19796_.m_188583_();
                    packet.queueParticle((ParticleOptions)ParticleTypes.f_123759_, false, new Vec3(caught.m_20208_(0.5), caught.m_20187_(), caught.m_20262_(0.5)), new Vec3(d0, d1, d2));
                }
                for (i = 0; i < 5; ++i) {
                    d0 = -0.5 + this.f_19796_.m_188583_();
                    d1 = -0.5 + this.f_19796_.m_188583_();
                    d2 = -0.5 + this.f_19796_.m_188583_();
                    packet.queueParticle((ParticleOptions)ParticleTypes.f_123812_, false, new Vec3(caught.m_20208_(0.5), caught.m_20187_(), caught.m_20262_(0.5)), new Vec3(d0, d1, d2));
                }
                ServerPlayer finalServerPlayer = serverPlayer;
                PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> finalServerPlayer), (Object)packet);
            }
        }
    }

    public void makeDispenserParticles() {
        if (!this.m_9236_().f_46443_) {
            Iterator var1 = ((ServerLevel)this.m_9236_()).m_6907_().iterator();
            while (true) {
                double d2;
                double d1;
                double d0;
                int i;
                if (!var1.hasNext()) {
                    return;
                }
                ServerPlayer serverPlayer = (ServerPlayer)var1.next();
                if (!(serverPlayer.m_20280_((Entity)this) < 4096.0)) continue;
                ParticlePacket packet = new ParticlePacket();
                for (i = 0; i < 5; ++i) {
                    d0 = (-0.5 + this.f_19796_.m_188583_()) / 4.0;
                    d1 = (-0.5 + this.f_19796_.m_188583_()) / 4.0;
                    d2 = (-0.5 + this.f_19796_.m_188583_()) / 4.0;
                    packet.queueParticle((ParticleOptions)ParticleTypes.f_123792_, false, new Vec3(this.m_20208_(1.0), this.m_20187_() + (double)this.m_20192_(), this.m_20262_(1.0)), new Vec3(d0, d1, d2));
                }
                for (i = 0; i < 25; ++i) {
                    d0 = (-0.5 + this.f_19796_.m_188583_()) / 4.0;
                    d1 = (-0.5 + this.f_19796_.m_188583_()) / 4.0;
                    d2 = (-0.5 + this.f_19796_.m_188583_()) / 4.0;
                    packet.queueParticle((ParticleOptions)ParticleTypes.f_123759_, false, new Vec3(this.m_20208_(1.0), this.m_20187_() + (double)this.m_20192_(), this.m_20262_(1.0)), new Vec3(d0, d1, d2));
                }
                ServerPlayer finalServerPlayer = serverPlayer;
                PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> finalServerPlayer), (Object)packet);
            }
        }
    }

    public void makeHealParticles() {
        if (!this.m_9236_().f_46443_) {
            Iterator var1 = ((ServerLevel)this.m_9236_()).m_6907_().iterator();
            while (true) {
                if (!var1.hasNext()) {
                    return;
                }
                ServerPlayer serverPlayer = (ServerPlayer)var1.next();
                if (!(serverPlayer.m_20280_((Entity)this) < 4096.0)) continue;
                ParticlePacket packet = new ParticlePacket();
                for (int i = 0; i < 50; ++i) {
                    double d0 = (-0.5 + this.f_19796_.m_188583_()) / 4.0;
                    double d1 = (-0.5 + this.f_19796_.m_188583_()) / 4.0;
                    double d2 = (-0.5 + this.f_19796_.m_188583_()) / 4.0;
                    packet.queueParticle((ParticleOptions)ParticleTypes.f_123750_, false, new Vec3(this.m_20208_(1.0) + (-0.5 + this.f_19796_.m_188500_()) * 2.5, this.m_20187_() + (-0.5 + this.f_19796_.m_188500_()) * 1.5, this.m_20262_(1.0) + (-0.5 + this.f_19796_.m_188500_()) * 2.5), new Vec3(d0, d1, d2));
                }
                ServerPlayer finalServerPlayer = serverPlayer;
                PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> finalServerPlayer), (Object)packet);
            }
        }
    }

    public void makeHealFailedParticles() {
        if (!this.m_9236_().f_46443_) {
            Iterator var1 = ((ServerLevel)this.m_9236_()).m_6907_().iterator();
            while (true) {
                if (!var1.hasNext()) {
                    return;
                }
                ServerPlayer serverPlayer = (ServerPlayer)var1.next();
                if (!(serverPlayer.m_20280_((Entity)this) < 4096.0)) continue;
                ParticlePacket packet = new ParticlePacket();
                for (int i = 0; i < 50; ++i) {
                    double d0 = (-0.5 + this.f_19796_.m_188583_()) / 4.0;
                    double d1 = (-0.5 + this.f_19796_.m_188583_()) / 4.0;
                    double d2 = (-0.5 + this.f_19796_.m_188583_()) / 4.0;
                    packet.queueParticle((ParticleOptions)ParticleTypes.f_123792_, false, new Vec3(this.m_20208_(1.0) + (-0.5 + this.f_19796_.m_188500_()) * 2.5, this.m_20187_() + (-0.5 + this.f_19796_.m_188500_()) * 1.5, this.m_20262_(1.0) + (-0.5 + this.f_19796_.m_188500_()) * 2.5), new Vec3(d0, d1, d2));
                }
                ServerPlayer finalServerPlayer = serverPlayer;
                PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> finalServerPlayer), (Object)packet);
            }
        }
    }

    public void makeHealProgressParticles() {
        if (!this.m_9236_().f_46443_) {
            Iterator var1 = ((ServerLevel)this.m_9236_()).m_6907_().iterator();
            while (true) {
                if (!var1.hasNext()) {
                    return;
                }
                ServerPlayer serverPlayer = (ServerPlayer)var1.next();
                if (!(serverPlayer.m_20280_((Entity)this) < 4096.0)) continue;
                ParticlePacket packet = new ParticlePacket();
                for (int i = 0; i < 1; ++i) {
                    double d0 = (-0.5 + this.f_19796_.m_188583_()) / 4.0;
                    double d1 = (-0.5 + this.f_19796_.m_188583_()) / 4.0;
                    double d2 = (-0.5 + this.f_19796_.m_188583_()) / 4.0;
                    packet.queueParticle((ParticleOptions)ParticleTypes.f_123748_, false, new Vec3(this.m_20208_(1.0) + (-0.5 + this.f_19796_.m_188500_()) * 2.5, this.m_20187_() + (-0.5 + this.f_19796_.m_188500_()) * 1.5, this.m_20262_(1.0) + (-0.5 + this.f_19796_.m_188500_()) * 2.5), new Vec3(d0, d1, d2));
                }
                ServerPlayer finalServerPlayer = serverPlayer;
                PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> finalServerPlayer), (Object)packet);
            }
        }
    }

    public void makeTotemParticles() {
        if (!this.m_9236_().f_46443_) {
            Iterator var1 = ((ServerLevel)this.m_9236_()).m_6907_().iterator();
            while (true) {
                if (!var1.hasNext()) {
                    return;
                }
                ServerPlayer serverPlayer = (ServerPlayer)var1.next();
                if (!(serverPlayer.m_20280_((Entity)this) < 4096.0)) continue;
                ParticlePacket packet = new ParticlePacket();
                for (int i = 0; i < 50; ++i) {
                    double d0 = (-0.5 + this.f_19796_.m_188583_()) / 4.0;
                    double d1 = (-0.5 + this.f_19796_.m_188583_()) / 4.0;
                    double d2 = (-0.5 + this.f_19796_.m_188583_()) / 4.0;
                    packet.queueParticle((ParticleOptions)ParticleTypes.f_123767_, false, new Vec3(this.m_20208_(1.0) + (-0.5 + this.f_19796_.m_188500_()) * 2.5, this.m_20187_() + (-0.5 + this.f_19796_.m_188500_()) * 1.5, this.m_20262_(1.0) + (-0.5 + this.f_19796_.m_188500_()) * 2.5), new Vec3(d0, d1, d2));
                }
                ServerPlayer finalServerPlayer = serverPlayer;
                PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> finalServerPlayer), (Object)packet);
            }
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.areIllagersNearby() && !source.m_276093_(DamageTypes.f_268724_) && !source.m_276093_(DamageTypes.f_286979_)) {
            return false;
        }
        if (this.isFaking()) {
            this.setFaking(false);
            if (!this.clones.isEmpty()) {
                for (FakeMagispellerEntity clone : this.clones) {
                    clone.m_6074_();
                }
            }
        }
        if (!source.m_276093_(DamageTypes.f_268724_) && !source.m_276093_(DamageTypes.f_286979_)) {
            amount = Math.min(amount, 20.0f);
        }
        if (source.m_7639_() instanceof CrashagerEntity && ((CrashagerEntity)source.m_7639_()).getOwner() == this) {
            return false;
        }
        if (source.m_7639_() instanceof KaboomerEntity && ((KaboomerEntity)source.m_7639_()).getOwner() == this) {
            return false;
        }
        if (this.isBalloon() && !source.m_276093_(DamageTypes.f_268724_) && !source.m_276093_(DamageTypes.f_286979_)) {
            return false;
        }
        if (!(this.isActive() || source.m_276093_(DamageTypes.f_268724_) || source.m_276093_(DamageTypes.f_286979_))) {
            amount = 0.0f;
        }
        if (source.m_7639_() instanceof LivingEntity && !this.isActive() && !this.areIllagersNearby()) {
            this.setActive(true);
            if (this.m_37886_() && this.m_37885_() != null) {
                this.m_37885_().f_37673_ = 0L;
            }
        }
        this.lastDamageSource = source;
        return super.m_6469_(source, amount);
    }

    public void addDamageTaken(float damage) {
        this.damageTaken += damage;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_213386_1_, DifficultyInstance p_213386_2_, MobSpawnType p_213386_3_, @Nullable SpawnGroupData p_213386_4_, @Nullable CompoundTag p_213386_5_) {
        RandomSource randomsource = p_213386_1_.m_213780_();
        if (p_213386_3_ == MobSpawnType.EVENT) {
            this.setShouldDeleteItself(true);
        }
        this.m_213945_(randomsource, p_213386_2_);
        this.m_213946_(randomsource, p_213386_2_);
        return super.m_6518_(p_213386_1_, p_213386_2_, p_213386_3_, p_213386_4_, p_213386_5_);
    }

    public void m_6667_(DamageSource p_37847_) {
        if (this.m_37886_() && this.m_37885_() != null) {
            this.m_37885_().f_37673_ = 0L;
        }
        this.setAnimationState(0);
        if (p_37847_.m_7639_() == null && this.m_21188_() == null && this.m_5448_() == null) {
            super.m_6667_(p_37847_);
        } else {
            if (!this.m_9236_().f_46443_) {
                this.f_21345_.m_25386_().forEach(WrappedGoal::m_8041_);
                this.setShakeAmount(0);
            }
            if (this.f_20889_ > 0) {
                this.f_20889_ = 10000;
            }
            this.setCustomDeath(true);
            if (this.m_21188_() == this && this.m_5448_() != null) {
                this.mobToLaughAt = this.m_5448_();
            } else if (this.m_21188_() != null) {
                this.mobToLaughAt = this.m_21188_();
            } else if (this.m_5448_() != null) {
                this.mobToLaughAt = this.m_5448_();
            } else if (p_37847_.m_7639_() != null) {
                this.mobToLaughAt = p_37847_.m_7639_();
            }
        }
    }

    protected void m_6153_() {
        if (!this.isCustomDeath()) {
            super.m_6153_();
        } else {
            this.m_20095_();
            ++this.customDeathTime;
            if (this.customDeathTime < 60) {
                ++this.f_20919_;
            }
            if (!this.m_9236_().f_46443_) {
                this.setShakeAmount(0);
            }
            if (this.customDeathTime == 60) {
                this.m_5496_(SoundEvents.f_12473_, 2.0f, 0.5f);
                this.m_5496_(SoundEvents.f_12275_, 2.0f, 1.0f);
                for (int i = 0; i < 15; ++i) {
                    this.makeHealProgressParticles();
                }
                ItemEntity totem = (ItemEntity)EntityType.f_20461_.m_20615_(this.m_9236_());
                assert (totem != null);
                totem.m_32045_(Items.f_42747_.m_7968_());
                totem.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                totem.m_20334_(0.0, 0.4, 0.0);
                totem.m_32062_();
                totem.m_149678_();
                totem.f_19794_ = true;
                this.m_9236_().m_7967_((Entity)totem);
                this.totem = totem;
            }
            if (this.customDeathTime == 80) {
                if (((Boolean)Config.CommonConfig.magispeller_distractEnemies.get()).booleanValue()) {
                    List list = this.m_9236_().m_45976_(Mob.class, this.m_20191_().m_82400_(50.0));
                    for (Mob mob : list) {
                        mob.f_21345_.m_25352_(0, (Goal)new StareAtDeadMagiGoal(mob, this));
                    }
                }
                this.m_5496_(SoundEvents.f_12513_, 2.0f, 1.0f);
                this.makeTotemParticles();
                CameraShakeEntity.cameraShake(this.m_9236_(), this.m_20182_(), 50.0f, 0.6f, 0, 30);
                this.setAnimationState(12);
                if (!this.m_9236_().f_46443_) {
                    this.setShowArms(true);
                }
                this.f_20919_ = 0;
                this.f_20890_ = false;
                this.m_20124_(Pose.STANDING);
                if (this.totem != null) {
                    this.totem.m_146870_();
                }
            }
            if (this.customDeathTime == 110) {
                this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_MAGISPELLER_LAUGH.get(), 1.0f, 1.0f);
            }
            if (this.customDeathTime >= 110 && this.mobToLaughAt != null) {
                this.lookAtWhileDead(this.mobToLaughAt, 30.0f, 30.0f);
            }
            if (this.customDeathTime == 200 && !this.m_9236_().f_46443_) {
                this.setGlowState(7);
            }
            if (this.customDeathTime == 232 && !this.m_9236_().f_46443_) {
                this.setGlowState(8);
            }
            if (this.customDeathTime == 248 && !this.m_9236_().f_46443_) {
                this.setGlowState(9);
            }
            if (this.customDeathTime >= 270 && this.customDeathTime < 290) {
                if (this.customDeathTime == 270) {
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_MAGISPELLER_ESCAPE.get(), 2.0f, 1.0f);
                }
                if (!this.m_9236_().f_46443_) {
                    this.setGlowState(this.f_19796_.m_188499_() ? 0 : 3);
                }
            }
            if (this.customDeathTime == 290 && !this.m_9236_().f_46443_) {
                this.setGlowState(3);
            }
            if (this.customDeathTime >= 300) {
                this.m_5496_(SoundEvents.f_12052_, 1.0f, 1.0f);
                if (this.lastDamageSource.m_7640_() instanceof MagiFireballEntity) {
                    this.shouldDropDisc = true;
                }
                super.m_6667_(this.lastDamageSource != null ? this.lastDamageSource : this.m_269291_().m_269264_());
                if (!this.m_9236_().m_5776_()) {
                    this.m_9236_().m_7605_((Entity)this, (byte)60);
                    this.m_142687_(Entity.RemovalReason.KILLED);
                }
            }
        }
    }

    public boolean isDead() {
        return this.f_20890_;
    }

    protected void m_6668_(DamageSource source) {
        if (this.m_6125_() && this.m_9236_().m_46469_().m_46207_(GameRules.f_46135_) && this.f_20889_ > 0 && this.shouldDropDisc) {
            this.m_9236_().m_7967_((Entity)new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)ItemRegisterer.MAGISPELLER_DISC.get())));
        }
        super.m_6668_(source);
    }

    public void lookAtWhileDead(Entity p_21392_, float p_21393_, float p_21394_) {
        double d1;
        double d0 = p_21392_.m_20185_() - this.m_20185_();
        double d2 = p_21392_.m_20189_() - this.m_20189_();
        if (p_21392_ instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)p_21392_;
            d1 = livingentity.m_20188_() - this.m_20188_();
        } else {
            d1 = (p_21392_.m_20191_().f_82289_ + p_21392_.m_20191_().f_82292_) / 2.0 - this.m_20188_();
        }
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
        float f1 = (float)(-(Mth.m_14136_((double)d1, (double)d3) * 57.2957763671875));
        this.m_146926_(this.m_21376_(this.m_146909_(), f1, p_21394_));
        this.m_146922_(this.m_21376_(this.m_146908_(), f, p_21393_));
        this.f_20885_ = this.m_21376_(this.m_146908_(), f, p_21393_);
    }

    private float m_21376_(float p_21377_, float p_21378_, float p_21379_) {
        float f = Mth.m_14177_((float)(p_21378_ - p_21377_));
        if (f > p_21379_) {
            f = p_21379_;
        }
        if (f < -p_21379_) {
            f = -p_21379_;
        }
        return p_21377_ + f;
    }

    public boolean m_7327_(Entity p_70652_1_) {
        if (this.isFaking() && !this.m_9236_().f_46443_ && this.f_19796_.m_188503_(3) != 0) {
            this.teleportTowards(p_70652_1_);
        }
        return (!this.isFaking() || this.waitTimeFaker >= 20) && super.m_7327_(p_70652_1_);
    }

    public boolean shouldShowArms() {
        return (Boolean)this.f_19804_.m_135370_(SHOW_ARMS);
    }

    public void setShowArms(boolean showArms) {
        this.f_19804_.m_135381_(SHOW_ARMS, (Object)showArms);
    }

    protected void createFangs(boolean particleOrReal) {
        if (this.m_5448_() != null) {
            LivingEntity livingentity = this.m_5448_();
            double d0 = Math.min(livingentity.m_20186_(), this.m_20186_());
            double d1 = Math.max(livingentity.m_20186_(), this.m_20186_()) + 1.0;
            float f = (float)Mth.m_14136_((double)(livingentity.m_20189_() - this.m_20189_()), (double)(livingentity.m_20185_() - this.m_20185_()));
            for (int l = 0; l < 16; ++l) {
                double d2 = 1.25 * (double)(l + 1);
                if (particleOrReal) {
                    this.createSpellEntity(this.m_20185_() + (double)Mth.m_14089_((float)f) * d2, this.m_20189_() + (double)Mth.m_14031_((float)f) * d2, d0, d1, f, l);
                    continue;
                }
                this.createSpellParticles(this.m_20185_() + (double)Mth.m_14089_((float)f) * d2, this.m_20189_() + (double)Mth.m_14031_((float)f) * d2, d0, d1);
            }
        }
    }

    private void createSpellEntity(double p_190876_1_, double p_190876_3_, double p_190876_5_, double p_190876_7_, float p_190876_9_, int p_190876_10_) {
        BlockPos blockpos = BlockPos.m_274561_((double)p_190876_1_, (double)p_190876_7_, (double)p_190876_3_);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1 = blockpos.m_7495_();
            BlockState blockstate = this.m_9236_().m_8055_(blockpos1);
            if (!blockstate.m_60783_((BlockGetter)this.m_9236_(), blockpos1, Direction.UP)) continue;
            if (!this.m_9236_().m_46859_(blockpos) && !(voxelshape = (blockstate1 = this.m_9236_().m_8055_(blockpos)).m_60812_((BlockGetter)this.m_9236_(), blockpos)).m_83281_()) {
                d0 = voxelshape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)p_190876_5_) - 1);
        if (flag) {
            EvokerFangs fangs = new EvokerFangs(this.m_9236_(), p_190876_1_, (double)blockpos.m_123342_() + d0, p_190876_3_, p_190876_9_, p_190876_10_, (LivingEntity)this);
            fangs.m_20225_(true);
            this.m_9236_().m_7967_((Entity)fangs);
        }
    }

    private void createSpellParticles(double p_190876_1_, double p_190876_3_, double p_190876_5_, double p_190876_7_) {
        BlockPos blockpos = BlockPos.m_274561_((double)p_190876_1_, (double)p_190876_7_, (double)p_190876_3_);
        boolean flag = false;
        double dthing = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1 = blockpos.m_7495_();
            BlockState blockstate = this.m_9236_().m_8055_(blockpos1);
            if (!blockstate.m_60783_((BlockGetter)this.m_9236_(), blockpos1, Direction.UP)) continue;
            if (!this.m_9236_().m_46859_(blockpos) && !(voxelshape = (blockstate1 = this.m_9236_().m_8055_(blockpos)).m_60812_((BlockGetter)this.m_9236_(), blockpos)).m_83281_()) {
                dthing = voxelshape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)p_190876_5_) - 1);
        if (flag && !this.m_9236_().f_46443_) {
            Iterator var25 = ((ServerLevel)this.m_9236_()).m_6907_().iterator();
            while (true) {
                if (!var25.hasNext()) {
                    return;
                }
                ServerPlayer serverPlayer = (ServerPlayer)var25.next();
                if (!(serverPlayer.m_20280_((Entity)this) < 4096.0)) continue;
                ParticlePacket packet = new ParticlePacket();
                for (int i = 0; i < 8; ++i) {
                    double d0 = (-0.5 + this.f_19796_.m_188583_()) / 4.0;
                    double d1 = (-0.5 + this.f_19796_.m_188583_()) / 4.0;
                    double d2 = (-0.5 + this.f_19796_.m_188583_()) / 4.0;
                    packet.queueParticle((ParticleOptions)ParticleTypes.f_123797_, false, new Vec3(p_190876_1_ + (double)this.f_19796_.m_188501_(), (double)blockpos.m_123342_() + dthing, p_190876_3_ + (double)this.f_19796_.m_188501_()), new Vec3(d0, d1, d2));
                }
                ServerPlayer finalServerPlayer = serverPlayer;
                PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> finalServerPlayer), (Object)packet);
            }
        }
    }

    public boolean m_6128_() {
        return this.kaboomerCooldown > 280;
    }

    public SoundEvent m_7930_() {
        return (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_MAGISPELLER_CELEBRATE.get();
    }

    protected SoundEvent m_7515_() {
        return !this.isFaking() ? (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_MAGISPELLER_AMBIENT.get() : (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_FAKER_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource p_184601_1_) {
        return (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_MAGISPELLER_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_MAGISPELLER_DEATH.get();
    }

    public boolean areIllagersNearby() {
        return (Boolean)this.f_19804_.m_135370_(NEARBY_ILLAGERS) != false && !this.isActive();
    }

    public void setIllagersNearby(boolean illagersNearby) {
        this.f_19804_.m_135381_(NEARBY_ILLAGERS, (Object)illagersNearby);
    }

    public boolean shouldRemoveItself() {
        return (Boolean)this.f_19804_.m_135370_(SHOULD_DELETE_ITSELF);
    }

    public void setShouldDeleteItself(boolean shouldDelete) {
        this.f_19804_.m_135381_(SHOULD_DELETE_ITSELF, (Object)shouldDelete);
    }

    public boolean isActive() {
        return (Boolean)this.f_19804_.m_135370_(ACTIVE);
    }

    public void setActive(boolean active) {
        this.f_19804_.m_135381_(ACTIVE, (Object)active);
    }

    public boolean m_21532_() {
        return (Boolean)Config.CommonConfig.ULTIMATE_NIGHTMARE.get() == false;
    }

    public boolean m_7301_(MobEffectInstance p_70687_1_) {
        return p_70687_1_.m_19544_() != MobEffects.f_19597_ && super.m_7301_(p_70687_1_);
    }

    protected void m_213945_(RandomSource random, DifficultyInstance p_180481_1_) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42386_));
        this.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
        this.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_42717_));
        this.m_21409_(EquipmentSlot.OFFHAND, 0.0f);
    }

    public boolean doesAttackMeetNormalRequirements() {
        return this.getAttackType() == 0 && !this.areIllagersNearby() && this.m_5448_() != null && this.m_142582_((Entity)this.m_5448_()) && this.isActive() && !this.isFaking() && !this.isRidingIllusion() && !this.isBalloon();
    }

    public boolean canAttackBackUp() {
        return this.getAttackType() == 0 || this.getAttackType() == 1 || this.getAttackType() == 2 && this.getAttackTicks() < 31 || this.getAttackType() == 4 || this.getAttackType() == 7 || this.getAttackType() == 9;
    }

    public boolean isBalloon() {
        return (Boolean)this.f_19804_.m_135370_(BALLOON);
    }

    public void setBalloon(boolean balloon) {
        this.f_19804_.m_135381_(BALLOON, (Object)balloon);
        if (balloon) {
            this.m_20242_(true);
        } else if (this.m_20068_()) {
            this.m_20242_(false);
        }
    }

    public boolean isTargetLowEnoughForGround() {
        return this.m_5448_() != null && !(this.m_5448_().m_20186_() > this.m_20186_() + 3.0);
    }

    private boolean teleportTowards(Entity p_70816_1_) {
        Vec3 vector3d = new Vec3(this.m_20185_() - p_70816_1_.m_20185_(), this.m_20227_(0.5) - p_70816_1_.m_20188_(), this.m_20189_() - p_70816_1_.m_20189_());
        vector3d = vector3d.m_82541_();
        double d1 = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 8.0 - vector3d.f_82479_ * 16.0;
        double d2 = this.m_20186_() + (double)(this.f_19796_.m_188503_(16) - 8) - vector3d.f_82480_ * 16.0;
        double d3 = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 8.0 - vector3d.f_82481_ * 16.0;
        return this.teleport(d1, d2, d3);
    }

    private boolean teleport(double p_70825_1_, double p_70825_3_, double p_70825_5_) {
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos(p_70825_1_, p_70825_3_, p_70825_5_);
        while (blockpos$mutable.m_123342_() > 0 && !this.m_9236_().m_8055_((BlockPos)blockpos$mutable).m_280555_()) {
            blockpos$mutable.m_122173_(Direction.DOWN);
        }
        BlockState blockstate = this.m_9236_().m_8055_((BlockPos)blockpos$mutable);
        boolean flag = blockstate.m_280555_();
        boolean flag1 = blockstate.m_60819_().m_205070_(FluidTags.f_13131_);
        if (flag && !flag1) {
            EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)this, (double)p_70825_1_, (double)p_70825_3_, (double)p_70825_5_);
            if (event.isCanceled()) {
                return false;
            }
            boolean flag2 = this.m_20984_(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
            if (flag2 && !this.m_20067_()) {
                this.m_9236_().m_6263_(null, this.f_19854_, this.f_19855_, this.f_19856_, SoundEvents.f_11852_, this.m_5720_(), 1.0f, 1.0f);
                this.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
            }
            return flag2;
        }
        return false;
    }

    public void distractAttackers(LivingEntity entity) {
        List list = this.m_9236_().m_45976_(Mob.class, this.m_20191_().m_82400_(100.0));
        for (Mob attacker : list) {
            if (attacker.m_21188_() == this) {
                attacker.m_6703_(entity);
            }
            if (attacker.m_5448_() != this) continue;
            attacker.m_6710_(entity);
        }
    }

    public void fireArrow(LivingEntity p_82196_1_, float p_82196_2_, float inaccuracy) {
        AbstractArrow abstractarrowentity = this.getArrow(Items.f_42411_.m_7968_(), p_82196_2_);
        if (this.m_21205_().m_41720_() instanceof BowItem) {
            abstractarrowentity = ((BowItem)this.m_21205_().m_41720_()).customArrow(abstractarrowentity);
        }
        double d0 = p_82196_1_.m_20185_() - this.m_20185_();
        double d1 = p_82196_1_.m_20227_(0.3333333333333333) - abstractarrowentity.m_20186_() - (double)p_82196_1_.m_20206_() / 2.0;
        double d2 = p_82196_1_.m_20189_() - this.m_20189_();
        double d3 = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2)));
        abstractarrowentity.m_36781_(2.5);
        float speed = this.m_20280_((Entity)p_82196_1_) > 22.5 ? 2.5f : (float)(this.m_20280_((Entity)p_82196_1_) / 9.0);
        abstractarrowentity.m_6686_(d0, d1 + d3 * (double)0.2f, d2, speed, inaccuracy);
        this.m_9236_().m_7967_((Entity)abstractarrowentity);
    }

    protected AbstractArrow getArrow(ItemStack p_213624_1_, float p_213624_2_) {
        return ProjectileUtil.m_37300_((LivingEntity)this, (ItemStack)p_213624_1_, (float)p_213624_2_);
    }

    public Component m_7755_() {
        return !this.m_8077_() && this.isFaking() ? ((EntityType)ModEntityTypes.Faker.get()).m_20676_() : super.m_7755_();
    }

    public void setAnimationState(int input) {
        this.f_19804_.m_135381_(ANIMATION_STATE, (Object)input);
    }

    @Override
    public AnimationState getAnimationState(String input) {
        if (Objects.equals(input, "fireball")) {
            return this.fireballAnimationState;
        }
        if (Objects.equals(input, "lifesteal")) {
            return this.lifestealAnimationState;
        }
        if (Objects.equals(input, "fakers")) {
            return this.fakersAnimationState;
        }
        if (Objects.equals(input, "vexes")) {
            return this.vexesAnimationState;
        }
        if (Objects.equals(input, "fangrun")) {
            return this.fangrunAnimationState;
        }
        if (Objects.equals(input, "potions")) {
            return this.potionsAnimationState;
        }
        if (Objects.equals(input, "crossbowspin")) {
            return this.crossbowspinAnimationState;
        }
        if (Objects.equals(input, "crashager")) {
            return this.crashagerAnimationState;
        }
        if (Objects.equals(input, "dispenser")) {
            return this.dispenserAnimationState;
        }
        if (Objects.equals(input, "knockback")) {
            return this.knockbackAnimationState;
        }
        if (Objects.equals(input, "kaboomer")) {
            return this.kaboomerAnimationState;
        }
        return Objects.equals(input, "death") ? this.deathAnimationState : new AnimationState();
    }

    public void m_7350_(EntityDataAccessor<?> p_21104_) {
        if (ANIMATION_STATE.equals(p_21104_) && this.m_9236_().f_46443_) {
            switch ((Integer)this.f_19804_.m_135370_(ANIMATION_STATE)) {
                case 0: {
                    this.stopAllAnimationStates();
                    break;
                }
                case 1: {
                    this.stopAllAnimationStates();
                    this.fireballAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 2: {
                    this.stopAllAnimationStates();
                    this.lifestealAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 3: {
                    this.stopAllAnimationStates();
                    this.fakersAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 4: {
                    this.stopAllAnimationStates();
                    this.vexesAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 5: {
                    this.stopAllAnimationStates();
                    this.fangrunAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 6: {
                    this.stopAllAnimationStates();
                    this.potionsAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 7: {
                    this.stopAllAnimationStates();
                    this.crossbowspinAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 8: {
                    this.stopAllAnimationStates();
                    this.crashagerAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 9: {
                    this.stopAllAnimationStates();
                    this.dispenserAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 10: {
                    this.stopAllAnimationStates();
                    this.knockbackAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 11: {
                    this.stopAllAnimationStates();
                    this.kaboomerAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 12: {
                    this.stopAllAnimationStates();
                    this.deathAnimationState.m_216977_(this.f_19797_);
                }
            }
        }
        super.m_7350_(p_21104_);
    }

    public boolean isMobNotInCreativeMode(Entity entity) {
        if (!(entity instanceof Player)) {
            return true;
        }
        return !((Player)entity).m_7500_() && !entity.m_5833_();
    }

    public void stopAllAnimationStates() {
        this.fireballAnimationState.m_216973_();
        this.lifestealAnimationState.m_216973_();
        this.fakersAnimationState.m_216973_();
        this.vexesAnimationState.m_216973_();
        this.fangrunAnimationState.m_216973_();
        this.potionsAnimationState.m_216973_();
        this.crossbowspinAnimationState.m_216973_();
        this.crashagerAnimationState.m_216973_();
        this.dispenserAnimationState.m_216973_();
        this.knockbackAnimationState.m_216973_();
        this.kaboomerAnimationState.m_216973_();
        this.deathAnimationState.m_216973_();
    }

    class KaboomerGoal
    extends Goal {
        public KaboomerGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return MagispellerEntity.this.m_5448_() != null && MagispellerEntity.this.getAttackType() == 0 && !MagispellerEntity.this.isFaking() && !MagispellerEntity.this.areIllagersNearby() && MagispellerEntity.this.isActive() && !MagispellerEntity.this.isBalloon() && MagispellerEntity.this.m_20202_() == null && MagispellerEntity.this.f_19796_.m_188503_(10) == 0 && MagispellerEntity.this.kaboomerCooldown < 1 && !MagispellerEntity.this.isRidingIllusion();
        }

        public void m_8056_() {
            MagispellerEntity.this.setAnimationState(11);
            EntityUtil.mobFollowingSound(MagispellerEntity.this.m_9236_(), (Entity)MagispellerEntity.this, (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_MAGISPELLER_KABOOMER.get(), 3.0f, 1.0f, false);
            MagispellerEntity.this.setAttackType(MagispellerEntity.this.KABOOMER_ATTACK);
            if (!MagispellerEntity.this.m_9236_().f_46443_) {
                MagispellerEntity.this.setShowArms(true);
            }
        }

        public boolean m_8045_() {
            return MagispellerEntity.this.getAttackTicks() <= 43;
        }

        public void m_8037_() {
            MagispellerEntity.this.m_21573_().m_26573_();
            if (MagispellerEntity.this.m_5448_() != null) {
                MagispellerEntity.this.m_21563_().m_24960_((Entity)MagispellerEntity.this.m_5448_(), 100.0f, 100.0f);
            }
            MagispellerEntity.this.f_21344_.m_26573_();
        }

        public void m_8041_() {
            MagispellerEntity.this.setAttackTicks(0);
            MagispellerEntity.this.setAttackType(0);
            MagispellerEntity.this.setAnimationState(0);
            if (!MagispellerEntity.this.m_9236_().f_46443_) {
                MagispellerEntity.this.setShowArms(false);
            }
            if (!MagispellerEntity.this.m_9236_().f_46443_) {
                MagispellerEntity.this.setGlowState(0);
                MagispellerEntity.this.setShakeAmount(0);
            }
            if (MagispellerEntity.this.m_5448_() != null) {
                KaboomerEntity kaboomer = null;
                if (!MagispellerEntity.this.m_9236_().f_46443_) {
                    kaboomer = (KaboomerEntity)((EntityType)ModEntityTypes.Kaboomer.get()).m_20615_(MagispellerEntity.this.m_9236_());
                }
                if (kaboomer != null) {
                    kaboomer.m_6034_(MagispellerEntity.this.m_20185_(), MagispellerEntity.this.m_20186_(), MagispellerEntity.this.m_20189_());
                    kaboomer.m_6710_(MagispellerEntity.this.m_5448_());
                    kaboomer.setOwner((Mob)MagispellerEntity.this);
                    if (MagispellerEntity.this.m_5647_() != null) {
                        MagispellerEntity.this.m_9236_().m_6188_().m_6546_(kaboomer.m_20149_(), MagispellerEntity.this.m_9236_().m_6188_().m_83489_(MagispellerEntity.this.m_5647_().m_5758_()));
                    }
                    MagispellerEntity.this.m_9236_().m_7967_((Entity)kaboomer);
                    MagispellerEntity.this.m_20329_((Entity)kaboomer);
                    kaboomer.teleport((Entity)MagispellerEntity.this.m_5448_());
                }
            }
            MagispellerEntity.this.kaboomerCooldown = 400;
        }
    }

    class HealGoal
    extends Goal {
        public HealGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return MagispellerEntity.this.getAttackType() == 0 && !MagispellerEntity.this.isFaking() && !MagispellerEntity.this.areIllagersNearby() && MagispellerEntity.this.healCooldown < 1 && MagispellerEntity.this.isActive() && MagispellerEntity.this.f_19796_.m_188503_(14) == 0 && MagispellerEntity.this.m_21223_() < MagispellerEntity.this.m_21233_() && !MagispellerEntity.this.m_21023_(MobEffects.f_19605_) && !MagispellerEntity.this.isBalloon() && !MagispellerEntity.this.isRidingIllusion();
        }

        public void m_8056_() {
            MagispellerEntity.this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_MAGISPELLER_HEAL.get(), 2.0f, 1.0f);
            MagispellerEntity.this.setAttackType(MagispellerEntity.this.HEAL_ATTACK);
            MagispellerEntity.this.gotHealed = true;
            MagispellerEntity.this.damageTaken = 0.0f;
            if (!MagispellerEntity.this.m_9236_().f_46443_) {
                MagispellerEntity.this.setShowArms(true);
                MagispellerEntity.this.setWavingArms(true);
                MagispellerEntity.this.setGlowState(6);
                MagiHealEntity healRing = (MagiHealEntity)((EntityType)ModEntityTypes.MagiHeal.get()).m_20615_(MagispellerEntity.this.m_9236_());
                assert (healRing != null);
                healRing.m_6034_(MagispellerEntity.this.m_20185_(), MagispellerEntity.this.m_20186_(), MagispellerEntity.this.m_20189_());
                healRing.setOwner(MagispellerEntity.this);
                MagispellerEntity.this.m_9236_().m_7967_((Entity)healRing);
            }
        }

        public boolean m_8045_() {
            return MagispellerEntity.this.getAttackTicks() <= 140 && MagispellerEntity.this.gotHealed;
        }

        public void m_8037_() {
            MagispellerEntity.this.m_21573_().m_26573_();
            if (MagispellerEntity.this.m_5448_() != null) {
                MagispellerEntity.this.m_21563_().m_24960_((Entity)MagispellerEntity.this.m_5448_(), 100.0f, 100.0f);
            }
            MagispellerEntity.this.f_21344_.m_26573_();
        }

        public void m_8041_() {
            MagispellerEntity.this.setAttackTicks(0);
            MagispellerEntity.this.setAttackType(0);
            if (!MagispellerEntity.this.m_9236_().f_46443_) {
                MagispellerEntity.this.setShowArms(false);
                MagispellerEntity.this.setWavingArms(false);
                MagispellerEntity.this.setGlowState(0);
            }
            if (MagispellerEntity.this.gotHealed) {
                MagispellerEntity.this.makeHealParticles();
                MagispellerEntity.this.m_5634_(8.0f);
                MagispellerEntity.this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 200, 3));
            } else if (!MagispellerEntity.this.isBalloon()) {
                MagispellerEntity.this.makeHealFailedParticles();
                MagispellerEntity.this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_MAGISPELLER_HEAL_INTERRUPT.get(), 2.0f, 1.0f);
            }
            MagispellerEntity.this.healCooldown = 200;
        }
    }

    class DispenserGoal
    extends Goal {
        public DispenserGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return MagispellerEntity.this.doesAttackMeetNormalRequirements() && MagispellerEntity.this.f_19796_.m_188503_(8) == 0 && MagispellerEntity.this.dispenserCooldown < 1;
        }

        public void m_8056_() {
            MagispellerEntity.this.setAnimationState(9);
            MagispellerEntity.this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_MAGISPELLER_DISPENSER.get(), 2.0f, 1.0f);
            MagispellerEntity.this.setAttackType(MagispellerEntity.this.DISPENSER_ATTACK);
            if (!MagispellerEntity.this.m_9236_().f_46443_) {
                MagispellerEntity.this.setShowArms(true);
            }
        }

        public boolean m_8045_() {
            return MagispellerEntity.this.getAttackTicks() <= 40;
        }

        public void m_8037_() {
            MagispellerEntity.this.m_21573_().m_26573_();
            if (MagispellerEntity.this.m_5448_() != null) {
                MagispellerEntity.this.m_21563_().m_24960_((Entity)MagispellerEntity.this.m_5448_(), 100.0f, 100.0f);
            }
            MagispellerEntity.this.f_21344_.m_26573_();
        }

        public void m_8041_() {
            MagispellerEntity.this.setAttackTicks(0);
            MagispellerEntity.this.setAttackType(0);
            MagispellerEntity.this.setAnimationState(0);
            if (!MagispellerEntity.this.m_9236_().f_46443_) {
                MagispellerEntity.this.setShowArms(false);
                MagispellerEntity.this.setGlowState(0);
            }
            MagispellerEntity.this.makeDispenserParticles();
            MagispellerEntity.this.dispenserCooldown = 300;
        }
    }

    class CrashagerGoal
    extends Goal {
        public CrashagerGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return MagispellerEntity.this.doesAttackMeetNormalRequirements() && MagispellerEntity.this.m_20202_() == null && MagispellerEntity.this.f_19796_.m_188503_(12) == 0 && MagispellerEntity.this.crashagerCooldown < 1 && MagispellerEntity.this.isTargetLowEnoughForGround();
        }

        public void m_8056_() {
            MagispellerEntity.this.setAnimationState(8);
            EntityUtil.mobFollowingSound(MagispellerEntity.this.m_9236_(), (Entity)MagispellerEntity.this, (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_MAGISPELLER_RAVAGER.get(), 2.0f, 1.0f, false);
            MagispellerEntity.this.setAttackType(MagispellerEntity.this.CRASHAGER_ATTACK);
            if (!MagispellerEntity.this.m_9236_().f_46443_) {
                MagispellerEntity.this.setShowArms(true);
                MagispellerEntity.this.setShakeAmount(30);
            }
        }

        public boolean m_8045_() {
            return MagispellerEntity.this.getAttackTicks() <= 71 || MagispellerEntity.this.isRidingIllusion();
        }

        public void m_8037_() {
            MagispellerEntity.this.m_21573_().m_26573_();
            if (MagispellerEntity.this.m_5448_() != null) {
                MagispellerEntity.this.m_21563_().m_24960_((Entity)MagispellerEntity.this.m_5448_(), 100.0f, 100.0f);
            }
            MagispellerEntity.this.f_21344_.m_26573_();
        }

        public void m_8041_() {
            MagispellerEntity.this.setAttackTicks(0);
            MagispellerEntity.this.setAttackType(0);
            MagispellerEntity.this.setAnimationState(0);
            if (!MagispellerEntity.this.m_9236_().f_46443_) {
                MagispellerEntity.this.setShowArms(false);
            }
            MagispellerEntity.this.crashagerCooldown = 160;
        }
    }

    class CrossbowSpinGoal
    extends Goal {
        public CrossbowSpinGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return MagispellerEntity.this.doesAttackMeetNormalRequirements() && MagispellerEntity.this.f_19796_.m_188503_(16) == 0 && MagispellerEntity.this.crossbowSpinCooldown < 1;
        }

        public void m_8056_() {
            MagispellerEntity.this.setAnimationState(7);
            MagispellerEntity.this.setAttackType(MagispellerEntity.this.CROSSBOWSPIN_ATTACK);
            MagispellerEntity.this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_MAGISPELLER_CROSSBOWSPIN.get(), 2.0f, 1.0f);
            if (!MagispellerEntity.this.m_9236_().f_46443_) {
                MagispellerEntity.this.setShowArms(true);
            }
        }

        public boolean m_8045_() {
            return MagispellerEntity.this.getAttackTicks() <= 133;
        }

        public void m_8037_() {
            MagispellerEntity.this.m_21573_().m_26573_();
            if (MagispellerEntity.this.m_5448_() != null) {
                MagispellerEntity.this.m_21563_().m_24960_((Entity)MagispellerEntity.this.m_5448_(), 100.0f, 100.0f);
            }
            MagispellerEntity.this.f_21344_.m_26573_();
        }

        public void m_8041_() {
            MagispellerEntity.this.setAttackTicks(0);
            MagispellerEntity.this.setAttackType(0);
            MagispellerEntity.this.setAnimationState(0);
            if (!MagispellerEntity.this.m_9236_().f_46443_) {
                MagispellerEntity.this.setShowArms(false);
                MagispellerEntity.this.setArrowState(0);
            }
            MagispellerEntity.this.crossbowSpinCooldown = 300;
        }
    }

    class ThrowPotionsGoal
    extends Goal {
        public ThrowPotionsGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return MagispellerEntity.this.doesAttackMeetNormalRequirements() && MagispellerEntity.this.f_19796_.m_188503_(12) == 0 && MagispellerEntity.this.throwPotionsCooldown < 1 && MagispellerEntity.this.m_20280_((Entity)MagispellerEntity.this.m_5448_()) < 36.0 && MagispellerEntity.this.isTargetLowEnoughForGround() && !Objects.requireNonNull(MagispellerEntity.this.m_5448_()).m_21023_(MobEffects.f_19597_);
        }

        public void m_8056_() {
            MagispellerEntity.this.setAnimationState(6);
            MagispellerEntity.this.setAttackType(MagispellerEntity.this.POTIONS_ATTACK);
            MagispellerEntity.this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_MAGISPELLER_POTIONS_START.get(), 2.0f, 1.0f);
            if (!MagispellerEntity.this.m_9236_().f_46443_) {
                MagispellerEntity.this.setShowArms(true);
            }
        }

        public boolean m_8045_() {
            return MagispellerEntity.this.getAttackTicks() <= 68;
        }

        public void m_8037_() {
            MagispellerEntity.this.m_21573_().m_26573_();
            if (MagispellerEntity.this.m_5448_() != null) {
                MagispellerEntity.this.m_21563_().m_24960_((Entity)MagispellerEntity.this.m_5448_(), 100.0f, 100.0f);
            }
            MagispellerEntity.this.f_21344_.m_26573_();
        }

        public void m_8041_() {
            MagispellerEntity.this.setAttackTicks(0);
            MagispellerEntity.this.setAttackType(0);
            MagispellerEntity.this.setAnimationState(0);
            if (!MagispellerEntity.this.m_9236_().f_46443_) {
                MagispellerEntity.this.setShowArms(false);
            }
            MagispellerEntity.this.throwPotionsCooldown = 100;
        }
    }

    class FangRunGoal
    extends Goal {
        public FangRunGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return MagispellerEntity.this.doesAttackMeetNormalRequirements() && MagispellerEntity.this.f_19796_.m_188503_(10) == 0 && MagispellerEntity.this.fangrunCooldown < 1 && MagispellerEntity.this.m_20280_((Entity)MagispellerEntity.this.m_5448_()) < 256.0 && MagispellerEntity.this.isTargetLowEnoughForGround();
        }

        public void m_8056_() {
            MagispellerEntity.this.setAnimationState(5);
            MagispellerEntity.this.setAttackType(MagispellerEntity.this.FANGRUN_ATTACK);
            if (!MagispellerEntity.this.m_9236_().f_46443_) {
                MagispellerEntity.this.setShowArms(true);
            }
        }

        public boolean m_8045_() {
            return MagispellerEntity.this.getAttackTicks() <= 109;
        }

        public void m_8037_() {
            MagispellerEntity.this.m_21573_().m_26573_();
            if (MagispellerEntity.this.m_5448_() != null) {
                MagispellerEntity.this.m_21563_().m_24960_((Entity)MagispellerEntity.this.m_5448_(), 100.0f, 100.0f);
            }
            MagispellerEntity.this.f_21344_.m_26573_();
        }

        public void m_8041_() {
            MagispellerEntity.this.setAttackTicks(0);
            MagispellerEntity.this.setAttackType(0);
            MagispellerEntity.this.setAnimationState(0);
            if (!MagispellerEntity.this.m_9236_().f_46443_) {
                MagispellerEntity.this.setShowArms(false);
                MagispellerEntity.this.setGlowState(0);
                MagispellerEntity.this.setShakeAmount(0);
            }
            MagispellerEntity.this.fangrunCooldown = 160;
        }
    }

    class SummonVexesGoal
    extends Goal {
        public SummonVexesGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return MagispellerEntity.this.doesAttackMeetNormalRequirements() && MagispellerEntity.this.f_19796_.m_188503_(8) == 0 && MagispellerEntity.this.vexesCooldown < 1;
        }

        public void m_8056_() {
            MagispellerEntity.this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_MAGISPELLER_SUMMON.get(), 1.0f, 1.0f);
            MagispellerEntity.this.setAttackType(MagispellerEntity.this.VEXES_ATTACK);
            MagispellerEntity.this.setAnimationState(4);
            if (!MagispellerEntity.this.m_9236_().f_46443_) {
                MagispellerEntity.this.setShowArms(true);
            }
        }

        public boolean m_8045_() {
            return MagispellerEntity.this.getAttackTicks() <= 40;
        }

        public void m_8037_() {
            MagispellerEntity.this.m_21573_().m_26573_();
            if (MagispellerEntity.this.m_5448_() != null) {
                MagispellerEntity.this.m_21563_().m_24960_((Entity)MagispellerEntity.this.m_5448_(), 100.0f, 100.0f);
            }
            MagispellerEntity.this.f_21344_.m_26573_();
        }

        public void m_8041_() {
            MagispellerEntity.this.setAttackTicks(0);
            MagispellerEntity.this.setAttackType(0);
            MagispellerEntity.this.setAnimationState(0);
            if (!MagispellerEntity.this.m_9236_().f_46443_) {
                MagispellerEntity.this.setShowArms(false);
            }
            MagispellerEntity.this.vexesCooldown = 900;
        }
    }

    class FakersGoal
    extends Goal {
        public FakersGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return MagispellerEntity.this.doesAttackMeetNormalRequirements() && MagispellerEntity.this.f_19796_.m_188503_(16) == 0 && MagispellerEntity.this.m_21223_() < MagispellerEntity.this.m_21233_() / 2.0f && MagispellerEntity.this.fakersCooldown < 1 && MagispellerEntity.this.isTargetLowEnoughForGround();
        }

        public void m_8056_() {
            MagispellerEntity.this.setAnimationState(3);
            MagispellerEntity.this.setAttackType(MagispellerEntity.this.FAKERS_ATTACK);
            EntityUtil.mobFollowingSound(MagispellerEntity.this.m_9236_(), (Entity)MagispellerEntity.this, (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_MAGISPELLER_PREPARE_FAKERS.get(), 2.0f, 1.0f, false);
            if (!MagispellerEntity.this.m_9236_().f_46443_) {
                MagispellerEntity.this.setShowArms(true);
            }
        }

        public boolean m_8045_() {
            return MagispellerEntity.this.getAttackTicks() <= 51;
        }

        public void m_8037_() {
            MagispellerEntity.this.m_21573_().m_26573_();
            if (MagispellerEntity.this.m_5448_() != null) {
                MagispellerEntity.this.m_21563_().m_24960_((Entity)MagispellerEntity.this.m_5448_(), 100.0f, 100.0f);
            }
            MagispellerEntity.this.f_21344_.m_26573_();
        }

        public void m_8041_() {
            MagispellerEntity.this.setAttackTicks(0);
            MagispellerEntity.this.setAttackType(0);
            MagispellerEntity.this.setAnimationState(0);
            if (!MagispellerEntity.this.m_9236_().f_46443_) {
                MagispellerEntity.this.setShowArms(false);
                MagispellerEntity.this.setGlowState(0);
                MagispellerEntity.this.setShakeAmount(0);
                MagispellerEntity.this.setFaking(true);
            }
            if (MagispellerEntity.this.m_5448_() != null) {
                if (!MagispellerEntity.this.m_9236_().f_46443_) {
                    int i;
                    for (i = 0; i < 11; ++i) {
                        FakeMagispellerEntity clone = (FakeMagispellerEntity)((EntityType)ModEntityTypes.Faker.get()).m_20615_(MagispellerEntity.this.m_9236_());
                        assert (clone != null);
                        clone.m_6034_(MagispellerEntity.this.m_20182_().f_82479_, MagispellerEntity.this.m_20182_().f_82480_, MagispellerEntity.this.m_20182_().f_82481_);
                        clone.m_6710_(MagispellerEntity.this.m_5448_());
                        clone.m_8061_(EquipmentSlot.MAINHAND, MagispellerEntity.this.m_6844_(EquipmentSlot.MAINHAND));
                        clone.m_8061_(EquipmentSlot.OFFHAND, MagispellerEntity.this.m_6844_(EquipmentSlot.OFFHAND));
                        clone.m_8061_(EquipmentSlot.HEAD, MagispellerEntity.this.m_6844_(EquipmentSlot.HEAD));
                        clone.m_8061_(EquipmentSlot.CHEST, MagispellerEntity.this.m_6844_(EquipmentSlot.CHEST));
                        clone.m_8061_(EquipmentSlot.LEGS, MagispellerEntity.this.m_6844_(EquipmentSlot.LEGS));
                        clone.m_8061_(EquipmentSlot.FEET, MagispellerEntity.this.m_6844_(EquipmentSlot.FEET));
                        clone.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
                        clone.m_21409_(EquipmentSlot.OFFHAND, 0.0f);
                        clone.m_21409_(EquipmentSlot.HEAD, 0.0f);
                        clone.m_21409_(EquipmentSlot.CHEST, 0.0f);
                        clone.m_21409_(EquipmentSlot.LEGS, 0.0f);
                        clone.m_21409_(EquipmentSlot.FEET, 0.0f);
                        clone.m_21153_(MagispellerEntity.this.m_21223_());
                        clone.setOwner((Mob)MagispellerEntity.this);
                        if (MagispellerEntity.this.m_8077_()) {
                            clone.m_6593_(MagispellerEntity.this.m_7770_());
                        }
                        if (MagispellerEntity.this.m_5647_() != null) {
                            MagispellerEntity.this.m_9236_().m_6188_().m_6546_(clone.m_20149_(), MagispellerEntity.this.m_9236_().m_6188_().m_83489_(MagispellerEntity.this.m_5647_().m_5758_()));
                        }
                        clone.m_21559_(MagispellerEntity.this.m_21526_());
                        MagispellerEntity.this.m_9236_().m_7967_((Entity)clone);
                        clone.tryToTeleportToEntity((Entity)MagispellerEntity.this.m_5448_());
                        MagispellerEntity.this.clones.add(clone);
                    }
                    for (i = 0; i < 64 && !MagispellerEntity.this.teleportTowards((Entity)MagispellerEntity.this.m_5448_()); ++i) {
                    }
                }
                MagispellerEntity.this.distractAttackers((LivingEntity)MagispellerEntity.this.clones.get(MagispellerEntity.this.f_19796_.m_188503_(MagispellerEntity.this.clones.size())));
            }
            MagispellerEntity.this.waitTimeFaker = 20;
            MagispellerEntity.this.fakersCooldown = 200;
        }
    }

    class LifestealGoal
    extends Goal {
        public LifestealGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return MagispellerEntity.this.doesAttackMeetNormalRequirements() && MagispellerEntity.this.f_19796_.m_188503_(10) == 0 && MagispellerEntity.this.lifestealCooldown < 1 && MagispellerEntity.this.m_20280_((Entity)MagispellerEntity.this.m_5448_()) < 144.0;
        }

        public void m_8056_() {
            MagispellerEntity.this.setAnimationState(2);
            MagispellerEntity.this.setAttackType(MagispellerEntity.this.LIFESTEAL_ATTACK);
            EntityUtil.mobFollowingSound(MagispellerEntity.this.m_9236_(), (Entity)MagispellerEntity.this, (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_MAGISPELLER_LIFESTEAL_START.get(), 2.0f, 1.0f, false);
            if (!MagispellerEntity.this.m_9236_().f_46443_) {
                MagispellerEntity.this.setShowArms(true);
            }
        }

        public boolean m_8045_() {
            return MagispellerEntity.this.getAttackTicks() <= 139;
        }

        public void m_8037_() {
            MagispellerEntity.this.m_21573_().m_26573_();
            if (MagispellerEntity.this.m_5448_() != null) {
                MagispellerEntity.this.m_21563_().m_24960_((Entity)MagispellerEntity.this.m_5448_(), 100.0f, 100.0f);
            }
            MagispellerEntity.this.f_21344_.m_26573_();
        }

        public void m_8041_() {
            MagispellerEntity.this.setAttackTicks(0);
            MagispellerEntity.this.setAttackType(0);
            MagispellerEntity.this.setAnimationState(0);
            if (!MagispellerEntity.this.m_9236_().f_46443_) {
                MagispellerEntity.this.setShowArms(false);
                MagispellerEntity.this.setGlowState(0);
                MagispellerEntity.this.setShakeAmount(0);
            }
            MagispellerEntity.this.lifestealCooldown = 160;
        }
    }

    class ShootFireballGoal
    extends Goal {
        public ShootFireballGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return MagispellerEntity.this.doesAttackMeetNormalRequirements() && MagispellerEntity.this.f_19796_.m_188503_(16) == 0 && MagispellerEntity.this.fireballCooldown < 1;
        }

        public void m_8056_() {
            MagispellerEntity.this.setAnimationState(1);
            MagispellerEntity.this.setAttackType(MagispellerEntity.this.FIREBALL_ATTACK);
            if (!MagispellerEntity.this.m_9236_().f_46443_) {
                MagispellerEntity.this.setShowArms(true);
            }
        }

        public boolean m_8045_() {
            return MagispellerEntity.this.getAttackTicks() <= 70;
        }

        public void m_8037_() {
            MagispellerEntity.this.m_21573_().m_26573_();
            if (MagispellerEntity.this.m_5448_() != null) {
                MagispellerEntity.this.m_21563_().m_24960_((Entity)MagispellerEntity.this.m_5448_(), 100.0f, 100.0f);
            }
            MagispellerEntity.this.f_21344_.m_26573_();
        }

        public void m_8041_() {
            MagispellerEntity.this.setAttackTicks(0);
            MagispellerEntity.this.setAttackType(0);
            MagispellerEntity.this.setAnimationState(0);
            if (!MagispellerEntity.this.m_9236_().f_46443_) {
                MagispellerEntity.this.setShowArms(false);
            }
            MagispellerEntity.this.m_21559_(false);
            MagispellerEntity.this.fireballCooldown = 200;
        }
    }

    class KnockbackGoal
    extends Goal {
        public KnockbackGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return MagispellerEntity.this.doesAttackMeetNormalRequirements() && MagispellerEntity.this.m_5448_() != null && (double)MagispellerEntity.this.m_20270_((Entity)MagispellerEntity.this.m_5448_()) < 3.0;
        }

        public void m_8056_() {
            MagispellerEntity.this.setAnimationState(10);
            MagispellerEntity.this.setAttackType(MagispellerEntity.this.KNOCKBACK_ATTACK);
            if (!MagispellerEntity.this.m_9236_().f_46443_) {
                MagispellerEntity.this.setShowArms(true);
            }
        }

        public boolean m_8045_() {
            return MagispellerEntity.this.getAttackTicks() <= 14;
        }

        public void m_8037_() {
            MagispellerEntity.this.m_21573_().m_26573_();
            if (MagispellerEntity.this.m_5448_() != null) {
                MagispellerEntity.this.m_21563_().m_24960_((Entity)MagispellerEntity.this.m_5448_(), 100.0f, 100.0f);
            }
            MagispellerEntity.this.f_21344_.m_26573_();
        }

        public void m_8041_() {
            MagispellerEntity.this.setAttackTicks(0);
            MagispellerEntity.this.setAttackType(0);
            MagispellerEntity.this.setAnimationState(0);
            if (!MagispellerEntity.this.m_9236_().f_46443_) {
                MagispellerEntity.this.setShowArms(false);
            }
        }
    }

    class StareAtTargetGoal
    extends Goal {
        public StareAtTargetGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            return MagispellerEntity.this.m_5448_() != null && (!MagispellerEntity.this.isActive() || MagispellerEntity.this.isBalloon()) && !MagispellerEntity.this.isFaking();
        }

        public boolean m_8045_() {
            return MagispellerEntity.this.m_5448_() != null && (!MagispellerEntity.this.isActive() || MagispellerEntity.this.isBalloon()) && !MagispellerEntity.this.isFaking();
        }

        public void m_8037_() {
            MagispellerEntity.this.m_21573_().m_26573_();
            if (MagispellerEntity.this.m_5448_() != null) {
                MagispellerEntity.this.m_21563_().m_24960_((Entity)MagispellerEntity.this.m_5448_(), 100.0f, 100.0f);
            }
            MagispellerEntity.this.f_21344_.m_26573_();
        }
    }
}

