/*
 * Decompiled with CFR 0.152.
 */
package com.yellowbrossproductions.illageandspillage.entities;

import com.yellowbrossproductions.illageandspillage.entities.CameraShakeEntity;
import com.yellowbrossproductions.illageandspillage.entities.IllagerAttack;
import com.yellowbrossproductions.illageandspillage.packet.PacketHandler;
import com.yellowbrossproductions.illageandspillage.packet.ParticlePacket;
import com.yellowbrossproductions.illageandspillage.util.IllageAndSpillageSoundEvents;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.network.PacketDistributor;

public class KaboomerEntity
extends Monster
implements IllagerAttack {
    private static final EntityDataAccessor<Integer> ATTACKSTAGE = SynchedEntityData.m_135353_(KaboomerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int spawnTicks;
    private Mob owner;
    private int oldSwell;
    private int swell;
    private final int maxSwell = 30;

    public KaboomerEntity(EntityType<? extends Monster> p_i48553_1_, Level p_i48553_2_) {
        super(p_i48553_1_, p_i48553_2_);
        this.m_274367_(1.0f);
    }

    public boolean m_6097_() {
        return false;
    }

    public boolean m_7301_(MobEffectInstance p_21197_) {
        return false;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new AttackGoal());
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, (double)0.8f).m_22268_(Attributes.f_22276_, 500.0).m_22268_(Attributes.f_22281_, 15.0).m_22268_(Attributes.f_22277_, 32.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKSTAGE, (Object)0);
    }

    public boolean canBeRiddenUnderFluidType(FluidType type, Entity rider) {
        return true;
    }

    public boolean m_142535_(float p_225503_1_, float p_225503_2_, DamageSource p_147189_) {
        return false;
    }

    public void m_8119_() {
        if (this.m_6084_()) {
            ++this.spawnTicks;
            if (this.getAttackStage() == 0) {
                this.setAttackStage(1);
            }
            this.m_146922_(this.m_6080_());
            this.f_20883_ = this.m_146908_();
            if (this.spawnTicks == 30) {
                this.setAttackStage(2);
            }
            if (this.spawnTicks == 70) {
                this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_MAGISPELLER_KABOOMER_HISS.get(), 2.0f, 1.0f);
                this.setAttackStage(3);
            }
            if (this.spawnTicks > 100) {
                this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_MAGISPELLER_KABOOMER_EXPLODE.get(), 3.0f, 1.0f);
                CameraShakeEntity.cameraShake(this.m_9236_(), this.m_20182_(), 50.0f, 0.6f, 0, 20);
                this.makeExplodeParticles();
                this.explode();
                this.m_6074_();
            }
            if (this.getAttackStage() == 3) {
                this.makeHissParticles();
                this.oldSwell = this.swell++;
                if (this.swell >= this.maxSwell) {
                    this.swell = this.maxSwell;
                }
            }
            if (this.getOwner() != null) {
                this.m_6710_(this.getOwner().m_5448_());
            }
            this.m_21573_().m_26573_();
            if (this.m_5448_() != null && this.getAttackStage() >= 2) {
                this.m_21563_().m_24960_((Entity)this.m_5448_(), 30.0f, 30.0f);
            }
            this.f_21344_.m_26573_();
        }
        super.m_8119_();
    }

    public float getSwelling(float p_32321_) {
        return Mth.m_14179_((float)p_32321_, (float)this.oldSwell, (float)this.swell) / (float)(this.maxSwell - 2);
    }

    public double m_6048_() {
        return 3.2;
    }

    public void teleport(@Nullable Entity entity) {
        if (entity != null) {
            this.m_5496_(SoundEvents.f_11852_, 3.0f, 1.0f);
            this.m_6034_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
        }
    }

    public void makeExplodeParticles() {
        if (!this.m_9236_().f_46443_) {
            Iterator var1 = ((ServerLevel)this.m_9236_()).m_6907_().iterator();
            while (true) {
                double d2;
                double d1;
                double d0;
                int i;
                if (!var1.hasNext()) {
                    return;
                }
                ServerPlayer serverPlayer = (ServerPlayer)var1.next();
                if (!(serverPlayer.m_20280_((Entity)this) < 4096.0)) continue;
                ParticlePacket packet = new ParticlePacket();
                for (i = 0; i < 250; ++i) {
                    d0 = (-0.5 + this.f_19796_.m_188583_()) / 2.0;
                    d1 = (-0.5 + this.f_19796_.m_188583_()) / 2.0;
                    d2 = (-0.5 + this.f_19796_.m_188583_()) / 2.0;
                    packet.queueParticle((ParticleOptions)ParticleTypes.f_123777_, false, new Vec3(this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0)), new Vec3(d0, d1, d2));
                }
                for (i = 0; i < 200; ++i) {
                    d0 = (-0.5 + this.f_19796_.m_188583_()) / 2.0;
                    d1 = (-0.5 + this.f_19796_.m_188583_()) / 2.0;
                    d2 = (-0.5 + this.f_19796_.m_188583_()) / 2.0;
                    packet.queueParticle((ParticleOptions)ParticleTypes.f_123759_, false, new Vec3(this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0)), new Vec3(d0, d1, d2));
                }
                for (i = 0; i < 150; ++i) {
                    d0 = (-0.5 + this.f_19796_.m_188583_()) / 2.0;
                    d1 = (-0.5 + this.f_19796_.m_188583_()) / 2.0;
                    d2 = (-0.5 + this.f_19796_.m_188583_()) / 2.0;
                    packet.queueParticle((ParticleOptions)ParticleTypes.f_123755_, false, new Vec3(this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0)), new Vec3(d0, d1, d2));
                }
                ServerPlayer finalServerPlayer = serverPlayer;
                PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> finalServerPlayer), (Object)packet);
            }
        }
    }

    public void makeHissParticles() {
        if (!this.m_9236_().f_46443_) {
            Iterator var1 = ((ServerLevel)this.m_9236_()).m_6907_().iterator();
            while (true) {
                if (!var1.hasNext()) {
                    return;
                }
                ServerPlayer serverPlayer = (ServerPlayer)var1.next();
                if (!(serverPlayer.m_20280_((Entity)this) < 4096.0)) continue;
                ParticlePacket packet = new ParticlePacket();
                for (int i = 0; i < 20; ++i) {
                    double d0 = (-0.5 + this.f_19796_.m_188583_()) / 2.0;
                    double d1 = (-0.5 + this.f_19796_.m_188583_()) / 2.0;
                    double d2 = (-0.5 + this.f_19796_.m_188583_()) / 2.0;
                    packet.queueParticle((ParticleOptions)ParticleTypes.f_175830_, false, new Vec3(this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0)), new Vec3(d0, d1, d2));
                }
                ServerPlayer finalServerPlayer = serverPlayer;
                PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> finalServerPlayer), (Object)packet);
            }
        }
    }

    protected SoundEvent m_7975_(DamageSource p_184601_1_) {
        return null;
    }

    protected SoundEvent m_5592_() {
        return null;
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.f_12361_;
    }

    protected void m_7355_(BlockPos p_180429_1_, BlockState p_180429_2_) {
        this.m_5496_(this.getStepSound(), 1.0f, 1.0f);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return (source.m_276093_(DamageTypes.f_268724_) || source.m_276093_(DamageTypes.f_286979_)) && super.m_6469_(source, amount);
    }

    public void m_6667_(DamageSource p_70645_1_) {
        super.m_6667_(p_70645_1_);
        if (this.m_9236_().f_46443_) {
            double d0 = this.f_19796_.m_188583_() * 0.02;
            double d1 = this.f_19796_.m_188583_() * 0.02;
            double d2 = this.f_19796_.m_188583_() * 0.02;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123812_, this.m_20185_(), this.m_20186_(), this.m_20189_(), d0, d1, d2);
        }
        this.f_20919_ = 19;
    }

    private void explode() {
        if (!this.m_9236_().f_46443_) {
            double range = 4.0;
            this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 5.0f, Level.ExplosionInteraction.NONE);
            this.m_9236_().m_254849_((Entity)this, this.m_20185_() + range, this.m_20186_(), this.m_20189_() + range, 5.0f, Level.ExplosionInteraction.NONE);
            this.m_9236_().m_254849_((Entity)this, this.m_20185_() + range, this.m_20186_(), this.m_20189_() - range, 5.0f, Level.ExplosionInteraction.NONE);
            this.m_9236_().m_254849_((Entity)this, this.m_20185_() - range, this.m_20186_(), this.m_20189_() + range, 5.0f, Level.ExplosionInteraction.NONE);
            this.m_9236_().m_254849_((Entity)this, this.m_20185_() - range, this.m_20186_(), this.m_20189_() - range, 5.0f, Level.ExplosionInteraction.NONE);
            this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_() + range, this.m_20189_(), 5.0f, Level.ExplosionInteraction.NONE);
            this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_() - range, this.m_20189_(), 5.0f, Level.ExplosionInteraction.NONE);
        }
    }

    public Mob getOwner() {
        return this.owner;
    }

    public void setOwner(Mob owner) {
        this.owner = owner;
    }

    public int getAttackStage() {
        return (Integer)this.f_19804_.m_135370_(ATTACKSTAGE);
    }

    public void setAttackStage(int attackStage) {
        this.f_19804_.m_135381_(ATTACKSTAGE, (Object)attackStage);
    }

    class AttackGoal
    extends Goal {
        AttackGoal() {
        }

        public boolean m_8036_() {
            return KaboomerEntity.this.getAttackStage() > 0;
        }

        public void m_8037_() {
        }
    }
}

